ssControlDrone:
	move.l	d7,-(a7)
; Now work out control status	
	moveq	#0,d5
	moveq	#0,d6
	moveq	#0,d7
	move.b	carDroneGuideAngle(a4),d6
	move.b	carWheelAngle(a4),d7
	cmp.b	d6,d7
	beq.s	.acc
	
; If the drone car turns then slow it down
	move.w	carDroneCornerSpeed(a4),d5
	sub.l	d5,carCurrentThrottle(a4)	; Slow down on courners level

	move.w	#TURN_LEFT,carStateDirection(a4)
	sub.b	d7,d6
	bmi.s	.acc				; Left or Right?
	move.w	#TURN_RIGHT,carStateDirection(a4)
	
.acc:	;moveq	#,d6				; Get accelleration status
	;move.b	carDroneAccellerate(a4),d6
	;move.w	d6,carStateButton(a4)
	move.w	#-1,carStateButton(a4)
	
	move.l	(a7)+,d7
.exit:	rts



; IFACE1_PORT
; BTN1_STATE
; BTN2_STATE
;d1 = Car to control (0-3) d6 d5
ssControlCar:
	tst.w	RACE_OVER(a6)
	bne	.exit

	GET_CAR_CONTEXT
	
	IFNE	ENABLE_PROTECTION
	tst.w	carIsDrone(a4)
	bmi.s	.f1
	tst.w	carTimeInPlay(a4)
	bmi	.exit
	subq.w	#1,carTimeInPlay(a4)
.f1:
	ENDC

; Override input if the car is a drone.
	tst.w	carControlDisable(a4)
	bmi.s	.not_drone
	tst.w	carIsDrone(a4)
	beq.s	.not_drone	

	tst.w	carDroneStartDelay(a4)
	bmi.s	.delay_done
	subq.w	#1,carDroneStartDelay(a4)
	bra	.exit

.delay_done:
	bsr	ssControlDrone
	
	cmp.l	#$100,carCurrentThrottle(a4)
	bgt.s	.not_drone
	move.l	#$100,carCurrentThrottle(a4)
	
.not_drone:
	move.l	d1,carNumber(a4)
	move.l	carYpos(a4),carLastYpos(a4)
	move.b	carWheelAngle(a4),carLastWheelAngle(a4)
	
; Update lap times for each car
	lea	carTimeLap1(a4),a2
	moveq	#0,d3
	move.w	carOnLap(a4),d3
	addq.l	#1,(a2,d3*4)
	
	addq.w	#1,carTimeSinceLastCheckPoint(a4)	; Increase time since Last Checkpoint

	tst.w	carIsFalling(a4)
	bmi.s	.drop_car
	tst.w	carRebounding(a4)			; Is the car direct rebounding?
	beq	.no_rebound				; No,
	tst.l	carCurrentThrottle(a4)			; Yes, has the throttle reached 0 or minus
	beq	.con_release
	bmi	.con_release
	move.l	carMaxBraking(a4),d0
	sub.l	d0,carCurrentThrottle(a4)		; Cause car to brake.	
	bra	.no_rebound

.drop_car:
	tst.b	carElevation(a4)			; Car elevation must be 0 if dropping.
	beq	.explode_or_land
	bmi	.explode_or_land
	
	add.w	#$40,carIsFallingIndex(a4)

; Drop the car on Y Axis
	moveq	#0,d0
	lea	.sintab(pc),a0
	move.b	carIsFallingIndex(a4),d0
	move.b	(a0,d0),d0
	bmi.s	.explode_or_land
	moveq	#1,d1
	tst.w	carIsDrone(a4)
	beq.s	.d
	moveq	#5,d1				; Drones drop slower.
.d:	lsr.b	d1,d0
	sub.b	d0,carElevation(a4)	

	and.l	#$ff,d0
	add.w	carLastYpos(a4),d0
	move.w	d0,carYpos(a4)
	bra	.next
	
.sintab:
	dc.b	0,0,0,$1,$3,$4,$6,$7,$9,$a,$c,$e,$f,$11,$12,$14,$15,$17
	dc.b	$18,$19,$1b,$1c,$1e,$1f,$20,$22,$23,$24,$26,$27,$28,$29,$2a,$2c
	dc.b	$2d,$2e,$2f,$30,$31,$32,$33,$34,$35,$36,$36,$37,$38,$39,$39,$3a
	dc.b	$3b,$3b,$3c,$3c,$3d,$3d,$3e,$3e,$3e,$3f,$3f,$3f,$3f,$3f,$3f,$3f
	dc.b	$40,-1
	even
	
.explode_or_land:
	tst.w	carSpinTimer(a4)
	bpl.s	.explode
	
; Explode the car if it is falling from an upper level
	cmp.b	#$0A,carFrontTerrainBlock(a4)
	beq.s	.explode
	cmp.b	#$0B,carFrontTerrainBlock(a4)
	beq.s	.explode
	cmp.b	#$15,carFrontTerrainBlock(a4)
	beq.s	.explode
	cmp.b	#$16,carFrontTerrainBlock(a4)
	beq.s	.explode
	cmp.b	#$17,carFrontTerrainBlock(a4)
	beq.s	.explode
	cmp.b	#$18,carFrontTerrainBlock(a4)
	beq.s	.explode

	
.land:	
	moveq	#9,d7				; Cause landing smokes
	bsr	ssCarSmokes

	clr.w	carElevation(a4)
	clr.l	carLevel(a4)	
	clr.w	carIsFalling(a4)
	clr.w	carIsFallingIndex(a4)
	bra	.exit

.explode:
	clr.l	carLevel(a4)
	bsr	ssExplodeCar
	bra	.exit
	
; Main car controlling code here.
.con_release:
	clr.w	carControlDisable(a4)			; Give back control
	clr.w	carRebounding(a4)			; Stop car rebounding
	clr.l	carCurrentThrottle(a4)			; Stop the car
	
	move.b	carLastCollisionAngle(a4),carWheelAngle(a4)	; Restore the collision angle
	move.b	carLastCollisionAngle(a4),carLastWheelDirection(a4)
	move.b	carLastCollisionAngle(a4),carDragAngle(a4)
.no_rebound:		
	;bsr	.buffer_angles
	bsr	.check_accellerate
	bsr	.check_brake
	bsr	.check_nitro

	moveq	#0,d0
	move.w	carTractionMod(a4),d0			; d1=(1-5) more steer = less
	
	moveq	#0,d3
	move.l	carCurrentThrottle(a4),d3
	lsr.l	#3,d3
	sub.w	d3,d0
	
	move.w	carRampAngleAdjust(a4),d2
	beq.s	.x
; determin direction of travel and 
	lsl.b	#3,d2
	move.b	carWheelAngle(a4),d3
	lsr.b	#7,d3
	beq.s	.ramp_right
	not.b	d2
.ramp_right:
	add.b	d2,carWheelAngle(a4)
		
.x:	move.b	carWheelDirection(a4),carLastWheelDirection(a4)

; Test player controls.
	tst.w	carControlDisable(a4)
	bmi.s	.con_disable
	tst.w	carSpinTimer(a4)
	bpl.s	.in_spin
	cmp.w	#TURN_LEFT,carStateDirection(a4)					
	beq.s	.left
	cmp.w	#TURN_RIGHT,carStateDirection(a4)
	beq.s	.right
	
.in_spin:
.con_disable:
	move.b	carWheelDirection(a4),carLastWheelDirection(a4)
	clr.b	carWheelDirection(a4)
	bsr	.steer_to_centre
	bra	.next
	nop

; Decrease traction when accellerating and turning	
.left:		
	move.b	#-1,carWheelDirection(a4)
	tst.b	carLastWheelDirection(a4)
	bmi.s	.left1
	clr.w	carSteerMod(a4)
.left1:	sub.w	d0,carWheelAngle(a4)	
	bsr	.steer_incr_left
	bra.s	.next
	
.right:		
	move.b	#1,carWheelDirection(a4)
	tst.b	carLastWheelDirection(a4)
	beq.s	.right1
	bpl.s	.right1
	clr.w	carSteerMod(a4)
.right1:	

	add.w	d0,carWheelAngle(a4)
	bsr	.steer_incr_right
	bra.s	.next
	nop
	
.next:	bsr	.inc_drag
	bsr	.apply_drag
	;bsr	.apply_screetch
	bsr	.apply_velocity
	bra	.exit
	
.apply_screetch:
; If we are not going fast enough then don't screetch
	tst.w	carIsDrone(a4)					; Drones don't skid
	bmi	.exit
	
	cmp.l	#$300,carCurrentThrottle(a4)
	ble	.clear_screetch
	
; is the car dragging?
	tst.b	carSteerMod(a4)
	beq	.clear_screetch

; Must be accelerating.
	;tst.w	carStateButton(a4)						; Accellerate?
	tst.w	carStateDirection(a4)
	beq	.exit
; Is Accereraing.
	tst.b	carSoundScreetch(a4)
	bmi	.exit			; Already screetching
	subq.b	#1,carSoundScreetch(a4)

; Only screetch if going very fast

	moveq	#sampleSkid,d0
	bsr	agdPlayIngameSample
	bra	.exit
	
; Stop the screetch sound
.clear_screetch:
	clr.b	carSoundScreetch(a4)
	bra	.exit
	
.steer_to_centre:
	clr.w	carSteerTime(a4)
	move.l	carCurrentThrottle(a4),d0	; 400
	;moveq	#CAR_DELAY_OUTSKID,d1		; This is how quick the car comes out of a skid/drag.

	cmp.l	#$80,carCurrentThrottle(a4)
	ble.s	.clear_steer
	
	move.l	d0,d2
	lsr.l	#4,d2
	move.l	#$80,d1
	sub.b	d2,d1
	
	tst.w	carSteerMod(a4)
	beq	.exit
	bmi	.steer_decr_left
	bra	.steer_decr_right

.clear_steer:
; The greater the Throttle...  the less carSteerMod is reduced
;                              the less close WheelAngle is to DragAngle
	clr.w	carSteerMod(a4)
	move.b	carDragAngle(a4),carWheelAngle(a4)
	bra	.exit
	
	
; If the car is not moving then the decrease is instant
.steer_decr_left:
	add.w	d1,d1
	add.w	d1,carSteerMod(a4)
	bmi	.exit
	clr.w	carSteerMod(a4)	
	bra	.exit

.steer_decr_right:
	add.w	d1,d1
	sub.w	d1,carSteerMod(a4)
	bpl	.exit
	clr.w	carSteerMod(a4)	
	bra	.exit
	
.steer_incr_left:
	bsr	.steer_on
	cmp.w	#CAR_DEFAULT_STEER,carSteerMod(a4)			; 
	bgt	.exit
; steer must be mutlipled by the current throttle.
	add.w	#CAR_DEFAULT_STEER_MOD,carSteerMod(a4)	
	bra	.exit

.steer_incr_right:
	bsr	.steer_on
	cmp.w	#-CAR_DEFAULT_STEER,carSteerMod(a4)			;
	blt	.exit
	sub.w	#CAR_DEFAULT_STEER_MOD,carSteerMod(a4)	
	bra	.exit
	
.steer_on:
	move.b	carSteerTime(a4),carSteerTimeOld(a4)
	add.w	#$c,carSteerTime(a4)
	move.b	carSteerTime(a4),d0
	cmp.b	carSteerTimeOld(a4),d0
	beq	.exit
	
; play screetch
	moveq	#0,d0
	move.w	carCurrentTraction(a4),d0
	sub.w	#$100,d0
	
	cmp.l	carCurrentThrottle(a4),d0
	bgt	.exit
	
	moveq	#sampleSkid,d0	
	bsr	agdPlayIngameSample
	
	bra	.exit
	
.dec_traction:
	bra	.exit
	move.w	#CAR_MINIMUM_TRACTION,d0		; Min traction (100)
	cmp.w	carTractionMod(a4),d0
	bge	.exit
	nop
	;sub.w	#CAR_TRACTION_MOD,carTractionMod(a4)
	bra	.exit

.inc_traction:
	bra	.exit
	move.w	carCurrentTraction(a4),d0		; Max traction (500)
	cmp.w	carTractionMod(a4),d0
	ble	.exit
	;add.w	#CAR_TRACTION_MOD,carTractionMod(a4)	
	nop
	
	bra	.exit
	
.inc_drag:

	move.w	#CAR_DEFAULT_DRAG,d0					; Param
	cmp.w	carDragMod(a4),d0
	ble	.exit
	add.w	#CAR_DRAG_MOD,carDragMod(a4)				; Param
	bra	.exit
	
.drag_zero:
	clr.w	carDragMod(a4)
	bra	.exit

.check_accellerate:
	tst.w	carControlDisable(a4)
	bmi	.exit
	tst.w	carStateButton(a4)						; Accellerate?
	beq	.exit
	bsr	.dec_traction
	move.l	carCurrentThrottle(a4),d0
	move.l	carMaxHorsePower(a4),d1	
	cmp.l	carMaxThrottle(a4),d0
	ble	.max
	tst.w	carIsDrone(a4)				; Don't increase speed when max
	bmi	.exit					; if the car is a drone.
	move.l	FRAME_COUNT(a6),d1
	and.l	#1,d1

.max:	add.l	d1,carCurrentThrottle(a4)
	move.w	#-1,carApplyThrottle(a4)
	bra	.exit

.check_brake:
	tst.w	carStateButton(a4) d6
	bne	.exit
	bsr	.inc_traction
	tst.l	carCurrentThrottle(a4)
	bmi	.exit
	beq	.exit
	
	tst.w	carApplyThrottle(a4)
	beq.s	.push
	
	sub.l	#$8,carCurrentThrottle(a4)
	clr.w	carApplyThrottle(a4)
	
.push:
; Last state was accelerating...
; New state is braking.
	move.l	carMaxBraking(a4),d0
	sub.l	d0,carCurrentThrottle(a4)
	bpl	.exit
	clr.l	carCurrentThrottle(a4)
	bra	.exit
	
.check_nitro:

	tst.w	carHasNitro(a4)
	bmi.s	.exit
	beq.s	.exit
	;moveq	#0,d0
	;move.w	carHasNitro(a4),d0
	;lsr.w	#6,d0
	;add.l	d0,carCurrentThrottle(a4)
	subq.w	#1,carHasNitro(a4)
	add.l	#$2,carCurrentThrottle(a4)
	bra	.exit
	
.apply_drag:
	move.b	carWheelAngle(a4),d0
	move.b	carSteerMod(a4),d1
	;moveq	#0,d1
	add.b	d1,d1
	add.b	d1,d1
	add.b	d1,d1
	sub.b	d1,d0
.spin:	move.b	d0,carDragAngle(a4)
	bra	.exit
	
.check_traction:
	bra	.exit
	
.apply_velocity:
	moveq	#$0,d3
	move.b	carWheelAngle(a4),d3		; angle		
	move.l	carCurrentThrottle(a4),d4
	move.l	d4,d5				; speed
	
	lea	SINE_TAB(pc),a1
	mulu.l	(a1,d3*4),d4			; XVel=COS(angle:d3)*speed:d4	
	mulu.l	64*4(a1,d3*4),d5		; YVel=SIN(angle:d3)*speed:d5

	add.l	d4,carXpos(a4)			; XPos+=XVel 
	add.l	d5,carYpos(a4)			; YPos+=YVel
	bra	.exit
	nop
.exit:	
	;move.l	GAME_FIRST_PLAYER(a6),d0	; Need to somehow get first two players
	cmp.l	#3,carNumber(a4)		; in the game....
	beq.s	.no_change
	
	move.l	carCurrentThrottle(a4),d7
	lsr.l	#4,d7
	cmp.w	carLastSampleThrottle(a4),d7
	beq.s	.no_change
	move.w	carThisSampleThrottle(a4),carLastSampleThrottle(a4)
	move.w	d7,carThisSampleThrottle(a4)
	
.play:	moveq	#sampleEngine,d0	
	bsr	agdPlayLoopedSample
	
.no_change:
	IFNE	DEBUGGING_OSD
	cmp.l	#CAR_1,carNumber(a4)
	bne.s	.dbg
	move.w	carElevation(a4),DEBUG_carElevation
	move.w	carIsFallingIndex(a4),DEBUG_carIsFallingIndex
	move.w	carCurrentFrame(a4),DEBUG_carCurrentFrame
	move.l	carLevel(a4),DEBUG_carLevel
	move.b	carFrontTerrainBlock(a4),DEBUG_carFrontTerrainBlock
	move.l	carCurrentThrottle(a4),DEBUG_carCurrentThrottle
	move.b	carWheelAngle(a4),DEBUG_carWheelAngle
	move.b	carDragAngle(a4),DEBUG_carDragAngle
	move.w	carSteerMod(a4),DEBUG_carSteerMod
	move.w	carDragMod(a4),DEBUG_carDragMod
	move.w	carPriOveride(a4),DEBUG_carPriOveride
	move.w	carSpinTimer(a4),DEBUG_carSpinTimer
	move.w	carTimeInPlay(a4),DEBUG_carTimeInPlay
	move.w	carSteerTime(a4),DEBUG_carSteerTime
	move.w	carOnTrack(a4),DEBUG_carOnTrack
	nop
	ENDC
.dbg:	rts



ssCarsNumberOfPlayers:

		moveq	#0,d0
		moveq	#CAR_1,d1
		
.loop:		
		GET_CAR_CONTEXT
		
		dbf	d1,.loop
		rts

; Car context is in a4	
ssExplodeCar:
		movem.l	d0-d7/a0-a3,-(a7)
		moveq	#sampleExplode,d0
		bsr	agdPlayIngameSample
		
		move.w	#-1,carExploding(a4)
		move.w	#-1,carControlEnabled(a4)		; Disable controls.
		move.l	carYpos(a4),carLastYpos(a4)		; Need to pivot from last Y position for crash.
	
; Decide here on position of car which sprite sheet to use (lower or full sets)
; Full sets are deployed after line $38 because they can be clipped on the upper Y axis
		moveq	#sprCarExplodeSet1,d0
		lea	hdlCarExplodeSet1,a0	
		moveq	#0,d2
		move.w	carYpos(a4),d2
		cmp.w	#$38,d2
		bge.s	.full
		
		addq.w	#2,d2
		moveq	#sprCarExplodeLower,d0
		lea	hdlCarExplodeLower,a0		
.full:
		moveq	#0,d1
		move.w	carXpos(a4),d1
		subq.w	#8,d1
		moveq	#0,d3
		move.l	carNumber(a4),d5
		move.l	#(LEVEL_UPPER_BITMAP<<16)+LEVEL_UPPER_TRACK,d6
		move.l	#LEVEL_UPPER_BITMAP,carLevel(a4)
		bsr	agdDispatchSprite
		
		clr.l	carXpos(a4)
		clr.l	carYpos(a4)
		clr.w	carIsFalling(a4)
		clr.w	carIsFallingIndex(a4)
		clr.l	carCurrentThrottle(a4)
		
		movem.l	(a7)+,d0-d7/a0-a3
		rts
		

; Sets all car priorities to low
ssSetCarsLowPriority:
	moveq	#maxCars-1,d7
	moveq	#CAR_1,d1
.loop:	GET_CAR_CONTEXT
	clr.w	carPriOveride(a4)
	addq.w	#1,d1
	dbf	d7,.loop
	rts
	
ssAnimateCars:	
	bsr	ssOrderCars
	bsr	ssSetCarsLowPriority			; Vpos 0 execution.	
	lea	CAR_PRI(a6),a0
; d2 - number to prioritise
; a0 - Sprite Order

	moveq	#0,d1
	move.b	(a0)+,d1
	moveq	#0,d6
	bsr	ssAnimateCar	

	moveq	#0,d1	
	move.b	(a0)+,d1
	moveq	#1,d6
	bsr	ssAnimateCar
	
	moveq	#0,d1	
	move.b	(a0)+,d1
	moveq	#2,d6
	bsr	ssAnimateCar
	
	moveq	#0,d1	
	move.b	(a0)+,d1
	moveq	#3,d6
	bsr	ssAnimateCar
		
; Set priorities in the copper
	move.l	COPPTR_BPLCON2(a6),a1
	lsl.w	#3,d2			; PF2 bits
	move.l	(a1),d6
	and.w	#%1111111111000111,d6
	or.w	d2,d6
	IFNE	DEBUG_COLLISION_MAP	; Fake car priorities to upper field.
	or.w	#%111000,d6	
	ENDC
	move.l	d6,(a1)
	rts
	
; Out=d2 number to prioritise
ssOrderCars: 
	lea	CAR_PRI(a6),a0			; Prir
	moveq	#0,d2				; Priorise upper counter of BPLCON2
	moveq	#maxCars-1,d1
	
; Find the number to prioritise in d2
.loop1:	GET_CAR_CONTEXT
	move.l	carLevel(a4),carOldLevel(a4)
	
	;tst.w	carPriOveride(a4)		; -1 when spinning (override priority).
	;beq.s	.1
	;move.l	#1,carLevel(a4)
	;nop
.1:	cmp.l	#LOWER_LEVEL,carLevel(a4)
	beq.s	.next1
	move.b	d1,(a0)+			; Priority

	addq.w	#1,d2
.next1:	dbf	d1,.loop1



	moveq	#maxCars-1,d1
.loop2:
	GET_CAR_CONTEXT
	
	cmp.l	#UPPER_LEVEL,carLevel(a4)
	beq.s	.next2
	move.b	d1,(a0)+			; Priority
.next2:	move.l	carOldLevel(a4),carLevel(a4)
	dbf	d1,.loop2
	rts
	

; d1=car number
; d6=sprite number
ssAnimateCar:
	movem.l	d0-d7/a0-a4,-(a7)
	move.l	d1,d2				; Car number
	GET_CAR_CONTEXT
	
	tst.w	carExploding(a4)
	bmi	.exit
	
	tst.w	carControlEnabled(a4)
	bmi	.exit
	
	bsr	.flash

	moveq	#0,d7
	tst.w	carControlDisable(a4)
	bmi.s	.no_change_frame
	
	lea	CAR_ANIM_LUT(a6),a3
	moveq	#0,d0		
	move.b	carDragAngle(a4),d0		; (0-$ff)
	
	tst.w	carSpinTimer(a4)
	bmi	.no_spin
	add.w	carSpinTimer(a4),d0
	and.w	#$ff,d0
	
.no_spin:
	move.b	(a3,d0),d7			; This is the car frame.
	move.w	d7,carCurrentFrame(a4)
	
.no_change_frame:	
	move.w	carXpos(a4),d0
	move.w	carYpos(a4),d1
	
	move.w	carCurrentFrame(a4),d7
	add.l	carColour(a4),d7		; Car colour
	
	move.l	LACPTR_CARS_SPRITESHEET(a6),a0
	moveq	#0,d2
	move.w	VPOSR(a5),d2
	rol.w	#1,d2
	;not.w	d2
	and.w	#1,d2
	move.l	hLacedOddSpriteSheet(a0,d2*4),a0
	move.l	COPPTR_SPRPTH0(a6),a1
	
	add.w	#127,d0
	add.w	#22,d1
	bsr	agdShowHardwareSprite
	bra	.exit

.flash:	tst.l	carTimer(a4)				
	bmi.s	.rts
	subq.w	#1,carTimer(a4)
	movem.l	d0-d3/a0-a1,-(a7)

; Get the copper pointer	
	lea	COPPTR_CAR_OFFSETS(a6),a0
	move.l	(a0,d1*4),d3			; Pointer to copper values	
	move.l	d3,a0				; d3=offset number
	add.l	COPPTR_CAR_PALS(a6),a0
	
	move.w	carTimer(a4),d0			; divide by 8
	beq.s	.clear
	
	lsr.l	#3,d0
	not.w	d0
	and.l	#1,d0	
	ror.w	#1,d0
	ext.l	d0
	rol.l	#8,d0
	rol.l	#4,d0
	
	tst.w	carHasNitro(a4) 
	beq.s	.x
	sub.w	carHasNitro(a4),d0
	subq.w	#1,carHasNitro(a4)
	
.x:
	and.w	#$777,d0
	
.clear:	move.l	PALPTR_INGAME_CARS(a6),a1		; Get original source car colours
	lea	hPalette(a1),a1				;
	add.l	d3,a1

	move.w	2(a1),d2
	eor.w	d0,d2
	move.w	d2,2(a0)
	
	move.w	6(a1),d2
	eor.w	d0,d2
	move.w	d2,6(a0)
	
	movem.l	(a7)+,d0-d3/a0-a1
	bra	.rts

.exit:	movem.l	(a7)+,d0-d7/a0-a4
.rts:	rts


; d1=car to reset
ssCarResetColours:
	movem.l	d0-d3/a0-a1,-(a7)
	lea	COPPTR_CAR_OFFSETS(a6),a0
	move.l	(a0,d1*4),d3			; Pointer to copper values	
	move.l	d3,a0				; d3=offset number
	add.l	COPPTR_CAR_PALS(a6),a0
	
.clear:	move.l	PALPTR_INGAME_CARS(a6),a1		; Get original source car colours
	lea	hPalette(a1),a1				;
	add.l	d3,a1

	move.w	2(a1),d2
	eor.w	d0,d2
	move.w	d2,2(a0)
	
	move.w	6(a1),d2
	eor.w	d0,d2
	move.w	d2,6(a0)
	
	movem.l	(a7)+,d0-d3/a0-a1
	rts


	CNOP	0,4
	


;In
; a0 = Sprite sheet
;Out
; d0 = -1 collision
ssCarToTerrain:
	move.l	d1,-(a7)
	moveq	#0,d1
	moveq	#0,d2
	move.b	carDragAngle(a4),d1
	lea	CAR_ANIM_LUT(a6),a3
	move.b	(a3,d1),d1
	
	move.l	SPSPTR_CAR_COLLMAP(a6),a0
	move.l	hAddress(a0),a0
	move.l	(a0,d1*8),a0			; Pointer to sprite


.left_bound:	
	moveq	#0,d0
	move.w	carXpos(a4),d0			; xpos
	cmp.w	#32,d0
	bgt.s	.right_bound
; Hit left
	move.b	#5,carFrontTerrainBlock(a4)
	moveq	#-1,d0
	bra	.exit

.right_bound:
	cmp.w	#256+16,d0
	blt.s	.up_bound
	move.b	#6,carFrontTerrainBlock(a4)
	moveq	#-1,d0	
	bra	.exit
	
.up_bound:
	moveq	#0,d1
	move.w	carYpos(a4),d1			; ypos
	cmp.w	#20,d1
	bgt.s	.inbound
	move.b	#7,carFrontTerrainBlock(a4)
	moveq	#-1,d0
	bra	.exit

.inbound:

	COMPENSATE_HWSPRX
	COMPENSATE_HWSPRY
	lsl.l	#6,d1				; Mutliply by 512
	
	IFNE	DEBUG_COLLISION_MAP
	move.l	SCRPTR_LOWER_TRACK_MASK(a6),a1
	move.l	hAddress(a1),a1
	ELSE

	move.l	BMPPTR_LOWER_TRACK_MASK(a6),a1	
	tst.l	carLevel(a4)
	beq.s	.lower
	move.l	BMPPTR_UPPER_TRACK_MASK(a6),a1	
.lower:
	move.l	hBitmapBody(a1),a1
	addq.w	#8,a1
	ENDC
	
	add.l	d1,a1
	
	move.l	d0,d1
	and.w	#$f,d1	
	
	and.w	#$fff0,d0
	lsr.w	#3,d0
	add.l	d0,a1				; to word offset.
	
;a=Car
;
	lea	$dff000,a5
	WAIT_FOR_BLITTER

	lea	$dff000,a5
	move.w	#80-6,BLTAMOD(a5)		; 320/8=40 - 48/8=6 	; Sprite
	move.w	#128-6,BLTCMOD(a5)		; 512/8=64 - 48/8=6	; Track
	move.w	#128-6,BLTDMOD(a5)		; 512/8=64 - 48/8=6	; Screen
	move.l	#$ffff0000,BLTAFWM(a5)
	
	ror.w	#4,d1
	move.w	d1,BLTCON1(a5)
	IFEQ	DEBUG_COLLISION_MAP
	or.w	#$aa0,d1			; A+C Chans or.	
	ELSE
	or.w	#$aa0,d1
	;or.w	#$b5f,d1			;
	ENDC
	
	move.w	d1,BLTCON0(a5)
	move.l	a0,BLTAPTH(a5)			; This is correct
	move.l	a1,BLTCPTH(a5)
	move.l	a1,BLTDPTH(a5)

	move.w	#(12<<6)+3,BLTSIZE(a5)		; 32x32+16
	
	WAIT_FOR_BLITTER
	lea	$dff000,a5	
	moveq	#0,d0
	btst	#13,DMACONR(a5)
	bne.s	.exit
	moveq	#-1,d0

.exit:	
	IFNE	DEBUGGING_OSD
	cmp.l	#CAR_1,carNumber(a4)
	bne.s	.dbg
	move.w	d0,DEBUG_ONTERRAIN
	ENDC

.dbg:	move.w	d0,carOnTrack(a4)
	tst.w	d0
	bmi.s	.e
	nop
.e:
	move.l	(a7)+,d1
	rts
	

	
	
		
; d1=This car
ssCarToCarCollision:
	tst.w	RACE_OVER(a6)
	bne	.exit
	
	;move.w	CLXDAT_STATE(a6),$120
	move.w	CLXDAT_STATE(a6),d2	
	beq	.clear

	moveq	#0,d6
	lea	.colltab(pc),a0
	moveq	#5,d7
.l1:	btst	d7,d2
	beq.s	.n1
	or.b	(a0,d7),d6
.n1:	dbf	d7,.l1

; this sets the car bits for each sprite.
	;move.w	d6,DEBUG_SHUNTSRC
	;move.w	d6,$122

;d6=3 0011 Sprites 1+2

; translate this sprite to the car.	
	move.l	CAR_PRI(a6),d4
	;move.l	d4,$124
	moveq	#maxCars-1,d5
	moveq	#0,d3
.bitloop:
	move.b	d4,d2		; get the last bit.
	btst	d5,d6			
	beq.s	.nb
	bset	d2,d3
.nb:	lsr.l	#8,d4
	dbf	d5,.bitloop
	
	move.w	d3,d6

; re-order bits
	btst	d1,d6			; Is this car involved in a collision?
	beq	.exit
	bclr	d1,d6
	
	tst.b	carTouchingCars(a4)	; only execute when zero
	beq.s	.action
	bra	.exit
	
.action:	
	subq.b	#1,carTouchingCars(a4)	; Collision check every 256 frames
		
; Need to loop through bits in d3
; Put car context in a1

	moveq	#maxCars-1,d5 		; check 4 bits
	moveq	#0,d7
.loop:	btst	d7,d6
	beq.s	.next
	bsr	.shunt
.next:	addq.b	#1,d7
	dbf	d5,.loop
	
	bra	.exit

; a4 = Player context of this car (d1) 
; d7 = Collided car mumber (opponent) to shunt
.shunt:
	;cmp.w	#CAR_1,d1
	;bne.s	.5
	;clr.w	$100
.5:	move.l	d7,d4
	lea	carStruct(a6),a1
	lsl.l	#carStructShiftSize,d4
	add.l	d4,a1	

; can't use d1,d3,d4 or d7, a1
; available is a0,a2,d0,d2,d5,d6
	
; Cause action on player car for collision, ensure no collision is done for any sprites
; that are exploding.
	tst.w	carControlEnabled(a4)
	bmi.s	.skip_oppo
	
	move.l	carLevel(a4),d0			; Don't collide if on a different level
	cmp.l	carLevel(a1),d0
	bne	.exit
	
	moveq	#0,d0
	move.b	carWheelAngle(a4),d0		; Get player wheel direction
	lsr.b	#6,d0					; Direction of travel (0=down, 1=Right, 2=Up 3=Left)	
	lea	.oppo_tab(pc),a0
	move.l	(a0,d0*4),a0
	jsr	(a0)

.skip_oppo:	
	tst.w	carControlEnabled(a1)
	bmi.s	.skip_player
	moveq	#0,d1
	move.b	carWheelAngle(a1),d1
	lsr.b	#6,d1					; d0 now has (00,01,02,03) (10,11,12,13), (20,21,22,23), (30,31,32,33)
	lea	.player_tab(pc),a0
	move.l	(a0,d1*4),a0
	jsr	(a0)	

;	cmp.b	d0,d1
;	beq.s	.no_spin
;'.spin:
;'	move.w	#(30*8),carSpinTimer(a4)		; spin for 2 seconds as collision here.
	
.no_spin:
	moveq	#sampleCarHit,d0
	bsr	agdPlayIngameSample

.skip_player:	
	bra	.exit
	
.player_tab:	
	dc.l	.player_left			; 0,0 player car and opponent car moving down so shuffle left, right
	dc.l	.player_up
	dc.l	.player_right
	dc.l	.player_down
	
.oppo_tab:
	dc.l	.oppo_left			;
	dc.l	.oppo_up
	dc.l	.oppo_right
	dc.l	.oppo_down
	
.clear:	clr.b	carTouchingCars(a4)
	bra.s	.exit
	
.player_left:	subq.w	#2,carXpos(a4)		
		subq.b	#8,carWheelAngle(a4)
		bra.s	.player_set_throttle
.player_up:	subq.w	#2,carYpos(a4)	
		subq.b	#8,carWheelAngle(a4)		
		bra.s	.player_set_throttle
.player_right:	addq.w	#2,carXpos(a4)		
		addq.b	#8,carWheelAngle(a4)	
		bra.s	.player_set_throttle
.player_down:	addq.w	#2,carYpos(a4)
		addq.b	#8,carWheelAngle(a4)			
		bra.s	.player_set_throttle
		nop
.player_set_throttle:
		cmp.l	#$180,carCurrentThrottle(a4)
		ble	.exit
		sub.l	#$100,carCurrentThrottle(a4)
		bra	.exit
	
.oppo_left:	addq.w	#3,carXpos(a1)			
		bra.s	.oppo_set_throttle
.oppo_up:	addq.w	#2,carYpos(a1)			
		bra.s	.oppo_set_throttle
.oppo_right:	subq.w	#3,carXpos(a1)			
		bra.s	.oppo_set_throttle
.oppo_down:	subq.w	#2,carYpos(a1)			
		bra.s	.oppo_set_throttle
		nop
.oppo_set_throttle:
		bra	.exit
		
			;   0
.colltab:	dc.b	%0011,%0101,%1001,%0110,%1010,%1100
		even
.exit:		rts
	
		
;	0-63		0-1   0-2   0-3   1-2   1-3   2-3



; In d0/d1 = car x and y origin
; d3=In Angle to apply from $40=front
; Out d4/d5 = car x and y line 
ssCarAngleFromOrigin:
	movem.l	d0-d1/a0,-(a7)
; Now find the sine/cosine to front of the car.
	moveq	#0,d2
	move.b	carWheelAngle(a4),d2
	not.b	d2
	add.b	d3,d2				; Front angle.
; Need to place nose in front of the car
	lea	SINE_TAB(pc),a0
	move.l	(a0,d2*4),d4			; Sin Y
	add.b	#$40,d2
	move.l	(a0,d2*4),d3			; Cos X
	lsr.l	#4,d3				; Adjust this to 3 (Tighter collision)
	lsr.l	#4,d4				; Adjust this to 3 (Tighter collision)
	ext.l	d3
	ext.l	d4
	add.w	d3,d0				; Add X
	bpl.s	.x
	moveq	#0,d0
.x:	add.w	d4,d1				' Add Y
	bpl.s	.y
	moveq	#0,d1
.y:	move.l	d0,d4
	move.l	d1,d5
	movem.l	(a7)+,d0-d1/a0
	rts
	
;  
; Input
; d1=Car

ssGetPositionBlocks: 
	movem.l	d1/d5/d6,-(a7)
	GET_CAR_CONTEXT

; Adjust x and y position due to hw sprites and interlaced screen
; Xpos
	moveq	#0,d0
	move.w	carXpos(a4),d0

	COMPENSATE_HWSPRX
		
; Ypos
	moveq	#0,d1
	move.w	carYpos(a4),d1

	COMPENSATE_HWSPRY

	add.w	#16,d0				; ; d0/d1 has top left of the car sprite
	add.w	#12,d1	
	
	lea	TRACK_LAYERS,a0			;%%%%
	move.l	carLevel(a4),d2
	lsl.l	#4,d2				; Upper Layers
	
; Now get the command blocks orgin to the car level
	move.l	8(a0),a2				; a2 checkpoints
	move.l	24(a0),a3				; Elevation
	move.l	4(a0,d2),a1				; a1 has drone guides
	move.l	(a0,d2),a0				; a0 has terrain
	
	IFEQ	TRACK_BUILD_MODE
	move.l	(a3),a3
	move.l	(a3),a3
	move.l	(a2),a2
	move.l	(a2),a2
	move.l	(a1),a1
	move.l	(a1),a1
	move.l	(a0),a0
	move.l	(a0),a0
	ENDC

; Get the rear terrain block of the car	
	move.l	a0,-(a7)
	move.l	#$c0,d3				; Angle to get (rear)
	bsr	ssCarAngleFromOrigin		; d0/d1
	lsr.w	#3,d4				; divide X by 8
	lsr.w	#3,d5				; divide Y by 8
	lsl.w	#6,d5				; multiply by 64 (Y Position)
	add.l	d4,d5				; d5 now has index into buffer	
	move.w	d5,carRearCollisionOffset(a4)
	add.l	d5,a0
	move.b	(a0),carRearTerrainBlock(a4)	; Get the block at the front of the car	
	move.l	(a7)+,a0

; Get the front terrain block of the car
	move.l	#$40,d3				; Angle to get (front)
	bsr	ssCarAngleFromOrigin		; d0/d1
	move.w	d4,carCrashXpos(a4)
	move.w	d5,carCrashYpos(a4)
	lsr.w	#3,d4				; divide X by 8
	lsr.w	#3,d5				; divide Y by 8
	lsl.w	#6,d5				; multiply by 64 (Y Position)
	add.l	d4,d5				; d5 now has index into buffer	
	move.w	d5,carFrontCollisionOffset(a4)
	add.l	d5,a0
	move.b	(a0),carFrontTerrainBlock(a4)	; Get the block at the front of the car	
	
; a0 is now freed

	add.l	d5,a1
	add.l	d5,a2
	add.l	d5,a3

.get_elevation_block_start:
	clr.w	carRampAngleAdjust(a4)
	moveq	#0,d7
	move.b	(a3),d7					; Get elevation 
	beq.s	.get_checkpoint_block_start
	sub.b	#$20,d7
	and.w	#$ff,d7
	bne.s	.elev2					; Zero?
	move.l	#LEVEL_LOWER_TRACK,carLevel(a4)		; Yes so move to lower level
	bra.s	.elev3

.elev2:	
	
	move.l	#LEVEL_UPPER_TRACK,carLevel(a4)

.elev5:	
	tst.w	carIsFallingIndex(a4)
	beq.s	.land
	
	movem.l	d0-d7/a0-a3,-(a7)
	moveq	#4,d7
	bsr	ssCarSmokes
	movem.l	(a7)+,d0-d7/a0-a3
	
.land:	clr.w	carIsFalling(a4)
	clr.w	carIsFallingIndex(a4)
.elev3:	move.b	carElevation(a4),carLastElevation(a4)
	move.b	d7,carElevation(a4)
	cmp.b	carLastElevation(a4),d7
	beq.s	.elev4
	cmp.w	#1,d7
	bne.s	.elev4
	move.w	#1,carRampAngleAdjust(a4)		; Set direction of ramp wheel adjust
	tst.w	carIsDrone(a4)
	beq.s	.elev4
	add.l	#$80,carCurrentThrottle(a4)		; Speed up drone if hitting a ramp or jump
.elev4:	
	
	
.get_checkpoint_block_start:
	moveq	#0,d7
	move.b	(a2),d7					; $20 Get this command block
	clr.w	carCommandDiff(a4)	
	cmp.b	carCommandBlock(a4),d7			; $21 = 0 ; False
	beq.s	.get_checkpoint_block_end		
	move.w	#-1,carCommandDiff(a4)

	move.b	carCommandBlock(a4),carLastCommandBlock(a4)	; Save previous command block
	move.b	d7,carCommandBlock(a4)	
.get_checkpoint_block_end:	

; This section gets the drone guide data
; It sets the carDroneAccelleate and finds carDroneAngle

.get_guide_block_start:	
	tst.w	carIsDrone(a4)
	beq.s	.get_guide_block_end

	moveq	#0,d7
	move.b	(a1),d7					; Drone guide angle
	bpl.s	.get_guide_block_end
	
; bit 7 is set $80+
	;moveq	#0,d6
	and.b	#%00111111,d7				; Clear last bit
	;move.b	d7,d6
	;lsr.b	#5,d6
	;move.b	d6,carDroneAccellerate(a4)		; will be 1 if true, 0 if not
	
	and.b	#$1f,d7
	lsl.b	#3,d7
	add.b	#$c0,d7					; This is the andle
	move.b	carDroneGuideAngle(a4),carDroneLastGuideAngle(a4)
	move.b	d7,carDroneGuideAngle(a4)		; Drone dest guide angle.	
	;cmp.b	carDroneLastGuideAngle(a4),d7
	;beq.s	.get_guide_block_end
; reduce drone speed
	;cmp.l	#$100,carCurrentThrottle(a4)
	;ble.s	.get_guide_block_end
	;sub.l	#$20,carCurrentThrottle(a4)
	;nop
.get_guide_block_end:

	IFNE	DEBUGGING_OSD
	cmp.l	#CAR_1,carNumber(a4)
	bne.s	.exit
	move.l	carFrontTerrainBlock(a4),DEBUG_carFrontTerrainBlock
	ENDC
.exit:	

	IFNE	DEBUGGING_OSD
	cmp.l	#CAR_1,carNumber(a4)
	bne.s	.e
	move.w	carCommandBlock(a4),DEBUG_COMMAND_BLOCKS
	move.w	carLevel+2(a4),DEBUG_C1ELEV
	ENDC
.e:	movem.l	(a7)+,d1/d5/d6
	rts




; MEMPTR_COLLISION_RAM(a6) contains positions of cars.
; d1 is the car number (0-3)

ssSetPositionBlocks:
	GET_CAR_CONTEXT
	
	move.l	MEMPTR_COLLISION_RAM(a6),a0
	move.l	hAddress(a0),a0
	moveq	#0,d0
	move.w	carFrontCollisionOffset(a4),d0
	IFNE	DEBUG_CAR_COLLISION
	bsr	.plot
	ENDC
	add.l	d0,a0
		
	moveq	#0,d0
	move.b	carWheelAngle(a4),d0		; Get car wheel direction
	sub.b	#$10,d0
	
	lsr.b	#5,d0				; 0-7 directions
	and.l	#$7,d0
	
	lea	.tab(pc),a1
	move.l	(a1,d0*4),a1
	jmp	(a1)
	
.plot:
	movem.l	d0-d7/a0-a3,-(a7)
	move.l	DBSPTR_UPPER_TRACK(a6),a0
	move.l	hDbuffScreen1(a0),a0
	move.l	hScreenPointers(a0),a0
	
	move.l	d0,d1
	and.w	#%0000000000111111,d0			; X
	and.w	#%1111111111000000,d1
	lsl.l	#2,d1					; Multiply x by 4
	lsl.l	#3,d1					; Then multiply by 8

	add.l	d0,a0
	add.l	d1,a0
	
	rept	16
	move.b	#$-1,0(a0)
	move.b	#$-1,1(a0)	
	add.l	#64*4,a0
	endr
	
	
	movem.l	(a7)+,d0-d7/a0-a3
	rts
	
	
.tab:	dc.l	.south,.south_east,.east,.north_east,.north,.north_west,.west,.south_west

.north:
.south:		bset	d1,0(a0)				;   01	
		bset	d1,1(a0)				; 0 XX
		add.l	#64,a0					; 1 XX
		bset	d1,0(a0)				; 2 XX
		bset	d1,1(a0)
		add.l	#64,a0
		bset	d1,0(a0)		
		bset	d1,1(a0)
		bra	.exit
		
.west:	
.east:		add.l	#64,a0					;   01
		bset	d1,0(a0)				; 0 --
		bset	d1,1(a0)				; 1 XX
		bra	.exit					; 2 --
		
.south_east:	add.l	#64,a0					
		bset	d1,0(a0)
		add.l	#64,a0
		bset	d1,1(a0)				
		bra	.exit
		
.north_east:	bset	d1,1(a0)
		add.l	#64,a0
		bset	d1,0(a0)		
		bra	.exit
	
.north_west:	bset	d1,0(a0)
		add.l	#64,a0
		bset	d1,1(a0)
		bra	.exit
		
.south_west:	add.l	#64,a0
		bset	d1,1(a0)
		add.l	#64,a0
		bset	d1,0(a0)
		bra.s	.exit
		nop
.exit:		rts
	
	
	

ssCarRebound:	bsr	ssCarSmokes
		bsr	ssCarReboundAngle
		rts
	
; In d1=Car
;	d7=Track Command
; Out d7=0 - no
ssCarSmokes:
	;moveq	#0,d7
	;move.b	carFrontTerrainBlock(a4),d7
	;and.b	#$f,d7
	lea	COLLISION_BASE(a6),a0
	tst.w	(a0,d7*2)
	beq	.exit
	
	add.w	(a0,d7*2),a0		; Get the frames
	
	moveq	#0,d7
	move.w	carCurrentFrame(a4),d7	; 
;
; Possible problem here.  (there is only 24 car frames) - 0 to $1d
;
	
	moveq	#0,d4
	move.w	2(a0,d7*8),d4	
	beq	.exit

; Reaction sprite #1	
	move.l	4(a0,d7*8),d5		; d5 = [Sprite 2 Y Offset].b
					;      [Sprite 2 X Offset].b
					;      [Sprite 1 Y Offset].b
					;      [Sprite 1 X Offset].b
	
	movem.l	d0-d7/a0-a4,-(a7)
	moveq	#0,d0
	move.w	d4,d0
	and.w	#$ff,d0
	tst.b	d0
	beq.s	.1
	move.w	carCrashXpos(a4),d1
	move.w	carCrashYpos(a4),d2
	
	moveq	#0,d3			; Y Position Sprite 2
	move.b	d5,d3
	ext.w	d3
	lsr.l	#8,d5
	add.w	d3,d2
	
	moveq	#0,d3			; X Position Sprite 2
	move.b	d5,d3
	ext.w	d3
	lsr.l	#8,d5
	add.w	d3,d1	
	
	move.l	d5,-(a7)
	moveq	#0,d3
	move.l	carLevel(a4),d6
	lea	hdlSmoke,a0
	move.l	carNumber(a4),d5
	bsr	agdDispatchSprite
	move.l	(a7)+,d5
.1:	movem.l	(a7)+,d0-d7/a0-a4
	
; Reaction sprite #2	
	movem.l	d0-d7/a0-a4,-(a7)
	swap	d5
	
	moveq	#0,d0
	move.w	d4,d0
	lsr.w	#$8,d0
	tst.b	d0
	beq.s	.2
	move.w	carCrashXpos(a4),d1
	move.w	carCrashYpos(a4),d2

	moveq	#0,d3			; Y Position Sprite 1
	move.b	d5,d3
	ext.w	d3
	lsr.l	#8,d5
	add.w	d3,d2
	
	moveq	#0,d3			; X Position Sprite 1
	move.b	d5,d3
	ext.w	d3
	lsr.l	#8,d5
	add.w	d3,d1	
	
	move.l	d5,-(a7)
	moveq	#0,d3
	move.l	carLevel(a4),d6
	lea	hdlSmoke,a0
	move.l	carNumber(a4),d5
	bsr	agdDispatchSprite
	move.l	(a7)+,d5
	
.2:	movem.l	(a7)+,d0-d7/a0-a4
.exit:	rts


ssCarReboundAngle:
	;moveq	#0,d7
	;move.w	carCurrentFrame(a4),d7
	;and.b	#$1f,d7
	;lea	COLLISION_BASE(a6),a0
	
.other:	
	move.w	(a0,d7*8),d7		; Get the collision ($ff/Reverse or $fe/SetDir)
	beq.s	.exit			; Nothing to do....
	
	move.w	d7,d6
	and.w	#$ff,d7			; d7 = new direction angle
	lsr.w	#8,d6			; 
	and.w	#$1,d6			
	beq.s	.enable_controls
	
.disable_controls:
	tst.w	carSpinTimer(a4)
	bpl.s	.exit
	move.b	carDragAngle(a4),carLastCollisionAngle(a4)
.angle:
	move.w	#-1,carControlDisable(a4)		; Disable controls	
	move.l	#$100,carCurrentThrottle(a4)		; Set throttle
	move.w	#-1,carRebounding(a4)			; Set car Rebounding
	bra.s	.set
	
.enable_controls:
	move.l	#$100,carCurrentThrottle(a4)		; Set throttle
.set:	move.b	d7,carWheelAngle(a4)			; Set car angle
	move.b	d7,carLastWheelDirection(a4)
	move.b	d7,carDragAngle(a4)


	;bsr	agdSetCarXYVelocity
.exit:	rts
	
	
; d7=Number
ssCarCheckpoints:
	move.l	d7,-(a7)

	and.l	#$ff,d7	
	sub.b	#$40,d7					; 1 then Last checkpoint must be 
	subq.b	#1,d7
	
	cmp.b	carLastCheckPoint(a4),d7		; might be 0
	bne	.exit

; Car advanced to next checkpoint
	move.l	carXpos(a4),carCheckPointXpos(a4)	; Save checkpoint incase of crash
	move.l	carYpos(a4),carCheckPointYpos(a4)
	move.b	carWheelAngle(a4),carCheckPointWheelAngle(a4)
	move.w	carElevation(a4),carCheckPointElevation(a4)
	move.l	carLevel(a4),carCheckPointLevel(a4)
	
	addq.b	#1,d7					; Check point increased
	move.b	d7,carLastCheckPoint(a4)
	clr.w	carTimeSinceLastCheckPoint(a4)
	
	move.l	carScoreMultiplier(a4),d1
	add.l	d1,carScore(a4)			
	
	move.w	#1,carUpdateScore(a4)
	
	cmp.b	trackCheckPoints,d7
	bne.s	.exit
	IFEQ	INFINTE_LAPS
	addq.w	#1,carOnLap(a4)
	ENDC
	cmp.w	#MAX_LAPS,carOnLap(a4)
	bne.s	.go
	move.w	#-1,RACE_OVER(a6)
.go:
	move.w	#1,carUpdateLap(a4)
	clr.b	carLastCheckPoint(a4)


	lea	.tab(pc),a0
	moveq	#0,d0
	move.w	carOnLap(a4),d0
	move.w	(a0,d0*2),d0
	;moveq	#sprLap0,d0
	
	tst.w	FLAG_WAVING(a6)
	bmi	.exit
	
	move.l	trackFlagXPos,d1						; This needs to come from the track data!!!
	move.l	trackFlagYPos,d2
	moveq	#0,d3
	move.l	#(LEVEL_LOWER_BITMAP<<16)+LEVEL_LOWER_TRACK,d6
	lea	hdlLaps,a0
	bsr	agdDispatchSprite
	
	bra.s	.exit
	
.tab:	dc.w	sprLap0,sprLap0,sprLap1,sprLap2,sprLap2
	
.exit:	move.l	(a7)+,d7
	rts
	


;;; bsr 	GetCollisionBlock
;;; bsr		HandlePriorities - Bit 5
;;; bsr		HandleCheckPoints - Bit 6
;;; bsr		HandleCollisions - bits 1,2,3,4 (0-$1f)


; Bit 7 = $80   Drone guides
; Bit 6 = $40   Car checkpoints
; Bit 5 = $20	Track switch
; Bit 4 = $10	Barriers and terrain
ssCheckCarCollisions:
		GET_CAR_CONTEXT

		tst.w	carControlEnabled(a4)			; No collisions if car disabled
		bmi	.exit
		tst.w	carIsFalling(a4)			; No collisions if car is falling
		bmi	.exit
		
		bsr	ssCarToTerrain				; Is the car still on the bounds
		bsr	ssCarToCarCollision			; Car to car collisions
		
.checkpoints:	moveq	#0,d7
		move.b	carCommandBlock(a4),d7
		beq	.obstacle
		btst	#TERRAIN_BIT_CHECKPOINT,d7
		beq.s	.obstacle
		bsr	ssCarCheckpoints			; Value must be $40-7f
	
; bit 5 check terrain or no terrain.
.obstacle:	

.x:		moveq	#0,d7
		move.b	carFrontTerrainBlock(a4),d7
		
		cmp.w	#COLLECTABLE_OBJECT,d7			; is $c0 less than d7?
		bge	.exit		
		btst	#TERRAIN_BIT_OBSTACLE,d7		; Value must be $10-1f
		beq.s	.terrain
		
; No terrain check required on this
		and.b	#%1111,d7					
; This is pretty important.  $1-4 are used for the collectables  $5-8 are used for the barrier collisions
; $9-f are used for the track hazzards (oil, water, mud)
		cmp.b	#BOUND_BLOCKS_START,d7			; Only bound blocks between 5-9				
		blt	.exit
		bsr	ssCarRebound

		bra	.exit

.terrain:	and.b	#%1111,d7				; Value must be $0-f
		beq	.exit					; 
		
		cmp.b	#BOUND_BLOCKS_START,d7			; Must be greater than 4
		blt.s	.exit					; exit if less.
		
; Terrain check required
		tst.w	carOnTrack(a4)				; Over the circuit (uses Blitter)
		IFNE	DISABLE_TRACK_COLLISION
		bra	.exit
		ENDC
		beq.s	.exit					; No - so nothing to check.
		
		tst.b	carFrontTerrainBlock(a4)		; If the collision block is 0
		beq	.exit					; then do nothing.
		
		cmp.b	#TERRAIN_DESTRUCT_DESCENDING_CAR,carFrontTerrainBlock(a4)	
		beq.s	.descend_car				; Cause car to fall if on $0A and 
		
; Check here to see if car was going to fast and make it explode		
		cmp.l	#carExplodeThreshold,carCurrentThrottle(a4)
		bge.s	.explode
.rebound:	bsr	ssCarRebound
		bra	.exit
		
.in_spin:	move.w	#-1,carIsFalling(a4)			; Set car falling
		;move.w	#-1,carControlEnabled(a4)		; Disable controls.
		move.l	carYpos(a4),carLastYpos(a4)		; Need to pivot from last Y position for crash.	
		bra	.exit
; Max throttle on so destroy the car
.explode:	;move.w	CURRENT_TRACK(a6),d0
		;btst	#1,d0					; Only explode on tracks 2,4,6 & 8
		;beq.s	.rebound

		tst.w	carStateDirection(a4)			; player must be currently turning 
		beq.s	.rebound
		
		bsr	ssExplodeCar
		move.l	carYpos(a4),carLastYpos(a4)		; Need to pivot from last Y position for crash.
		bra	.exit


.descend_car:	

; Car is now falling...
; cause it to drop from carElevation value and explode.
		cmp.l	#0,carLevel(a4)				; Only if on upper level
		beq.s	.exit
		
		;tst.w	carIsDrone(a4)
		;beq.s	.is_player
		
; set land flag - causes drone to smoke wheels when landing.
		;move.w	#-1,carLandFlag(a4)

.is_player:
		move.w	#-1,carIsFalling(a4)			; Set car falling
		;move.w	#-1,carControlEnabled(a4)		; Disable controls.
		move.l	carYpos(a4),carLastYpos(a4)		; Need to pivot from last Y position for crash.
.exit:		rts


SINE_TAB:	
	dc.l	0,$3,$6,$9,$c,$f,$12,$15,$18,$1c,$1f,$22,$25,$28,$2b,$2e
	dc.l	$30,$33,$36,$39,$3c,$3f,$41,$44,$47,$49,$4c,$4e,$51,$53,$55,$58
	dc.l	$5a,$5c,$5e,$60,$62,$64,$66,$68,$6a,$6c,$6d,$6f,$70,$72,$73,$75
	dc.l	$76,$77,$78,$79,$7a,$7b,$7c,$7c,$7d,$7e,$7e,$7f,$7f,$7f,$7f,$7f
COS_TAB:
	dc.l	$80,$7f,$7f,$7f,$7f,$7f,$7e,$7e,$7d,$7c,$7c,$7b,$7a,$79,$78,$77
	dc.l	$76,$75,$73,$72,$70,$6f,$6d,$6c,$6a,$68,$66,$64,$62,$60,$5e,$5c
	dc.l	$5a,$58,$55,$53,$51,$4e,$4c,$49,$47,$44,$41,$3f,$3c,$39,$36,$33
	dc.l	$30,$2e,$2b,$28,$25,$22,$1f,$1c,$18,$15,$12,$f,$c,$9,$6,$3
	dc.l	$0,-$3,-$6,-$9,-$c,-$f,-$12,-$15,-$18,-$1c,-$1f,-$22,-$25,-$28,-$2b,-$2e
	dc.l	-$30,-$33,-$36,-$39,-$3c,-$3f,-$41,-$44,-$47,-$49,-$4c,-$4e,-$51,-$53,-$55,-$58
	dc.l	-$5a,-$5c,-$5e,-$60,-$62,-$64,-$66,-$68,-$6a,-$6c,-$6d,-$6f,-$70,-$72,-$73,-$75
	dc.l	-$76,-$77,-$78,-$79,-$7a,-$7b,-$7c,-$7c,-$7d,-$7e,-$7e,-$7f,-$7f,-$7f,-$7f,-$7f
	dc.l	-$80,-$7f,-$7f,-$7f,-$7f,-$7f,-$7e,-$7e,-$7d,-$7c,-$7c,-$7b,-$7a,-$79,-$78,-$77
	dc.l	-$76,-$75,-$73,-$72,-$70,-$6f,-$6d,-$6c,-$6a,-$68,-$66,-$64,-$62,-$60,-$5e,-$5c
	dc.l	-$5a,-$58,-$55,-$53,-$51,-$4e,-$4c,-$49,-$47,-$44,-$41,-$3f,-$3c,-$39,-$36,-$33
	dc.l	-$30,-$2e,-$2b,-$28,-$25,-$22,-$1f,-$1c,-$18,-$15,-$12,-$f,-$c,-$9,-$6,-$3
	dc.l	$0,$3,$6,$9,$c,$f,$12,$15,$18,$1c,$1f,$22,$25,$28,$2b,$2e
	dc.l	$30,$33,$36,$39,$3c,$3f,$41,$44,$47,$49,$4c,$4e,$51,$53,$55,$58
	dc.l	$5a,$5c,$5e,$60,$62,$64,$66,$68,$6a,$6c,$6d,$6f,$70,$72,$73,$75
	dc.l	$76,$77,$78,$79,$7a,$7b,$7c,$7c,$7d,$7e,$7e,$7f,$7f,$7f,$7f,$7f
	
	
	CNOP	0,4
	
	data
	
CLXDAT_STATE:		dc.w	0
	
CAR_PRI:	dc.l	0
		

	code	
