;------------------------------
;- Turbo Sprint 2020/21
;- Commodore Amiga AGA
;- Coded by McGeezer 
;- Audio by DJ Metune
;------------------------------
;
; How to build?
; Install the dev chain on Windows as shown here:
;   

VERSION MACRO
		dc.b	"                          ",0
		even		
	ENDM


ENABLE_DEBUG:		equ	0	; Switches off System Shutdown code for MonAm
DEBUGGING_OSD:		equ	0	; Enables OSD Debug
ENABLE_HANDLE_TRACKING:	equ	0	; Creates handle structure pointer at $120.l
DEBUG_COLOURS:		equ	0	; Used for when MonAm Debugging scenes
DISABLE_AUDIO:		equ	0	; Disable audio for UAE Debugging
ENABLE_PROTECTION:	equ	0	; Free play demo mode
ENABLE_SPRITE_TRACKING:	equ	0	; Enables car collision tracking on Bob Sprites
ENABLE_DEBUG_MESSAGES:	equ	0	
FREE_PLAY_TIME:		equ	(60*60)*5	; 6 minutes 



BUILD_ASSETS:		equ	0

LOAD_FROM_BOX:		equ	1

DEBUG_COLLISION_MAP:	equ	0
DEBUG_COLLISION_LOWER_MAP:	equ	0
DEBUG_COLLISION_UPPER_MAP:	equ	0
DEBUG_CAR_COLLISION:	equ	0
DISABLE_TRACK_COLLISION:	equ	0

NO_INPUT_INTERUPTS:	equ	ENABLE_DEBUG

ENABLE_INTER_BLITS:	equ	1

REQUIRED_CHIPRAM:	equ	$178000

ENABLE_CONVERT:		equ	0
CONVERT_SRCFILE	MACRO
		incbin	"assets/chopperb.iff",0
		ENDM
		
CONVERT_SUB	MACRO
		bsr	CONVERT_CHOPPER
		ENDM

START_DIFFICULTY:	equ	0
START_TRACK:		equ	1

; ---------------------------------------------------------------
; To build tracks, first export the tmx files to csv using Tiled
; Import each .csv for the guides, terrain and commands into 
; the tracks/test_trackN.asm file for the track number.
; 
; Tip: when importing the csv, use regec s/^/\tdc.b\t/g and s/-1/0/g
; 
; Test the track out by setting TRACK_BUILD_MODE to 1 and TEST_TRACK(N) 
; playing it and repeat the above step until correct.
;
; Be sure to set the other parameters in the structure such as
; starting car positions and directions and flag positions. 
;
; To save the track first, set SAVE_TRACKS and SAVE_TRACK(N) to 1, this
; will save the dat files for the tracks to DH1:TurboSprint/SavedTracks.
; Next run the packall.bat file which simply uses RNC to pack each file.
; 
; Copy the packed dat files into C:\Development\TurboSprint\Tracks\track(n)
; Then set BUILD_TRACKS and BUILD_TRACK(n) to 1
; this will then save out a trackN.box file which Turbo Sprint can read.
;

RELEASE:		equ	1

LEVELS_AB:		equ	1
LEVELS_A_ONLY:		equ	0
LEVELS_B_ONLY:		equ	0

; Track testing
TEST_GROUP_A:		equ	1
TEST_GROUP_B:		equ	0
TEST_GROUP_C:		equ	0
TEST_GROUP_D:		equ	0

TRACK_BUILD_MODE:	equ	0		; Read from data files in source
TEST_TRACK1:		equ	0		; Done
TEST_TRACK2:		equ	0		; Bugs
TEST_TRACK3:		equ	0		; Done
TEST_TRACK4:		equ	0		; Done
TEST_TRACK5:		equ	0		; Done
TEST_TRACK6:		equ	0		; Done
TEST_TRACK7:		equ	0		; Done
TEST_TRACK8:		equ	0		; Done

SAVE_TRACKS:		equ	0
SAVE_TRACK1:		equ	0		
SAVE_TRACK2:		equ	0		
SAVE_TRACK3:		equ	0		
SAVE_TRACK4:		equ	0		
SAVE_TRACK5:		equ	0		
SAVE_TRACK6:		equ	0		
SAVE_TRACK7:		equ	0		
SAVE_TRACK8:		equ	0	

BUILD_TRACKS:		equ	0
BUILD_TRACK1:		equ	0
BUILD_TRACK2:		equ	0
BUILD_TRACK3:		equ	0
BUILD_TRACK4:		equ	0
BUILD_TRACK5:		equ	0
BUILD_TRACK6:		equ	0
BUILD_TRACK7:		equ	0
BUILD_TRACK8:		equ	0



			IFNE	RELEASE
LOAD_TRACK_FROM_DF0:	equ	1		; 0 = Read tracks from local HD, 1=Read from DF0
LOAD_ALL_FROM_DF0:	equ	1		; Used for release, read all files from DFO
LOAD_RELATIVE_PATHS:	equ	1
			ELSE
			
			IFEQ	TRACK_BUILD_MODE
LOAD_TRACK_FROM_DF0:	equ	1		; 0 = Read tracks from local HD, 1=Read from DF0
LOAD_ALL_FROM_DF0:	equ	1		; Used for release, read all files from DFO
LOAD_RELATIVE_PATHS:	equ	1
			ELSE
LOAD_TRACK_FROM_DF0:	equ	0		; 0 = Read tracks from local HD, 1=Read from DF0
LOAD_ALL_FROM_DF0:	equ	0		; Used for release, read all files from DFO
LOAD_RELATIVE_PATHS:	equ	1	
			ENDC
			ENDC

ENABLE_WINNING_CARS:	equ	0

MAX_LEVELS:		equ	32



; Drone enable for testing
BLUECAR_IS_DRONE:	equ	0
REDCAR_IS_DRONE:	equ	1
YELLOWCAR_IS_DRONE:	equ	1
GREENCAR_IS_DRONE:	equ	1

BLUECAR_DISABLE:	equ	0
REDCAR_DISABLE:		equ	0
YELLOWCAR_DISABLE:	equ	0
GREENCAR_DISABLE:	equ	0

TORNADO_TOPRIGHT:	equ	0
INFINTE_LAPS:		equ	0
MAX_LAPS:		equ	4	;4

COPPER_SIZE:		equ	$1800
SCREEN_SIZE_X:		equ	512
SCREEN_SIZE_Y:		equ	384
SCREEN_BITPLANES:	equ	5

SPRITE_STATE_CONSTRUCT	equ	-1
SPRITE_STATE_ENABLE:	equ	0
SPRITE_STATE_DESTRUCT:	equ	1

TILE_SIZE_32X24:	equ	$0218			; 32x24

MAX_SPRITES:		equ	4

			IFNE	DEBUGGING_OSD
VRAM_SIZE:		equ	392*1024		; MUST BE 392KB!!!! (NO LESS!)
			ELSE
VRAM_SIZE:		equ	392*1024			
			ENDC
			
ExecBase:		equ	4

sceneLoad:		equ	-1
sceneRace:		equ	0
sceneTitle:		equ	1
sceneHiscore:		equ	2
sceneTrackSelect:	equ	3
sceneUpgradeCar:	equ	4
sceneWinningCars:	equ	5
scenePrepareRace:	equ	6
sceneCredits:		equ	7
sceneLoadSave:		equ	8

DualPlayfieldInterlaceOffset:	equ	$100		(4x64) Dual Playfield
WinningCarsInterlaceOffset:	equ	$180		(6*64)
PrepareRaceInterlaceOffset:	equ	$140		(5*64)
TitleScreenInterlaceOffset:	equ	$140		(5*64)
TrackSelectInterlaceOffset:	equ	$140		(5*64)
UpgradeCarInterlaceOffset:	equ	$100		(4*64)
HiScoresInterlaceOffset:	equ	$100		(4*64)
CreditsInterlaceOffset:		equ	$100		(4*64)
LoadSaveInterlaceOffset:	equ	$40		(1*64)


ThisTask            equ $114
;pr_CLI              equ $ac
;pr_MsgPort          equ $5c
sm_ArgList          equ $24
;cli_CommandName     equ $10
;SHARED_LOCK         equ -2
;id_UnitNumber       equ 4

DEBUG_SERIAL:	equ	0

AvailMem:	equ	-216

;\----------------------------\
; \    **** GAME LOOP ****     \     
;  \----------------------------\
SCENE_ENABLE		MACRO
	
	IFNE	TRACK_BUILD_MODE
	
.ttt:	
	bsr	ssRace
	moveq	#0,d0
	rts
	ENDC

.game_init:
	clr.w	END_GAME(a6)
	clr.w	CURRENT_DIFFICULTY(a6)

	clr.w	START_GAME(a6)
	bsr	ssTitle	
	tst.w	END_GAME
	bmi.s	.game_exit
	tst.w	START_GAME
	bmi.s	.track_select
	
	clr.w	START_GAME(a6)
	bsr	ssHiscore
	tst.w	START_GAME(a6)
	bmi.s	.game_init
	
	bsr	ssCredits
	bra.s	.game_init

.track_select:	
	clr.w	START_GAME(a6)
	bsr	ssTrackSelect
.game_loop:	
	bsr	ssRace	
	bsr	ssWinningCars
	bsr	ssUpgradeCar
	bsr	ssPrepareRace
	bsr	ssHiscoreCheckSaveNeeded
	tst.w	d0
	bmi	.game_init
	addq.w	#1,CURRENT_LEVEL(a6)
	add.w	#$10,CURRENT_DIFFICULTY(a6)
	cmp.w	#MAX_LEVELS,CURRENT_LEVEL(a6)
	bne	.game_loop
	move.w	#16,CURRENT_LEVEL(a6)			; Reset back to level 16
	;clr.w	CURRENT_LEVEL(a6)
	bra	.game_loop
	bra	.game_init
.game_exit:

ENDM
        code

;--------------------------------------------------------------------------

        basereg DATA_MID,a6

	IFNE	SAVE_TRACKS
	bsr	saveTracks
	nop
	nop
STOP:	move.w	#$007,$dff180
	bra	STOP
	
	include	save_tracks.asm
	ENDC

	
	bra	ENTRY
	
	include 'include_files.asm'
ENTRY:		

	WORKBENCH_BOOT
	
	CNOP	0,4
	
START:	
	;move.l	#SCRPTR_HISCORE_SCREEN,$120
	IFNE	ENABLE_HANDLE_TRACKING
	move.l	#carStruct,$130.w
	ENDC

	move.l  ExecBase,a6				
	lea     DOSNAME(pc),a1
	moveq   #0,d0
	jsr     _LVOOpenLibrary(a6)			; LibBase = OpenLibrary=(version[d0],libname[a1])

	lea	DATA_MID,a6
	move.l	d0,DOSBASE(a6)				; save DOSBASE address	
	
	bsr	agdCheckMemory
	tst.l	d0
	bmi	.quit
	
	clr.l	MEMORY_INDEX(a6)
	lea	MEMORY_RELEASE_TAB(a6),a0
	moveq	#maxMemorySegments-1,d7
.mem:	move.l	#-1,(a0)+
	move.l	#-1,(a0)+
	dbf	d7,.mem
	
	move.w	#sceneLoad,CURRENT_SCENE(a6)
	clr.w	INT3_INSTALLED(a6)
	
	lea	txtDbgInit(a6),a0
	bsr	agdPrintString
	
	move.l	#256,d0				; Create MFM Buffer
	move.l	#(MEMF_CHIP!MEMF_CLEAR),d1
	bsr	agdAllocateResource
	move.l	d0,RAWPTR_BLANK_BITPLANES(a6)
	
	lea	txtDbgInitFonts(a6),a0
	bsr	agdPrintString
	
; Create a Bitmap Handle and work out dimensions
	lea	FNAME_SMALL_FONT(a6),a1			; Pointer to IFF in a1
	bsr	agdCreateBitmap			;
	move.l	d0,BMPPTR_SMALL_FONT(a6)	

	lea	FNAME_LARGE_FONT,a1			; Pointer to IFF in a1
	bsr	agdCreateBitmap			;
	move.l	d0,BMPPTR_LARGE_FONT(a6)
	
	sub.l	a0,a0
	move.l	BMPPTR_LARGE_FONT(a6),d0
	bsr	agdCreateBitmapMask
	move.l	d0,MSKPTR_LARGE_FONT(a6)

	sub.l	a0,a0
	move.l	BMPPTR_LARGE_FONT(a6),d0
	move.l	MSKPTR_LARGE_FONT(a6),d1
	move.l	#$1010,d2				; 16x16 Font
	moveq	#0,d3
	bsr	agdCreateSpriteSheet
	move.l	d0,SPRPTR_LARGE_FONT(a6)
	
	lea	txtDbgInitHardwareSprites(a6),a0
	bsr	agdPrintString

	bsr	agdBuildHardwareSpriteXY

	move.l	#512,d0				; Create MFM Buffer
	move.l	#(MEMF_CHIP!MEMF_CLEAR),d1
	bsr	agdAllocateResource
	move.l	d0,COPPTR_LOADSAVE(a6)
	
	
; Create raw objects space for game sprites.
	move.l	#(SCREEN_SIZE_X/8)*(SCREEN_SIZE_Y/8),d0
	add.l	#64*10,d0
	move.l	#MEMF_CHIP!MEMF_CLEAR,d1
	bsr	agdAllocateResource
	tst.l	d0
.coll:	bmi.s	.coll
	move.l	d0,MEMPTR_COLLISION_RAM(a6)
	
; Create a Load Save Screen
	move.l	#64*8,d0
	move.l	#(MEMF_CHIP),d1
	bsr	agdAllocateResource	
	move.l	d0,SCRPTR_LOADSAVE(a6)
	
; Create Load Save copper
	move.l	SCRPTR_LOADSAVE,a0
	move.l	COPPTR_LOADSAVE,a1
	bsr	ssLoadSaveCopper
	
; Create Video RAM
	move.l	#VRAM_SIZE,d0
	bsr	agdCreateVideoRam
	tst.l	d0
.vram:	bmi.s	.vram
	move.l	d0,VRMPTR_SCREENS(a6)
	
; a0 = filename
; a1 = load address.
	
	IFEQ	LOAD_FROM_BOX
	jsr	mainLoadModules
	jsr	mainLoadSamples
	bsr	mainLoadHardwareSpriteSheets
	bsr	mainLoadCarCollisionMasks
	bsr	mainLoadGameSprites
	ELSE
	lea	FNAME_BOX_ASSET(a6),a0
	move.l	VRMPTR_SCREENS(a6),a1
	bsr	agdLoadBox
	
	jsr	mainLoadModules
	jsr	mainLoadSamples
	bsr	mainLoadHardwareSpriteSheets
	bsr	mainLoadCarCollisionMasks
	bsr	mainLoadGameSprites
	
	move.l	VRMPTR_SCREENS(a6),a1	
	bsr	agdClearResource
	
	ENDC
	
; Initialise Packed assets
	bsr	ssRaceInitialise
	bsr	ssTrackSelectInitilise
	bsr	ssTitleInitialise
	bsr	ssUpgradeCarInitilise
	bsr	ssHiscoreInitialise
	bsr	ssCreditsInitialise
	bsr	ssPrepareRaceInitilise
	bsr	ssWinningCarsInitialise
	
	IFNE	DEBUGGING_OSD
		move.l	#DEBUG_SCREEN_SIZE_X*48,d0
		move.l	#MEMF_CHIP|MEMF_CLEAR,d1
		bsr	agdAllocateResource	
		move.l	d0,DEBUG_SCREEN_PTR(a6)
	ENDC
	
	
; Create a copper resource
	lea	txtDbgCreateCopper(a6),a0
	bsr	agdPrintString
	move.l	#COPPER_SIZE,d0
	move.l	#MEMF_CHIP,d1
	bsr	agdAllocateResource
	tst.l	d0
	bpl.s	.cop
	move.l	a0,-(a7)
	lea	txtDbgMainNoRamForCopper,a0
	bsr	agdPrintString
	move.l	(a7)+,a0	
.cop:	move.l	d0,COPPTR_COPPER_1(a6)
	
; Create track buffers for holding track data
	IFEQ	TRACK_BUILD_MODE
	bsr	raceCreateTrackBuffers
	ENDC
	

; Set top of ram marker
	lea	txtDbgRamTopMarker(a6),a0
	bsr	agdPrintString
	
	bsr	agdShowAvilableChipMemory
	
	bsr	ssLoadHiscoreTable
	
	clr.w	AUDIO_INSTALLED(a6)
	OPEN_LIBS			; GFX Lib
	IFEQ	ENABLE_DEBUG
	INIT_FORBID_OS			; Forbid()
	SAVE_COPPER			; Load View stuff
	OS_WAITBLIT
	OWN_BLITTER			; Take Blitter
	WAIT_FOR_BLITTER
	DISABLE
	SAVE_SYSTEM_STATE
	INIT_DMA_INT
	lea	CHIPBASE,a5	
	move.w	#0,BEAMCON0(a5)
	move.w #$8000,VPOSW(a5)			; Set LOF Auto Toggle
	bsr	InstallScreenInterrupt
	bsr	InstallKeyboardInterrupt
	bsr	agdInstallAudioPlayer
	ENDC
	
; Turn off motor
        lea     $bfd100,a0
        or.b    #$f8,(a0)
        nop
        and.b   #$87,(a0)
        nop
        or.b    #$78,(a0)
        nop
	
	IFNE	REDCAR_IS_DRONE
	moveq	#CAR_2,d1
	GET_CAR_CONTEXT
	move.w	#-1,carIsDrone(a4)
	ENDC
	
	IFNE	YELLOWCAR_IS_DRONE
	moveq	#CAR_3,d1
	GET_CAR_CONTEXT
	move.w	#-1,carIsDrone(a4)
	ENDC
	
	IFNE	GREENCAR_IS_DRONE
	moveq	#CAR_4,d1
	GET_CAR_CONTEXT
	move.w	#-1,carIsDrone(a4)
	ENDC
	
	IFNE	TRACK_BUILD_MODE
	move.w	#START_TRACK-1,CURRENT_LEVEL
	move.w	#START_DIFFICULTY<<4,CURRENT_DIFFICULTY(a6)
	bsr	ssRace
	ELSE

; Show dirty pirate message
	bsr	ssLoadSaveSetSupport
	move.l	#60*5,d7
.support:
	bsr	WaitVbl
	dbf	d7,.support
		
	INIT_DMA_INT

	SCENE_ENABLE
	ENDC
	
	lea	CHIPBASE,a5
	;move.w	#$20,BEAMCON0(a5)
	
	IFEQ	ENABLE_DEBUG
	bsr	agdRemoveAudioPlayer
	bsr	RemoveScreenInterrupt
	IFEQ	NO_INPUT_INTERUPTS
	bsr	RemoveKeyboardInterrupt
	ENDC
	ENDC


	RESTORE_SYSTEM_STATE
	IFEQ	ENABLE_DEBUG
	ENABLE
	RESTORE_COPPER
	ENDC
	INIT_PERMIT_OS
	OS_WAITBLIT
	DISOWN_BLITTER
	
	bsr	ssSaveHiscoreTable

	bsr	mainReleaseRam
	
	move.l	GFXBASE,a1
	move.l	ExecBase,a6
	jsr 	_LVOCloseLibrary(a6)

.quit:	
	move.l	DOSBASE,a1
	move.l	ExecBase,a6
	jsr 	_LVOCloseLibrary(a6)


	moveq	#0,d0
	rts

	near	a6
	
mainAllocRamFail:
.fail:	add.w	#$147,.col
	move.w	.col(a6),$dff180
	bra	.fail
.exit:	rts
	data
.col:	dc.w	0
	code


mainReleaseRam:
	move.l	a6,-(a7)
	lea	MEMORY_RELEASE_TAB(a6),a2

.loop:	move.l	(a2)+,a1
	tst.l	a1
	bmi.s	.exit
	move.l	(a2)+,d0
	move.l	ExecBase,a6
	jsr	_LVOFreeMem(a6)
	bra.s	.loop
	
.exit:	move.l	(a7)+,a6
	rts



agdCheckMemory:
	bsr	agdShowAvilableChipMemory
	
	move.l	a6,-(a7)
	move.l	ExecBase,a6
	move.l	#MEMF_CHIP,d1
	jsr	AvailMem(a6)
	move.l	(a7)+,a6
	
	cmp.l	#REQUIRED_CHIPRAM,d0
	bgt.s	.ok
.no:	lea	.not_enough(pc),a0
	bsr	agdPrintLine
.w:	btst.b	#7,$bfe001
	bne.s	.w
	moveq	#-1,d0
	bra	.exit
.ok:	lea	.enough(pc),a0
	bsr	agdPrintLine
.exit:	rts
	
.enough:	dc.b	13,10,"Turbo Sprint - Enough chip ram found",13,10,0
		even
.not_enough:	dc.b	13,10,"Turbo Sprint - Not enough chip ram available ($17d800 required)",13,10
		dc.b	13,10,"Turbo Sprint - LMB or Joy Button to continue",13,10,0
		even
	
;d0=word
;a0=text pointer
;d7=length 3=Word 7=LWORD

agdShowAvilableChipMemory:
	lea	txtDbgAvailableChipRam,a0
	bsr	agdPrintLine		
	move.l	a6,-(a7)
	move.l	ExecBase,a6
	move.l	#MEMF_CHIP,d1
	jsr	AvailMem(a6)
	move.l	(a7)+,a6
	
	lea	txtAsciiBuf,a0
	moveq	#7,d7
	bsr	agdHexToAscii
	lea	txtAsciiBuf,a0
	bsr	agdPrintLine	
	rts



DOSNAME:	dc.b	'dos.library',0
		even
		
GFXNAME:
	dc.b	'graphics.library',0
	even		
		
	ENDB	a6
		
; ---- Data segment begins ----

	data	

DATA_START:
;DATA_MID:	equ	DATA_START+(65536/2)

	CNOP	0,4
	
		IFEQ	TRACK_BUILD_MODE
trackFlagXPos:			dc.l	0
trackFlagYPos:			dc.l	0
CAR_TRACK_POSITIONS:
		dc.l	380<<15,344<<15,LOWER_LEVEL,CAR_PLAYER_BLUE,CAR_ANGLE_EAST,0,0
		dc.l	380<<15,358<<15,LOWER_LEVEL,CAR_PLAYER_RED,CAR_ANGLE_EAST,0,0
		dc.l	380<<15,372<<15,LOWER_LEVEL,CAR_PLAYER_YELLOW,CAR_ANGLE_EAST,0,0
		dc.l	380<<15,386<<15,LOWER_LEVEL,CAR_PLAYER_GREEN,CAR_ANGLE_EAST,0,0	
		ENDC
		

LOADSCREEN_VIEW:
	dc.l	0	;v_ViewPort
	dc.l	0	;v_LOFCprList
	dc.l	0	;v_SHFCprList
	dc.w	0	;v_DyOffset
	dc.w	0	;v_DxOffset
	dc.w	0	;v_Modes
	
   ;STRUCTURE View,0
   ;LONG	   
   ;LONG	   
   ;LONG	   
   ;WORD	   
   ;WORD	   
   ;WORD	   
   ;LABEL   v_SIZEOF
		
CHOPPER_STATE:			dc.b	0,0,0,0		
INTERLACE_OFFSET:		dc.l	0
OSD_SCREEN_UPDATE:		dc.l	0	; -1 = full update 0 = partial
FRAME_COUNT:			dc.l	0
;RAWPTR_WORKBUFFER:		dc.l	0
DOSBASE:			dc.l	0
GFXBASE:			dc.l	0
GAME_FIRST_PLAYER:		dc.l	0
MEMPTR_TRACK_PACK_BUFFER:	dc.l	0
MFM_BUFFER:			dc.l	0
CAR_WIN_ORDER:			dc.l	0		; 
CURRENT_SCENE:			dc.w	0			; Scene Number
RACE_OVER:			dc.w	0
SCENE_DELAY_TIME:		dc.w	0
START_GAME:			dc.w	0
END_GAME:			dc.w	0
INT2_INSTALLED:			dc.w	0
INT3_INSTALLED:			dc.w	0
				dc.b	"HELO"
AUDIO_INSTALLED:		dc.w	0
FLAG_WAVING:			dc.w	0	
VOLUME:				dc.l	0
CURRENT_LEVEL:			dc.w	0	
trackCheckPoints:		dc.b	0
				even
oldint				dc.l	0
vbroffset:			dc.l	0 
irq5_old:			dc.l	0
sysCopper:			dc.l	0
sysDMACON:			dc.w	0
sysINTENA:			dc.w	0
sysINTREQ:			dc.w	0
sysADKCON:			dc.w	0

PALPTR_LOADSCREEN:		dc.l	0
SCRPTR_LOADSCREEN:		dc.l	0

UNPPTR_MODS1:			dc.l	0
UNPPTR_MODS3:			dc.l	0

UNPPTR_CARS_F1_12:		dc.l	0
UNPPTR_CARS_F1_34:		dc.l	0
UNPPTR_CARS_F2_12:		dc.l	0
UNPPTR_CARS_F2_34:		dc.l	0
SPSPTR_CARS_SPRITESHEET_F1:	dc.l	0
SPSPTR_CARS_SPRITESHEET_F2:	dc.l	0

UNPPTR_CHOPPER_F1_12:		dc.l	0
UNPPTR_CHOPPER_F1_34:		dc.l	0
UNPPTR_CHOPPER_F2_12:		dc.l	0
UNPPTR_CHOPPER_F2_34:		dc.l	0
SPSPTR_CHOPPER_SPRITESHEET_F1:	dc.l	0
SPSPTR_CHOPPER_SPRITESHEET_F2:	dc.l	0	
	
UNPPTR_EXPLOWER_F1_12:		dc.l	0
UNPPTR_EXPLOWER_F1_34:		dc.l	0
UNPPTR_EXPLOWER_F2_12:		dc.l	0
UNPPTR_EXPLOWER_F2_34:		dc.l	0
SPSPTR_EXPLOWER_SPRITESHEET_F1:	dc.l	0
SPSPTR_EXPLOWER_SPRITESHEET_F2:	dc.l	0

UNPPTR_EXPFULL_F1_12:		dc.l	0
UNPPTR_EXPFULL_F1_34:		dc.l	0
UNPPTR_EXPFULL_F2_12:		dc.l	0
UNPPTR_EXPFULL_F2_34:		dc.l	0
SPSPTR_EXPFULL_SPRITESHEET_F1:	dc.l	0
SPSPTR_EXPFULL_SPRITESHEET_F2:	dc.l	0

SPSPTR_CAR_COLLMAP:		dc.l	0

LACPTR_CARS_SPRITESHEET:	dc.l	0
LACPTR_CHOPPER_SPRITESHEET:	dc.l	0
LACPTR_EXPLOWER_SPRITESHEET:	dc.l	0
LACPTR_EXPFULL_SPRITESHEET:	dc.l	0

SPSPTR_GAME_SPRITES:		dc.l	0
VRMPTR_SCREENS:			dc.l	0		; Video Ram Pointer
PALPTR_INGAME_CARS:			dc.l	0

BMPPTR_SMALL_FONT:	dc.l	0
BMPPTR_LARGE_FONT:	dc.l	0
MSKPTR_LARGE_FONT:	dc.l	0
SPRPTR_LARGE_FONT:	dc.l	0

UNPPTR_MODS2:		dc.l	0

SPLPTR_ENGINE:		dc.l	0

RNCPTR_BUMP1:		dc.l	0
RNCPTR_CARHIT:		dc.l	0
RNCPTR_CHIME:		dc.l	0
RNCPTR_CHOPPER:		dc.l	0
RNCPTR_COUNTDOWN:	dc.l	0
RNCPTR_EXPLODE:		dc.l	0
RNCPTR_ENGINE:		dc.l	0
RNCPTR_PICKUP:		dc.l	0
RNCPTR_SKID:		dc.l	0
RNCPTR_SPANNER:		dc.l	0
RNCPTR_SPIN:		dc.l	0
RNCPTR_WATER:		dc.l	0
RNCPTR_NITRO:		dc.l	0
RNCPTR_REVS:		dc.l	0

CURRENT_DIFFICULTY:	dc.w	0
	
				CNOP	0,4
				
HEXASCII:			dc.b	"0123456789ABCDEF",0
				even
				

			include files.asm
			include agd/debug.dat
			include agd/handles.dat
			include agd/copper.dat
			include agd/input.dat
			include agd/sprite.dat

DATA_MID:	; Middle of data segment
			dc.b	"DATA"
			CNOP	0,4
			include cars.dat
			include tables.dat
			include levels.dat
			include sprites/game_sprite.dat

FNAME_BOX_ASSET:	dc.b	"turbo_sprint.box",0
			even
			
; From Title	
SCRPTR_TITLE_SCREEN:	dc.l	0		
UNPPTR_TITLE_SCREEN:	dc.l	0
BMPPTR_TITLE_SCREEN:	dc.l	0
PALPTR_TITLE_SCREEN:	dc.l	0	

RNCPTR_LOADER:		dc.l	0

SCRPTR_LOADSAVE:	dc.l	0

COPPTR_TITLE_TEXT1:	dc.l	0
RNCPTR_TITLE_SCREEN:	dc.l	0

COPPTR_LOADSCREEN:	dc.l	0

COPPTR_LOADSAVE:	dc.l	0

SELECTED_CAR:		dc.w	0
IFACE_SELECT:		dc.w	0	
MENU_ACTIVE:		dc.w	0
;---------

RAND_CARS:	dc.l	0


MEMORY_INDEX:		dc.l	0

MEMORY_RELEASE_TAB:
	ds.l	maxMemorySegments*2
	dc.l	-1
	
	dc.l	((50&$FF)<<8)!((50&$1FE)>>1)
	
RNCPTR_GAME_SPRITES:	dc.l	0
RNCPTR_CARS_F1_12:	dc.l	0
RNCPTR_CARS_F1_34:	dc.l	0
RNCPTR_CARS_F2_12:	dc.l	0
RNCPTR_CARS_F2_34:	dc.l	0
RNCPTR_CHOPPER_F1_12:	dc.l	0
RNCPTR_CHOPPER_F1_34:	dc.l	0
RNCPTR_CHOPPER_F2_12:	dc.l	0
RNCPTR_CHOPPER_F2_34:	dc.l	0
RNCPTR_EXPLOWER_F1_12:	dc.l	0
RNCPTR_EXPLOWER_F1_34:	dc.l	0
RNCPTR_EXPLOWER_F2_12:	dc.l	0
RNCPTR_EXPLOWER_F2_34:	dc.l	0
RNCPTR_EXPFULL_F1_12:	dc.l	0
RNCPTR_EXPFULL_F1_34:	dc.l	0
RNCPTR_EXPFULL_F2_12:	dc.l	0
RNCPTR_EXPFULL_F2_34:	dc.l	0
RNCPTR_CAR_COLLMAP:	dc.l	0

RAWPTR_BLANK_BITPLANES:	dc.l	0


; From Hiscore
SCRPTR_HISCORE_SCREEN:	dc.l	0	
UNPPTR_HISCORE_SCREEN:	dc.l	0
BMPPTR_HISCORE_SCREEN:	dc.l	0
PALPTR_HISCORE_SCREEN:	dc.l	0		
RNCPTR_HISCORE_SCREEN:	dc.l	0	
HI_SCORES_NUMBER:	dc.l	0

saveLevel3:		dc.l	0
saveLevel2:		dc.l	0
sysView:	dc.l	0
sysCopper1:	dc.l	0
sysCopper2:	dc.l	0
sysBeamCon0:	dc.w	0

txtDbgMainNoRamForCopper:	dc.b	13,10,"AllocateResource() No chip ram left for COPPER allocation",0


txtDbgAvailableChipRam:	dc.b	13,10,"Available chip ram : ",0
			even
txtNoVram:	dc.b	13,10,"VramAlloc - Not enough ram",13,10,0
		even
txtDbgInit:	dc.b	"Init - Code Entry",13,10,0
		even
txtDbgInitFonts:	dc.b	"InitFonts()",13,10,0
		even	
		
txtDbgLoadingTrack:	dc.b	13,10,"Loading Track",0
			even
txtDbgCreateScreen:	dc.b	13,10,"Creating Screens",0
			even
txtDbgShutSystem:	dc.b	13,10,"Shutting down system",0
			even
txtDbgRamTopMarker:	dc.b	13,10,"Available Chip Ram after all allocs $",0
			even
txtDbgInitHardwareSprites:	dc.b	13,10,"InitHardwareSprites()",0
		even	
txtDbgLoadCarsSpriteSheet:	dc.b	13,10,"LoadCarsSpriteSheet()",0
		even
txtDbgLoadCarCollisionMasks:	dc.b	13,10,"LoadCarCollisionMasks()",0
		even	
txtDbgLoadMainGameSprites:	dc.b	13,10,"LoadMainGameSprites()",0
		even		
txtDbgRaceTrackBitmaps:	dc.b	13,10,"LoadTrackBitmaps()",0
		even	
txtDbgCreateScreens:	dc.b	13,10,"CreateScreens()",0
		even
txtDbgCreateCopper:	dc.b	13,10,"CreateCopper()",0
		even
txtDbgBuildCopper:	dc.b	13,10,"BuildCopper()",0
		even
txtDbgSystemOff:	dc.b	13,10,"SystemOff()",0
		even
txtDbgDmaOff:	dc.b	13,10,"DmaOff()",0
		even
txtDbgLoadPackedAsset:	dc.b	13,10,"agdLoadPackedAsset() Entered",0
			even
txtDbgNewLine:	dc.b	13,10,0
		even
txtDbgCreateObjectRam:
		dc.b	13,10,"agdDbgCreateObjectRam",0
		even
txtAsciiBuf:	dc.b	"                 ",0
		even
			
txtDbgError:		dc.b	13,10,"Return Error()",0
			even
txtDbgOK:		dc.b	13,10,"Return OK()",0
			even



CARS_PAL:		INCBIN	"assets/cars.col"
			even
				
FNAME_SMALL_FONT:	INCBIN	"assets/small_font8.iff"
			even

FNAME_LARGE_FONT:	INCBIN	"assets/large_font16q.iff"	
			ds.b	128
			even
			

			
			include tracks.dat

DATA_END			
	
		data,assets		

RNC_WINNING_CARS_FLAGS:		INCBIN	"assets/winners_circle_flags.rnc"
				even	

RNC_WINNING_CARS_MECHANIC:	INCBIN	"assets/winners_circle_mech.rnc"
				even	

RNC_WINNING_CARS_SCENE:		INCBIN	"assets/winners_circle_cars1.rnc"
				even

RNC_TITLE_SCREEN:		INCBIN	"assets/turbo_title.rnc"
				even
				
RNC_HISCORES_SCREEN:		INCBIN	"assets/hiscores.rnc"
				even

RNC_CREDITS_SCREEN:		INCBIN	"assets/credits.rnc"
				even
				
RNC_TRACK_SELECT_SCENE:		INCBIN	"assets/track_select.rnc"
				even
	
RNC_UPGRADE_CAR_SPRITES	
RNC_TRACK_SELECT_SPRITES:	INCBIN	"assets/track_select_wheel.rnc"
				even

RNC_UPGRADE_CAR_SCENE:		INCBIN	"assets/upgrades1.rnc"
				even

RNC_PREPARE_RACE_SCENE:		INCBIN	"assets/ptr_scene_copper1.rnc"
				even
				
RNC_PREPARE_RACE_DRIVERS:	INCBIN	"assets/ptr_driver_copper.rnc"
				even	

RNC_PREPARE_RACE_ENGINE:	INCBIN	"assets/ptr_engines_copper.rnc"
				even	
	
	IFNE	BUILD_ASSETS

BOX_BEGIN:
ASSETS_START:	dc.l	AFNAME_MODS1-BOX_BEGIN
		dc.l	AFNAME_MODS2-BOX_BEGIN
		dc.l	AFNAME_MODS3-BOX_BEGIN
		dc.l	AFNAME_SPRITES_F1_CARS_12-BOX_BEGIN
		dc.l	AFNAME_SPRITES_F1_CARS_34-BOX_BEGIN
		dc.l	AFNAME_SPRITES_F2_CARS_12-BOX_BEGIN
		dc.l	AFNAME_SPRITES_F2_CARS_34-BOX_BEGIN
		dc.l	AFNAME_SPRITES_F1_CHOPPER_12-BOX_BEGIN
		dc.l	AFNAME_SPRITES_F1_CHOPPER_34-BOX_BEGIN
		dc.l	AFNAME_SPRITES_F2_CHOPPER_12-BOX_BEGIN
		dc.l	AFNAME_SPRITES_F2_CHOPPER_34-BOX_BEGIN			
		dc.l	AFNAME_SPRITES_F1_EXPLOWER_12-BOX_BEGIN
		dc.l	AFNAME_SPRITES_F1_EXPLOWER_34-BOX_BEGIN
		dc.l	AFNAME_SPRITES_F2_EXPLOWER_12-BOX_BEGIN
		dc.l	AFNAME_SPRITES_F2_EXPLOWER_34-BOX_BEGIN				
		dc.l	AFNAME_SPRITES_F1_EXPFULL_12-BOX_BEGIN
		dc.l	AFNAME_SPRITES_F1_EXPFULL_34-BOX_BEGIN
		dc.l	AFNAME_SPRITES_F2_EXPFULL_12-BOX_BEGIN
		dc.l	AFNAME_SPRITES_F2_EXPFULL_34-BOX_BEGIN				
		dc.l	AFNAME_CAR_COLLMAP-BOX_BEGIN
		dc.l	AFNAME_GAME_SPRITES-BOX_BEGIN
		dc.l	AFNAME_SAMPLE_BUMP1-BOX_BEGIN
		dc.l	AFNAME_SAMPLE_CARHIT-BOX_BEGIN
		dc.l	AFNAME_SAMPLE_CHIME-BOX_BEGIN
		dc.l	AFNAME_SAMPLE_CHOPPER-BOX_BEGIN
		dc.l	AFNAME_SAMPLE_COUNTDOWN-BOX_BEGIN
		dc.l	AFNAME_SAMPLE_ENGINE-BOX_BEGIN
		dc.l	AFNAME_SAMPLE_EXPLODE-BOX_BEGIN
		dc.l	AFNAME_SAMPLE_PICKUP-BOX_BEGIN
		dc.l	AFNAME_SAMPLE_SKID-BOX_BEGIN
		dc.l	AFNAME_SAMPLE_SPANNER-BOX_BEGIN
		dc.l	AFNAME_SAMPLE_SPIN-BOX_BEGIN
		dc.l	AFNAME_SAMPLE_WATER-BOX_BEGIN
		dc.l	AFNAME_SAMPLE_NITRO-BOX_BEGIN
		dc.l	AFNAME_SAMPLE_REVS-BOX_BEGIN
	


AFNAME_MODS1:			incbin	"assets/box/ssprint.vgm.1.rnc",0
				even			
AFNAME_MODS2:			incbin	"assets/box/ssprint.vgm.2.rnc",0
				even			
AFNAME_MODS3:			incbin	"assets/box/ssprint.vgm.3.rnc",0
				even		
AFNAME_SPRITES_F1_CARS_12:	incbin	"assets/box/cars64_even_bp12.rnc",0
				even
AFNAME_SPRITES_F1_CARS_34:	incbin	"assets/box/cars64_even_bp34.rnc",0
				even
AFNAME_SPRITES_F2_CARS_12:	incbin	"assets/box/cars64_odd_bp12.rnc",0
				even
AFNAME_SPRITES_F2_CARS_34:	incbin	"assets/box/cars64_odd_bp34.rnc",0
				even
AFNAME_SPRITES_F1_CHOPPER_12:	incbin	"assets/box/chop64b_even_bp12.rnc",0
				even
AFNAME_SPRITES_F1_CHOPPER_34:	incbin	"assets/box/chop64b_even_bp34.rnc",0
				even
AFNAME_SPRITES_F2_CHOPPER_12:	incbin	"assets/box/chop64b_odd_bp12.rnc",0
				even
AFNAME_SPRITES_F2_CHOPPER_34:	incbin	"assets/box/chop64b_odd_bp34.rnc",0
				even
AFNAME_SPRITES_F1_EXPLOWER_12:	incbin	"assets/box/explower_even_bp12.rnc",0
				even
AFNAME_SPRITES_F1_EXPLOWER_34:	incbin	"assets/box/explower_even_bp34.rnc",0
				even
AFNAME_SPRITES_F2_EXPLOWER_12:	incbin	"assets/box/explower_odd_bp12.rnc",0
				even
AFNAME_SPRITES_F2_EXPLOWER_34:	incbin	"assets/box/explower_odd_bp34.rnc",0
				even			
AFNAME_SPRITES_F1_EXPFULL_12:	incbin	"assets/box/expfull_even_bp12.rnc",0
				even
AFNAME_SPRITES_F1_EXPFULL_34:	incbin	"assets/box/expfull_even_bp34.rnc",0
				even
AFNAME_SPRITES_F2_EXPFULL_12:	incbin	"assets/box/expfull_odd_bp12.rnc",0
				even
AFNAME_SPRITES_F2_EXPFULL_34:	incbin	"assets/box/expfull_odd_bp34.rnc",0
				even	
AFNAME_CAR_COLLMAP:		incbin	"assets/box/car_collmask_a.rnc",0
				even
AFNAME_GAME_SPRITES:		incbin	"assets/box/super_sprites_v8.rnc",0
				even				
AFNAME_SAMPLE_BUMP1:	incbin	"assets/box/bump1.8svx.rnc",0
			even
AFNAME_SAMPLE_CARHIT:	incbin	"assets/box/carhit.8svx.rnc",0
			even
AFNAME_SAMPLE_CHIME:	incbin	"assets/box/chime.8svx.rnc",0
			even
AFNAME_SAMPLE_CHOPPER:	incbin	"assets/box/chopper2.8svx.rnc",0
			even
AFNAME_SAMPLE_COUNTDOWN:	incbin	"assets/box/countdown.8svx.rnc",0
			even
AFNAME_SAMPLE_ENGINE:	incbin	"assets/box/engine.8svx.rnc",0
			even
AFNAME_SAMPLE_EXPLODE:	incbin	"assets/box/explode.8svx.rnc",0
			even
AFNAME_SAMPLE_PICKUP:	incbin	"assets/box/pickup.8svx.rnc",0
			even
AFNAME_SAMPLE_SKID:	incbin	"assets/box/skid2.8svx.rnc",0
			even				
AFNAME_SAMPLE_SPANNER:	incbin	"assets/box/spanner.8svx.rnc",0
			even	
AFNAME_SAMPLE_SPIN:	incbin	"assets/box/carspin.8svx.rnc",0
			even	
AFNAME_SAMPLE_WATER:	incbin	"assets/box/water.8svx.rnc",0
			even	
AFNAME_SAMPLE_NITRO:	incbin	"assets/box/turbo.8svx.rnc",0
			even				
AFNAME_SAMPLE_REVS:	incbin	"assets/box/revs.8svx.rnc",0
			even
			
BOX_END

			ENDC