MAX_PLAYERS_SECONDS:	equ	60

ssRaceInitialise:

	
	IFNE	ENABLE_PROTECTION
	moveq	#CAR_1,d1
	GET_CAR_CONTEXT
	move.w	#FREE_PLAY_TIME,carTimeInPlay(a4)
	move.b	#$c1,carProtectionByte(a4)
	moveq	#CAR_2,d1
	GET_CAR_CONTEXT
	move.w	#FREE_PLAY_TIME,carTimeInPlay(a4)
	move.b	#$52,carProtectionByte(a4)
	moveq	#CAR_3,d1
	GET_CAR_CONTEXT
	move.w	#FREE_PLAY_TIME,carTimeInPlay(a4)
	move.b	#$86,carProtectionByte(a4)
	moveq	#CAR_4,d1
	GET_CAR_CONTEXT
	move.w	#FREE_PLAY_TIME,carTimeInPlay(a4)
	move.b	#$9d,carProtectionByte(a4)
	ENDC
	rts
	
; Initialise all handles
ssRaceInitHandles:
	move.l	BMPPTR_LOWER_TRACK_MASK(a6),a0
	bsr	agdDestroyHandle
	clr.l	BMPPTR_LOWER_TRACK_MASK(a6)
	
	move.l	BMPPTR_UPPER_TRACK_MASK(a6),a0
	bsr	agdDestroyHandle
	clr.l	BMPPTR_UPPER_TRACK_MASK(a6)

	move.l	BMPPTR_LOWER_TRACK(a6),a0
	bsr	agdDestroyHandle
	clr.l	BMPPTR_LOWER_TRACK(a6)

	move.l	BMPPTR_UPPER_TRACK(a6),a0
	bsr	agdDestroyHandle
	clr.l	BMPPTR_UPPER_TRACK(a6)	

	move.l	PALPTR_LOWER_TRACK(a6),a0
	bsr	agdDestroyHandle
	clr.l	PALPTR_LOWER_TRACK(a6)	

	move.l	PALPTR_UPPER_TRACK(a6),a0
	bsr	agdDestroyHandle
	clr.l	PALPTR_UPPER_TRACK(a6)	

	move.l	PALPTR_INGAME_CARS(a6),a0
	bsr	agdDestroyHandle
	clr.l	PALPTR_INGAME_CARS(a6)	
	rts
	
	

; d0=Level to load
ssRace:	

	move.w	$dff006,d0
	and.w	#1,d0
	add.w	d0,d0
	move.w	d0,RANDOM01(a6)
	move.w	#-1,RACE_OVER(a6)
	clr.w	WIN_DELAY_TIMER(a6)
	clr.l	FRAME_COUNT(a6)
	
	clr.l	CHOPPER_STATE(a6)
	
	move.l	VRMPTR_SCREENS(a6),a0	
	bsr	agdDestroyAllVramScreens
	
	bsr	ssRaceInitHandles
	

	
; Create a debug screen in chip ram
	IFNE	DEBUGGING_OSD
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	#DEBUG_SCREEN_SIZE_X*8,d0
	move.l	#8*6,d1				; 6 lines only.
	move.l	#1,d2
	bsr	agdCreateScreen	
.no_mem:	tst.l	d0
	bmi.s	.no_mem
	move.l	d0,DEBUG_SCREEN_PTR(a6)
	ENDC
	
	lea	CARS_PAL(a6),a1
	bsr	agdGetBitmapPalette
	move.l	d0,PALPTR_INGAME_CARS(a6)
	
	lea	CHIPBASE,a5

	bsr	ssLoadSaveSetLoadText
	
	clr.b	_mt_Enable
	
	IFEQ	ENABLE_DEBUG
	move.w	#$000f,DMACON(a5)	;Disable Audio DMA
	bsr	RemoveScreenInterrupt
	bsr	RemoveKeyboardInterrupt	
	ENABLE	
	RESTORE_SYSTEM_STATE
	IFEQ	ENABLE_DEBUG_MESSAGES

	;RESTORE_COPPER			; Disable this to stop showing WB screen (must replace though).
	ENDC
	INIT_PERMIT_OS
	OS_WAITBLIT
	DISOWN_BLITTER
	
	lea	CHIPBASE,a5	
	move.w	#0,BEAMCON0(a5)
	move.w #$8000,VPOSW(a5)			; Set LOF Auto Toggle
	ENDC
	
;-- This will be a call to load a track and unpack it
; maybe parse track too.
	IFEQ	TRACK_BUILD_MODE
	lea	txtDbgLoadingTrack,a0
	bsr	agdPrintString

	moveq	#0,d0				; Level to load
	move.w	CURRENT_LEVEL(a6),d0
	bsr	raceLoadPackedTrackOS
	
	STOP_DRIVE_MOTOR
	ELSE	

	IFNE	TEST_TRACK1
	move.w	#0,CURRENT_TRACK(a6)
	ENDC
	IFNE	TEST_TRACK2
	move.w	#1,CURRENT_TRACK(a6)
	ENDC
	IFNE	TEST_TRACK3
	move.w	#2,CURRENT_TRACK(a6)
	ENDC
	IFNE	TEST_TRACK4
	move.w	#3,CURRENT_TRACK(a6)
	ENDC
	IFNE	TEST_TRACK5
	move.w	#4,CURRENT_TRACK(a6)
	ENDC
	IFNE	TEST_TRACK6
	move.w	#5,CURRENT_TRACK(a6)
	ENDC
	IFNE	TEST_TRACK7
	move.w	#6,CURRENT_TRACK(a6)
	ENDC
	IFNE	TEST_TRACK8
	move.w	#7,CURRENT_TRACK(a6)
	ENDC

	bsr	raceLoadTrackBitmaps
	bsr	raceLoadTrackMasks
	ENDC
	
	IFNE	DEBUG_COLLISION_MAP
	bsr	ssDebugTrackMasks
	ENDC
	
	lea	txtDbgCreateScreen,a0
	bsr	agdPrintString
	
	bsr	raceCreateLowerScreen
	bsr	raceCreateUpperScreen
	
	lea	txtDbgShutSystem,a0
	bsr	agdPrintString
	
	IFEQ	ENABLE_DEBUG
	INIT_FORBID_OS			; Forbid()
	;SAVE_COPPER			; Load View stuff
	OS_WAITBLIT
	OWN_BLITTER			; Take Blitter
	WAIT_FOR_BLITTER
	SAVE_SYSTEM_STATE
	INIT_DMA_INT
	
	move.w	#$0200,BPLCON0(a5)
	move.l	RAWPTR_BLANK_BITPLANES(a6),a0
	move.l	(a0),a0
	move.l	a0,BPL0PTH(a5)
	move.l	a0,BPL1PTH(a5)
	move.l	a0,BPL2PTH(a5)
	move.l	a0,BPL3PTH(a5)
	move.l	a0,BPL4PTH(a5)
	move.l	a0,BPL5PTH(a5)
	move.l	a0,BPL6PTH(a5)
	move.l	a0,BPL7PTH(a5)
	bsr	InstallScreenInterrupt
	bsr	InstallKeyboardInterrupt
	ENDC

	move.w	#sceneRace,CURRENT_SCENE(a6)
	
	lea	CHIPBASE,a5	
	bsr	ssGetTotalCheckpoints
	and.l	#$ff,d0
	move.b	d0,trackCheckPoints(a6)

	bsr	raceInitTrack
	
	bsr	raceSetDroneParameters
	
	bsr	agdDestroyAllBobs
	

	
; Create a simple copper list
	move.l	COPPTR_COPPER_1,a1
	bsr	ssBuildRaceCopper
	
; Call Animate cars to force sprite pointers to corretc place.
	bsr	ssAnimateCars
	
	moveq	#0,d0
	moveq	#0,d1
	bsr	ssUpdateDualPlayfield

	move.l	COPPTR_COPPER_1,a1
	move.l	(a1),a1
	
; Plot a sprite
	lea	$dff000,a5
	
	IFEQ	ENABLE_DEBUG
	INIT_DMA_INT
	START_COPPER
	SET_PARALLEL_PORT
	move.w	#(DMAF_SETCLR!DMAF_MASTER!DMAF_RASTER!DMAF_COPPER!DMAF_BLITTER!DMAF_SPRITE),DMACON(a5)
	move.w	#(INTF_SETCLR!INTF_EXTER!INTF_INTEN!INTF_VERTB!INTF_COPER!INTF_PORTS),INTENA(a5)
	ENDC


	
	move.l	DBSPTR_LOWER_TRACK(a6),a1			; Dest
	move.l	DBSPTR_UPPER_TRACK(a6),a0
	move.l	BMPPTR_LOWER_TRACK(a6),a2			; Source
	move.l	BMPPTR_UPPER_TRACK(a6),a3			; 
	bsr	agdTranstionBitmapToDoubleBuffers
	
	move.l	DBSPTR_UPPER_TRACK(a6),a0
	move.l	hDbuffScreen1(a0),a0
	moveq	#OSD_UPDATE_INIT,d0
	bsr	ssUpdateOSD
	
	move.l	DBSPTR_UPPER_TRACK(a6),a0
	move.l	hDbuffScreen2(a0),a0
	moveq	#OSD_UPDATE_INIT,d0
	bsr	ssUpdateOSD
	
; Short pause before race starts
	move.l	#60*2,d7
.pause:	
	bsr	raceWaitVbl
	movem.l	d0-d7/a0-a5,-(a7)
	bsr	ssRaceGetReady
	movem.l	(a7)+,d0-d7/a0-a5
	dbf	d7,.pause
	
	move.l	DBSPTR_UPPER_TRACK(a6),a2
	move.l	hDbuffScreen1(a2),a1
	move.l	hAddress(a1),a1
	move.l	BMPPTR_UPPER_TRACK(a6),a0
	move.l	hBitmapBody(a0),a0
	addq.w	#8,a0
	bsr	ssRaceGetReadyUpdateScreen
	
	move.l	DBSPTR_UPPER_TRACK(a6),a2
	move.l	hDbuffScreen2(a2),a1
	move.l	hAddress(a1),a1
	move.l	BMPPTR_UPPER_TRACK(a6),a0
	move.l	hBitmapBody(a0),a0
	addq.w	#8,a0
	bsr	ssRaceGetReadyUpdateScreen
	
	IFEQ	DEBUGGING_OSD	
	move.l	COPPTR_GET_READY(a6),a1
	rept	3
	move.l  #$01fe0000,(a1)+
	endr
	ENDC
	
	clr.w	RACE_OVER(a6)
	
	clr.l	FRAME_COUNT(a6)
	
.frame:	
	IFNE	DEBUG_COLOURS
	move.w	#$070,$dff180
	ENDC
	move.w	INTREQR(a5),d0
	and.w	#$20,d0
	beq.s	.frame
	
	move.l	#-1,OSD_SCREEN_UPDATE(a6)
	
	IFNE	ENABLE_DEBUG
	moveq	#0,d0
	moveq	#0,d1
	bsr	ssUpdateDualPlayfield
	bsr	ssRaceHandleCars
; Cast any game sprites that are ready on this frame.
	ENDC

	bsr	ssInjectSprites	

	bsr	agdRestoreGameSprites	
	bsr	agdBlitGameSprites

; Update the OSD, must be called every frame.	
	move.l	OSD_SCREEN_UPDATE(a6),d0
	move.l	DBSPTR_UPPER_TRACK(a6),a0
	move.l	FRAME_COUNT,d4
	and.l	#1,d4
	move.l	hDbuffScreen1(a0,d4*4),a0
	bsr	ssUpdateOSD
	
; Debugging stuff here.
	IFNE	DEBUGGING_OSD
	bsr	agdDebugWindow
	ENDC
		
	bsr	ssRaceCheckTimeOut
	
	tst.w	RACE_OVER(a6)			; Finish race
	bpl.s	.race
; PAUSE GAME triggered

	tst.w	WIN_DELAY_TIMER(a6)
	bmi.s	.delay
; will be zero so start counting down.
	bsr	ssRaceStartWinTune
	
.delay:
	subq.w	#1,WIN_DELAY_TIMER(a6)
	cmp.w	#$10000-200,WIN_DELAY_TIMER(a6)
	beq.s	.exit
	
.race:		
	addq.l	#1,FRAME_COUNT(a6)
	bra	.frame
	
	
; d0 = Pointer to handle information
	nop
	
.error:	moveq	#-1,d0
	bra	.rts
	
.exit:	
	move.w	#(DMAF_SPRITE),DMACON(a5)
	
	move.l	DBSPTR_LOWER_TRACK(a6),a0
	move.l	DBSPTR_UPPER_TRACK(a6),a1
	bsr	agdTranstionFromDoubleBuffer

	move.w	#sceneLoad,CURRENT_SCENE(a6)

	
; Kill VBL
	IFEQ	ENABLE_DEBUG
	move.w	#(INTF_VERTB!INTF_COPER!INTF_PORTS),INTENA(a5)
	move.w	#(INTF_VERTB!INTF_COPER!INTF_PORTS),INTENA(a5)
	move.w	#(DMAF_RASTER!DMAF_COPPER!DMAF_BLITTER!DMAF_SPRITE),DMACON(a5)
	move.w	#$0201,BPLCON0(a5)
	move.w	#$000,COLOR00(a5)
	ENDC

	bsr	ssRaceInitHandles
	
	moveq	#0,d0
.rts:	rts


ssRaceStartWinTune:
; Play success tune
	IFEQ	ENABLE_DEBUG
	clr.b	_mt_Enable
	bsr	agdStopChannels
		
	lea	.positions(pc),a1
	moveq	#0,d1
	move.w	CURRENT_TRACK(a6),d1
	move.l	(a1,d1*8),a0
	move.l	(a0),a0
	move.l	4(a1,d1*8),d0
	
	bsr	agdPlayModule
	
	move.b	#-1,_mt_Enable
	moveq	#63,d0
	bsr	agdSetVolume
	ENDC
	rts
	
.positions:
	dc.l	UNPPTR_MODS1,SONG_WINNING_CARS1
	dc.l	UNPPTR_MODS1,SONG_WINNING_CARS2
	dc.l	UNPPTR_MODS1,SONG_WINNING_CARS3
	dc.l	UNPPTR_MODS1,SONG_WINNING_CARS4
	dc.l	UNPPTR_MODS2,SONG_WINNING_CARS5
	dc.l	UNPPTR_MODS2,SONG_WINNING_CARS6
	dc.l	UNPPTR_MODS1,SONG_WINNING_CARS1
	dc.l	UNPPTR_MODS2,SONG_WINNING_CARS5
	dc.l	UNPPTR_MODS3,SONG_WINNING_CARS7
	dc.l	UNPPTR_MODS3,SONG_WINNING_CARS8
	
MOUSE:
	btst.b	#6,$bfe001
	bne	MOUSE
.w:	btst.b	#6,$bfe001
	beq	.w
.exit:	rts


ssRaceHandleCars:
; Clear collision ram

	move.l	MEMPTR_COLLISION_RAM(a6),a1
	bsr	agdClearResource

	;move.l	MEMPTR_COLLISION_RAM(a6),a0
	;move.l	hAddress(a0),a2
	
;------------------------------------
; Control Cars

	IFEQ	BLUECAR_DISABLE
	moveq	#CAR_1,d1
	bsr	ssGetPositionBlocks
	moveq	#CAR_1,d1
	bsr	ssSetPositionBlocks
	moveq	#CAR_1,d1
	bsr	ssControlCar
	ENDC

	IFEQ	REDCAR_DISABLE
	moveq	#CAR_2,d1
	bsr	ssGetPositionBlocks
	moveq	#CAR_2,d1
	bsr	ssSetPositionBlocks
	moveq	#CAR_2,d1
	bsr	ssControlCar
	ENDC

	IFEQ	YELLOWCAR_DISABLE
	moveq	#CAR_3,d1
	bsr	ssGetPositionBlocks	
	moveq	#CAR_3,d1
	bsr	ssSetPositionBlocks
	moveq	#CAR_3,d1
	bsr	ssControlCar
	ENDC
	
	IFEQ	GREENCAR_DISABLE
	moveq	#CAR_4,d1
	bsr	ssGetPositionBlocks
	moveq	#CAR_4,d1
	bsr	ssSetPositionBlocks
	moveq	#CAR_4,d1
	bsr	ssControlCar
	ENDC
	
;---------------------------------------------
; Work out collisions and respond to them.

; For all cars respond to their collisions.
	moveq	#CAR_1,d1
	bsr	ssCheckCarCollisions
	moveq	#CAR_2,d1
	bsr	ssCheckCarCollisions
	moveq	#CAR_3,d1
	bsr	ssCheckCarCollisions
	moveq	#CAR_4,d1
	bsr	ssCheckCarCollisions
	rts
		
raceCreateLowerScreen:
; ---------- Create Lower Screen	
; Create a screen in chip ram
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	#SCREEN_SIZE_X,d0
	move.l	#SCREEN_SIZE_Y,d1
	move.l	#4,d2
	bsr	agdCreateScreen
	move.l	d0,d3
	
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	#SCREEN_SIZE_X,d0
	move.l	#SCREEN_SIZE_Y,d1
	move.l	#4,d2
	bsr	agdCreateScreen
	move.l	d0,d4
	
	move.l	BMPPTR_LOWER_TRACK(a6),a0
	move.l	hBitmapBody(a0),d0
	addq.l	#8,d0
	move.l	d3,d1
	move.l	d4,d2
	bsr	agdCreateDbuffScreen
	move.l	d0,DBSPTR_LOWER_TRACK(a6)
	rts
	

raceCreateUpperScreen:
; ---------- Create Upper Screen	
; Create a screen in chip ram
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	#SCREEN_SIZE_X,d0
	move.l	#SCREEN_SIZE_Y,d1
	move.l	#4,d2
	bsr	agdCreateScreen
	move.l	d0,d3
	
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	#SCREEN_SIZE_X,d0
	move.l	#SCREEN_SIZE_Y,d1
	move.l	#4,d2
	bsr	agdCreateScreen
	move.l	d0,d4
	
	move.l	BMPPTR_UPPER_TRACK(a6),a0
	move.l	hBitmapBody(a0),d0
	addq.l	#8,d0
	move.l	d3,d1
	move.l	d4,d2
	bsr	agdCreateDbuffScreen
	move.l	d0,DBSPTR_UPPER_TRACK(a6)
	rts
	
	

raceCreateTrackBuffers:
; Space for track pack to load
	move.l	#44*1024,d0				; 44Kb
	move.l	#MEMF_CHIP,d1
	bsr	agdAllocateResource
	move.w	#$f00,d2
	tst.l	d0
	bmi	.error
	move.l	d0,MEMPTR_TRACK_PACK_BUFFER(a6)
	
; Lower collision map
	move.l	#(SCREEN_SIZE_X/8)*SCREEN_SIZE_Y,d0
	add.l	#$100,d0
	move.l	#MEMF_CHIP,d1
	bsr	agdAllocateResource
	move.w	#$f0f,d2
	tst.l	d0
	bmi	.error
	move.l	d0,MEMPTR_LOWER_TRACKCOLLMAP(a6)
	
; Upper collision map
	move.l	#(SCREEN_SIZE_X/8)*SCREEN_SIZE_Y,d0
	add.l	#$100,d0
	move.l	#MEMF_CHIP,d1
	bsr	agdAllocateResource
	move.w	#$00f,d2
	tst.l	d0
	bmi	.error
	move.l	d0,MEMPTR_UPPER_TRACKCOLLMAP(a6)
		
; Lower track bitmap
	move.l	#((SCREEN_SIZE_X/8)*SCREEN_SIZE_Y)*4,d0
	add.l	#$100,d0
	move.l	#(MEMF_CHIP!MEMF_CLEAR),d1
	bsr	agdAllocateResource
	move.w	#$0ff,d2
	tst.l	d0
	bmi	.error
	move.l	d0,MEMPTR_LOWER_TRACKBITMAP(a6)
	
	bsr	agdShowAvilableChipMemory
	
; Upper track bitmap
	move.l	#((SCREEN_SIZE_X/8)*SCREEN_SIZE_Y)*4,d0
	add.l	#$100,d0
	move.l	#(MEMF_CHIP!MEMF_CLEAR),d1
	bsr	agdAllocateResource
	move.w	#$ff0,d2
	tst.l	d0
	bmi	.error
	move.l	d0,MEMPTR_UPPER_TRACKBITMAP(a6)
	
; Lower track guide map
	move.l	#(SCREEN_SIZE_X/8)*(SCREEN_SIZE_Y/8),d0
	add.l	#$10,d0
	move.l	#MEMF_CHIP,d1
	bsr	agdAllocateResource
	move.w	#$5fa,d2
	tst.l	d0
	bmi	.error
	move.l	d0,MEMPTR_LOWER_TRACKGUIDE(a6)
	
; Upper track guide map
	move.l	#(SCREEN_SIZE_X/8)*(SCREEN_SIZE_Y/8),d0
	add.l	#$10,d0
	move.l	#MEMF_CHIP,d1
	bsr	agdAllocateResource
	move.w	#$af5,d2
	tst.l	d0
	bmi	.error
	move.l	d0,MEMPTR_UPPER_TRACKGUIDE(a6)	
	
; Lower track terrain map
	move.l	#(SCREEN_SIZE_X/8)*(SCREEN_SIZE_Y/8),d0
	add.l	#$10,d0
	move.l	#MEMF_CHIP,d1
	bsr	agdAllocateResource
	move.w	#$5af,d2
	tst.l	d0
	bmi	.error
	move.l	d0,MEMPTR_LOWER_TRACKTERRAIN(a6)
	
; Upper track terrain map
	move.l	#(SCREEN_SIZE_X/8)*(SCREEN_SIZE_Y/8),d0
	add.l	#$10,d0
	move.l	#MEMF_CHIP,d1
	bsr	agdAllocateResource
	move.w	#$6ac,d2
	tst.l	d0
	bmi	.error
	move.l	d0,MEMPTR_UPPER_TRACKTERRAIN(a6)

; Lower track terrain map
	move.l	#(SCREEN_SIZE_X/8)*(SCREEN_SIZE_Y/8),d0
	add.l	#$10,d0
	move.l	#MEMF_CHIP,d1
	bsr	agdAllocateResource
	move.w	#$ca6,d2
	tst.l	d0
	bmi	.error
	move.l	d0,MEMPTR_LOWER_TRACKCOMMANDS(a6)
	
; Upper track terrain map
	move.l	#(SCREEN_SIZE_X/8)*(SCREEN_SIZE_Y/8),d0
	add.l	#$10,d0
	move.l	#MEMF_CHIP,d1
	bsr	agdAllocateResource
	move.w	#$789,d2
	tst.l	d0
	bmi	.error
	move.l	d0,MEMPTR_UPPER_TRACKCOMMANDS(a6)
	bra	.exit
.error:	move.w	d2,$dff180
	bra.s	.error
	
.exit:	rts

	
; A1 will have 4 bytes for each car
ssRaceGetRandomCars:
	move.l	d0,-(a7)
	lea	RAND_CARS(a6),a1
	moveq	#0,d0
	move.w	$dff006,d0
	divu.w	#24,d0
	swap	d0
        add.w d0,d0
        add.w d0,d0
	move.l	.random(pc,d0.w),(a1)
	move.l	(a7)+,d0
	rts
	
.random:
	   dc.b  0,1,2,3
	   dc.b  0,1,3,2
	   dc.b  0,2,1,3
	   dc.b  0,2,3,1
	   dc.b  0,3,1,2
	   dc.b  0,3,2,1
	   dc.b  1,0,2,3
	   dc.b  1,0,3,2
	   dc.b  1,2,0,3
	   dc.b  1,2,3,0
	   dc.b  1,3,0,2
	   dc.b  1,3,2,0
	   dc.b  2,0,1,3
	   dc.b  2,0,3,1
	   dc.b  2,1,0,3
	   dc.b  2,1,3,0
	   dc.b  2,3,0,1
	   dc.b  2,3,1,0
	   dc.b  3,0,1,2
	   dc.b  3,0,2,1
	   dc.b  3,1,0,2
	   dc.b  3,1,2,0
	   dc.b  3,2,0,1
	   dc.b  3,2,1,0

;---------------

raceSetDroneParameters:
; I somehow need to randomise this.
	bsr	ssRaceGetRandomCars

	;;;move.w	CURRENT_TRACK(a6),d0
	
	move.w	CURRENT_LEVEL(a6),d0
	
	lea	LEVELS(a6),a0
	add.w	6(a0,d0*8),a0
	
	moveq	#maxCars-1,d7
	moveq	#0,d1
.drone:	move.b	(a1)+,d1
	GET_CAR_CONTEXT
	tst.w	carIsDrone(a4)
	beq.s	.next
	moveq	#0,d2
	move.w	0(a0),d2				;1
	move.l	d2,carCurrentTraction(a4)
	move.w	2(a0),d2	;2
	add.w	CURRENT_DIFFICULTY(a6),d2
	
; Set the drone maximum throttle speed
	cmp.l	#DRONE_MAX_THROTTLE,d2
	ble.s	.max
	move.l	#DRONE_MAX_THROTTLE,d2
.max:
	move.l	d2,carMaxThrottle(a4)
	move.w	4(a0),d2				;3
	move.l	d2,carMaxHorsePower(a4)
	move.w	6(a0),carDroneStartDelay(a4)		;4
	move.w	8(a0),carDroneCornerSpeed(a4)		;5
.next:	add.l	#10,a0
	dbf	d7,.drone
	rts
	

; d0=Level
; Load a packed track is taken from one file
; Use Ross's loader for this.
raceLoadPackedTrackOS:
; Get the track to load
	lea	LEVELS(a6),a0
	move.w	4(a0,d0*8),d0			; Track Number

	move.w	d0,CURRENT_TRACK(a6)
; Load the drone information here
		
	IFEQ	LOAD_TRACK_FROM_DF0
	lea	TRACK_FILES,a0			; %%%%
	move.l	(a0,d0*4),a0			; Pointer to track filename
	moveq	#0,d0
	moveq	#MEMF_CHIP,d1
	bsr	agdLoadPackedAsset				; hAsset = amgLoadPackedAsset(*name[a0], memtype[d1])
	tst.l	d0
.error:	bmi	.error
	move.l	d0,a0
	move.l	(a0),UNPPTR_PACKED_TRACK(a6)			; Save pointer to asset!
	move.l	(a0),a2
	ELSE



; Here we load using Amiga DOS
; a0=Filename
; a1=Destination buffer
	move.l	a6,-(a7)
	lea	TRACK_FILES,a0			; %%%%
	move.l	(a0,d0*4),d1			; Pointer to track filename				      
        move.l  #MODE_OLDFILE,d2
	move.l  DOSBASE(a6),a6 
        jsr     _LVOOpen(a6)         		; handle[d0] = LVOOpenFile(filename[d1],mode[d2])
	move.l	d0,d7
	move.l	(a7)+,a6

.open_handle_fail:
	move.w	#$700,$dff180
	tst.l	d0
	beq	.open_handle_fail
	
	move.l	a6,-(a7)
	move.l	d7,d1
	move.l	MEMPTR_TRACK_PACK_BUFFER(a6),a0	; Load point
	move.l	hAddress(a0),d2
	move.l	#$ffffff,d3
	move.l  DOSBASE(a6),a6 
	jsr     _LVORead(a6)        		; bytes[d0] = LVORead(handle[d1],buffer[d2],size[d3]) 	
	move.l	(a7)+,a6
	
	move.l	a6,-(a7)
	move.l	d7,d1
	move.l  DOSBASE(a6),a6 
        jsr     _LVOClose(a6)        
	move.l	(a7)+,a6	

	
;----
	ENDC
	
	
	
	move.l	d2,a2
	
	cmp.l	#"SSTR",hTrackSignature(a2)
	beq.s	.header
.crash1:	bra.s	.crash1
.header:
; Get pointer to lower track mask
	tst.l	hTrackLowerCollisionBitmapOffset(a2)
	beq.s	.skip1
	move.l	a2,a0
	add.l	hTrackLowerCollisionBitmapOffset(a2),a0		; RNC Packed Collision Mask
	move.l	MEMPTR_LOWER_TRACKCOLLMAP(a6),a1
	bsr	agdClearResource
	move.l	hAddress(a1),a1					; Unpack Address
	bsr	Unpack
	bsr	agdCreateBitmap			;
	move.l	d0,BMPPTR_LOWER_TRACK_MASK(a6)	
.skip1:

	tst.l	hTrackUpperCollisionBitmapOffset(a2)
	beq.s	.skip2
	move.l	a2,a0
	add.l	hTrackUpperCollisionBitmapOffset(a2),a0		; RNC Packed Collision Mask
	move.l	MEMPTR_UPPER_TRACKCOLLMAP(a6),a1
	bsr	agdClearResource
	move.l	hAddress(a1),a1					; Unpack Address
	bsr	Unpack
	bsr	agdCreateBitmap			;
	move.l	d0,BMPPTR_UPPER_TRACK_MASK(a6)
.skip2:

	tst.l	hTrackLowerTrackBitmapOffset(a2)
	beq.s	.skip3
	move.l	a2,a0
	add.l	hTrackLowerTrackBitmapOffset(a2),a0		; RNC Packed Collision Mask
	move.l	MEMPTR_LOWER_TRACKBITMAP(a6),a1
	bsr	agdClearResource
	move.l	hAddress(a1),a1					; Unpack Address
	bsr	Unpack
	bsr	agdGetBitmapPalette			;
	move.l	d0,PALPTR_LOWER_TRACK(a6)
	bsr	agdCreateBitmap			;
	move.l	d0,BMPPTR_LOWER_TRACK(a6)

.skip3:
	tst.l	hTrackUpperTrackBitmapOffset(a2)
	beq.s	.skip4
	move.l	a2,a0
	add.l	hTrackUpperTrackBitmapOffset(a2),a0		; RNC Packed Collision Mask
	move.l	MEMPTR_UPPER_TRACKBITMAP(a6),a1
	bsr	agdClearResource
	move.l	hAddress(a1),a1					; Unpack Address
	bsr	Unpack
	bsr	agdGetBitmapPalette			
	move.l	d0,PALPTR_UPPER_TRACK(a6)
	bsr	agdCreateBitmap			;
	move.l	d0,BMPPTR_UPPER_TRACK(a6)
.skip4:
	tst.l	hTrackLowerCommandByteMapOffset(a2)
	beq.s	.skip5
	move.l	a2,a0
	add.l	hTrackLowerCommandByteMapOffset(a2),a0		; RNC Packed Collision Mask
	move.l	MEMPTR_LOWER_TRACKCOMMANDS(a6),a1
	bsr	agdClearResource
	move.l	hAddress(a1),a1					; Unpack Address
	bsr	Unpack
.skip5:
	tst.l	hTrackUpperCommandByteMapOffset(a2)
	beq.s	.skip6
	move.l	a2,a0
	add.l	hTrackUpperCommandByteMapOffset(a2),a0		; RNC Packed Collision Mask
	move.l	MEMPTR_UPPER_TRACKCOMMANDS(a6),a1
	bsr	agdClearResource
	move.l	hAddress(a1),a1					; Unpack Address
	bsr	Unpack

.skip6:
	tst.l	hTrackLowerDroneGuideByteMapOffset(a2)
	beq.s	.skip7
	move.l	a2,a0
	add.l	hTrackLowerDroneGuideByteMapOffset(a2),a0		; RNC Packed Collision Mask
	move.l	MEMPTR_LOWER_TRACKGUIDE(a6),a1
	bsr	agdClearResource
	move.l	hAddress(a1),a1					; Unpack Address
	bsr	Unpack
.skip7:
	tst.l	hTrackUpperDroneGuideByteMapOffset(a2)
	beq.s	.skip8
	move.l	a2,a0
	add.l	hTrackUpperDroneGuideByteMapOffset(a2),a0		; RNC Packed Collision Mask
	move.l	MEMPTR_UPPER_TRACKGUIDE(a6),a1
	bsr	agdClearResource
	move.l	hAddress(a1),a1					; Unpack Address
	bsr	Unpack
.skip8:
	tst.l	hTrackLowerTerrainByteMapOffset(a2)
	beq.s	.skip9
	move.l	a2,a0
	add.l	hTrackLowerTerrainByteMapOffset(a2),a0		; RNC Packed Collision Mask
	move.l	MEMPTR_LOWER_TRACKTERRAIN(a6),a1
	bsr	agdClearResource
	move.l	hAddress(a1),a1					; Unpack Address
	bsr	Unpack
.skip9:
	tst.l	hTrackUpperTerrainByteMapOffset(a2)
	beq.s	.skip10
	move.l	a2,a0
	add.l	hTrackUpperTerrainByteMapOffset(a2),a0		; RNC Packed Collision Mask
	move.l	MEMPTR_UPPER_TRACKTERRAIN(a6),a1
	bsr	agdClearResource
	move.l	hAddress(a1),a1					; Unpack Address
	bsr	Unpack
.skip10:	
	move.l	hTrackFlagPosX(a2),trackFlagXPos
	move.l	hTrackFlagPosY(a2),trackFlagYPos
	
; Load Car Positions
	lea	CAR_TRACK_POSITIONS,a0
	rept	4
	move.l	hTrackCar1StartPosX(a2),0(a0)
	move.l	hTrackCar1StartPosY(a2),4(a0)	
	move.l	hTrackCar1StartLevel(a2),8(a0)
	move.l	hTrackCar1StartFacingAngle(a2),16(a0)
	add.l	#28,a0
	add.l	#16,a2
	endr
	rts
	
	
; Get the total number of checkpoints from the loaded track commands
ssGetTotalCheckpoints:
	moveq	#0,d0				; counter
	
	lea	TRACK_LAYERS,a0			; %%%%
	move.l	8(a0),a0			; Get lower layer
	IFEQ	TRACK_BUILD_MODE
	move.l	(a0),a0
	move.l	(a0),a0
	ENDC
	
	move.l	#(SCREEN_SIZE_X/8*SCREEN_SIZE_Y/8)-5,d7
	bsr	.get
	lea	TRACK_LAYERS,a0			; %%%%
	move.l	24(a0),a0			; Get upper layer
	IFEQ	TRACK_BUILD_MODE
	move.l	(a0),a0
	move.l	(a0),a0
	ENDC
	move.l	#(SCREEN_SIZE_X/8*SCREEN_SIZE_Y/8)-5,d7
	bsr	.get
	bra	.exit
	
.get:	moveq	#0,d1
	move.b	(a0)+,d1
	btst	#6,d1
	beq.s	.next
	and.b	#%11111,d1
	cmp.b	d1,d0
	bge.s	.next
	move.b	d1,d0
.next:	dbf	d7,.get
.exit:	rts


	
; Unpack mask bitmap to lower screen

ssDebugTrackMasks:
	IFNE	DEBUG_COLLISION_MAP
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	#SCREEN_SIZE_X,d0
	move.l	#SCREEN_SIZE_Y,d1
	move.l	#1,d2
	bsr	agdCreateScreen
	tst.l	d0
.crash2:	
	bmi.s	.crash2
	move.l	d0,SCRPTR_LOWER_TRACK_MASK(a6)
	
	move.l	SCRPTR_LOWER_TRACK_MASK(a6),d0
	bsr	agdClearScreen
	move.l	BMPPTR_LOWER_TRACK_MASK(a6),d0
	move.l	SCRPTR_LOWER_TRACK_MASK(a6),d1
	bsr	agdCopyBitmapToScreen	
	
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	#SCREEN_SIZE_X,d0
	move.l	#SCREEN_SIZE_Y,d1
	move.l	#1,d2
	bsr	agdCreateScreen
.crash3:	
	bmi.s	.crash3
	move.l	d0,SCRPTR_UPPER_TRACK_MASK(a6)
	
	move.l	SCRPTR_UPPER_TRACK_MASK(a6),d0
	bsr	agdClearScreen
	move.l	BMPPTR_UPPER_TRACK_MASK(a6),d0
	move.l	SCRPTR_UPPER_TRACK_MASK(a6),d1
	bsr	agdCopyBitmapToScreen
	ENDC
.exit:
.error:	rts
	

	IFNE	TRACK_BUILD_MODE
raceLoadTrackBitmaps:
;-------- Load Lower Track Bitmap	
; Load Background file into RAM
	lea	FNAME_LOWER_TRACK(a6),a0				
	moveq	#0,d0
	move.l	#(MEMF_CHIP!MEMF_CLEAR),d1
	bsr	agdLoadPackedAsset			; hAsset = amgLoadPackedAsset(*name[a0], memtype[d1])
	tst.l	d0
	bmi	.error
	move.l	d0,UNPPTR_LOWER_TRACK(a6)			; Save pointer to asset!

	
; Create a Bitmap Handle and work out dimensions
	move.l	UNPPTR_LOWER_TRACK(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdCreateBitmap			;
	move.l	d0,BMPPTR_LOWER_TRACK(a6)
	
; Get the palette of the Bitmap
	move.l	UNPPTR_LOWER_TRACK(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdGetBitmapPalette			;
	move.l	d0,PALPTR_LOWER_TRACK(a6)
	
;-------- Load Upper Track Bitmap	
; Load Background file into RAM
	lea	FNAME_UPPER_TRACK(a6),a0				
	moveq	#0,d0
	move.l	#(MEMF_CHIP!MEMF_CLEAR),d1
	bsr	agdLoadPackedAsset			; hAsset = amgLoadPackedAsset(*name[a0], memtype[d1])
	tst.l	d0
	bmi	.error
	move.l	d0,UNPPTR_UPPER_TRACK(a6)			; Save pointer to asset!
	
; Create a Bitmap Handle and work out dimensions
	move.l	UNPPTR_UPPER_TRACK(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdCreateBitmap			;
	move.l	d0,BMPPTR_UPPER_TRACK(a6)	
	
; Get the palette of the Bitmap
	move.l	UNPPTR_UPPER_TRACK(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdGetBitmapPalette			;
	move.l	d0,PALPTR_UPPER_TRACK(a6)
.error:	rts
	

raceLoadTrackMasks:
	lea	FNAME_LOWER_TRACK_MASK(a6),a0				
	moveq	#0,d0
	moveq	#MEMF_CHIP,d1
	bsr	agdLoadPackedAsset				; hAsset = amgLoadPackedAsset(*name[a0], memtype[d1])
	tst.l	d0
	bmi	.error
	move.l	d0,a0
	move.l	(a0),UNPPTR_LOWER_TRACK_MASK(a6)			; Save pointer to asset!

; Create a Bitmap Handle and work out dimensions
	move.l	UNPPTR_LOWER_TRACK_MASK(a6),a1			; Pointer to IFF in a1
	bsr	agdCreateBitmap			;
	move.l	d0,BMPPTR_LOWER_TRACK_MASK(a6)
	
;----------------
	lea	FNAME_UPPER_TRACK_MASK(a6),a0				
	moveq	#0,d0
	moveq	#MEMF_CHIP,d1
	bsr	agdLoadPackedAsset				; hAsset = amgLoadPackedAsset(*name[a0], memtype[d1])
	tst.l	d0
	bmi	.error
	move.l	d0,a0
	move.l	(a0),UNPPTR_UPPER_TRACK_MASK(a6)			; Save pointer to asset!

; Create a Bitmap Handle and work out dimensions
	move.l	UNPPTR_UPPER_TRACK_MASK(a6),a1			; Pointer to IFF in a1
	bsr	agdCreateBitmap			;
	move.l	d0,BMPPTR_UPPER_TRACK_MASK(a6)
.error:	rts
	
	ENDC
	
; Reset all car variables ready for a race.	
raceInitTrack:
	clr.w	NUM_SPANNER_SPRITES(a6)
	clr.w	NUM_POINTS_SPRITES(a6)
	clr.w	INGAME_PLAYERS(a6)
	
; Maybe something here around seconds to complete a track
	move.l	#(MAX_PLAYERS_SECONDS*64),INGAME_TIMER(a6)
	
	
	movem.l	d0-d7/a0-a3,-(a7)
	moveq	#maxCars-1,d7
	
	moveq	#0,d0
	lea	CAR_POSITIONS_TAB(a6),a0
	move.l	(a0,d0*4),a0			; a0=Car x,y,level
	
	moveq	#CAR_1,d1
	
.loop:	GET_CAR_CONTEXT
	move.l	#carInitMaxThrottle,carMaxThrottle(a4)
	move.l	#carInitMaxHorsePower,carMaxHorsePower(a4)	
	move.l	#carInitMaxBraking,carMaxBraking(a4)	
	
	move.w	#CAR_DRONE_TRACTION,carCurrentTraction(a4)
	move.w	#CAR_DRONE_TRACTION,carTractionMod(a4)
	tst.w	carIsDrone(a4)
	bmi.s	.is_drone	
	move.w	#CAR_PLAYER_TRACTION,carCurrentTraction(a4)
	move.w	#CAR_PLAYER_TRACTION,carTractionMod(a4)
.is_drone:
	
	move.w	#-1,carSpinTimer(a4)
	clr.b	carShortTimer(a4)
	clr.l	carCurrentThrottle(a4)
	
	move.b	#0,carLastCheckPoint(a4)
	clr.w	carOnLap(a4)
	clr.w	carElevation(a4)
	clr.w	carIsFalling(a4)
	clr.w	carControlEnabled(a4)
	clr.w	carIsFallingIndex(a4)
	clr.w	carRebounding(a4)
	clr.l	carTimeLap1(a4)
	clr.l	carTimeLap2(a4)
	clr.l	carTimeLap3(a4)
	clr.l	carTimeLap4(a4)
	clr.w	carTimeSinceLastCheckPoint(a4)
	clr.w	carTouchingCars(a4)
	clr.b	carOutOfRace(a4)
	clr.w	carHasNitro(a4)
	clr.w	carHasNitro(a4)
	clr.b	carShortTimer(a4)
	clr.l	carTimer(a4)
	clr.w	carExploding(a4)

; Used for testing	
	move.l	d1,carNumber(a4)			; Store Car Number
	move.l	(a0)+,carXpos(a4)
	move.l	(a0)+,carYpos(a4)
	move.l	carXpos(a4),carCheckPointXpos(a4)
	move.l	carYpos(a4),carCheckPointYpos(a4)	
	move.l	(a0)+,carLevel(a4)
	move.l	(a0)+,carColour(a4)			; if 90 or above then a drone.
	move.l	(a0)+,d2
	move.b	d2,carWheelAngle(a4)
	move.b	carWheelAngle(a4),carCheckPointWheelAngle(a4)
	move.b	d2,carDragAngle(a4)
	move.l	(a0)+,d2			
	move.b	d2,carCheckPoints(a4)
	
	move.l	(a0)+,d2
	
	bsr	ssRaceSetCarAttributes

	addq.w	#1,d1		; a4 now points to structure.
	dbf	d7,.loop

.exit:	movem.l	(a7)+,d0-d7/a0-a3
	rts
	

	
ssRaceCheckTimeOut:
	IFEQ	INFINTE_LAPS
	cmp.w	#4,INGAME_PLAYERS(a6)
	bne.s	.exit
	
	IFEQ	INFINTE_LAPS
	move.l	FRAME_COUNT(a6),d0
	and.l	#1,d0
	beq.s	.1
	subq.l	#1,INGAME_TIMER(a6)
.1:
	ENDC	

	tst.l	INGAME_TIMER(a6)
	bpl.s	.exit

	move.w	#-1,RACE_OVER(a6)	
	ENDC
.exit:	rts

ssRaceInitCars:
	moveq	#maxCars-1,d1
.loop:	bsr	ssRaceInitCarAttributes
	dbf	d1,.loop
	rts


;d1 = car
ssRaceInitCarAttributes:
	GET_CAR_CONTEXT
	
	clr.w	carSpanners(a4)
	clr.l	carScore(a4)
	clr.b	carAttrTraction(a4)
	clr.b	carAttrSpeed(a4)
	clr.b	carAttrTurbo(a4)
	clr.b	carOutOfRace(a4)

	clr.w	carHasNitro(a4)
	clr.b	carShortTimer(a4)
	clr.l	carTimer(a4)
		
	rts


;d1=Car number	
;d2=0 (player), -1= (drone)	
ssRaceSetCarAttributes:
		movem.l	d0/a0,-(a7)
		
		GET_CAR_CONTEXT
	
		cmp.l	#CAR_1,d1
		beq.s	.car_1
		cmp.l	#CAR_2,d1
		beq.s	.car_2
		cmp.l	#CAR_3,d1
		beq.s	.car_3
		cmp.l	#CAR_4,d1
		beq.s	.car_4		
		bra	.exit
; Set the car colour	
.car_1:		move.l	#CAR_DRONE_BLUE,carColour(a4)
		;move.w	#CAR_DRONE_TRACTION,carCurrentTraction(a4)		; Default for drones
		tst.w	carIsDrone(a4)
		bmi	.exit
		move.l	#CAR_PLAYER_BLUE,carColour(a4)
		clr.w	carControlDisable(a4)
		addq.w	#1,INGAME_PLAYERS(a6)
		bra.s	.attributes

.car_2:		move.l	#CAR_DRONE_RED,carColour(a4)
		;move.w	#CAR_DRONE_TRACTION,carCurrentTraction(a4)		; Default for drones
		tst.w	carIsDrone(a4)
		bmi	.exit
		move.l	#CAR_PLAYER_RED,carColour(a4)
		clr.w	carControlDisable(a4)
		addq.w	#1,INGAME_PLAYERS(a6)
		bra.s	.attributes		

.car_3:		move.l	#CAR_DRONE_YELLOW,carColour(a4)
		;move.w	#CAR_DRONE_TRACTION,carCurrentTraction(a4)		; Default for drones
		tst.w	carIsDrone(a4)
		bmi	.exit
		move.l	#CAR_PLAYER_YELLOW,carColour(a4)
		clr.w	carControlDisable(a4)
		addq.w	#1,INGAME_PLAYERS(a6)
		bra.s	.attributes

.car_4:		move.l	#CAR_DRONE_GREEN,carColour(a4)
		;move.w	#CAR_DRONE_TRACTION,carCurrentTraction(a4)		; Default for drones
		tst.w	carIsDrone(a4)
		bmi	.exit
		move.l	#CAR_PLAYER_GREEN,carColour(a4)
		clr.w	carControlDisable(a4)
		addq.w	#1,INGAME_PLAYERS(a6)
		bra.s	.attributes		
		nop
.attributes:
; Load traction setting	
		lea	.ptraction(pc),a0
		moveq	#0,d0
		move.b	carAttrTraction(a4),d0
		move.l	(a0,d0*4),d0
		move.w	d0,carCurrentTraction(a4)

; Load turbo
		lea	.pturbo(pc),a0
		moveq	#0,d0
		move.b	carAttrTurbo(a4),d0
		move.l	(a0,d0*4),d0
		move.l	d0,carMaxHorsePower(a4)

; Load maximum speed/throttle
		lea	.pspeed(pc),a0
		moveq	#0,d0
		move.b	carAttrSpeed(a4),d0
		move.l	(a0,d0*4),d0
		move.l	d0,carMaxThrottle(a4)
		bra	.exit	
	
;levels 0-4	
.ptraction:	dc.l	$280,$2c0,$300,$340,$380,$3c0	
.pturbo:	dc.l	6,8,10,12,14,16
.pspeed:	dc.l	$300,$320,$340,$360,$380,$3a0

		
.exit:		movem.l	(a7)+,d0/a0
		rts
		
		
; d4=xpos
; d5=ypos
ssDbgPlotLowerBlock:
		movem.l	d4-d5/a0-a1,-(a7)
		
		move.l	DBSPTR_LOWER_TRACK(a6),a0
		move.l	hDbuffScreen2(a0),a1
		move.l	hDbuffScreen1(a0),a0

		move.l	hScreenPointers(a0),a0
		move.l	hScreenPointers(a1),a1	

		lsl.l	#8,d5
		lsl.l	#3,d5
		
		add.l	d4,d5
		add.l	d5,a0
		add.l	d5,a1
		
		move.l	#256,d4
		moveq	#-1,d5
		
		rept	8
		move.b	d5,64(a0)
		move.b	d5,64(a1)
		add.l	d4,a0
		add.l	d4,a1
		endr
		
		movem.l	(a7)+,d4-d5/a0-a1
		rts
		
		data

NUM_SPANNER_SPRITES:	dc.w	0
NUM_POINTS_SPRITES:	dc.w	0

CURRENT_TRACK:	dc.w	0
WIN_DELAY_TIMER:	dc.w	0

INGAME_PLAYERS:	dc.w	0
INGAME_TIMER:	dc.l	0

RANDOM01:	dc.w	0
	
LOADED_TRACK_PTR:	dc.l	0

UNPPTR_UPPER_TRACK:		dc.l	0
UNPPTR_LOWER_TRACK:		dc.l	0
UNPPTR_LOWER_TRACK_MASK:	dc.l	0
UNPPTR_UPPER_TRACK_MASK:	dc.l	0

UNPPTR_CAR_COLLMAP:		dc.l	0
UNPPTR_GAME_SPRITES:		dc.l	0
MEMPTR_COLLISION_RAM:		dc.l	0

UNPPTR_PACKED_TRACK:		dc.l	0
MEMPTR_LOWER_TRACKCOLLMAP:	dc.l	0
MEMPTR_UPPER_TRACKCOLLMAP:	dc.l	0
MEMPTR_LOWER_TRACKBITMAP:	dc.l	0
MEMPTR_UPPER_TRACKBITMAP:	dc.l	0
MEMPTR_LOWER_TRACKGUIDE:	dc.l	0
MEMPTR_UPPER_TRACKGUIDE:	dc.l	0
MEMPTR_LOWER_TRACKTERRAIN:	dc.l	0
MEMPTR_UPPER_TRACKTERRAIN:	dc.l	0
MEMPTR_LOWER_TRACKCOMMANDS:	dc.l	0
MEMPTR_UPPER_TRACKCOMMANDS:	dc.l	0

BMPPTR_LOWER_TRACK:		dc.l	0
BMPPTR_UPPER_TRACK:		dc.l	0
BMPPTR_LOWER_TRACK_MASK:	dc.l	0
BMPPTR_UPPER_TRACK_MASK:	dc.l	0
BMPPTR_CAR_COLLMAP:		dc.l	0
BMPPTR_GAME_SPRITES:		dc.l	0

MSKPTR_GAME_SPRITES:		dc.l	0

PALPTR_UPPER_TRACK:		dc.l	0
PALPTR_LOWER_TRACK:		dc.l	0

SCRPTR_LOWER_TRACK_MASK:	dc.l	0
SCRPTR_UPPER_TRACK_MASK:	dc.l	0

DBSPTR_LOWER_TRACK:		dc.l	0
DBSPTR_UPPER_TRACK:		dc.l	0
				
	code