; Game Sprites
sprCarExplodeLower:	equ	0
sprTornado:		equ	1
sprBarrierA:		equ	2
sprLap0:		equ	3
sprLap1:		equ	4
sprLap2:		equ	5
sprStartRace:		equ	6
sprConeHit:		equ	7
sprWater:		equ	8
sprBollardA:		equ	9
sprVertWallA:		equ	10
sprHoriWallA:		equ	11
sprCarExplodeSet1:	equ	12
sprSmokeSouthLeft:	equ	13
sprSmokeSouthRight:	equ	14
sprSmokeNorthLeft:	equ	15
sprSmokeNorthRight:	equ	16		; Collectibles mapped $10-$1f
spr100Points:		equ	17		; 17 $11 Collectable
spr150Points:		equ	18		; 18 $12 Collectable
sprCone:		equ	19		; 19 $13 Collectable
sprSpanner:		equ	20		; 20 $14 Collectable
sprBlank16x16:		equ	21		; 21 $15 Used for obtacle
sprBlank48x32:		equ	22		; 22 $16 Used for obtacle
sprSmokeEastUp:		equ	23		; 23 $17 Used for obtacle
sprSmokeEastDown:	equ	24		; 24 $18 Used for obtacle
sprSmokeWestUp:		equ	25		; 25 $19 Spare
sprSmokeWestDown:	equ	26		; 26 $1a Spare
sprOil:			equ	27		; 27 $1b Oil  
sprMud:			equ	28		; 28 $1c Mud
sprBlueChopperDown:	equ	29
sprRedChopperDown:	equ	30
sprYellowChopperDown:	equ	31
sprGreenChopperDown:	equ	32
sprCarExplodeSet2:	equ	33
sprCarExplodeSet3:	equ	34
sprNitro:		equ	35
sprBollardB:		equ	36
sprBollardC:		equ	37
sprBollardD:		equ	38
sprBarrierB:		equ	39
sprBarrierC:		equ	40
sprBarrierD:		equ	41
sprVertWallB:		equ	42
sprVertWallC:		equ	43
sprVertWallD:		equ	44
sprHoriWallB:		equ	45
sprHoriWallC:		equ	46
sprHoriWallD:		equ	47
sprHoriWallCookD:	equ	48
sprOilCook:		equ	49  
sprMudCook:		equ	50		
spr100PointsCook:	equ	51		
spr150PointsCook:	equ	52		
sprBomb:		equ	53		
sprBombCook:		equ	54
sprBollardCookA:	equ	55
sprBollardCookB:	equ	56
sprBollardCookC:	equ	57
sprBollardCookD:	equ	58
sprConeCook:		equ	59

CLIP_SIZE_X:		equ	64
CLIP_SIZE_Y:		equ	128

BLANK_SPRITE:		equ	94
LAPS_RESTORE:		equ	93

LEVEL_LOWER_TRACK:	equ	0
LEVEL_UPPER_TRACK:	equ	1
LEVEL_LOWER_BITMAP:	equ	0
LEVEL_UPPER_BITMAP:	equ	1

LEVEL1:		equ	0

; Cast game sprites

; d0=Level to load
ssInjectSprites:
	movem.l	d0-d7/a0-a3,-(a7)
	moveq	#0,d0
	move.w	CURRENT_LEVEL(a6),d0
	lea	LEVELS(a6),a1
	moveq	#0,d1
	move.w	RANDOM01(a6),d1
	add.l	d1,a1
	add.w	(a1,d0*8),a1
	sub.l	d1,a1

; check frame for each entry in the level.
; if frame is -1 then inject straight away.

.loop:	tst.l	(a1)
	bmi	.exit
	move.l	FRAME_COUNT(a6),d0
	cmp.w	(a1),d0
	beq.s	.load
	add.l	#16,a1
	bra.s	.loop
	
.load:
	addq.w	#2,a1			; Skip frame for now.
	
	moveq	#0,d0
	move.w	(a1)+,d0		; Sprite Number
	moveq	#0,d1
	move.w	(a1)+,d1		; Xposition
	moveq	#0,d2
	move.w	(a1)+,d2		; Yposition
	moveq	#0,d3
	move.w	(a1)+,d3		; Delay frames
	moveq	#0,d5			; Car Number to assign
	
	moveq	#0,d6			
	move.w	(a1)+,d6		; Upper or lower for track
	swap	d6
	move.w	(a1)+,d6		; Upper or lower for bitmap
	
	swap	d2
	move.w	(a1)+,d2		; Arg 1
	swap	d2
	
; Don't allow multiple spanners and points to be placed onto the track

	cmp.w	#sprSpanner,d0		
	beq.s	.span
	cmp.w	#spr100Points,d0	
	beq.s	.100
	cmp.w	#spr150Points,d0	
	beq.s	.150
	bra.s	.ok
	
.span:	tst.w	NUM_SPANNER_SPRITES(a6)
	bmi.s	.loop
	bra.s	.ok
	
.100:	
.150:	tst.w	NUM_POINTS_SPRITES(a6)
	bmi.s	.loop	
	
.ok:	move.l	a1,-(a7)
	bsr	agdDispatchSprite
	move.l	(a7)+,a1
	bra.s	.loop

.exit:	
	movem.l	(a7)+,d0-d7/a0-a3
	rts

	

	
;
; d0=Sprite Number
; d1=Xpos
; d2=Ypos
; d3=Frame index to start
; d4=used
; d5=Car Number to cast against.
; d6=Tier (level)  <Bitmap Tier|Track Tier>
; a0=Handler Address
; a1=Sprite Parameters (word.SpriteNumber, word.XPosition, word.YPosition, word.Level)
;	(long.argument1, long.argument2, long.argument3, long.argument4)

agdDispatchSprite:
		move.l	a3,-(a7)
		moveq	#maxBobSpriteStructs-1,d7
		lea	RESOURCE_BOBSPRITES(a6),a3
		moveq	#0,d4
.find:		tst.w	hBobSpriteNumber(a3)
		bmi.s	.found
		cmp.w	#maxBobSpriteStructs-1,d4
		beq.s	.exit	
		addq.w	#1,d4	
		add.l	#sizeStructBobSprite,a3
		dbf	d7,.find
		moveq	#-1,d7
		bra.s	.exit
; Need to some how link a car to a bob
; This is because the chopper sprite needs to know where
; to place the car....  or we could cheat with an ordered table.
	
; a3=Structure
.found:		
		move.w	d0,hBobSpriteNumber(a3)	
		lea	gameSprites,a0
		move.l	4(a0,d0*8),a1
		move.l	a1,hBobSpriteHandler(a3)	; Get sprite handler		;
		move.l	(a0,d0*8),a0			; Get sprite meta data
		
		move.l	(a0)+,a1
		move.l	hAddress(a1),hBobSpriteSheet(a3)
		move.w	(a0)+,hBobSpriteXsize(a3)
		move.w	(a0)+,hBobSpriteYsize(a3)		
		move.w	(a0),hBobSpriteDelayFrames(a3)
		move.w	(a0)+,hBobSpriteDelayFrames+2(a3)
		move.w	(a0)+,hBobSpriteCookie(a3)
		move.l	d5,hBobSpriteCarNumber(a3)

		move.w	d6,hBobSpriteBitmapLevel(a3)
		swap	d6
		move.w	d6,hBobSpriteTrackLevel(a3)

		move.w	d7,hBobSpriteIndex(a3)
		move.w	d3,hBobSpriteCurrentFrame(a3)
		move.w	d1,hBobSpriteXpos(a3)
		move.w	d2,hBobSpriteYpos(a3)	
		swap	d1
		move.w	d1,hBobSpriteArg0(a3)
		swap	d2
		move.w	d2,hBobSpriteArg1(a3)
		
		lea	hBobSpriteAnimFrames(a3),a3	
.copy:		move.w	(a0)+,(a3)+
		bpl.s	.copy
		moveq	#0,d7
.exit:		
		move.l	(a7)+,a3
		rts

	
; a3 number point to current context.
agdRemoveGameSprite:
		movem.l	d3-d6/a3,-(a7)
;256 bytes
		lea	sizeStructBobSprite(a3),a3
		moveq	#-1,d3	;4
		moveq	#-1,d4	;8
		moveq	#-1,d5	;12
		moveq	#-1,d6	;16
		rept	32
		movem.l	d3-d6,-(a3)
		endr
		movem.l	(a7)+,d3-d6/a3
		rts
		
agdDestroyAllBobs:
		moveq	#maxBobSpriteStructs-1,d7
		lea	RESOURCE_BOBSPRITES(a6),a3
.loop:		bsr	agdRemoveGameSprite
		add.l	#sizeStructBobSprite,a3
		dbf	d7,.loop		
		rts
		
	
; a0=Screen Struct
; d0=Animation
; d5

agdAnimateGameSprites:
agdBlitGameSprites:
; DO copies first
		moveq	#maxBobSpriteStructs-1,d7
		lea	RESOURCE_BOBSPRITES(a6),a3
.find_copy:	move.w	hBobSpriteNumber(a3),d6
		tst.w	hBobSpriteNumber(a3)
		bmi.s	.skip_copy
		tst.w	hBobSpriteCookie(a3)		; copy or cookie?
		bmi.s	.skip_copy			; Copy.
		bsr	.animate
.skip_copy:	add.l	#sizeStructBobSprite,a3
		dbf	d7,.find_copy
		
; Then overlay cookies
		moveq	#maxBobSpriteStructs-1,d7
		lea	RESOURCE_BOBSPRITES(a6),a3
.find_cook:	move.w	hBobSpriteNumber(a3),d6
		tst.w	hBobSpriteNumber(a3)
		bmi.s	.skip_cook
		tst.w	hBobSpriteCookie(a3)		; copy or cookie?
		beq.s	.skip_cook			; Copy.
		bsr	.animate
.skip_cook:	add.l	#sizeStructBobSprite,a3
		dbf	d7,.find_cook
		
		bra	.exit 
		
		CNOP	0,4
.animate:	
		
	
.animate_2:	subq.w	#1,hBobSpriteDelayFrames(a3)
		bpl.s	.animate_1
		move.w	hBobSpriteDelayFrames+2(a3),hBobSpriteDelayFrames(a3)		
		addq.w	#1,hBobSpriteCurrentFrame(a3)
		bra.s	.animate_1
		nop
		
.animate_1:	
		movem.l	d0-d7/a0-a2,-(a7)
		move.l	hBobSpriteHandler(a3),a2
		jsr	(a2)
		movem.l	(a7)+,d0-d7/a0-a2	


		movem.l	d0-d7/a0-a3,-(a7)
		moveq	#0,d2
		move.w	hBobSpriteCurrentFrame(a3),d2
		lea	hBobSpriteAnimFrames(a3),a2
		move.w	(a2,d2*2),d2			; Get Bob Number
		bpl.s	.go
; d2=$8000 or $8001
.loop_or_destroy:		; $00=Destroy	$01=Loop   $ff=Halt
		tst.b	d2				
		beq.s	.destroy			; d0=$8000
		bmi.s	.halt				; d0=$80ff
; The value here will be 1
		bra.s	.loop				; d0=$8001
		
.halt:		addq.w	#1,hBobSpriteDelayFrames(a3)
		move.w	hBobSpriteCurrentFrame(a3),d2
		subq.w	#1,d2
		move.w	(a2,d2*2),d2		; Get Bob Number		
		bra.s	.go
		
.destroy:	bsr	agdRemoveGameSprite
		bra	.done

.loop:		subq.b	#1,d2
		and.w	#$00ff,d2
		move.w	d2,hBobSpriteCurrentFrame(a3)	
		;clr.w	hBobSpriteCurrentFrame(a3)	
		;moveq	#0,d2
		move.w	(a2,d2*2),d2			; Get Bob Number

.go:		move.w	d2,hBobSpriteBobNumber(a3)

		moveq	#0,d2
		move.w	hBobSpriteBobNumber(a3),d2
		and.w	#$fff,d2 		
		
		move.l	hBobSpriteSheet(a3),a2	
		cmp.l	#-1,a2
		beq	.done
		cmp.l	#tLacedSpriteSheet,hType(a2)	; Is it a hardware interlaced sprite sheet?
		beq.s	.hwspr				; if yes then
		
		;move.l	$dff004,d0			; Are we too far down the screen?
		;and.l	#$1ff00,d0
		;cmp.l	#240<<8,d0
		;bgt	.done
		
		moveq	#0,d0
		move.w	hBobSpriteXpos(a3),d0
		moveq	#0,d1
		move.w	hBobSpriteYpos(a3),d1				
		bsr	.blit				; Blit the sprite.
		bra.s	.done
.hwspr:		
		moveq	#0,d0
		move.w	hBobSpriteXpos(a3),d0
		moveq	#0,d1
		move.w	hBobSpriteYpos(a3),d1

		move.l	hLacedOddSpriteSheet(a2),a0
		moveq	#0,d7
		move.w	d2,d7
		
		moveq	#0,d2
		move.w	VPOSR(a5),d2
		rol.w	#1,d2
		not.w	d2
		and.w	#1,d2
		move.l	hLacedOddSpriteSheet(a2,d2*4),a0
		
		move.l	hBobSpriteCarNumber(a3),d6
		move.l	COPPTR_SPRPTH0,a1	
		add.w	#127,d0
		;add.w	#22,d1
		bsr	agdShowHardwareSpriteByOrder
.done:		movem.l	(a7)+,d0-d7/a0-a3
		bra	.exit

.fwmaskbits:	dc.w	%0000000000000000
		dc.w	%0000000000000001
		dc.w	%0000000000000011
		dc.w	%0000000000000111
		dc.w	%0000000000001111
		dc.w	%0000000000011111
		dc.w	%0000000000111111
		dc.w	%0000000001111111
		dc.w	%0000000011111111
		dc.w	%0000000111111111
		dc.w	%0000001111111111
		dc.w	%0000011111111111
		dc.w	%0000111111111111
		dc.w	%0001111111111111
		dc.w	%0011111111111111
		dc.w	%0111111111111111
		dc.w	%1111111111111111

.lwmaskbits:	dc.w	$ffff,$fffe,$fffc,$fff8	
		dc.w	$fff0,$ffe0,$ffc0,$ff80		
		dc.w	$ff00,$fe00,$fc00,$f800	
		dc.w	$f000,$e000,$c000,$8000
	
; Inputs	
; a0=Screen pointer
; a3=Sprite structure ptr
; Use:
; d0 is used for x Pos
; d1 is used for y pos
; d2 is used for Bob number and BLTCON regs

; d3 is a scratch register
; d4 is used for masking on shifts
; d5 is used for barrel shifting
; d6 is used for x clipping
; d7 is used for y clipping
.blit:	
; d0 & d1 has coordinates
		tst.w	d0
		bmi	.exit
		tst.w	d1
		bmi	.exit
		
		move.l	(a2),a1
		move.l	(a1,d2*8),a2			; a2= Bob		
		move.l	4(a1,d2*8),a1			; a1= Mask
		
		move.l	DBSPTR_LOWER_TRACK(a6),a0
		cmp.w	#LEVEL_LOWER_TRACK,hBobSpriteBitmapLevel(a3)
		beq.s	.lower
		move.l	DBSPTR_UPPER_TRACK(a6),a0
		
.lower:		moveq	#0,d4
		move.w	VPOSR(a5),d4
		rol.w	#1,d4
		and.w	#1,d4
		
		move.l	hDbuffScreen1(a0,d4*4),a0
		move.l	hScreenPointers(a0),a0		; a0= Screen
; a0 = screen address, a1=Mask, a2=Bob 
		
; Does this sprite require clipping (chopper and big explosion)
		move.l	#$ffff0000,d4
		moveq	#0,d5				; modulo modifier
		moveq	#0,d6				; bltsize x modifier
		moveq	#0,d7				; bltsize y modifier
		tst.b	hBobSpriteCookie+1(a3)
		beq	.clip_done
	
		move.l	#-CLIP_SIZE_X,d3
		add.w	d0,d3				; Clipping required at all
		bpl	.xclip_left				; no.
; Clipping required here.

; if plus then we are either needing to clip or sprite is fully visible
;0-63 would mean clipping
		move.w	hBobSpriteXsize(a3),d2		; Number of words
		lsl.w	#4,d2				
		add.w	d2,d3
		bmi.s	.xclip_left
		
; Clipping required.

		move.w	hBobSpriteXsize(a3),d6
		move.w	d3,d6
		sub.w	d3,d2				; number of words to index
		move.w	d2,d6
		
		move.w	d2,d5
		not.w	d5
		and.w	#$f,d5
		moveq	#0,d4
		lea	.fwmaskbits(pc),a6
		move.w	(a6,d5*2),d4
		swap	d4
		
		lsr.w	#4,d6				; d6 has number of words to reduce by.		
		
		add.w	d6,a1
		add.w	d6,a1				; index into sprite
		add.w	d6,a2				; index into mask
		add.w	d6,a2
		
		subq.w	#2,a0


		moveq	#0,d0				; Set X Position to left of screen
		bra.s	.yclip


; DO right clipping		
.xclip_left:	sub.w	#CLIP_SIZE_X-1,d0
		cmp.w	#SCREEN_SIZE_X-1,d0		; Out of bounds then don't bother
		bge	.exit
		
		move.w	hBobSpriteXsize(a3),d2		; Sprite size
		lsl.w	#4,d2				
		add.w	d0,d2
			
		sub.w	#SCREEN_SIZE_X,d2
		bmi.s	.yclip
		
		move.w	d2,d5
		and.w	#$f,d5
		lea	.lwmaskbits(pc),a6
		move.w	(a6,d5*2),d4

		move.w	d2,d6
		
		moveq	#$0,d2
		moveq	#$0,d5		
		lsr.w	#4,d6				; Number to reduce by
		addq.w	#1,d6
		
		
; All clipping handler here
; Handle Y clipping here.

.yclip:
		move.l	#-CLIP_SIZE_Y,d3
		add.w	d1,d3			; -128 + (Y Position + Y Size)	
		bmi	.exit			; Still 0 or minus, then nothing to do.
		beq	.exit
		move.w	hBobSpriteYsize(a3),d2
		lsr.w	#8,d2		
		sub.w	d3,d2			
		bmi.s	.yclip_up
		
		lsl.w	#8,d2			; Adjust for blit size
		move.l	d2,d7			; d7 has bltsize reduce and index into sprite amount.
		
		add.l	d7,a1			; Index into bob
		add.l	d7,a2			; Index into mask

		cmp.w	hBobSpriteYsize(a3),d1
		bge.s	.yclip_up
		moveq	#0,d1			; Set Y position to top of the screen.
		bra.s	.clip_done
		
.yclip_up:	sub.w	#CLIP_SIZE_Y,d1		; In the middle of the screen here.
		
		move.w	hBobSpriteYsize(a3),d2
		lsr.w	#8,d2
		sub.w	d2,d1
	
; Now check lower bounds...
		move.l	#SCREEN_SIZE_Y,d2				;
		moveq	#0,d3
		move.w	hBobSpriteYsize(a3),d3
		lsr.w	#8,d3
		sub.w	d3,d2
		cmp.w	d2,d1
		ble.s	.clip_done
; Clipping required here.
		move.w	d1,d3
		sub.w	d2,d3
		lsl.w	#8,d3
		
		moveq	#0,d7
		cmp.w	hBobSpriteYsize(a3),d3		
		bge	.exit			
		move.w	d3,d7				; Adjust Y Blit Size
		
.clip_done:	cmp.w	#SCREEN_SIZE_Y,d1
		bge	.exit
		
		move.w	hBobSpriteYsize(a3),d2
		lsr.w	#8,d2
		add.w	d1,d2
		
		lsl.l	#8,d1				; d1 * 256 (512/8=64 * 4) screen lines
		moveq	#0,d2				; Shifter
		move.w	d0,d2
		lsr.w	#3,d0				; d0 x pos/8
		add.l	d0,d1
		
		move.l	d1,d0				; d1 & d6 has screen address offset	
		add.l	d1,a0				; Index into screen.

; Shift position from word boundary
		tst.w	d5
		beq.s	.no_clip_shift
		move.w	d5,d2

		
.no_clip_shift:	and.w	#$f,d2
		ror.w	#4,d2
		move.w	d2,d1
		swap	d2
		move.w	d1,d2				
		or.l	#$0fca0000,d2			; d2=BLTCON0 & BLTCON1

; Are we copying or cookie cutting?		
		tst.w	hBobSpriteCookie(a3)		; copy or cookie?
		bmi.s	.cookie	
		
; Need B shift channel on Copy.
		and.l	#$f0000000,d2
		or.l	#$09f00000,d2			; A->D
		exg.l	a2,a1				; Move Bob Addr into A Ptr
		
.cookie:	move.w	hBobSpriteXsize(a3),d3

		addq.w	#1,d3				; d3 has words wide		
		moveq	#64,d1 				; HARD CODED.
		sub.w	d3,d1				
		sub.w	d3,d1				; d1 has modulo (screen and sprites)
		
		add.w	d6,d1
		add.w	d6,d1

		or.w	hBobSpriteYsize(a3),d3		; d3 has bltsize
; Must adjust for clipping


; If bit 14 is set in the animation frame then it means
; the explosion cut needs to be done.
; We also have bites 13 and 12 available if need to do others.
; This is a performance and memory saver.

		btst.b	#14-8,hBobSpriteBobNumber(a3)	; test bit 6
		beq.s	.explosion_cut

; d7 is always 0 when nothing is clipped.
		tst.w	d7				; If the sprite is clipped at all
		bne	.exit				; then don't blit the smaller sprites (duh!).
; Index into smaller sprites.
		add.l	#(84<<8),a0			; Index into screen area				
		add.l	#(84<<8),d0			; Index into sprite
		and.w	#%0000000000111111,d3
		or.w	#32<<8,d3			; 32 pixels in depth

.explosion_cut:		
		sub.w	d6,d3				; x clipping
		sub.w	d7,d3				; y clipping

		move.l	hBobSpriteThisOffset(a3),hBobSpriteLastOffset(a3)
		move.w	hBobSpriteBlitSize(a3),hBobSpriteLastBlitSize(a3)
		move.w	hBobSpriteModSize(a3),hBobSpriteLastModSize(a3)
		
		move.w	hBobSpriteBitmapLevel0(a3),hBobSpriteBitmapLevel1(a3)
		move.w	hBobSpriteBitmapLevel(a3),hBobSpriteBitmapLevel0(a3)
		
		move.w	d3,hBobSpriteBlitSize(a3)
		move.w	d1,hBobSpriteModSize(a3)
		move.l	d0,hBobSpriteThisOffset(a3)
		
		cmp.w	#BLANK_SPRITE,hBobSpriteBobNumber(a3)
		beq.s	.blank
		;cmp.w	#16,hBobSpriteBobNumber(a3)
		;beq.s	.blank
		
		move.l	$dff004,d5			; Are we too far down the screen?
		and.l	#$1ff00,d5
		cmp.l	#240<<8,d5
		bgt	.exit
	
.blank:		moveq	#0,d5
		move.b	d3,d5
		and.b	#%111111,d5
		lsr.w	#6,d3				; Blitter adjust
		IFEQ	ENABLE_INTER_BLITS
		lsr.w	#2,d3				; Divide by 4
		ENDC
		lsl.w	#6,d3
		or.w	d5,d3
		
		move.w	d1,d5				; d1=mask mod
		IFEQ	ENABLE_INTER_BLITS		
		add.w	#$40*3,d5			; d3=bob,screen mod
		ENDC
		WAIT_FOR_BLITTER
		
		moveq	#0,d6
		moveq	#$40,d7
		
		btst	#9+16,d2			; Cookie or Copy mode?
		bne.s	.cook
		move.w	d5,d1
		moveq	#$40,d6 
		
.cook:		move.l	d2,BLTCON0(a5)
		move.l	d4,BLTAFWM(a5)
		move.w	d5,BLTCMOD(a5)			; Source modulo for screen (+$40 *3)
		move.w	d5,BLTDMOD(a5)			; Source modulo for screen (+$40 *3)
		
		IFEQ	ENABLE_INTER_BLITS
		move.w	d5,BLTBMOD(a5)			; Source modulo for bob - Adjust (+$40 *3)
		ELSE
		move.w	d1,BLTBMOD(a5)			; Source modulo for bob - Adjust (+$40 *3)		
		ENDC
		
		move.w	d1,BLTAMOD(a5)			; Source modulo for mask - Adjust
		
		IFEQ	ENABLE_INTER_BLITS
		rept	4
		ENDC
		WAIT_FOR_BLITTER
		move.l	a1,BLTAPTH(a5)			; Mask
		move.l	a2,BLTBPTH(a5)			; Bob
		move.l	a0,BLTCPTH(a5)			; Screen
		move.l	a0,BLTDPTH(a5)			; Screen
		move.w	d3,BLTSIZE(a5)
		
		IFEQ	ENABLE_INTER_BLITS
		add.l	d6,a1				; Next for Copy Bob
		add.l	d7,a0
		add.l	d7,a2
		endr
		ENDC
.exit:		rts		
	
	
; a0=Screen Struct
; d0=Animation#
agdRestoreGameSprites:
		moveq	#maxBobSpriteStructs-1,d7
		lea	RESOURCE_BOBSPRITES(a6),a3
.find:		tst.w	hBobSpriteNumber(a3)
		bmi.s	.skip
		bsr	.restore
.skip:		add.l	#sizeStructBobSprite,a3
		dbf	d7,.find
		bra	.exit
		
.restore:	tst.w	hBobSpriteLastModSize(a3)
		bmi	.exit
		
		tst.w	hBobSpriteCookie(a3)		; copy or cookie?
		beq	.exit				; Copy - don't restore copy sprites.

		cmp.w	#BLANK_SPRITE,hBobSpriteBobNumber(a3)	; Don't restore blank sprites
		beq.s	.exit

.1		movem.l	a0-a1,-(a7)
		
		move.l	DBSPTR_LOWER_TRACK(a6),a0
		move.l	BMPPTR_LOWER_TRACK(a6),a1
		cmp.w	#LEVEL_LOWER_TRACK,hBobSpriteBitmapLevel1(a3)
		beq.s	.lower
		move.l	DBSPTR_UPPER_TRACK(a6),a0
		move.l	BMPPTR_UPPER_TRACK(a6),a1
		
.lower:		moveq	#0,d4
		move.w	VPOSR(a5),d4
		rol.w	#1,d4
		and.w	#1,d4
		
		move.l	hDbuffScreen1(a0,d4*4),a0
		
		move.l	hScreenPointers(a0),a0		; a0=Get screen address
		move.l	hBobSpriteLastOffset(a3),d6
		add.l	d6,a0
		
		move.l	hBitmapBody(a1),a1
		addq.w	#8,a1
		add.l	d6,a1
		
		WAIT_FOR_BLITTER
		move.l	#$09f00000,BLTCON0(a5)
		move.l	#$ffffffff,BLTAFWM(a5)
		move.w	hBobSpriteLastModSize(a3),BLTAMOD(a5)
		move.w	hBobSpriteLastModSize(a3),BLTDMOD(a5)
		move.l	a1,BLTAPTH(a5)
		move.l	a0,BLTDPTH(a5)
		move.w	hBobSpriteLastBlitSize(a3),BLTSIZE(a5)
		movem.l	(a7)+,a0-a1
.exit:		rts



hdlDummy:
		rts
			
