
hdlMud:
.event:		
		move.l	hBobSpriteCarNumber(a3),d1
		GET_CAR_CONTEXT
		
		tst.w	hBobSpriteState(a3)		
		bmi	.construct
		beq	.frame
		bra	.destruct

; Construct variables 
.construct:	clr.w	hBobSpriteState(a3)
		move.w	hBobSpriteXpos(a3),d1
		move.w	hBobSpriteYpos(a3),d2
		lsr.w	#3,d1
		lsr.w	#3,d2
		
	IFNE 	ENABLE_SPRITE_TRACKING
		moveq	#0,d4
		moveq	#0,d5
	
		move.w	d1,d4
		move.w	d2,d5
		addq.w	#1,d5				; 64
		bsr	ssDbgPlotLowerBlock
		
		move.w	d1,d4
		move.w	d2,d5		
		addq.w	#1,d4
		addq.w	#1,d5				; 65
		bsr	ssDbgPlotLowerBlock
	ENDC
		
		lsl.w	#6,d2
		
		move.l	MEMPTR_COLLISION_RAM(a6),a0
		move.l	hAddress(a0),a0
		add.w	d1,a0
		add.w	d2,a0
		move.l	a0,hBobSpriteTerrainPtr(a3)
			
		bra	.frame

; If state = 1 then run destruct.
.destruct:	bra	.exit

.frame:		moveq	#maxCars-1,d1
.loop:
		move.l	hBobSpriteTerrainPtr(a3),a0		; Water pointer
		GET_CAR_CONTEXT
		
		tst.w	carSpinTimer(a4)
		bmi.s	.check
	
		move.w	#-1,carPriOveride(a4)
		subq.w	#4,carSpinTimer(a4)			; Decrement timer
		cmp.l	#$100,carCurrentThrottle(a4)
		bgt.s	.next
		move.l	#$100,carCurrentThrottle(a4)
		bra.s	.next
		
.check:		move.b	64(a0),d0
		btst	d1,d0			
		bne.s	.spin
		
		move.b	65(a0),d0
		btst	d1,d0			
		bne.s	.spin
		
.next:		dbf	d1,.loop
		bra	.exit
		
.spin:		move.w	#(60*4),carSpinTimer(a4)		; spin for 2 seconds as collision here.
		move.l	carCurrentThrottle(a4),d2
		lsr.l	#4,d2
		move.l	d2,carCurrentThrottle(a4)
		moveq	#sampleSpin,d0
		bsr	agdPlayIngameSample
.exit:		rts
