; "Game of Life" in 32 bytes
; by HellMood/DESiRE, April 2020
;
; rest in peace Mr. Conway 
;
; my attempt to do game of life in 32 bytes
; i feel it can be shorter/better
; but my goal is achieved =)
;
; tested on DosBox, WinXP Dos, MsDos, FreeDos
;
; https://youtu.be/EgqiLf19og4
;
; http://read.pudn.com/downloads208/sourcecode/asm/981812/LIFE65.ASM__.htm
; Life simulator, 72 bytes  - Vladislav Kaipetsky and Tenie Remmel 
;                 65 bytes  - Mark Andreas 
;                 32 bytes  - HellMood
;
; O: original comments from Kaipetsky & Remmel
; (kept, even if instructions have changed)
;
; detailed write up will follow
; on http://www.sizecoding.org/wiki/Case_Studies
;
lds sp,[si]
X: db 32
mov bl,7                    ; O: 3 iterations
or [si],al                  ; O: Add in new cell
cmpsw
shr byte [di],5             ; O: Shift previous value 
C: xchg cx,ax
add al,[di+bx+94]           ; O: Add in this column
add al,[si+bx-4]
add al,[si+bx+156]
dec bx                      ; O: Loop back
jnz C
mov al,[si]                 ; O: 3 = birth, 4 = stay (tricky): 
stc                         ; O: 1.00?0000x --> 0.0x100?00 (rcr 3) 
rcr al,cl                   ; O:          +---> 0.00x100?0 (rcr 4) 
jmp short X-1
