INCLUDE "COUNTER.INC"

RESX EQU 320
RESY EQU 200

ORG 256
;---------------------------------------------------------------------
 MOV ES,DX
;---------------------------------------------------------------------
;MOV    BP,320          ; RESX
main:
 MOV    BH,64000/256
 SUB    DI,DI
 CALL ESCAPE
 SHR AX,1
 ADD AX,128+64
 XCHG CX,AX
nextpixel:
 DEC    BX
;---------------------------------------------------------------------
wheels:
 MOV    AX,DI
 CWD
 DIV    BP
 SUB    AX,RESY/2
 SUB    DX,RESX/2
 MOV    [SI+BP],AX
 FILD   WORD [SI+BP]
 MOV    [SI+BP],DX
 FILD   WORD [SI+BP]
 FLD    ST1
 FMUL   ST0,ST0
 FLD    ST1
 FMUL   ST0,ST0
 FADDP
 FSQRT
 FISTP  WORD [SI+BP]
 FPATAN
 MOV    AL,[SI+BP]
 FIMUL  WORD [SI-256+BP-320+MULP]
 FISTP  WORD [SI+BP]

 SHR    AL,3
 ADD    AL,4
 MOV    AH,16
 TEST   CH,1
 JZ     @F
 OR     AH,CL           ; transition to fullscreen
@@:
 CMP    AL,AH
 JNC    plot
 MUL    CL
 ADD    AL,[SI+BP]
 SHL    AL,1
 SALC
 AND    AL,32
 SUB    AL,-91          ; two colors: 91, 123
;---------------------------------------------------------------------
plot:
 STOSB
 JNC    @F
 XOR    AL,32           ; swap colors (on wheels only)
@@:
 MOV    [ES:BX],AL      ; mirroring for speedup
 CMP    DI,BX           ; check halfscreen
 JC     nextpixel
;---------------------------------------------------------------------
 JMP main
MULP DW -41
;---------------------------------------------------------------------
