// YM player for the NGPC
//
// /Mic, 2013

#include "ngpc.h"
#include "carthdr.h"
#include "library.h"
#include <stdlib.h>
#include <stdio.h>
#include "ym_emu.h"


typedef volatile u8 vu8;
typedef volatile u16 vu16;


#define Z80_OFF_SOUND_OFF() SOUNDCPU_CTRL = 0xAAAA

#define memcpy(dst, src, len) BlockCopy(dst, src, len)

// Calculate the timer0 count-up threshold based on a T1 prescaler
// and a 16000 Hz sample rate
#define SAMPLE_TIMEOUT (48000/16000)


void __interrupt vblint_handler(void);
void __interrupt udma0int_handler(void);

extern void SysShutdown();

extern const unsigned char FONT_CHR_DATA[];
extern const unsigned char BG_CHR_DATA[];
extern const unsigned char BG_NAM_DATA[];

const unsigned char YM_DATA[384*1024] = {0};


u8 pcmBuffer[0x1000];	// Assumed to start at address 0x4000 !

u8 *pReadPos;


static char *put_string(const char *text, u8 pal, u8 column, u8 row)
{
	u8 *dest;
	char c;

	pal <<= 1;
	dest = (u8*)0x9000;
	dest += ((u16)row << 6) + column + column;
	while (*text) {
		c = *text++;
		if (column < 18) {
			if (c > 91) c -= 0x20;
			c += 52-32;
			*dest++ = c;
			*dest++ = pal;
			column++;
		}
	}

	return (char*)text;
}


void main(void) {
	u16 i;
	char *src,*dest;

    InitNGPC();
    SysSetSystemFont();

	Z80_OFF_SOUND_OFF();

	DMA0_INT		= udma0int_handler;
	VBL_INT			= vblint_handler;

	ClearScreen(SCR_1_PLANE);
	ClearScreen(SCR_2_PLANE);

   	SetColors(SCR_1_PLANE, 0, RGB(0,2,7), RGB(3,4,10), RGB(10,11,15));
   	SetColors(SCR_1_PLANE, 1, RGB(12,11,2), RGB(6,4,0), RGB(14,14,13));
   	SetColors(SCR_1_PLANE, 2, RGB(9,9,10), RGB(4,4,5), RGB(13,13,14));
   	BG_PAL = RGB(0,1,1);
   	BG_COL = 0x80;

	CpuSpeed(0);

	ym_emu_init(YM_DATA, pcmBuffer);

	// Fill up 6/50s (0.12s) of the buffer (== 3840 bytes @ 16 kHz dual-mono)
	pfn_ym_emu_run();
	pfn_ym_emu_run();
	pfn_ym_emu_run();
	pfn_ym_emu_run();
	pfn_ym_emu_run();
	pfn_ym_emu_run();

	memcpy(TILE_RAM, BG_CHR_DATA, 832);
	dest = (char*)TILE_RAM;
	dest += 832;
	memcpy(dest, FONT_CHR_DATA, 1280);

	// Show background graphic
	dest = (char*)SCROLL_PLANE_1;
	src = (char*)BG_NAM_DATA;
	for (i = 0; i < 18; i++) {
		memcpy(dest, src, 40);
		dest += 64;
		src += 40;
	}

	put_string("NOW PLAYING:", 2, 2, 7);
	src = (char*)&YM_DATA[0x22];
	src = put_string(src, 1, 2, 9);
	src++;
	src = put_string(src, 1, 2, 10);


	TRUN	= 0;					// Disable timers
	INTETC01= 6;					// Set prio 6 for the uDMA completion interrupt

	T01MOD 	= TIMER0_SRC_T1 | TIMER01_8BIT;
	TREG0	= SAMPLE_TIMEOUT;
	INTET01	= 0;					// Disable interrupts for timer0; we just want
									// it to trigger uDMA
	TFFCR	= 0;					// Flip-flop (we don't use this)
	TRDC	= 0;					// Double buffering (we don't use this)

	__asm(" DAC_L   equ 0xA2");
	__asm(" DAC_R   equ 0xA3");
	__asm(" WORD_SRC_INC equ 0x09");

	// Set the source, destination, mode and transfer count for uDMA channel 0
	// The uDMA channel is set up to transfer 2 bytes each time it's triggered,
	__asm(" lda xwa, 0x4000");
	__asm(" ldc DMAS0,xwa");
	__asm(" ldl xwa,  DAC_L");
	__asm(" ldc DMAD0,xwa");
	__asm(" ldb w,    WORD_SRC_INC");
	__asm(" ldc DMAM0,w");
	__asm(" ldw wa,   0x800");
	__asm(" ldc DMAC0,wa");

	DMA0V	= DMAV_TIMER0;			// Set the uDMA vector for channel 0 to timer0

	// Start timer0
	TRUN	= TIMER0_ON | PRESCALER_ON;

	while (1) {
		// Prevent buffer overruns by waiting here if we're about to write at the
		// slice of the buffer which is currently being read from by the microDMA
		// channel. Waiting until about half of the data in that slice has been
		// consumed before we start writing more data should be sufficient.
		pReadPos = ym_emu_buffer_ptr();
		while ((u16)((pReadPos - ym_emu_buffer_ptr()) & 0xFFF) < 140) {
			__asm(" ldc xwa, DMAS0");
			__asm(" nop");
			__asm(" ldl (_pReadPos), xwa");
			__asm(" nop");
		}


		pfn_ym_emu_run();
	}
}



void __interrupt udma0int_handler(void) {
	__asm(" push xwa");
	__asm(" lda xwa,  0x4000");
	__asm(" ldc DMAS0, xwa");
	__asm(" ldw wa,    0x800");
	__asm(" ldc DMAC0, wa");
	DMA0V	= DMAV_TIMER0;
	__asm(" pop xwa");
}


void __interrupt vblint_handler(void) {
	__asm(" ldb	(0x6f),0x4e");
	__asm(" cpb	(0x6f85),0x0");
	__asm("	j	eq,vblint_done");
	__asm(" cal	_SysShutdown");
	__asm(" vblint_done:");
}

