//--------------------------------------------------------------------------//
// iq . 2007 . kindernoiser 4k intro demo by RGBA                           //
//--------------------------------------------------------------------------//

#define WIN32_LEAN_AND_MEAN
#define WIN32_EXTRA_LEAN
#include <windows.h>
#include <mmsystem.h>
#include "../../intro.h"
#include "../../mzk.h"
#include "../../main.h"
#include "../../fft.h"
//----------------------------------------------------------------------------

/*static*/ short myMuzik[(MZK_DURATION+4)*MZK_RATE*MZK_NUMCHANNELS];
/*static*/ float rout[4096];

//----------------------------------------------------------------------------
extern "C" int  _fltused = 0;

/*static*/ const PIXELFORMATDESCRIPTOR pfd = {
    sizeof(PIXELFORMATDESCRIPTOR), 1, PFD_DRAW_TO_WINDOW|PFD_SUPPORT_OPENGL|PFD_DOUBLEBUFFER,
    PFD_TYPE_RGBA, 32, 0, 0, 0, 0, 0, 0,  0,  0, 0, 0, 0, 0, 0, 32, 0, 0, PFD_MAIN_PLANE, 0, 0, 0, 0 };

/*static*/ DEVMODE screenSettings = { 
    #if _MSC_VER < 1400
    {0},0,0,148,0,0x001c0000,{0},0,0,0,0,0,0,0,0,0,{0},0,32,XRES,YRES,0,0,      // Visual C++ 6.0
    #else
    {0},0,0,156,0,0x001c0000,{0},0,0,0,0,0,{0},0,32,XRES,YRES,{0}, 0,           // Visual Studio 2005
    #endif
    #if(WINVER >= 0x0400)
    0,0,0,0,0,0,
    #if (WINVER >= 0x0500) || (_WIN32_WINNT >= 0x0400)
    0,0
    #endif
    #endif
    };

/*static*/ WAVEFORMATEX wavinfo = {
    WAVE_FORMAT_PCM,				// format type
    MZK_NUMCHANNELS,				// number of channels
    MZK_RATE,						// sample rate 
    MZK_RATE*2*MZK_NUMCHANNELS,	    // for buffer estimation = rate*"block size of data"
    2*MZK_NUMCHANNELS,				// block size of data = 4 bytes = 2*16bit
    16,								// number of bits per sample of mono data
    0 };

/*static*/ WAVEHDR  wav = { (LPSTR)myMuzik, MZK_DURATION*MZK_RATE*MZK_NUMCHANNELS*sizeof(short), 0, 0, 0, 0, 0, 0 };

//----------------------------------------------------------------------------

void entrypoint( void )
{
    // set screen resolution
    if( ChangeDisplaySettings(&screenSettings,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL) return; 
	ShowCursor(0);

    // create window
    HDC hDC = GetDC(CreateWindow( "static",0,WS_POPUP|WS_VISIBLE,0,0,XRES,YRES,0,0,0,0));
    SetPixelFormat(hDC,ChoosePixelFormat(hDC,&pfd),&pfd);
    wglMakeCurrent(hDC,wglCreateContext(hDC));
    // init intro
    if( !intro_init() ) goto endend;
    // render music
    mzk_init( myMuzik );
    // init sound
    HWAVEOUT    h;
    if( waveOutOpen( &h, WAVE_MAPPER, &wavinfo, 0, 0, 0) )  goto endend;
    waveOutPrepareHeader( h, &wav, sizeof(WAVEHDR) );
    waveOutWrite( h, &wav, sizeof(WAVEHDR) );
    // main loop
    int frame = 0;
	while( !GetAsyncKeyState(VK_ESCAPE) )
    {
        // get time
		MMTIME  mmt;
		mmt.wType = TIME_MS;
		waveOutGetPosition( h, &mmt, sizeof(MMTIME) );
        const unsigned long pos = mmt.u.cb/(sizeof(short)*MZK_NUMCHANNELS);
        const float time = (float)pos/(float)MZK_RATE;
        // stop intro
        if( pos>=(MZK_DURATION*MZK_RATE) )
            break;
        // do fft
        iqsft12( rout, myMuzik+MZK_NUMCHANNELS*pos+2048 );
        // intro
        intro_do( rout, time, frame++ );
        // dump to screen
        wglSwapLayerBuffers( hDC, WGL_SWAP_MAIN_PLANE );    //SwapBuffers( hDC );
    }
    // close sound
    waveOutClose( h );
endend:
    // reset screen resolution
    ChangeDisplaySettings( 0, 0 );
    ShowCursor(1);
    // exit
    ExitProcess(0);
}
