;
; ZX81DEF.INC
; include file with definitions and symbols used by Sinclair ZX81
; for FASMZ80 (flatassembler with Z80 instruction set)
;
; V1.1
;

; this definitions should not be changed

	NO	EQU	0
	YES	EQU	1
	NEWLINE EQU	$76	; character for NEWLINE
	SPACE	EQU	0	; character for SPACE

	MEM_1K	=1024
	MEM_2K	=2048
	MEM_4K	=4096
	MEM_8K	=8192
	MEM_16K =16384
	MEM_32K =32768
	MEM_48K =49152

	MEMST	EQU	16384	; begin of memory section of ZX81 (system variables)

; description of flag variable in ZX81
;       BIT 0   leading space in line, 0=permitted / 1=suppress
;       BIT 1   printer in use, 0=no / 1=yes
;       BIT 2   cursor mode, 0=K cursor / 1=L cursor
;       BIT 3
;       BIT 4
;       BIT 5
;       BIT 6   result type, 0=string / 1=numeric
;       BIT 7   syntax check, 0=check syntax only / 1=executing
;
	FLAG_SUPS EQU $01	; suppress space
	FLAG_PRIU EQU $02	; printer using
	FLAG_CURL EQU $04	; cursor L type
	FLAG_NUM  EQU $40	; numeric expression
	FLAG_EXEC EQU $80	; execution

; description of cursor type variable (MODE) in ZX81
;
	CURSOR_KL EQU $00
	CURSOR_F  EQU $01
	CURSOR_G  EQU $02

; margin value for ZX81 (55 for PAL, 50Hz / 31 for NTSC, 60Hz)
;
	PAL  EQU 55
	NTSC EQU 31

; compute and display flag in ZX81
;
;       BIT 0   keystroke, 0=NO / 1=YES
;       BIT 6   fast/slow mode, 0=fast mode / 1=slow mode
;       BIT 7   internal mode using now, 0=fast mode / 1=slow mode

	KEYSTROKE EQU $01
	SLOW_MODE EQU $40
	FAST_MODE EQU $00

; this definitions can be changed regarding hardware used
; change this definitions in source file before including ZX81VARS.INC
; (because changes affects contents of system variables)

; default value for FLAG variable
	DEFFLAG EQU	FLAG_EXEC OR FLAG_NUM



//
// 	ZX81 ROM Routines
//

	ZX81ROM_BASERR	EQU	$0008	// parameters:	byte error_code-1 follows call
					//		$FF = no error
					// destroyed:	return to BASIC context
					// remarks:	short form RST $08

	ZX81ROM_PRTCHAR	EQU	$0010	// parameters:	A=<char to print>
					// destroyed:	AF,BC,DE,HL
					// remarks:	short form RST $10

	ZX81ROM_CLS	EQU	$0A2A   // parameters:	no
					// destroyed:	AF,BC,DE,HL

	ZX81ROM_PRINTAT	EQU	$08F5  	// parameters:	B=<row>,C=<column> start with 0
					// destroyed:	AF,BC,DE,HL

	ZX81ROM_GETRT	EQU	$0AC5	// get runtime address
					// returned:	HL=address of calling function
