format zx81

        MEMAVL     =       MEM_1K
        STARTMODE  EQU     SLOW_MODE       // SLOW or FAST
;_LISTOFF
        include './ZX81.INC'     // definitions of constants
;_LISTON
        AUTOLINE 1

        REM _asm
;-------------------------------------
SCREEN_WIDTH    EQU     33
SCREEN_HEIGHT   EQU     8

FrameCounter    db      0
RotChar         db      0, 0, 0, 0, 0, 0, 0, 0
RowCounter      db      0
ColumnData      db      0
BorderTop       db      255 - 8 - 154
BorderBottom    db      255 - 8 - 0
ScrollPtr       dw      ScrollText
ScrollText      dbzx    'NOLLKOLLTROLL PRESENTS A DEMO FOR THE UNEXPANDED ZX81. '
                dbzx    'WITH 1K RAM THERE IS NOT MUCH ROOM FOR FANCY DESIGN, '
                dbzx    'BUT ENOUGH TO SHOW OFF SOME TECH EFFECTS.'
                db      NEWLINE
BlinderAdd      db      1

Screen          db      1                                       ;RowHeight
                dbzx    '                                '      ;characters
                db      NEWLINE                                 ;EndOfLine
                db      1
                dbzx    '                                '
                db      NEWLINE
                db      1
                dbzx    '                                '
                db      NEWLINE
                db      1
                dbzx    '                                '
                db      NEWLINE
                db      1
                dbzx    '                                '
                db      NEWLINE
                db      1
                dbzx    '                                '
                db      NEWLINE
                db      1
                dbzx    '                                '
                db      NEWLINE
                db      1
                dbzx    '                                '
                db      NEWLINE

ScrollerBounce  db      0, 7, 15, 22, 30, 37, 44, 51
                db      58, 65, 72, 79, 85, 91, 97, 103
                db      108, 114, 119, 123, 128, 132, 135, 139
                db      142, 144, 147, 149, 151, 152, 153, 153
                db      154, 153, 153, 152, 151, 149, 147, 144
                db      142, 139, 135, 132, 128, 123, 119, 114
                db      108, 103, 97, 91, 85, 79, 72, 65
                db      58, 51, 44, 37, 30, 22, 15, 7

;-------------------------------------
MAIN:
        call    START_VIDEO
MAIN_LOOP:
        ld      hl,FrameCounter
        ld      a,(hl)
WAIT_FRAME:
        cp      (hl)
        jr      z,WAIT_FRAME            ;wait for a new frame before continuing

BORDER_UPDATE:
;SineValue = ScrollerBounce[BorderCounter]
        ld      bc,0
BorderCounter = $ - 2
        ld      hl,ScrollerBounce
        add     hl,bc
        ld      a,(hl)
        push    af
;BorderBottom = 255 - 8 - SineValue
        neg
        add     a,255 - 8
        ld      (BorderBottom),a
;BorderTop = 255 - 8 - (154 - SineValue)
        pop     af
        neg
        add     a,154
        neg
        add     a,255 - 8
        ld      (BorderTop),a
;BorderCounter = (BorderCounter + 1) and 63
        ld      a,(BorderCounter)
        inc     a
        and     63
        ld      (BorderCounter),a
BORDER_DONE:

SCROLL_SCREEN:
        ld      de,Screen + 1
        ld      hl,Screen + 2
        ld      b,8
SCROLL_LOOP:
        push    bc
        ld      bc,31
        ldir
        inc     de
        inc     de
        inc     de
        inc     hl
        inc     hl
        inc     hl
        pop     bc
        djnz    SCROLL_LOOP

BLINDER_EFFECT:
        ld      a,(BlinderAdd)
        cp      1
        jp      nz,NEG_ADDER
        ld      hl,Screen
        ld      a,(hl)
        inc     a
        cp      16
        jp      nz,SET_FIRST_HEIGHT
        ld      a,-1
        ld      (BlinderAdd),a
        ld      a,14
        jp      SET_FIRST_HEIGHT
NEG_ADDER:
        ld      hl,Screen
        ld      a,(hl)
        dec     a
        cp      0
        jp      nz,SET_FIRST_HEIGHT
        ld      a,1
        ld      (BlinderAdd),a
        ld      a,2
SET_FIRST_HEIGHT:
        ld      (hl),a

ROTATE_HEIGHT:
        ld      hl,Screen + 6 * 34
        ld      de,34
        ld      b,7
ROTATE_HEIGHT_LOOP:
        ld      a,(hl)
        ld      de,34
        add     hl,de
        ld      (hl),a
        ld      de,-34*2
        add     hl,de
        djnz    ROTATE_HEIGHT_LOOP


PRINT_CHAR:
        ld      bc,0
CharacterColumn = $ - 2
        ld      hl,RotChar
        add     hl,bc
        ld      a,8
        ld      (RowCounter),a
        ld      a,(hl)
        ld      (ColumnData),a
        ld      hl,Screen + 1 + 31
        ld      bc,34
PRINT_LOOP:
        ld      a,(ColumnData)
        rra
        ld      (ColumnData),a
        jp      c,PRINT_BLACK
PRINT_WHITE:
        ld      (hl),$00
        jp      PRINT_TEST_COUNTER
PRINT_BLACK:
        ld      (hl),$80
PRINT_TEST_COUNTER:
        add     hl,bc
        ld      a,(RowCounter)
        dec     a
        ld      (RowCounter),a
        jp      nz,PRINT_LOOP

        ld      a,(CharacterColumn)
        inc     a
        and     7
        ld      (CharacterColumn),a
        cp      0
        jp      nz,MAIN_LOOP
ROTATE_CHAR:
        ld      hl,(ScrollPtr)
        ld      c,(hl)
        ld      b,0
        sla     c
        sla     c
        sla     c
        rl      b
        ld      hl,$1e00
        add     hl,bc
        push    hl
        pop     de
        ld      hl,RotChar
        call    ROTATE_TILE

        ld      hl,ScrollPtr
        inc     (hl)
        ld      hl,(ScrollPtr)
        ld      a,(hl)
        cp      NEWLINE
        jp      nz,MAIN_LOOP
        ld      hl,ScrollText
        ld      (ScrollPtr),hl

        jp      MAIN_LOOP

;-------------------------------------
START_VIDEO:
        ld      hl,Screen
        ld      (D_FILE),hl
        ld      ix,VIDEO_ROUTINE
        ret

;-------------------------------------
VIDEO_ROUTINE:
        ld      b,4                     ;dummy timing
        djnz    $                       ;dummy timing
        nop                             ;dummy timing

        ld      hl,Screen
        ld      b,8                     ;nr of rows to draw
ROW_LOOP:
        push    bc                      ;RowCounter

        ld      b,1                     ;nr of character rows, always 1
        res     7,h
        ld      c,(hl)                  ;nr of rasters for this row
        push    bc                      ;NrOfRasters
        inc     hl                      ;point to row-data
        set     7,h
        ld      a,255 - 34              ;34 characters per line
        call    $0041                   ;generate video

        ld      b,4                     ;dummy timing
        djnz    $                       ;dummy timing
        ld      a,r                     ;dummy timing
        inc     ix                      ;dummy timing

        ld      a,15
        pop     bc
        sub     c
        jp      z,CHECK_ROW_COUNTER
EXTRA_LINES:
        ld      b,13
        djnz    $
dec (hl)
inc (hl)
        dec     a
        jp      nz,EXTRA_LINES

CHECK_ROW_COUNTER:
        pop     bc                      ;RowCounter
        djnz    ROW_LOOP

FRAME_COUNTER:
        ld      hl,FrameCounter
        inc     (hl)

        call    RETURN_TO_BASIC
        call    SYNC                    ;FRAMES, KEYBOARD, VERTICAL SYNC
        ld      a,(BorderTop)           ;NUMBER OF TOP BLANK RASTERS
        ex      af,af'                  ;SAVE FOR NMI
        ld      ix,VIDEO_ROUTINE        ;RESTORE JUMP VECTOR
        jp      $02a4                   ;EXIT TO BASIC UNTIL NEXT VDR

RETURN_TO_BASIC:
        ld      a,(BorderBottom)        ;BLANK RASTERS
        ex      af,af'                  ;SAVE IN AF FOR NMI
        pop     ix                      ;SAVE RETURN ADDRESS IN REG IX
        jp      $02a2                   ;START NMI AND RETURN TO BASIC

SYNC:
        push    af                      ;DUMMY REGISTER PUSH TO FORCE
        push    bc                      ;RETURN TO VIDEO_ROUTINE (NOT BASIC)
        push    de
        push    hl
        jp      $0229                   ;FRAMES, KEYBOARD AND VSYNC

;-------------------------------------
;DE = 8x8 bytes input tile
;HL = 8x8 bytes output tile, rotated 90 degrees
ROTATE_TILE:
        ld      c,8
ROTATE_OUTER:
        ld      a,(de)
        inc     de
        push    hl
        ld      b,8
ROTATE_INNER:
        rla
        rr      (hl)
        inc     hl
        djnz    ROTATE_INNER
        pop     hl
        dec     c
        jr      nz,ROTATE_OUTER
        ret

;-------------------------------------
        END   _asm
AUTORUN:
        RAND USR #MAIN

VARS_ADDR:
        db 80h                  ;DO NOT REMOVE!!!

WORKSPACE:

assert ($-MEMST)<MEMAVL
// end of program


