;--- ASSEMBLE WITH :-   TASM -80 -B multiscroll3.asm MS.P
;                       -----------------------------------
;
; zx81 buffered display routine
;
; the objective of this file is to allow an
; arbitary sized [MAYBE] ( min 32cols by 24rows ) display buffer
; to be displayed on the zx81, by specifying only the 
; start byte, the routine should then display a
; 32 column by 24 row, rectangle from that buffer
;
; SirMorris & Andy Rea
;


#INCLUDE ZX81HDR.ASM
#INCLUDE ZXCHARS.ASM

; some rom routine addresses
#DEFINE ROM_SLOW	$0F2B

; some constants
#DEFINE WINDOW_HEIGHT 24
#DEFINE WINDOW_WIDTH 32
#DEFINE BUFFER_HEIGHT 24
#DEFINE BUFFER_WIDTH 256


		

; my code starts here

INITIALISE:

; here we initialise the necessary things
; before altering the value of the IX register
;
; by altering the value of IX we jump to our
; own routines when an NMI_CONT occurs after 
; the top or bottom margins have been generated
;


	; set slow mode else following detect loops forever
	LD	HL,STC
	CALL	INITALISE_STC
	CALL ROM_SLOW
	

IX_DETECT:
	
	; loop round until display has been generated
	LD	A,IXL
	CP	$8F
	JP	NZ,IX_DETECT
	
	; IX registers points to our own vsync routine
	LD	IX,NMI_VSYNC
	JP	GO_LOOPY
	;RET
	

NMI_VSYNC:

; here we do the normal Vsync / read the keyboard routine
; most likely the rom routine will suffice
	LD	HL,VSYNC_RET
	;push some extra stuff on the stack (it's popped by the rom routine)
	;but return below
	PUSH	HL
	PUSH	HL
	PUSH	HL
	PUSH	HL
	CALL $028F
	
VSYNC_RET:
		; nmi's have just started to generate the 
		; top margin
		; now we check if the origin has changed
		; and modify the buffers as necessary
	
	LD	IX,NMI_VIDEO
	
	; return to users code
	ld	c,55
	JP	$029D
	

NMI_VIDEO:

; here we will generate the display
; 192 scanlines to go, NMI's and INT's are disabled
;



	;LD	B,7
	nop
	INC BC
	LD	BC,$04FE
SYNC_DELAY:
	DJNZ	SYNC_DELAY
	LD	(SP_STORE),SP
	LD	SP,VIDEO_STACK_BOTTOM
	CP	A			; set zero flag
	POP	HL
; lets do some video
; each scan lines worth of video ends with a 
; RET Z (11 cycles when took) leaving a nice round 
; 196 cycles in that scan line
;
; Erm some lines end in RET 10 cycles....
; for timing reasons
;
; each scanline takes exactly 207 cycles, the RET or RET Z
;
; jumps to the start of the next scan line.
;
; and when all scanlines are complete
; the final RET jumpos to VIDEO_COMPLETE
;
; the original SP is restored and user program 
; execution continues


	JP	(HL)
	
VIDEO_COMPLETE:
	LD	A,$FF
	LD	(VIDEO_FINISHED),A
SP_STORE: EQU $+1
	LD	SP,$0000
	

	LD	IX,NMI_VSYNC
;	JP	$0294
	 ;  LD      C,($4000+$28)      ; load C with value of system constant MARGIN.
       ; BIT     7,($4000+$3B)      ; test CDFLAG for compute and display.
       ; JR      Z,L02A9         ; forward, with FAST mode, to DISPLAY-4

        LD      A,55            ; move MARGIN to A  - 31d or 55d.
        NEG                     ; Negate
        INC     A               ;
        EX      AF,AF'          ; place negative count of blank lines in A'

        OUT     ($FE),A         ; enable the NMI generator.

        POP     HL              ; ****
        POP     DE              ; ***
        POP     BC              ; **
        POP     AF              ; *             Restore Main Registers

        RET          	
	
#INCLUDE STPLAYMS.ASM

	
GO_LOOPY:
	LD	A,(VIDEO_FINISHED)
	INC	A
	JP	NZ,GO_LOOPY
	LD	(VIDEO_FINISHED),A
	PUSH	IY
	CALL	PLAY_SOUND
	POP	IY
	CALL	TOP_SCROLLER
	
	
S2ADD
	DB	0,0,0
;	CALL NEXT_SCROLL
Q1ADD
	DB	0,0,0
;	CALL Q_SCROLLER
Q2ADD
	DB	0,0,0
;	CALL	Q2_SCROLLER

	
	LD	A,(LOGO_POS)
INC_LOGO: EQU $+1
	ADD	A,1
	LD	(LOGO_POS),A
	JP	Z,LOGO_REVERSE_DIR
	CP	140
MOVE_LOGO:
	JP	C, MAKE
;	JP	NC,LOGO_REVERSE_DIR
	
	
	
LOGO_REVERSE_DIR:
	LD	A,(INC_LOGO - 1)
	XOR	$10
	LD	(INC_LOGO - 1),A
	
; 	DEC	A
; 	JP	NZ,SET_ONE
; 	ADD	A,-4
; SET_ONE:
; 	ADD	A,3
; 	LD	(INC_TOP),A
	;JP MOVE_LOGO
MAKE:
	CALL	MAKE_STACK
	JP	GO_LOOPY
	
;	CALL MAKE_STACK
	
	;JP	GO_LOOPY
	
START2:
	LD	(HL),0
	LD	HL,S2ADD
	LD	(HL),$CD
	INC HL
	LD	(HL),NEXT_SCROLL &$00FF
	INC HL
	LD (HL),NEXT_SCROLL >> 8
	JP START2_CONT
	
TOP_SCROLLER:
; time to step yet ?
	LD A,(TS_STEP)
	DEC	A
	JP	Z,TOP_SCROLL
	LD	(TS_STEP),A
	RET
TOP_SCROLL:
; move to next position
	; get current position of the ret z
	LD	A,14
	LD	(TS_STEP),A
START2_CONT:
	LD	HL,(TS_RET)
	INC	HL
	LD	A,(HL)
	CP	$FE
	JP	Z,START2
	CP	$FF
	; reset scroll to the begining
	JP	Z,TOP_SCROLL_RESET

	;else put current byte in previous location
	LD	DE,CHAR_STORE
	LD	A,(DE)			;GET CHAR IN STORE
	LDD					;SAVE CURRENT CHAR IN STORE
	LD	(HL),A			
	INC	HL
	LD	(HL),$C8
	
	
	LD	(TS_RET),HL
	LD	HL,(TS_START)
	INC	HL
FRM_RESET:
	LD	(TS_START),HL
	
	SET	7,H
	LD	(R1_ADD),HL

INC_TOPT:	
	LD	A,(R1_SCAN)
INC_TOP: EQU $+1

	ADD	A,1
	LD	(R1_SCAN),A
	JP	Z,REVERSE_DIR
	
	CP	182
MOVE_TOP:
	
	RET	C
	;JP	NC,REVERSE_DIR
	
	;RET
	
REVERSE_DIR:
	LD	A,(INC_TOP - 1)
	XOR	$10
	LD	(INC_TOP - 1),A
	JP INC_TOPT
; 	DEC	A
; 	JP	NZ,SET_ONE
; 	ADD	A,-4
; SET_ONE:
; 	ADD	A,3
; 	LD	(INC_TOP),A
	;JP MOVE_TOP

	
; 	LD	DE,VIDEO_STACK_BOTTOM + 8
; 	EX	DE,HL
; 	SET 	7,D
; 	LD	B,7
; TS_STCK_PRP:
; 	LD	(HL),E
; 	INC	HL
; 	LD	(HL),D
; 	INC	HL
; 	DJNZ	TS_STCK_PRP
; 	RET
	
TOP_SCROLL_RESET:
	DEC	HL
	LD	(HL),0
	LD	HL,TOP_SCROLL_RET
	LD	(HL),$C8
	LD	(TS_RET),HL
	LD	HL,TOP_SCROLL_TEXT
	JP	FRM_RESET
	
START3:
	LD	(HL),0
	LD	HL,Q1ADD
	LD	(HL),$CD
	INC	HL
	LD	(HL),Q_SCROLLER & $00FF
	INC	HL
	LD	(HL),Q_SCROLLER >> 8
	JP	NS_SCROLL
	
NEXT_SCROLL:

; ld r,n/ld r,n  = 7+7 = 14
; nop/nop/nop/nop  = 4+4+4+4 = 16
; each take 4 bytes, so alternating between the
; two will make the chars move 4 pixels
;
; 16 cycles-display -> 14 cycles-display -> move-loop

; time to step yet ?
	LD A,(NS_STEP)
	DEC	A
	JP	Z,NS_SCROLL
	LD	(NS_STEP),A
	RET
NS_SCROLL:
	LD	A,6
	LD	(NS_STEP),A
	LD	HL,(NS_START)
	INC	HL
	LD	A,(HL)
	CP	$FE
	JP	Z,START3
	CP	$FF
	JP	Z,NS_RESET
NS_GO:
	LD	A,(NS_O_E)
	DEC	A
	JP	NZ,NS14
NS16
	LD	(NS_O_E),A
	LD	DE,T16TT
	LD	BC,37
	LDDR
	LD	HL,T16
	JP	NSTT
NS14:
	LD	(NS_START),HL
	LD	A,1
	LD	(NS_O_E),A
	LD	DE,T14TT

	LD	BC,37
	LDDR
	LD	HL,T14	

NSTT
	SET	7,H
	LD	(R2_ADD),HL

	
	LD	A,(R2_SCAN)
NS_INC_TOP: EQU $+1
	ADD	A,1
	LD	(R2_SCAN),A
	JP	Z,NS_REVERSE_DIR
	CP	182
NS_MOVE_TOP:	
	RET	C
	;JP	NC,NS_REVERSE_DIR
	
	;RET
	
NS_REVERSE_DIR:
	LD	A,(NS_INC_TOP - 1)
	XOR	$10
	LD	(NS_INC_TOP - 1),A
	
; 	DEC	A
; 	JP	NZ,NS_SET_ONE
; 	ADD	A,-4
; NS_SET_ONE:
; 	ADD	A,3
; 	LD	(NS_INC_TOP),A
	RET
 	;JP 	NS_MOVE_TOP
; 	
NS_RESET:
 	LD	HL,N_SCROLL_TEXT
 	LD	(NS_START),HL
	JP	NS_SCROLL

	
T16:
	NOP			;4
	LD	A,(HL)	;11
	LD	R,A		;20
	LD	R,A		;29
	
T16T:
	DB 0,0,0,0,0,0,0,0,0,0	;69
	DB 0,0,0,0,0,0,0,0,0,0	;109
	DB 0,0,0,0,0,0,0,0,0,0	;149
	DB 0,0,0,0,0,0,0,0,0,0	;189
T16TT:
	DB 0					;193
	
	NOP			;197
	RET 				;207
	
T14:

	NOP					;4
	LD	R,A				;13
	LD	A,(HL)			;20
	LD	A,(HL)			;27
	
	
T14T:
	DB 0,0,0,0,0,0,0,0,0,0	;67
	DB 0,0,0,0,0,0,0,0,0,0	;107
	DB 0,0,0,0,0,0,0,0,0,0	;147
	DB 0,0,0,0,0,0,0,0,0,0	;187
T14TT:
	DB 0					;191
	RET	NZ				;196
	RET 	Z				;207
	
START4:
	LD	(HL),0
	LD	HL,Q2ADD
	LD	(HL),$CD
	INC	HL
	LD	(HL),Q2_SCROLLER & $00FF
	INC	HL
	LD	(HL),Q2_SCROLLER >> 8
	JP	QS_SCROLL
	
Q_SCROLLER:
	LD A,(QS_STEP)
	DEC	A
	JP	Z,QS_SCROLL
	LD	(QS_STEP),A
	RET
QS_SCROLL:
	LD	A,2
	LD	(QS_STEP),A
		
	LD	HL,(QS_START)
	INC	HL
	LD	A,(HL)
	CP	$FE
	JP Z,START4
	CP	$FF
	JP	Z,QS_RESET
QS_GO:
	LD	A,(QS_O_E)
	DEC	A
	JP	Z,QS7
	DEC	A
	JP	Z,QS8
	DEC	A
	JP	Z,QS9
	
QS10
	LD	A,3
	LD	(QS_O_E),A
	LD	DE,Q4B
	LD	BC,37
	LDDR
	LD	HL,Q4
	JP	QSTT
	
QS9:
	LD	A,2
	LD	(QS_O_E),A
	LD	DE,Q3B
	LD	BC,37
	LDDR
	LD	HL,Q3
	JP	QSTT	
	
QS8:
	LD	A,1
	LD	(QS_O_E),A
	LD	DE,Q2B
	LD	BC,37
	LDDR
	LD	HL,Q2
	JP	QSTT	
	
QS7:
	LD	(QS_START),HL
	LD	A,4
	LD	(QS_O_E),A
	LD	DE,Q1B
	LD	BC,37
	LDDR
	LD	HL,Q1
	JP	QSTT


QSTT
	SET	7,H
	LD	(R3_ADD),HL
	
	
	LD	A,(R3_SCAN)
QS_INC_TOP: EQU $+1
	ADD	A,1
	LD	(R3_SCAN),A
	JP	Z,QS_REVERSE_DIR
	CP	182
QS_MOVE_TOP:	
	RET	C
	;JP	NC,QS_REVERSE_DIR
	
	;RET
	
QS_REVERSE_DIR:
	LD	A,(QS_INC_TOP - 1)
	XOR	$10
	LD	(QS_INC_TOP - 1),A
	
; 	DEC	A
; 	JP	NZ,QS_SET_ONE
; 	ADD	A,-4
; QS_SET_ONE:
; 	ADD	A,3
; 	LD	(QS_INC_TOP),A
 	RET
	;JP 	QS_MOVE_TOP
	
	
; 	
; 	LD	DE,VIDEO_STACK_BOTTOM + 72
; 	EX	DE,HL
; 	SET 	7,D
; 	LD	B,7
; QS_STCK_PRP:
; 	LD	(HL),E
; 	INC	HL
; 	LD	(HL),D
; 	INC	HL
; 	DJNZ	QS_STCK_PRP
; 	RET
	
QS_RESET:
	LD	HL,Q_SCROLL_TEXT
	LD	(QS_START),HL
	JP	QS_SCROLL

Q2_SCROLLER:

	
Q2S_SCROLL:
	
	LD	HL,(Q2S_START)
	INC	HL
	LD	A,$FF
	CP	(HL)
	JP	Z,Q2S_RESET
Q2S_GO:
	LD	A,(Q2S_O_E)
	DEC	A
	JP	Z,Q2S7
	DEC	A
	JP	Z,Q2S8
	DEC	A
	JP	Z,Q2S9
	
Q2S10
	LD	A,3
	LD	(Q2S_O_E),A
	LD	DE,Q24B
	LD	BC,37
	LDDR
	LD	HL,Q24
	JP	Q2STT
	
Q2S9:
	LD	A,2
	LD	(Q2S_O_E),A
	LD	DE,Q23B
	LD	BC,37
	LDDR
	LD	HL,Q23
	JP	Q2STT	
	
Q2S8:
	LD	A,1
	LD	(Q2S_O_E),A
	LD	DE,Q22B
	LD	BC,37
	LDDR
	LD	HL,Q22
	JP	Q2STT	
	
Q2S7:
	LD	(Q2S_START),HL
	LD	A,4
	LD	(Q2S_O_E),A
	LD	DE,Q21B
	LD	BC,37
	LDDR
	LD	HL,Q21
	JP	Q2STT


Q2STT
	SET	7,H
	LD	(R4_ADD),HL
	
	
	LD	A,(R4_SCAN)

Q2S_INC_TOP: EQU $+1
	ADD	A,1
	LD	(R4_SCAN),A
	JP	Z,Q2S_REVERSE_DIR
	CP	182
Q2S_MOVE_TOP:	
	RET	C
	;JP	NC,Q2S_REVERSE_DIR
	
	;RET
	
Q2S_REVERSE_DIR:
	LD	A,(Q2S_INC_TOP - 1)
	XOR	$10
	LD	(Q2S_INC_TOP - 1),A

	;JP 	Q2S_MOVE_TOP
	
	RET
; 	LD	DE,VIDEO_STACK_BOTTOM + 104
; 	EX	DE,HL
; 	SET 	7,D
; 	LD	B,7
; Q2S_STCK_PRP:
; 	LD	(HL),E
; 	INC	HL
; 	LD	(HL),D
; 	INC	HL
; 	DJNZ	Q2S_STCK_PRP
; 	RET
	
Q2S_RESET:
	LD	HL,Q2_SCROLL_TEXT
	LD	(Q2S_START),HL
	JP	Q2S_SCROLL

	
	
; LD	A,(HL) 	= 207 - (7 + 11) = 189
; NOP, NOP	= 207 - (8 + 11) = 188
; LD A,I		= 207 - (9 + 11) = 187
; CALL CC,NN	= 207 - (10 +11) = 186

Q1:
	LD	R,A				;9
	LD	R,A				;18
	NOP					;22
	NOP					;26
Q1A:
	DB 0,0,0,0,0,0,0,0,0,0	;66
	DB 0,0,0,0,0,0,0,0,0,0	;106
	DB 0,0,0,0,0,0,0,0,0,0	;146
	DB 0,0,0,0,0,0,0,0,0,0	;186
Q1B:
	DB 0					;190
Q1C:
	LD	A,(HL)			;197
	RET					;207

Q2:
	LD	R,A				;9
	LD	R,A				;18
	LD	R,A				;27
Q2A:
	DB 0,0,0,0,0,0,0,0,0,0	;67
	DB 0,0,0,0,0,0,0,0,0,0	;107
	DB 0,0,0,0,0,0,0,0,0,0	;147
	DB 0,0,0,0,0,0,0,0,0,0	;187
Q2B:
	DB 0					;191
Q2C:
	RET	NZ				;196
	RET	Z				;207

Q3
	LD	A,(HL)			;8
	LD	A,(HL)			;14		
	LD	A,(HL)			;21
	LD	A,(HL)			;28
Q3A:
	DB 0,0,0,0,0,0,0,0,0,0	;68
	DB 0,0,0,0,0,0,0,0,0,0	;108
	DB 0,0,0,0,0,0,0,0,0,0	;148
	DB 0,0,0,0,0,0,0,0,0,0	;188
Q3B:
	DB 0					;192
	
	NOP					;196
	RET	Z				;207
		
Q4
	CALL	NZ,0				;10
	CALL	NZ,0				;20
	LD	R,A				;29
Q4A:
	DB 0,0,0,0,0,0,0,0,0,0	;69
	DB 0,0,0,0,0,0,0,0,0,0	;109
	DB 0,0,0,0,0,0,0,0,0,0	;149
	DB 0,0,0,0,0,0,0,0,0,0	;189
Q4B:
	DB 0					;193
	
	
	NOP					;197
	RET					;207

Q21:
	LD	R,A				;9
	LD	R,A				;18
	NOP					;22
	NOP					;26
Q21A:
	DB 0,0,0,0,0,0,0,0,0,0	;66
	DB 0,0,0,0,0,0,0,0,0,0	;106
	DB 0,0,0,0,0,0,0,0,0,0	;146
	DB 0,0,0,0,0,0,0,0,0,0	;186
Q21B:
	DB 0					;190
Q21C:
	LD	A,(HL)			;197
	RET					;207

Q22:
	LD	R,A				;9
	LD	R,A				;18
	LD	R,A				;27
Q22A:
	DB 0,0,0,0,0,0,0,0,0,0	;67
	DB 0,0,0,0,0,0,0,0,0,0	;107
	DB 0,0,0,0,0,0,0,0,0,0	;147
	DB 0,0,0,0,0,0,0,0,0,0	;187
Q22B:
	DB 0					;191
Q22C:
	RET	NZ				;196
	RET	Z				;207

Q23
	LD	A,(HL)			;8
	LD	A,(HL)			;14		
	LD	A,(HL)			;21
	LD	A,(HL)			;28
Q23A:
	DB 0,0,0,0,0,0,0,0,0,0	;68
	DB 0,0,0,0,0,0,0,0,0,0	;108
	DB 0,0,0,0,0,0,0,0,0,0	;148
	DB 0,0,0,0,0,0,0,0,0,0	;188
Q23B:
	DB 0					;192
	
	NOP					;196
	RET	Z				;207
		
Q24
	CALL	NZ,0				;10
	CALL	NZ,0				;20
	LD	R,A				;29
Q24A:
	DB 0,0,0,0,0,0,0,0,0,0	;69
	DB 0,0,0,0,0,0,0,0,0,0	;109
	DB 0,0,0,0,0,0,0,0,0,0	;149
	DB 0,0,0,0,0,0,0,0,0,0	;189
Q24B:
	DB 0					;193
	
	
	NOP					;197
	RET					;207
	
	
	
	
	
VIDEO_FINISHED:
	DB	$00
	
	
R1_SCAN:
	DB	$00
R1_ADD:
	DW	$0000	
R2_SCAN:
	DB	$00	; $00 means don't draw it
R2_ADD:
	DW	$0000	
R3_SCAN:
	DB	$00
R3_ADD:
	DW	$0000	
R4_SCAN:
	DB	$00	
R4_ADD:
	DW	$0000
	
ZR1_SCAN:
	DB	$00
ZR1_ADD:
	DW	$0000	
ZR2_SCAN:
	DB	$00
ZR2_ADD:
	DW	$0000	
ZR3_SCAN:
	DB	$00
ZR3_ADD:
	DW	$0000	
ZR4_SCAN:
	DB	$00
ZR4_ADD:
	DW	$0000
	
BUILD_STACK:
	LD	A,(ZR1_SCAN)
	AND	A
	JP	Z,BUILD_ST2
	INC	A
	LD	H,0
	LD	L,A
	ADD	HL,HL
	LD	DE,VIDEO_STACK_BOTTOM
	ADD	HL,DE
	LD	DE,CHAR_RESET
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	LD	DE,(ZR1_ADD)
	LD	B,6
S1_STCK_PRP:
 	LD	(HL),E
 	INC	HL
 	LD	(HL),D
 	INC	HL
 	DJNZ	S1_STCK_PRP
	LD	DE,CHAR_RESET
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
BUILD_ST2:

	LD	A,(ZR2_SCAN)
	AND	A
	JP	Z,BUILD_ST3
	INC	A
	LD	H,0
	LD	L,A
	ADD	HL,HL
	LD	DE,VIDEO_STACK_BOTTOM
	ADD	HL,DE
	LD	DE,CHAR_RESET
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	LD	DE,(ZR2_ADD)
	LD	B,6
S2_STCK_PRP:
 	LD	(HL),E
 	INC	HL
 	LD	(HL),D
 	INC	HL
 	DJNZ	S2_STCK_PRP
	LD	DE,CHAR_RESET
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
BUILD_ST3:
	LD	A,(ZR3_SCAN)
	AND	A
	JP	Z,BUILD_ST4
	INC	A
	LD	H,0
	LD	L,A
	ADD	HL,HL
	LD	DE,VIDEO_STACK_BOTTOM
	ADD	HL,DE
	LD	DE,CHAR_RESET
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	LD	DE,(ZR3_ADD)
	LD	B,6
S3_STCK_PRP:
 	LD	(HL),E
 	INC	HL
 	LD	(HL),D
 	INC	HL
 	DJNZ	S3_STCK_PRP
	LD	DE,CHAR_RESET
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
BUILD_ST4:
	LD	A,(ZR4_SCAN)
	AND	A
	RET	Z
	INC	A
	LD	H,0
	LD	L,A
	ADD	HL,HL
	LD	DE,VIDEO_STACK_BOTTOM
	ADD	HL,DE
	LD	DE,CHAR_RESET
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	LD	DE,(ZR4_ADD)
	LD	B,6
S4_STCK_PRP:
 	LD	(HL),E
 	INC	HL
 	LD	(HL),D
 	INC	HL
 	DJNZ	S4_STCK_PRP
	LD	DE,CHAR_RESET
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	RET
	
; STCK_PREP:
; 	LD	DE,CHAR_RESET
; 	LD	(HL),E
; 	INC	HL
; 	LD	(HL),D
; 	INC	HL
; 	RET
; 	
; S_STCK_PREP	
;  	LD	B,6
; S1_STCK_PRP:
;  	LD	(HL),E
;  	INC	HL
;  	LD	(HL),D
;  	INC	HL
;  	DJNZ	S1_STCK_PRP
;  	RET		




	
MAKE_STACK:
	
; first sort the scrollers into scanline order
; lowest first

; need to copy because they are not all updated every frame
	LD	HL,R1_SCAN
	LD	DE,ZR1_SCAN
	LD	BC,12
	LDIR
;	CALL	SWAP_LP
	
; FILL_STACK:
; 	LD	HL,VIDEO_STACK_BOTTOM
; 	LD	DE,BLANK_LINE + $8000
; 	LD	B,192 
; FILL_ST_LP:
; 	LD	(HL),E
; 	INC	HL
; 	LD	(HL),D
; 	INC	HL
; 	DJNZ	FILL_ST_LP

NEXT_LOGO:
	LD	A,(LOGO_SWAP)
	DEC	A
	LD	(LOGO_SWAP),A
	JP	NZ,NO_LOGO_SWAP
	LD	A,15
	LD	(LOGO_SWAP),A
	LD	HL,(LOGO_PTR)
	INC	HL
	INC	HL
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	LD	A,E
	OR	D
	JP	NZ,NEXT_LOGO_FOUND
	LD	HL,LOGO_ADDRESSES + 1
NEXT_LOGO_FOUND:
	LD	D,(HL)
	DEC	HL
	LD	E,(HL)
	LD	(LOGO_PTR),HL
	LD	(THIS_LOGO),DE
	
NO_LOGO_SWAP

	LD	DE,VIDEO_STACK_BOTTOM
	LD	A,(LOGO_POS)
	LD	L,A
	LD	H,0
	ADD	HL,HL
	ADD	HL,DE
	EX	DE,HL
THIS_LOGO: EQU $+1
	LD	HL,SINC_LOGO
	LD	BC,88
	LDIR
	
	JP BUILD_STACK
	
	
SWAP_LP:
	XOR	A		
	LD	(SWAPS),A

	LD	HL,ZR1_SCAN
	LD	DE,ZR2_SCAN
	LD	B,3			;NUMBER OF COMPARES
	
SWP_L:
	LD	A,(DE)		;SECOND VAL
	CP	(HL)			;FIRST VAL
	JP	NC,NO_SWAP
SWAP:
	CALL	SWAP1_B
	CALL	SWAP1_B
	CALL	SWAP1_B
	PUSH	HL
	LD	HL,SWAPS
	INC	(HL)
	POP	HL
	
NO_SWAP1:
	DJNZ	SWP_L
	LD	A,(SWAPS)
	AND	A
	JP	NZ,SWAP_LP	
	RET
	
NO_SWAP:
	INC	DE
	INC	DE
	INC	DE
	INC	HL
	INC	HL
	INC	HL
	JP	NO_SWAP1
	
SWAP1_B:
	LD	C,(HL)
	LD	A,(DE)
	LD	(HL),A
	LD	A,C
	LD	(DE),A
	INC	HL
	INC	DE
	RET
		
SWAPS:
	DB	0

VIDEO_STACK_BOTTOM:
; this is a virtual machine stack that will
; hold the 'return' address to the video 
; scanlines, an intial jump to the first 
; address will then 'ret' to each scanline
; in turn, finnaly 'ret'ing to the video complete
; part of the code

	
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000

	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000

	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000

	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000

	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000

	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000

	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000

	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000

	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000

	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000

	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000

	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000

	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000

	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000

	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000

	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000

	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000

	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000

	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000

	DW	BLANK_LINE + $8000
	DW	BLANK_LINE + $8000
	
	DW	VIDEO_COMPLETE
VIDEO_STACK_TOP: EQU $-2



SINC1:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128,0,0,0,0,0,0
	DB 0
	RET	Z
	
SINC2:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 0
	RET	Z
	
SINC3:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,128,128,128,128,0,128,0,128,128,128,128,128,0,128,128,128,128,128,0,128,0,128,128,128,128,128,0,128,0,128,128,128,128,128
	DB 0
	RET	Z
	
SINC4:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,0,0,0,0,128,0,128,0,0,0,128,0,128,0,0,0,0,0,128,0,0,0,0,0,128,0,128,0,128,0,0,0,0
	DB 0
	RET	Z
	
SINC5:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,128,128,128,128,0,128,0,128,0,0,0,128,0,128,0,0,0,0,0,128,0,128,128,128,128,128,0,128,0,128,0,0,0,0
	DB 0
	RET	Z
	
SINC6:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,128,0,128,0,128,0,0,0,128,0,128,0,0,0,0,0,128,0,128,0,0,0,128,0,128,0,128,0,0,0,0
	DB 0
	RET	Z
	
SINC7:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,128,128,128,128,0,128,0,128,0,0,0,128,0,128,128,128,128,128,0,128,0,128,128,128,128,128,0,128,0,128,0,0,0,0
	DB 0
	RET	Z
	
	
SINC_LOGO:
	DW	CHAR_RESET
	DW	SINC1+$8000,SINC1+$8000,SINC1+$8000,SINC1+$8000,SINC1+$8000,SINC1+$8000
	DW	SINC2+$8000,SINC2+$8000,SINC2+$8000,SINC2+$8000,SINC2+$8000,SINC2+$8000
	DW	SINC3+$8000,SINC3+$8000,SINC3+$8000,SINC3+$8000,SINC3+$8000,SINC3+$8000
	DW	SINC4+$8000,SINC4+$8000,SINC4+$8000,SINC4+$8000,SINC4+$8000,SINC4+$8000
	DW	SINC5+$8000,SINC5+$8000,SINC5+$8000,SINC5+$8000,SINC5+$8000,SINC5+$8000
	DW	SINC6+$8000,SINC6+$8000,SINC6+$8000,SINC6+$8000,SINC6+$8000,SINC6+$8000
	DW	SINC7+$8000,SINC7+$8000,SINC7+$8000,SINC7+$8000,SINC7+$8000,SINC7+$8000
	DW	CHAR_RESET
	
; 44 WORDS, 88 BYTES

BLANK_LOGO
	DW	CHAR_RESET
	DW	BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000
	DW	BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000
	DW	BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000
	DW	BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000
	DW	BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000
	DW	BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000
	DW	BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000,BLANK_LINE + $8000
	DW	CHAR_RESET
	
MUSIC_LOGO:
	DW	CHAR_RESET
	DW	MUSIC1+$8000,MUSIC1+$8000,MUSIC1+$8000,MUSIC1+$8000,MUSIC1+$8000,MUSIC1+$8000
	DW	MUSIC2+$8000,MUSIC2+$8000,MUSIC2+$8000,MUSIC2+$8000,MUSIC2+$8000,MUSIC2+$8000
	DW	MUSIC3+$8000,MUSIC3+$8000,MUSIC3+$8000,MUSIC3+$8000,MUSIC3+$8000,MUSIC3+$8000
	DW	MUSIC4+$8000,MUSIC4+$8000,MUSIC4+$8000,MUSIC4+$8000,MUSIC4+$8000,MUSIC4+$8000
	DW	MUSIC5+$8000,MUSIC5+$8000,MUSIC5+$8000,MUSIC5+$8000,MUSIC5+$8000,MUSIC5+$8000
	DW	MUSIC6+$8000,MUSIC6+$8000,MUSIC6+$8000,MUSIC6+$8000,MUSIC6+$8000,MUSIC6+$8000
	DW	MUSIC7+$8000,MUSIC7+$8000,MUSIC7+$8000,MUSIC7+$8000,MUSIC7+$8000,MUSIC7+$8000
	DW	CHAR_RESET
	
YERZ_LOGO:
	DW	CHAR_RESET
	DW	YERZ1+$8000,YERZ1+$8000,YERZ1+$8000,YERZ1+$8000,YERZ1+$8000,YERZ1+$8000
	DW	YERZ2+$8000,YERZ2+$8000,YERZ2+$8000,YERZ2+$8000,YERZ2+$8000,YERZ2+$8000
	DW	YERZ3+$8000,YERZ3+$8000,YERZ3+$8000,YERZ3+$8000,YERZ3+$8000,YERZ3+$8000
	DW	YERZ4+$8000,YERZ4+$8000,YERZ4+$8000,YERZ4+$8000,YERZ4+$8000,YERZ4+$8000
	DW	YERZ5+$8000,YERZ5+$8000,YERZ5+$8000,YERZ5+$8000,YERZ5+$8000,YERZ5+$8000
	DW	YERZ6+$8000,YERZ6+$8000,YERZ6+$8000,YERZ6+$8000,YERZ6+$8000,YERZ6+$8000
	DW	YERZ7+$8000,YERZ7+$8000,YERZ7+$8000,YERZ7+$8000,YERZ7+$8000,YERZ7+$8000
	DW	CHAR_RESET
	
CODE_LOGO:
	DW	CHAR_RESET
	DW	CODE1+$8000,CODE1+$8000,CODE1+$8000,CODE1+$8000,CODE1+$8000,CODE1+$8000
	DW	CODE2+$8000,CODE2+$8000,CODE2+$8000,CODE2+$8000,CODE2+$8000,CODE2+$8000
	DW	CODE3+$8000,CODE3+$8000,CODE3+$8000,CODE3+$8000,CODE3+$8000,CODE3+$8000
	DW	CODE4+$8000,CODE4+$8000,CODE4+$8000,CODE4+$8000,CODE4+$8000,CODE4+$8000
	DW	CODE5+$8000,CODE5+$8000,CODE5+$8000,CODE5+$8000,CODE5+$8000,CODE5+$8000
	DW	CODE6+$8000,CODE6+$8000,CODE6+$8000,CODE6+$8000,CODE6+$8000,CODE6+$8000
	DW	CODE7+$8000,CODE7+$8000,CODE7+$8000,CODE7+$8000,CODE7+$8000,CODE7+$8000
	DW	CHAR_RESET
	
MADAXE_LOGO:
	DW	CHAR_RESET
	DW	MADAXE1+$8000,MADAXE1+$8000,MADAXE1+$8000,MADAXE1+$8000,MADAXE1+$8000,MADAXE1+$8000
	DW	MADAXE2+$8000,MADAXE2+$8000,MADAXE2+$8000,MADAXE2+$8000,MADAXE2+$8000,MADAXE2+$8000
	DW	MADAXE3+$8000,MADAXE3+$8000,MADAXE3+$8000,MADAXE3+$8000,MADAXE3+$8000,MADAXE3+$8000
	DW	MADAXE4+$8000,MADAXE4+$8000,MADAXE4+$8000,MADAXE4+$8000,MADAXE4+$8000,MADAXE4+$8000
	DW	MADAXE5+$8000,MADAXE5+$8000,MADAXE5+$8000,MADAXE5+$8000,MADAXE5+$8000,MADAXE5+$8000
	DW	MADAXE6+$8000,MADAXE6+$8000,MADAXE6+$8000,MADAXE6+$8000,MADAXE6+$8000,MADAXE6+$8000
	DW	MADAXE7+$8000,MADAXE7+$8000,MADAXE7+$8000,MADAXE7+$8000,MADAXE7+$8000,MADAXE7+$8000
	DW	CHAR_RESET
	
FOREVER_LOGO:
	DW	CHAR_RESET
	DW	FOREVER1+$8000,FOREVER1+$8000,FOREVER1+$8000,FOREVER1+$8000,FOREVER1+$8000,FOREVER1+$8000
	DW	FOREVER2+$8000,FOREVER2+$8000,FOREVER2+$8000,FOREVER2+$8000,FOREVER2+$8000,FOREVER2+$8000
	DW	FOREVER3+$8000,FOREVER3+$8000,FOREVER3+$8000,FOREVER3+$8000,FOREVER3+$8000,FOREVER3+$8000
	DW	FOREVER4+$8000,FOREVER4+$8000,FOREVER4+$8000,FOREVER4+$8000,FOREVER4+$8000,FOREVER4+$8000
	DW	FOREVER5+$8000,FOREVER5+$8000,FOREVER5+$8000,FOREVER5+$8000,FOREVER5+$8000,FOREVER5+$8000
	DW	FOREVER6+$8000,FOREVER6+$8000,FOREVER6+$8000,FOREVER6+$8000,FOREVER6+$8000,FOREVER6+$8000
	DW	FOREVER7+$8000,FOREVER7+$8000,FOREVER7+$8000,FOREVER7+$8000,FOREVER7+$8000,FOREVER7+$8000
	DW	CHAR_RESET	
	
	
MUSIC1:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,0,0,128,0,128,0,128,0,0,128,128,0,128,128,128,0,0,128,128
	DB 0,0,0,0,0,0,0,0
	RET	Z

MUSIC2:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,128,0,128,128,0,128,0,128,0,128,0,0,0,0,128,0,0,128,0,0
	DB 0,0,0,0,0,0,0,0
	RET	Z

MUSIC3:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,128,0,128,128,0,128,0,128,0,128,0,0,0,0,128,0,0,128,0,0
	DB 0,0,0,0,0,0,0,0
	RET	Z
	
MUSIC4:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,128,0,128,0,128,0,128,0,0,128,0,0,0,128,0,0,128,0,0
	DB 0,0,0,0,0,0,0,0
	RET	Z

MUSIC5:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,0,0,128,0,128,0,128,0,0,0,128,0,0,128,0,0,128,0,0
	DB 0,0,0,0,0,0,0,0
	RET	Z
	
MUSIC6:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,0,0,128,0,128,0,128,0,0,0,128,0,0,128,0,0,128,0,0
	DB 0,0,0,0,0,0,0,0
	RET	Z	

MUSIC7:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,0,0,128,0,128,128,128,0,128,128,0,0,128,128,128,0,0,128,128
	DB 0,0,0,0,0,0,0,0
	RET	Z
	
	
YERZ1:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,128,0,128,128,128,0,128,128,0,0,128,128,128,0,128,0,0,0,128,0,128,0,128,0,128,128,128,0,128,0,128
	DB 0,0
	RET	Z

YERZ2:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,128,0,128,0,0,0,128,0,128,0,0,0,128,0,128,128,0,128,128,0,128,0,128,0,128,0,0,0,128,0,128
	DB 0,0
	RET	Z

YERZ3:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,128,0,128,0,0,0,128,0,128,0,0,0,128,0,128,128,0,128,128,0,128,0,128,0,128,0,0,0,128,0,128
	DB 0,0
	RET	Z

YERZ4:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,128,128,0,128,128,128,0,128,128,0,0,0,128,0,0,128,0,128,0,128,0,128,128,128,0,128,128,128,0,128,128,128
	DB 0,0
	RET	Z

YERZ5:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 0,0,128,0,128,0,0,0,128,0,128,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,128,0,0,0,0,0,128
	DB 0,0
	RET	Z
				
YERZ6:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 0,0,128,0,128,0,0,0,128,0,128,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,128,0,0,0,0,0,128
	DB 0,0
	RET	Z

YERZ7:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,128,128,0,128,128,128,0,128,0,128,0,128,128,128,0,128,0,0,0,128,0,128,128,128,0,128,128,128,0,128,128,128
	DB 0,0
	RET	Z
	

	
	
CODE1:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 0,128,128,0,0,128,0,0,128,128,0,0,128,128,128,0,128,128,128,0,128,128,128
	DB 0,0,0,0,0,0,0
	RET	Z
	
CODE2:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,0,0,128,0,128,0,128,0,128,0,0,128,0,0,128,0,128,0,128,0,128
	DB 0,0,0,0,0,0,0
	RET	Z
	
CODE3:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,0,0,128,0,128,0,128,0,128,0,0,128,0,0,128,0,128,0,128,0,128
	DB 0,0,0,0,0,0,0
	RET	Z
	
CODE4:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,0,0,128,0,128,0,128,0,128,0,0,128,0,0,128,0,128,0,128,128,128
	DB 0,0,0,0,0,0,0
	RET	Z
	
CODE5:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,0,0,128,0,128,0,128,0,128,0,0,128,0,0,128,0,128,0,0,0,128
	DB 0,0,0,0,0,0,0
	RET	Z
	
CODE6:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,0,0,128,0,128,0,128,0,128,0,0,128,0,0,128,0,128,0,0,0,128
	DB 0,0,0,0,0,0,0
	RET	Z
	
CODE7:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 0,128,128,0,0,128,0,0,128,128,0,0,128,128,128,0,128,0,128,0,128,128,128
	DB 0,0,0,0,0,0,0
	RET	Z
	
MADAXE1:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,0,0,128,0,0,128,0,0,128,128,0,0,0,128,0,128,0,128,0,0,0,128,0,0,128,0,128,0,128,128,128
	DB 0,0
	RET	Z

MADAXE2:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,128,0,128,128,0,128,0,128,0,128,0,128,0,128,0,128,128,128,0,128,0,128,0,128,0,128,0,128,0,128,0,0
	DB 0,0
	RET	Z

MADAXE3:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,128,0,128,128,0,128,0,128,0,128,0,128,0,128,0,0,128,0,0,128,0,128,0,128,0,0,128,0,0,128,0,0
	DB 0,0
	RET	Z

MADAXE4:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,128,0,128,0,128,128,128,0,128,0,128,0,128,0,128,128,128,0,128,0,128,128,128,0,0,128,0,0,128,128,128
	DB 0,0
	RET	Z

MADAXE5:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,0,0,128,0,128,0,128,0,128,0,128,0,0,128,0,128,0,128,0,0,128,0,128,0,0,128,0,0,128,0,0
	DB 0,0
	RET	Z
				
MADAXE6:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,0,0,128,0,128,0,128,0,128,0,128,0,0,0,0,128,0,0,0,0,128,0,128,0,128,0,128,0,128,0,0
	DB 0,0
	RET	Z

MADAXE7:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,0,0,128,0,128,0,128,0,128,128,0,0,0,0,0,128,0,0,0,0,128,0,128,0,128,0,128,0,128,128,128
	DB 0,0
	RET	Z
	
FOREVER1:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,128,128,0,0,128,0,0,128,128,0,0,128,128,128,0,128,0,0,0,128,0,128,128,128,0,128,128,0
	DB 0,0,0,0
	RET	Z
	
FOREVER2:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,0,0,128,0,128,0,128,0,128,0,128,0,0,0,128,0,0,0,128,0,128,0,0,0,128,0,128
	DB 0,0,0,0
	RET	Z
	
FOREVER3:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,0,0,128,0,128,0,128,0,128,0,128,0,0,0,128,0,0,0,128,0,128,0,0,0,128,0,128
	DB 0,0,0,0
	RET	Z
	
FOREVER4:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,128,0,0,128,0,128,0,128,128,0,0,128,128,128,0,128,0,0,0,128,0,128,128,128,0,128,128,0
	DB 0,0,0,0
	RET	Z
	
FOREVER5:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,0,0,128,0,128,0,128,0,128,0,128,0,0,0,128,0,0,0,128,0,128,0,0,0,128,0,128
	DB 0,0,0,0
	RET	Z
	
FOREVER6:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,0,0,128,0,128,0,128,0,128,0,128,0,0,0,0,128,0,128,0,0,128,0,0,0,128,0,128
	DB 0,0,0,0
	RET	Z
	
FOREVER7:
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 128,0,0,0,0,128,0,0,128,0,128,0,128,128,128,0,0,0,128,0,0,0,128,128,128,0,128,0,128
	DB 0,0,0,0
	RET	Z	
	
LOGO_POS:
	DB $10
	
LOGO_SWAP:
	DB 15
	
LOGO_PTR:
	DW	LOGO_ADDRESSES
	
LOGO_ADDRESSES:
	DW SINC_LOGO
	DW SINC_LOGO
	DW SINC_LOGO
	DW SINC_LOGO
	DW SINC_LOGO
	DW FOREVER_LOGO
	DW FOREVER_LOGO
	DW FOREVER_LOGO
	DW FOREVER_LOGO
	DW FOREVER_LOGO
	DW BLANK_LOGO
	DW MUSIC_LOGO
	DW MUSIC_LOGO
	DW MUSIC_LOGO
	DW MUSIC_LOGO
	DW MUSIC_LOGO
	DW YERZ_LOGO
	DW YERZ_LOGO
	DW YERZ_LOGO
	DW YERZ_LOGO
	DW YERZ_LOGO
	DW BLANK_LOGO
	DW CODE_LOGO
	DW CODE_LOGO
	DW CODE_LOGO
	DW CODE_LOGO
	DW CODE_LOGO
	DW MADAXE_LOGO
	DW MADAXE_LOGO
	DW MADAXE_LOGO
	DW MADAXE_LOGO
	DW MADAXE_LOGO
	DW BLANK_LOGO
	DW $0000
	

	
	




BLANK_LINE:
; this is a line of 49 spaces, + ret z

	DB 0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0
	DB 0,$C8
	
CHAR_RESET:
; 

	
	IN	A,($FE)			;181	
	OUT	($FF),A			;192
	DB 0,0,0,0,0,0,0,0,0,0	;40
	DB 0,0,0,0,0,0,0,0,0,0	;80
	DB 0,0,0,0,0,0,0,0,0,0	;120
	DB 0,0,0,0,0,0,0,0,0,0	;160
	DB 0					;164
	
	RET	NZ				;165
	RET	NZ				;170
	; the following short vsync overlaps the free
	; running hsync, it does not disturb video generation
	; but does reset the character line counter 
	; in the ULA, so we can position text starting
	; on any scan line :-)
	
	
;	NOP					;196
	RET	Z				;207
	
	
	
TS_STEP:
	DB	8	
TS_START:
	DW TOP_SCROLL_TEXT - 1
TS_RET:
	DW TOP_SCROLL_RET -1
CHAR_STORE:
	DB	0
		
	DB 0
TOP_SCROLL_TEXT:
	DB 0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0
	DB $C8
TOP_SCROLL_RET:
	DB 0
	
	DB ZX_H,ZX_E,ZX_L,ZX_L,ZX_O,0,ZX_A,ZX_N,ZX_D,0,ZX_W,ZX_E,ZX_L,ZX_C,ZX_O,ZX_M,ZX_E,0,ZX_T,ZX_O,0
	DB ZX_T,ZX_H,ZX_E,0,ZX_W,ZX_O,ZX_R,ZX_S,ZX_T,0,ZX_S,ZX_C,ZX_R,ZX_O,ZX_L,ZX_L,ZX_E,ZX_R,0,ZX_E,ZX_V,ZX_E,ZX_R,0,ZX_O,ZX_N,0,ZX_Z,ZX_X,ZX_8,ZX_1,0
	DB ZX_I,ZX_T,ZX_S,0,ZX_A,0,ZX_P,ZX_R,ZX_E,ZX_T,ZX_T,ZX_Y,0,ZX_L,ZX_A,ZX_M,ZX_E,0,ZX_A,ZX_T,ZX_T,ZX_E,ZX_M,ZX_P,ZX_T,0,ZX_S,ZX_O,0,ZX_I,0
	DB ZX_T,ZX_H,ZX_O,ZX_U,ZX_G,ZX_H,ZX_T,0,ZX_I,0,ZX_B,ZX_E,ZX_T,ZX_T,ZX_E,ZX_R,0,ZX_M,ZX_A,ZX_K,ZX_E,0,ZX_A,ZX_N,ZX_O,ZX_T,ZX_H,ZX_E,ZX_R,0
	DB ZX_S,ZX_C,ZX_R,ZX_O,ZX_L,ZX_L,ZX_E,ZX_R,0,ZX_L,ZX_E,ZX_S,ZX_S,0,ZX_J,ZX_E,ZX_R,ZX_K,ZX_Y,0,ZX_T,ZX_H,ZX_A,ZX_N,0
	DB ZX_T,ZX_H,ZX_I,ZX_S,ZX_PERIOD,0,0,0,0
	DB 0,$FE,0,0,0
	DB ZX_N,ZX_O,ZX_W,0,ZX_S,ZX_O,ZX_M,ZX_E,0,ZX_G,ZX_R,ZX_E,ZX_E,ZX_T,ZX_Z,0,ZX_H,ZX_E,ZX_L,ZX_L,ZX_O,ZX_S,0,ZX_F,ZX_L,ZX_Y,0,ZX_O,ZX_U,ZX_T,0,ZX_T,ZX_O,0,0,0,0
	DB ZX_S,ZX_I,ZX_G,ZX_G,ZX_I,ZX_COMMA,0,ZX_M,ZX_O,ZX_G,ZX_G,ZX_Y,ZX_COMMA,0,ZX_B,ZX_O,ZX_D,ZX_O,ZX_COMMA,0,ZX_S,ZX_I,ZX_R,ZX_M,ZX_O,ZX_R,ZX_R,ZX_I,ZX_S,ZX_COMMA,0
	DB ZX_T,ZX_O,ZX_M,ZX_COMMA,0,ZX_Y,ZX_E,ZX_R,ZX_Z,ZX_M,ZX_Y,ZX_E,ZX_Y,ZX_COMMA,0,ZX_R,ZX_W,ZX_A,ZX_P,ZX_COMMA,0,ZX_X,ZX_A,ZX_V,ZX_S,ZX_N,ZX_A,ZX_P,ZX_COMMA,0
	DB ZX_B,ZX_R,ZX_U,ZX_N,ZX_I,ZX_F,ZX_L,ZX_O,ZX_R,ZX_I,ZX_N,ZX_D,ZX_O,ZX_COMMA,0,ZX_G,ZX_U,ZX_S,ZX_COMMA,0,ZX_J,ZX_E,ZX_N,ZX_S,ZX_COMMA,0,ZX_P,ZX_A,ZX_U,ZX_L,ZX_COMMA,0
	DB ZX_P,ZX_O,ZX_K,ZX_E,ZX_M,ZX_O,ZX_N,ZX_COMMA,0,ZX_B,ZX_O,ZX_B,ZX_S,ZX_COMMA,0,ZX_S,ZX_A,ZX_S,ZX_C,ZX_H,ZX_A,ZX_COMMA,0,ZX_P,ZX_E,ZX_T,ZX_E,ZX_R,ZX_COMMA,0
	DB ZX_J,ZX_O,ZX_A,ZX_C,ZX_H,ZX_I,ZX_M,ZX_COMMA,0,ZX_K,ZX_A,ZX_I,ZX_COMMA,0,ZX_P,ZX_R,ZX_I,ZX_M,ZX_E,ZX_COMMA,0,ZX_B,ZX_B,ZX_O,ZX_C,ZX_K,ZX_COMMA,0
	DB ZX_S,ZX_B,ZX_E,ZX_T,ZX_A,ZX_M,ZX_A,ZX_X,ZX_COMMA,0,ZX_A,ZX_L,ZX_I,ZX_COMMA,0,ZX_D,ZX_R,0,ZX_B,ZX_E,ZX_E,ZX_P,ZX_COMMA,0,ZX_M,ZX_A,ZX_T,ZX_T,ZX_H,ZX_I,ZX_A,ZX_S,ZX_COMMA,0
	DB ZX_H,ZX_O,ZX_L,ZX_M,ZX_A,ZX_T,ZX_I,ZX_C,0,0
	
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB $FF
	
	
NS_STEP:
	DB	2
NS_O_E
	DB	1	
NS_START:
	DW N_SCROLL_TEXT 

NSCHAR_STORE:
	DW	0
	

	DB 0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0,0,0
	DB 0
N_SCROLL_TEXT:
	DB 0,0,0,0,0,0,0,0,0,0
		
	
	DB ZX_Y,ZX_E,ZX_S,0,ZX_T,ZX_H,ZX_I,ZX_S,0,ZX_I,ZX_S,0,ZX_B,ZX_E,ZX_T,ZX_T,ZX_E,ZX_R,0,ZX_B,ZX_U,ZX_T,0,ZX_I,ZX_T,ZX_S,0,ZX_S,ZX_T,ZX_I,ZX_L,ZX_L,0,ZX_A,0,ZX_B,ZX_I,ZX_T,0,ZX_J,ZX_E,ZX_R,ZX_K,ZX_Y,0
	DB ZX_I,0,ZX_S,ZX_U,ZX_P,ZX_P,ZX_O,ZX_S,ZX_E,0,ZX_T,ZX_H,ZX_A,ZX_T,ZX_S,0,ZX_W,ZX_H,ZX_A,ZX_T,0,ZX_Y,ZX_O,ZX_U,0,ZX_G,ZX_E,ZX_T,0,ZX_W,ZX_H,ZX_E,ZX_N,0,ZX_Y,ZX_O,ZX_U,ZX_R,0,ZX_S,ZX_T,ZX_U,ZX_C,ZX_K,0
	DB ZX_I,ZX_N,0,ZX_T,ZX_E,ZX_X,ZX_T,0,ZX_O,ZX_N,ZX_L,ZX_Y,0,ZX_M,ZX_O,ZX_D,ZX_E,0
	DB 0,0
	DB ZX_I,0,ZX_W,ZX_A,ZX_N,ZX_T,ZX_E,ZX_D,0,ZX_T,ZX_O,0,ZX_S,ZX_E,ZX_E,0,ZX_W,ZX_H,ZX_A,ZX_T,0,ZX_C,ZX_R,ZX_A,ZX_Z,ZX_Y,0,ZX_T,ZX_H,ZX_I,ZX_N,ZX_G,ZX_S,0,ZX_Y,ZX_O,ZX_U,0,ZX_C,ZX_A,ZX_N,0,ZX_D,ZX_O,0
	DB ZX_W,ZX_I,ZX_T,ZX_H,0,ZX_J,ZX_U,ZX_S,ZX_T,0,ZX_T,ZX_E,ZX_X,ZX_T,0,ZX_A,ZX_N,ZX_D,0,ZX_S,ZX_O,ZX_M,ZX_E,0,ZX_C,ZX_L,ZX_E,ZX_V,ZX_E,ZX_R,0,ZX_P,ZX_R,ZX_O,ZX_G,ZX_R,ZX_A,ZX_M,ZX_M,ZX_I,ZX_N,ZX_G,0
	DB ZX_I,0,ZX_H,ZX_A,ZX_V,ZX_E,0,ZX_O,ZX_N,ZX_C,ZX_E,0,ZX_A,ZX_G,ZX_A,ZX_I,ZX_N,0,ZX_B,ZX_E,ZX_E,ZX_N,0,ZX_I,ZX_N,ZX_S,ZX_P,ZX_I,ZX_R,ZX_E,ZX_D,0,ZX_B,ZX_Y,0,ZX_S,ZX_O,ZX_M,ZX_E,0,ZX_O,ZX_F,0,ZX_T,ZX_H,ZX_E,0
	DB ZX_G,ZX_R,ZX_E,ZX_A,ZX_T,ZX_E,ZX_S,ZX_T,0,ZX_Z,ZX_E,ZX_D,ZX_D,ZX_Y,0,ZX_P,ZX_R,ZX_O,ZX_G,ZX_R,ZX_A,ZX_M,ZX_M,ZX_E,ZX_R,ZX_S,0,ZX_A,ZX_R,ZX_O,ZX_U,ZX_N,ZX_D,0
	DB ZX_S,ZX_O,0,ZX_W,ZX_I,ZX_T,ZX_H,0,ZX_T,ZX_H,ZX_I,ZX_S,0,ZX_I,ZX_N,0,ZX_M,ZX_I,ZX_N,ZX_D,0,ZX_I,ZX_T,ZX_S,0,ZX_T,ZX_I,ZX_M,ZX_E,0,ZX_F,ZX_O,ZX_R,ZX_PERIOD,ZX_PERIOD,ZX_PERIOD,ZX_PERIOD,ZX_PERIOD,0
	DB $FE,0,0,0,0,0,0,0,0,0
	
	DB $FF
	

QS_STEP:
	DB	2
QS_O_E
	DB	1	
QS_START:
	DW Q_SCROLL_TEXT 

QSCHAR_STORE:
	DW	0
	

	DB 0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0,0,0
	DB 0
Q_SCROLL_TEXT:
	DB 0,0,0,0,0,0,0,0,0,0
	DB ZX_A,ZX_N,ZX_O,ZX_T,ZX_H,ZX_E,ZX_R,0,ZX_S,ZX_C,ZX_R,ZX_O,ZX_L,ZX_L,0,ZX_A,ZX_N,ZX_D,0,ZX_S,ZX_T,ZX_I,ZX_L,ZX_L,0,ZX_I,ZX_T,ZX_S,0,ZX_N,ZX_O,ZX_T,0,ZX_W,ZX_O,ZX_R,ZX_K,ZX_I,ZX_N,ZX_G,0,ZX_A,ZX_S,0
	DB ZX_G,ZX_O,ZX_O,ZX_D,0,ZX_A,ZX_S,0,ZX_I,0,ZX_T,ZX_H,ZX_O,ZX_U,ZX_G,ZX_H,ZX_T,0,ZX_I,ZX_T,0,ZX_C,ZX_O,ZX_U,ZX_L,ZX_D,0,ZX_B,ZX_E,0
	
	DB ZX_T,ZX_H,ZX_E,ZX_N,0,ZX_T,ZX_H,ZX_E,ZX_R,ZX_E,0,ZX_I,ZX_S,0,ZX_O,ZX_N,ZX_L,ZX_Y,0,ZX_1,0,ZX_T,ZX_H,ZX_I,ZX_N,ZX_G,0,ZX_T,ZX_O,0,ZX_D,ZX_O,0,ZX_Y,ZX_E,ZX_S,0,ZX_Y,ZX_O,ZX_U,0,ZX_G,ZX_U,ZX_E,ZX_S,ZX_S,ZX_E,ZX_D,0
DB ZX_W,ZX_E,0,ZX_A,ZX_R,ZX_E,0,ZX_G,ZX_O,ZX_N,ZX_N,ZX_A,0,ZX_G,ZX_O,0,ZX_F,ZX_O,ZX_R,0,ZX_1,0,ZX_L,ZX_A,ZX_S,ZX_T,0,ZX_S,ZX_C,ZX_R,ZX_O,ZX_L,ZX_L,0
	DB ZX_O,ZX_K,ZX_SPC,ZX_H,ZX_E,ZX_R,ZX_E,ZX_SPC,ZX_G,ZX_O,ZX_E,ZX_S,ZX_SPC,ZX_N,ZX_O,ZX_T,ZX_H,ZX_I,ZX_N,ZX_G,ZX_PERIOD
	
	DB $FE,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB $FF
	
Q2S_STEP:
	DB	2
Q2S_O_E
	DB	1	
Q2S_START:
	DW Q2_SCROLL_TEXT 

Q2SCHAR_STORE:
	DW	0
	

	DB 0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0,0,0
	DB 0
Q2_SCROLL_TEXT:
	DB 0,0,0,0,0,0,0,0,0
	DB ZX_W,ZX_H,ZX_O,ZX_O,ZX_E,ZX_Y,0,ZX_I,0,ZX_M,ZX_A,ZX_D,ZX_E,0,ZX_I,ZX_T,0,ZX_I,0,ZX_M,ZX_A,ZX_D,ZX_E,0,ZX_I,ZX_T,0
	DB ZX_N,ZX_O,ZX_W,0,ZX_T,ZX_H,ZX_I,ZX_S,0,ZX_I,ZX_S,0,ZX_M,ZX_O,ZX_R,ZX_E,0,ZX_L,ZX_I,ZX_K,ZX_E,0,ZX_W,ZX_H,ZX_A,ZX_T,0
	DB ZX_I,0,ZX_W,ZX_A,ZX_N,ZX_T,ZX_E,ZX_D,0,ZX_A,0,ZX_V,ZX_E,ZX_R,ZX_Y,0,ZX_B,ZX_I,ZX_G,0
	DB ZX_H,ZX_E,ZX_L,ZX_L,ZX_O,0,ZX_T,ZX_O,0
	DB ZX_A,ZX_L,ZX_L,0,ZX_Z,ZX_E,ZX_D,ZX_D,ZX_Y,0,ZX_F,ZX_A,ZX_N,ZX_S,0,ZX_A,ZX_R,ZX_O,ZX_U,ZX_N,ZX_D,0
	DB ZX_T,ZX_H,ZX_E,0,ZX_W,ZX_O,ZX_R,ZX_L,ZX_D,ZX_PERIOD,0 
	DB ZX_A,ZX_L,ZX_L,0,ZX_C,ZX_O,ZX_D,ZX_I,ZX_N,ZX_G,0,ZX_B,ZX_Y,0,ZX_A,ZX_N,ZX_D,ZX_Y,0,ZX_R,ZX_E,ZX_A,0,ZX_M,ZX_U,ZX_S,ZX_I,ZX_C,0,ZX_B,ZX_Y,0,ZX_Y,ZX_E,ZX_R,ZX_Z,ZX_M,ZX_Y,ZX_E,ZX_Y,ZX_PERIOD,0

	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB $FF
	
	
	
;MUSIC FILE. 

STC:
	
	DB  $05,$5C,$04,$93,$04,$FE,$05,$53,$4F,$4E,$47,$20,$42,$59,$20,$53 ;.\...SONG BY S
	DB  $54,$20,$43,$4F,$4D,$50,$49,$4C,$45,$A9,$12,$03,$0F,$00,$00,$0F ;T COMPILE......
	DB  $00,$00,$0F,$00,$00,$0F,$00,$00,$0F,$00,$00,$0E,$00,$00,$0E,$00 ;................
	DB  $00,$0E,$00,$00,$0D,$00,$00,$0C,$00,$00,$0C,$00,$00,$0C,$00,$00 ;................
	DB  $0C,$00,$00,$0C,$00,$00,$0C,$00,$00,$0C,$00,$00,$0C,$00,$00,$0B ;................
	DB  $00,$00,$0A,$00,$00,$0A,$00,$00,$0A,$00,$00,$09,$00,$00,$09,$00 ;................
	DB  $00,$08,$00,$00,$07,$00,$00,$07,$00,$00,$07,$00,$00,$07,$00,$00 ;................
	DB  $07,$00,$00,$07,$00,$00,$06,$00,$00,$04,$00,$00,$00,$00,$04,$2F ;.............../
	DB  $A0,$00,$4F,$A0,$00,$6F,$A0,$00,$8F,$A0,$00,$AE,$A0,$00,$CC,$A0 ;.O.o...̠
	DB  $00,$EA,$A0,$00,$E8,$A0,$97,$E6,$A0,$BA,$E4,$A0,$D8,$00,$80,$00 ;..蠗栺..
	DB  $00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00 ;...........
	DB  $80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80 ;..........
	DB  $00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00 ;...........
	DB  $00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00 ;...........
	DB  $00,$05,$0F,$20,$00,$0F,$26,$2F,$0D,$2C,$5E,$0C,$32,$8D,$0B,$38 ;... ..&/.,^.2.8
	DB  $BC,$0A,$3E,$EB,$19,$24,$1A,$18,$2A,$49,$16,$30,$78,$15,$36,$A7 ;.>.$..*I.0x.6
	DB  $14,$3C,$D6,$23,$22,$05,$22,$28,$34,$21,$2E,$63,$00,$00,$00,$00 ;.<#"."(4!.c....
	DB  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ;................
	DB  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ;................
	DB  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ;................
	DB  $00,$00,$00,$00,$07,$0F,$20,$00,$0E,$20,$00,$0E,$20,$00,$0E,$20 ;...... .. .. .. 
	DB  $00,$0D,$20,$00,$0C,$20,$00,$0B,$20,$00,$0A,$20,$00,$09,$20,$00 ;.. .. .. .. .. .
	DB  $09,$20,$00,$08,$20,$00,$08,$20,$00,$07,$20,$00,$07,$20,$00,$06 ;. .. .. .. .. ..
	DB  $20,$00,$06,$20,$00,$06,$20,$00,$05,$20,$00,$05,$20,$00,$05,$20 ; .. .. .. .. .. 
	DB  $00,$04,$20,$00,$04,$20,$00,$04,$20,$00,$04,$20,$00,$04,$20,$00 ;.. .. .. .. .. .
	DB  $03,$20,$00,$03,$20,$00,$02,$20,$00,$01,$20,$00,$00,$20,$00,$00 ;. .. .. .. .. ..
	DB  $20,$00,$00,$20,$00,$00,$00,$08,$0F,$80,$00,$0F,$80,$02,$0E,$80 ; .. .........
	DB  $04,$0C,$80,$02,$0A,$A0,$00,$08,$A0,$02,$06,$A0,$04,$06,$A0,$02 ;...........
	DB  $06,$80,$00,$06,$80,$02,$06,$80,$04,$06,$80,$02,$06,$A0,$00,$06 ;...........
	DB  $A0,$02,$06,$A0,$04,$06,$A0,$02,$06,$80,$00,$06,$80,$02,$06,$80 ;..........
	DB  $04,$06,$80,$02,$06,$A0,$00,$06,$A0,$02,$06,$A0,$04,$06,$A0,$02 ;...........
	DB  $06,$80,$00,$06,$80,$02,$06,$80,$04,$06,$80,$02,$06,$80,$00,$06 ;...........
	DB  $A0,$02,$06,$A0,$04,$06,$A0,$02,$00,$1D,$09,$0F,$80,$00,$0D,$80 ;...........
	DB  $00,$0D,$80,$00,$0D,$80,$01,$0D,$80,$01,$0C,$A0,$00,$0C,$A0,$00 ;...........
	DB  $0C,$A0,$01,$0C,$A0,$01,$0B,$80,$00,$0B,$80,$00,$0B,$80,$01,$0A ;...........
	DB  $80,$01,$09,$A0,$00,$09,$A0,$00,$08,$A0,$00,$08,$80,$00,$08,$80 ;..........
	DB  $00,$07,$80,$00,$06,$80,$00,$06,$80,$00,$06,$80,$00,$05,$80,$00 ;...........
	DB  $05,$80,$00,$05,$80,$00,$05,$80,$00,$04,$80,$00,$04,$80,$00,$04 ;...........
	DB  $80,$00,$03,$80,$00,$03,$80,$00,$02,$80,$00,$00,$00,$0A,$0B,$80 ;...........
	DB  $00,$0B,$80,$01,$0B,$80,$01,$0B,$80,$00,$0B,$80,$00,$0B,$80,$01 ;...........
	DB  $0B,$80,$00,$0B,$A0,$01,$0B,$A0,$01,$0B,$A0,$00,$0B,$A0,$00,$0B ;...........
	DB  $A0,$01,$0B,$80,$00,$0B,$80,$01,$0B,$80,$01,$0B,$80,$00,$0B,$80 ;..........
	DB  $00,$0B,$80,$01,$0B,$80,$00,$0B,$A0,$01,$0B,$A0,$01,$0B,$A0,$00 ;...........
	DB  $0B,$A0,$00,$0B,$A0,$01,$0B,$80,$00,$0B,$80,$01,$0B,$80,$01,$0B ;...........
	DB  $80,$00,$0B,$80,$00,$0B,$80,$01,$0B,$80,$00,$0B,$80,$00,$03,$05 ;...........
	DB  $0B,$0E,$00,$00,$0C,$80,$00,$0C,$80,$00,$0B,$80,$00,$0B,$80,$00 ;............
	DB  $0A,$80,$00,$09,$80,$00,$08,$80,$00,$06,$80,$00,$05,$80,$00,$05 ;...........
	DB  $80,$00,$04,$80,$00,$04,$80,$00,$03,$80,$00,$02,$80,$00,$02,$80 ;..........
	DB  $00,$01,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00 ;...........
	DB  $00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00 ;...........
	DB  $80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80 ;..........
	DB  $00,$00,$00,$0C,$0C,$80,$00,$0C,$A0,$00,$0C,$A0,$00,$0C,$A0,$00 ;............
	DB  $0C,$A0,$00,$0C,$A0,$00,$0C,$A0,$00,$0C,$A0,$00,$0C,$A0,$00,$0C ;...........
	DB  $A0,$00,$0C,$A0,$00,$0C,$A0,$00,$0C,$A0,$00,$0C,$A0,$00,$0C,$A0 ;..........
	DB  $00,$0C,$A0,$00,$0C,$A0,$00,$0C,$A0,$00,$0C,$A0,$00,$0C,$A0,$00 ;...........
	DB  $0C,$A0,$00,$0C,$A0,$00,$0C,$A0,$00,$0C,$A0,$00,$0C,$A0,$00,$0C ;...........
	DB  $A0,$00,$0C,$A0,$00,$0C,$A0,$00,$0C,$A0,$00,$0C,$A0,$00,$0C,$A0 ;..........
	DB  $00,$0C,$A0,$00,$03,$05,$0D,$0B,$80,$00,$09,$80,$00,$09,$80,$00 ;............
	DB  $08,$80,$00,$07,$80,$00,$07,$80,$00,$06,$80,$00,$05,$80,$00,$05 ;...........
	DB  $80,$00,$04,$80,$00,$03,$80,$00,$03,$80,$00,$02,$80,$00,$01,$80 ;..........
	DB  $00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00 ;...........
	DB  $00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00 ;...........
	DB  $80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80 ;..........
	DB  $00,$00,$80,$00,$00,$80,$00,$00,$00,$0E,$0C,$80,$00,$0B,$80,$00 ;............
	DB  $0B,$80,$00,$0A,$80,$00,$09,$80,$00,$09,$80,$00,$08,$80,$00,$07 ;...........
	DB  $80,$00,$06,$80,$00,$06,$80,$00,$05,$80,$00,$05,$80,$00,$04,$80 ;..........
	DB  $00,$04,$80,$00,$03,$80,$00,$03,$80,$00,$02,$80,$00,$01,$80,$00 ;...........
	DB  $00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00 ;...........
	DB  $80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80 ;..........
	DB  $00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$00,$1A,$02,$00,$03 ;.............
	DB  $00,$01,$00,$01,$00,$04,$00,$04,$00,$05,$00,$05,$00,$06,$00,$06 ;................
	DB  $00,$07,$00,$03,$00,$08,$00,$09,$00,$0A,$00,$09,$00,$0D,$00,$0E ;................
	DB  $00,$0B,$00,$0C,$00,$0B,$00,$0C,$00,$0F,$00,$10,$00,$0B,$00,$11 ;................
	DB  $00,$12,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ;................
	DB  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ;................
	DB  $00,$00,$00,$00,$02,$00,$03,$07,$00,$03,$07,$00,$03,$07,$00,$03 ;................
	DB  $07,$00,$03,$07,$00,$03,$07,$00,$03,$07,$00,$03,$07,$00,$03,$07 ;................
	DB  $00,$03,$07,$00,$03,$04,$00,$04,$07,$00,$04,$07,$00,$04,$07,$00 ;................
	DB  $04,$07,$00,$04,$07,$00,$04,$07,$00,$04,$07,$00,$04,$07,$00,$04 ;................
	DB  $07,$00,$04,$07,$00,$04,$06,$00,$0C,$F4,$0C,$00,$0C,$00,$0C,$00 ;...............
	DB  $0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00 ;................
	DB  $0C,$00,$0C,$00,$0C,$00,$0C,$08,$0C,$00,$00,$0C,$00,$00,$00,$00 ;................
	DB  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ;................
	DB  $00,$00,$00,$00,$00,$00,$00,$00,$09,$F4,$00,$00,$00,$00,$00,$00 ;...............
	DB  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ;................
	DB  $00,$00,$00,$00,$00,$00,$00,$00,$00,$0A,$18,$00,$00,$00,$00,$00 ;................
	DB  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ;................
	DB  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$0B,$00,$01,$02,$02,$03 ;................
	DB  $03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03 ;................
	DB  $03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$0D,$00,$00,$00,$01 ;................
	DB  $01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01 ;................
	DB  $01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$0E,$00,$00,$01 ;................
	DB  $01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02 ;................
	DB  $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$0F,$0C,$00 ;................
	DB  $0C,$00,$00,$0C,$00,$00,$0C,$00,$00,$00,$0C,$00,$00,$00,$0C,$00 ;................
	DB  $0C,$00,$0C,$00,$0C,$00,$0C,$0C,$00,$0C,$00,$0C,$00,$0C,$01,$7D ;...............}
	DB  $06,$ED,$06,$4B,$07,$02,$C5,$07,$CD,$07,$DC,$07,$03,$57,$08,$CD ;..K......W.
	DB  $07,$DC,$07,$04,$7D,$06,$78,$08,$E6,$08,$05,$63,$09,$D0,$09,$58 ;...}.x...c..X
	DB  $0A,$06,$63,$09,$E3,$0A,$73,$0B,$07,$F5,$0B,$CD,$07,$DC,$07,$08 ;..c..s......
	DB  $01,$0C,$71,$0C,$D0,$0C,$09,$01,$0C,$71,$0C,$FC,$0C,$0A,$28,$0D ;..q.....q...(.
	DB  $71,$0C,$42,$0D,$0B,$53,$0D,$C2,$0D,$5F,$0E,$0C,$C9,$0E,$37,$0F ;q.B..S.._...7.
	DB  $CF,$0F,$0D,$32,$10,$3E,$10,$4D,$10,$0E,$D0,$10,$0A,$11,$4D,$10 ;..2.>.M.....M.
	DB  $0F,$17,$11,$C2,$0D,$2B,$11,$10,$95,$11,$37,$0F,$CB,$11,$11,$C9 ;....+...7...
	DB  $0E,$37,$0F,$2E,$12,$12,$8C,$12,$96,$12,$9D,$12,$FF,$A1,$64,$70 ;.7.......dp
	DB  $2F,$68,$0C,$A2,$18,$A1,$64,$2F,$68,$0C,$A2,$18,$A1,$64,$2F,$68 ;/h..d/h..d/h
	DB  $0C,$18,$18,$64,$2F,$68,$0C,$A2,$18,$A1,$64,$2F,$68,$03,$A2,$0F ;...d/h..d/h..
	DB  $A1,$64,$2F,$68,$03,$A2,$0F,$A1,$64,$2F,$68,$03,$0F,$0F,$64,$2F ;d/h..d/h...d/
	DB  $68,$03,$A2,$0F,$A1,$64,$2F,$68,$08,$A2,$14,$A1,$64,$2F,$68,$08 ;h..d/h..d/h.
	DB  $A2,$14,$A1,$64,$2F,$68,$08,$14,$14,$64,$2F,$68,$08,$A2,$14,$A1 ;.d/h...d/h..
	DB  $64,$2F,$68,$05,$A2,$11,$A1,$64,$2F,$68,$05,$A2,$11,$A1,$64,$2F ;d/h..d/h..d/
	DB  $68,$05,$11,$11,$64,$2F,$68,$05,$64,$2F,$68,$11,$FF,$A2,$6B,$72 ;h...d/h.d/h.kr
	DB  $24,$24,$A3,$65,$70,$23,$A2,$6B,$72,$24,$24,$A1,$24,$A2,$65,$70 ;$$ep#kr$$$ep
	DB  $23,$23,$6B,$74,$27,$27,$A3,$65,$70,$23,$A2,$6B,$74,$27,$27,$A1 ;##kt''ep#kt''
	DB  $27,$A2,$65,$70,$23,$A1,$6B,$74,$27,$65,$70,$23,$A2,$6B,$74,$2C ;'ep#kt'ep#kt,
	DB  $2C,$A3,$65,$70,$23,$A2,$6B,$74,$2C,$2C,$A1,$2C,$A2,$65,$70,$23 ;,ep#kt,,,ep#
	DB  $23,$6B,$72,$29,$29,$A3,$65,$70,$23,$A2,$6B,$72,$29,$29,$A1,$29 ;#kr))ep#kr)))
	DB  $65,$70,$23,$23,$6B,$72,$29,$65,$70,$23,$FF,$A1,$69,$79,$33,$6D ;ep##kr)ep#iy3m
	DB  $32,$69,$2B,$6D,$33,$69,$33,$6D,$2B,$A2,$69,$32,$A1,$6D,$33,$32 ;2i+m3i3m+i2m32
	DB  $69,$32,$6D,$32,$A2,$69,$33,$A1,$6D,$32,$33,$69,$33,$6D,$33,$69 ;i2m2i3m23i3m3i
	DB  $2B,$6D,$33,$69,$33,$6D,$2B,$A2,$69,$32,$A1,$6D,$33,$32,$69,$32 ;+m3i3m+i2m32i2
	DB  $6D,$32,$69,$33,$6D,$32,$69,$32,$6D,$33,$69,$33,$6D,$32,$69,$2C ;m2i3m2i2m3i3m2i,
	DB  $6D,$33,$69,$33,$6D,$2C,$A2,$69,$32,$A1,$6D,$33,$32,$69,$32,$6D ;m3i3m,i2m32i2m
	DB  $32,$A2,$69,$33,$A1,$6D,$32,$A3,$33,$A2,$69,$35,$A1,$6D,$33,$35 ;2i3m23i5m35
	DB  $69,$2B,$6D,$35,$69,$35,$6D,$2B,$69,$2B,$6D,$35,$69,$33,$6D,$2B ;i+m5i5m+i+m5i3m+
	DB  $69,$32,$6D,$33,$FF,$B0,$6A,$70,$0C,$0F,$08,$05,$FF,$B0,$6A,$8E ;i2m3jp....j
	DB  $1E,$00,$8E,$19,$03,$8E,$25,$08,$8E,$2C,$05,$FF,$A1,$69,$70,$33 ;....%.,.ip3
	DB  $6D,$32,$69,$2B,$6D,$33,$69,$33,$6D,$2B,$A2,$69,$32,$A1,$6D,$33 ;m2i+m3i3m+i2m3
	DB  $32,$69,$32,$6D,$32,$A2,$69,$33,$A1,$6D,$32,$33,$69,$33,$6D,$33 ;2i2m2i3m23i3m3
	DB  $69,$2B,$6D,$33,$69,$33,$6D,$2B,$A2,$69,$32,$A1,$6D,$33,$32,$69 ;i+m3i3m+i2m32i
	DB  $32,$6D,$32,$69,$33,$6D,$32,$69,$32,$6D,$33,$69,$33,$6D,$32,$69 ;2m2i3m2i2m3i3m2i
	DB  $2C,$6D,$33,$69,$33,$6D,$2C,$A2,$69,$32,$A1,$6D,$33,$32,$69,$32 ;,m3i3m,i2m32i2
	DB  $6D,$32,$A2,$69,$33,$A1,$6D,$32,$A3,$33,$A2,$69,$79,$35,$A1,$6D ;m2i3m23iy5m
	DB  $33,$35,$69,$2B,$6D,$35,$69,$35,$6D,$2B,$69,$2B,$6D,$35,$69,$33 ;35i+m5i5m+i+m5i3
	DB  $6D,$2B,$69,$32,$6D,$33,$FF,$B0,$6A,$70,$0C,$0F,$08,$A1,$64,$2F ;m+i2m3jp...d/
	DB  $A3,$6A,$05,$A1,$64,$2F,$A3,$6A,$05,$A1,$64,$2F,$A3,$6A,$05,$A1 ;j.d/j.d/j.
	DB  $64,$2F,$6A,$05,$64,$2F,$2F,$FF,$A2,$6B,$72,$24,$A1,$24,$24,$A2 ;d/j.d//kr$$$
	DB  $65,$70,$23,$A1,$6B,$72,$24,$A2,$24,$24,$A1,$24,$A2,$65,$70,$23 ;ep#kr$$$$ep#
	DB  $23,$6B,$74,$27,$A1,$27,$27,$A2,$65,$70,$23,$A1,$6B,$74,$27,$A2 ;#kt'''ep#kt'
	DB  $27,$27,$A1,$27,$A2,$65,$70,$23,$A1,$6B,$74,$27,$65,$70,$23,$A2 ;'''ep#kt'ep#
	DB  $6B,$74,$2C,$A1,$2C,$2C,$A2,$65,$70,$23,$A1,$6B,$74,$2C,$A2,$2C ;kt,,,ep#kt,,
	DB  $2C,$A1,$2C,$A2,$65,$70,$23,$23,$6B,$72,$29,$A1,$29,$29,$A2,$65 ;,,ep##kr)))e
	DB  $70,$23,$A1,$6B,$72,$29,$A2,$29,$29,$A1,$29,$65,$70,$23,$6B,$72 ;p#kr))))ep#kr
	DB  $29,$65,$70,$23,$23,$FF,$A1,$69,$79,$37,$6D,$35,$69,$30,$6D,$37 ;)ep##iy7m5i0m7
	DB  $69,$37,$6D,$30,$A2,$69,$35,$A1,$6D,$37,$33,$69,$35,$6D,$33,$A2 ;i7m0i5m73i5m3
	DB  $69,$37,$A1,$6D,$35,$33,$69,$37,$6D,$33,$69,$2E,$6D,$37,$69,$37 ;i7m53i7m3i.m7i7
	DB  $6D,$2E,$A2,$69,$35,$A1,$6D,$37,$33,$69,$35,$6D,$33,$69,$33,$6D ;m.i5m73i5m3i3m
	DB  $35,$69,$32,$6D,$33,$69,$33,$6D,$32,$69,$2C,$6D,$33,$69,$33,$6D ;5i2m3i3m2i,m3i3m
	DB  $2C,$A2,$69,$32,$A1,$6D,$33,$30,$69,$32,$6D,$30,$A2,$69,$33,$A1 ;,i2m30i2m0i3
	DB  $6D,$32,$33,$69,$33,$6D,$2C,$69,$29,$6D,$33,$69,$33,$6D,$35,$A2 ;m23i3m,i)m3i3m5
	DB  $69,$32,$A1,$6D,$2C,$69,$33,$32,$6D,$33,$69,$30,$6D,$32,$69,$2E ;i2m,i32m3i0m2i.
	DB  $6D,$30,$FF,$A1,$64,$2F,$68,$0C,$A2,$18,$A1,$64,$2F,$68,$0C,$A2 ;m0d/h..d/h.
	DB  $18,$A1,$64,$2F,$68,$0C,$18,$18,$64,$2F,$68,$0C,$A2,$18,$A1,$64 ;.d/h...d/h..d
	DB  $2F,$68,$05,$A2,$11,$A1,$64,$2F,$68,$05,$A2,$11,$A1,$64,$2F,$68 ;/h..d/h..d/h
	DB  $05,$11,$11,$64,$2F,$68,$05,$11,$64,$2F,$2F,$68,$08,$A2,$14,$A1 ;...d/h..d//h..
	DB  $64,$2F,$68,$08,$A2,$14,$A1,$64,$2F,$68,$08,$14,$14,$64,$2F,$68 ;d/h..d/h...d/h
	DB  $08,$A2,$14,$A1,$64,$2F,$68,$0A,$A2,$16,$A1,$64,$2F,$68,$0A,$A2 ;..d/h..d/h.
	DB  $16,$A1,$64,$2F,$68,$0A,$16,$16,$64,$2F,$68,$0A,$16,$64,$2F,$FF ;.d/h...d/h..d/
	DB  $A2,$6B,$72,$24,$67,$24,$A1,$65,$70,$23,$6B,$72,$24,$67,$24,$A2 ;kr$g$ep#kr$g$
	DB  $6B,$24,$A1,$24,$67,$24,$6B,$24,$65,$70,$23,$6B,$72,$24,$A2,$67 ;k$$g$k$ep#kr$g
	DB  $24,$6B,$29,$67,$29,$A1,$65,$70,$23,$6B,$72,$29,$67,$29,$A2,$6B ;$k)g)ep#kr)g)k
	DB  $29,$A1,$65,$70,$23,$67,$72,$29,$6B,$29,$65,$70,$23,$6B,$72,$29 ;)ep#gr)k)ep#kr)
	DB  $A2,$67,$29,$6B,$74,$2C,$67,$2C,$A1,$65,$70,$23,$6B,$74,$2C,$67 ;g)kt,g,ep#kt,g
	DB  $2C,$A2,$6B,$2C,$A1,$2C,$67,$2C,$6B,$2C,$65,$70,$23,$6B,$74,$2C ;,k,,g,k,ep#kt,
	DB  $A2,$67,$2C,$6B,$2E,$67,$2E,$A1,$65,$70,$23,$6B,$74,$2E,$67,$2E ;g,k.g.ep#kt.g.
	DB  $A2,$6B,$2E,$A1,$65,$70,$23,$A2,$67,$74,$2E,$A1,$65,$70,$23,$6B ;k.ep#gt.ep#k
	DB  $74,$2E,$67,$2E,$65,$70,$23,$FF,$A2,$69,$7D,$29,$A1,$70,$29,$6D ;t.g.ep#i})p)m
	DB  $7D,$29,$69,$70,$27,$6D,$29,$69,$29,$6D,$27,$69,$27,$6D,$29,$69 ;})ip'm)i)m'i'm)i
	DB  $24,$6D,$27,$A2,$69,$7D,$29,$A1,$70,$29,$6D,$7D,$29,$69,$70,$27 ;$m'i})p)m})ip'
	DB  $6D,$29,$A2,$69,$7D,$29,$A1,$70,$29,$6D,$29,$69,$27,$6D,$29,$69 ;m)i})p)m)i'm)i
	DB  $24,$6D,$27,$69,$22,$6D,$24,$69,$24,$6D,$22,$69,$27,$6D,$24,$A2 ;$m'i"m$i$m"i'm$
	DB  $69,$7E,$2E,$A1,$70,$2B,$6D,$7E,$2E,$69,$70,$2E,$6D,$2B,$69,$30 ;i~.p+m~.ip.m+i0
	DB  $6D,$2E,$69,$2B,$6D,$30,$69,$2E,$6D,$2B,$69,$30,$6D,$2E,$69,$33 ;m.i+m0i.m+i0m.i3
	DB  $6D,$30,$69,$35,$6D,$33,$69,$36,$6D,$35,$69,$35,$6D,$36,$69,$33 ;m0i5m3i6m5i5m6i3
	DB  $6D,$35,$69,$30,$6D,$33,$69,$2E,$6D,$30,$69,$30,$6D,$2E,$69,$33 ;m5i0m3i.m0i0m.i3
	DB  $6D,$30,$FF,$A2,$6B,$72,$24,$67,$24,$A1,$65,$70,$23,$6B,$72,$24 ;m0kr$g$ep#kr$
	DB  $67,$24,$A2,$6B,$24,$A1,$24,$67,$24,$6B,$24,$65,$70,$23,$6B,$72 ;g$k$$g$k$ep#kr
	DB  $24,$A2,$67,$24,$6B,$29,$67,$29,$A1,$65,$70,$23,$6B,$72,$29,$67 ;$g$k)g)ep#kr)g
	DB  $29,$A2,$6B,$29,$A1,$65,$70,$23,$67,$72,$29,$6B,$29,$65,$70,$23 ;)k)ep#gr)k)ep#
	DB  $6B,$72,$29,$67,$29,$65,$70,$23,$A2,$6B,$74,$2C,$67,$2C,$A1,$65 ;kr)g)ep#kt,g,e
	DB  $70,$23,$6B,$74,$2C,$67,$2C,$A2,$6B,$2C,$A1,$2C,$67,$2C,$6B,$2C ;p#kt,g,k,,g,k,
	DB  $65,$70,$23,$6B,$74,$2C,$A2,$67,$2C,$A1,$6B,$2E,$65,$70,$23,$A2 ;ep#kt,g,k.ep#
	DB  $67,$74,$2E,$A1,$65,$70,$23,$6B,$74,$2E,$67,$2E,$A2,$6B,$2E,$A1 ;gt.ep#kt.g.k.
	DB  $65,$70,$23,$A2,$67,$74,$2E,$A1,$65,$70,$23,$6B,$74,$2E,$65,$70 ;ep#gt.ep#kt.ep
	DB  $23,$23,$FF,$A3,$69,$24,$A1,$6D,$27,$A3,$69,$24,$A2,$6E,$24,$A1 ;##i$m'i$n$
	DB  $6D,$24,$69,$22,$6D,$24,$69,$24,$6D,$22,$A3,$69,$7B,$24,$A1,$6D ;m$i"m$i$m"i{$m
	DB  $24,$69,$70,$24,$6D,$7B,$24,$69,$70,$22,$6D,$24,$69,$24,$6D,$22 ;$ip$m{$ip"m$i$m"
	DB  $A2,$69,$7B,$24,$A1,$70,$29,$6D,$7B,$24,$69,$70,$2B,$6D,$29,$69 ;i{$p)m{$ip+m)i
	DB  $2E,$6D,$2B,$A2,$69,$30,$A1,$6D,$2E,$30,$A3,$69,$30,$A2,$6E,$30 ;.m+i0m.0i0n0
	DB  $A1,$6D,$30,$69,$2E,$6D,$30,$69,$30,$6D,$2E,$A3,$69,$7B,$30,$A1 ;m0i.m0i0m.i{0
	DB  $6D,$30,$69,$70,$30,$6D,$7B,$30,$69,$70,$2E,$6D,$30,$69,$30,$6D ;m0ip0m{0ip.m0i0m
	DB  $2E,$A2,$69,$7B,$30,$A1,$70,$35,$6D,$7B,$30,$69,$70,$33,$6D,$35 ;.i{0p5m{0ip3m5
	DB  $69,$30,$6D,$33,$FF,$A1,$64,$70,$2F,$AF,$6A,$0C,$B0,$0F,$08,$05 ;i0m3dp/j....
	DB  $FF,$A1,$64,$70,$2F,$68,$0C,$A2,$18,$A1,$64,$2F,$68,$0C,$A2,$18 ;dp/h..d/h..
	DB  $A1,$64,$2F,$68,$0C,$18,$18,$64,$2F,$68,$0C,$A2,$18,$A1,$64,$2F ;d/h...d/h..d/
	DB  $68,$08,$A2,$14,$A1,$64,$2F,$68,$08,$A2,$14,$A1,$64,$2F,$68,$08 ;h..d/h..d/h.
	DB  $14,$14,$64,$2F,$68,$08,$64,$2F,$68,$14,$64,$2F,$68,$0A,$A2,$16 ;..d/h.d/h.d/h..
	DB  $A1,$64,$2F,$68,$0A,$A2,$16,$A1,$64,$2F,$68,$0A,$16,$16,$64,$2F ;d/h..d/h...d/
	DB  $68,$0A,$A2,$16,$A1,$64,$2F,$68,$05,$A2,$11,$A1,$64,$2F,$68,$05 ;h..d/h..d/h.
	DB  $A2,$11,$A1,$64,$2F,$68,$05,$11,$11,$64,$2F,$68,$05,$11,$64,$2F ;.d/h...d/h..d/
	DB  $FF,$A2,$6B,$72,$24,$67,$24,$65,$70,$23,$6B,$72,$24,$24,$67,$24 ;kr$g$ep#kr$$g$
	DB  $65,$70,$23,$67,$72,$24,$6B,$74,$2C,$67,$2C,$65,$70,$23,$6B,$74 ;ep#gr$kt,g,ep#kt
	DB  $2C,$2C,$67,$2C,$65,$70,$23,$67,$74,$2C,$6B,$2E,$67,$2E,$65,$70 ;,,g,ep#gt,k.g.ep
	DB  $23,$6B,$74,$2E,$2E,$67,$2E,$65,$70,$23,$67,$74,$2E,$A1,$6B,$72 ;#kt..g.ep#gt.kr
	DB  $29,$65,$23,$A2,$67,$29,$65,$70,$23,$6B,$72,$29,$A1,$29,$65,$70 ;)e#g)ep#kr))ep
	DB  $23,$A2,$67,$72,$29,$65,$70,$23,$A1,$67,$72,$29,$65,$70,$23,$FF ;#gr)ep#gr)ep#
	DB  $A6,$6C,$7F,$2B,$6A,$2B,$A2,$6C,$29,$6A,$29,$6C,$27,$6A,$27,$6C ;l+j+l)j)l'j'l
	DB  $26,$6A,$26,$6C,$24,$6A,$24,$6C,$22,$6A,$22,$A6,$6C,$26,$6A,$26 ;&j&l$j$l"j"l&j&
	DB  $A2,$6C,$22,$6A,$22,$A6,$6C,$20,$AA,$6A,$20,$FF,$A6,$6C,$7F,$2B ;l"j"l j l+
	DB  $6A,$2B,$A2,$6C,$29,$6A,$29,$6C,$27,$6A,$27,$6C,$26,$6A,$26,$6C ;j+l)j)l'j'l&j&l
	DB  $24,$6A,$24,$6C,$22,$6A,$22,$A6,$6C,$26,$6A,$26,$A2,$6C,$27,$6A ;$j$l"j"l&j&l'j
	DB  $27,$A6,$6C,$24,$AA,$6A,$24,$FF,$A1,$64,$70,$2F,$CF,$69,$0C,$A1 ;'l$j$dp/i.
	DB  $65,$23,$80,$23,$23,$80,$23,$23,$23,$23,$80,$23,$23,$80,$23,$23 ;e###########
	DB  $80,$FF,$AC,$6A,$7F,$2B,$A4,$29,$27,$26,$24,$22,$AC,$26,$A4,$22 ;j+)'&$"&"
	DB  $B0,$20,$FF,$A1,$64,$70,$2F,$68,$0F,$A2,$1B,$A1,$64,$2F,$68,$0F ; dp/h..d/h.
	DB  $A2,$1B,$A1,$64,$2F,$68,$0F,$1B,$1B,$64,$2F,$68,$0F,$A2,$1B,$A1 ;.d/h...d/h..
	DB  $64,$2F,$68,$05,$A2,$11,$A1,$64,$2F,$68,$05,$A2,$11,$A1,$64,$2F ;d/h..d/h..d/
	DB  $68,$05,$11,$11,$64,$2F,$68,$05,$A2,$11,$A1,$64,$2F,$68,$07,$A2 ;h...d/h..d/h.
	DB  $13,$A1,$64,$2F,$68,$07,$A2,$13,$A1,$64,$2F,$68,$07,$13,$13,$64 ;.d/h..d/h...d
	DB  $2F,$68,$07,$A2,$13,$A1,$64,$2F,$68,$0C,$A2,$18,$A1,$64,$2F,$68 ;/h..d/h..d/h
	DB  $0C,$A2,$18,$A1,$64,$2F,$68,$0C,$18,$18,$64,$2F,$68,$0C,$18,$64 ;..d/h...d/h..d
	DB  $2F,$FF,$A1,$6B,$74,$27,$27,$67,$27,$6A,$27,$65,$70,$23,$6B,$74 ;/kt''g'j'ep#kt
	DB  $27,$67,$27,$65,$70,$23,$6B,$74,$27,$65,$70,$23,$67,$74,$27,$6A ;'g'ep#kt'ep#gt'j
	DB  $27,$65,$70,$23,$6B,$74,$27,$67,$27,$6A,$27,$6B,$29,$29,$67,$29 ;'ep#kt'g'j'k))g)
	DB  $6A,$29,$65,$70,$23,$6B,$74,$29,$67,$29,$65,$70,$23,$6B,$74,$29 ;j)ep#kt)g)ep#kt)
	DB  $65,$70,$23,$67,$74,$29,$6A,$29,$65,$70,$23,$6B,$74,$29,$65,$70 ;ep#gt)j)ep#kt)ep
	DB  $23,$23,$6B,$72,$2B,$2B,$67,$2B,$6A,$2B,$65,$70,$23,$6B,$72,$2B ;##kr++g+j+ep#kr+
	DB  $67,$2B,$65,$70,$23,$6B,$72,$2B,$65,$70,$23,$67,$72,$2B,$6A,$2B ;g+ep#kr+ep#gr+j+
	DB  $65,$70,$23,$6B,$72,$2B,$67,$2B,$6A,$2B,$6B,$24,$24,$65,$70,$23 ;ep#kr+g+j+k$$ep#
	DB  $6A,$72,$24,$65,$70,$23,$23,$67,$72,$24,$6A,$24,$65,$70,$23,$23 ;jr$ep##gr$j$ep##
	DB  $23,$6A,$72,$24,$65,$70,$23,$6B,$72,$24,$65,$70,$23,$23,$FF,$A2 ;#jr$ep#kr$ep##
	DB  $69,$79,$2B,$6E,$29,$69,$32,$6E,$2B,$A1,$69,$30,$6E,$32,$69,$32 ;iy+n)i2n+i0n2i2
	DB  $6E,$30,$69,$2E,$6E,$32,$A2,$69,$2B,$6E,$2E,$69,$32,$6E,$2B,$A1 ;n0i.n2i+n.i2n+
	DB  $69,$32,$6E,$29,$69,$30,$6E,$32,$69,$32,$6E,$30,$69,$2E,$6E,$32 ;i2n)i0n2i2n0i.n2
	DB  $69,$32,$6E,$2E,$A2,$69,$2B,$6E,$32,$69,$32,$6E,$2B,$A1,$69,$30 ;i2n.i+n2i2n+i0
	DB  $6E,$2B,$69,$32,$6E,$30,$69,$2E,$6E,$32,$A2,$69,$2B,$6E,$2E,$69 ;n+i2n0i.n2i+n.i
	DB  $32,$6E,$2B,$A1,$69,$32,$6E,$30,$69,$30,$6E,$32,$69,$32,$6E,$30 ;2n+i2n0i0n2i2n0
	DB  $69,$2E,$6E,$32,$69,$2D,$6E,$2E,$FF,$A1,$64,$70,$2F,$68,$0F,$A2 ;i.n2i-n.dp/h.
	DB  $1B,$A1,$64,$2F,$68,$0F,$A2,$1B,$A1,$64,$2F,$68,$0F,$1B,$1B,$64 ;.d/h..d/h...d
	DB  $2F,$68,$0F,$A2,$1B,$A1,$64,$2F,$68,$05,$A2,$11,$A1,$64,$2F,$68 ;/h..d/h..d/h
	DB  $05,$A2,$11,$A1,$64,$2F,$68,$05,$11,$11,$64,$2F,$68,$05,$11,$64 ;..d/h...d/h..d
	DB  $2F,$2F,$68,$07,$A2,$13,$A1,$64,$2F,$68,$07,$A2,$13,$A1,$64,$2F ;//h..d/h..d/
	DB  $68,$07,$13,$13,$64,$2F,$68,$07,$A2,$13,$A1,$64,$2F,$68,$07,$A2 ;h...d/h..d/h.
	DB  $13,$A1,$64,$2F,$68,$07,$A2,$13,$A1,$64,$2F,$68,$07,$13,$13,$64 ;.d/h..d/h...d
	DB  $2F,$68,$07,$13,$64,$2F,$FF,$A1,$6B,$74,$27,$27,$67,$27,$6A,$27 ;/h..d/kt''g'j'
	DB  $65,$70,$23,$6B,$74,$27,$67,$27,$6A,$27,$6B,$27,$27,$67,$27,$6A ;ep#kt'g'j'k''g'j
	DB  $27,$65,$70,$23,$6B,$74,$27,$67,$27,$6A,$27,$6B,$29,$65,$70,$23 ;'ep#kt'g'j'k)ep#
	DB  $67,$74,$29,$6A,$29,$65,$70,$23,$6B,$74,$29,$67,$29,$6A,$29,$6B ;gt)j)ep#kt)g)j)k
	DB  $29,$29,$65,$70,$23,$6A,$74,$29,$6B,$29,$29,$65,$70,$23,$6A,$74 ;))ep#jt)k))ep#jt
	DB  $29,$6B,$72,$2B,$2B,$67,$2B,$6A,$2B,$65,$70,$23,$6B,$72,$2B,$67 ;)kr++g+j+ep#kr+g
	DB  $2B,$6A,$2B,$6B,$2B,$2B,$67,$2B,$6A,$2B,$65,$70,$23,$6B,$72,$2B ;+j+k++g+j+ep#kr+
	DB  $67,$2B,$6A,$2B,$65,$70,$23,$6B,$72,$2B,$65,$70,$23,$6A,$72,$2B ;g+j+ep#kr+ep#jr+
	DB  $65,$70,$23,$23,$67,$72,$2B,$65,$70,$23,$23,$6B,$72,$2B,$65,$70 ;ep##gr+ep##kr+ep
	DB  $23,$6A,$72,$2B,$65,$70,$23,$6B,$72,$2B,$65,$70,$23,$23,$FF,$A2 ;#jr+ep#kr+ep##
	DB  $69,$79,$2B,$6E,$29,$69,$32,$6E,$2B,$A1,$69,$30,$6E,$32,$69,$32 ;iy+n)i2n+i0n2i2
	DB  $6E,$30,$69,$2E,$6E,$32,$A2,$69,$2B,$6E,$2E,$69,$32,$6E,$2B,$A1 ;n0i.n2i+n.i2n+
	DB  $69,$32,$6E,$29,$69,$30,$6E,$32,$69,$32,$6E,$30,$69,$2E,$6E,$32 ;i2n)i0n2i2n0i.n2
	DB  $69,$2D,$6E,$2E,$A2,$69,$2B,$6E,$2B,$6D,$2B,$A1,$65,$70,$2B,$2B ;i-n.i+n+m+ep++
	DB  $69,$80,$65,$28,$28,$A2,$6E,$80,$A1,$65,$23,$69,$80,$65,$1E,$69 ;ie((ne#ie.i
	DB  $76,$1F,$21,$22,$26,$22,$24,$26,$29,$26,$29,$2B,$2E,$2B,$2E,$30 ;v.!"&"$&)&)+.+.0
	DB  $32,$FF,$A1,$64,$70,$2F,$AF,$6A,$0F,$B0,$11,$13,$0C,$FF,$B0,$6A ;2dp/j....j
	DB  $8E,$32,$03,$8E,$2E,$05,$8E,$27,$07,$8E,$3A,$00,$FF,$A1,$6E,$70 ;2...'.:.np
	DB  $33,$6D,$32,$6E,$37,$6D,$33,$6E,$3A,$6D,$37,$6E,$3F,$6D,$3A,$6E ;3m2n7m3n:m7n?m:n
	DB  $33,$6D,$3F,$6E,$37,$6D,$33,$6E,$3A,$6D,$37,$6E,$3F,$6D,$3A,$6E ;3m?n7m3n:m7n?m:n
	DB  $35,$6D,$3F,$6E,$39,$6D,$35,$6E,$3C,$6D,$39,$6E,$41,$6D,$3C,$6E ;5m?n9m5n<m9nAm<n
	DB  $35,$6D,$41,$6E,$39,$6D,$35,$6E,$3C,$6D,$39,$6E,$41,$6D,$3C,$6E ;5mAn9m5n<m9nAm<n
	DB  $3E,$6D,$41,$6E,$37,$6D,$3E,$6E,$3C,$6D,$37,$6E,$37,$6D,$3C,$6E ;>mAn7m>n<m7n7m<n
	DB  $3A,$6D,$37,$6E,$39,$6D,$3A,$6E,$37,$6D,$39,$6E,$35,$6D,$37,$6E ;:m7n9m:n7m9n5m7n
	DB  $3E,$6D,$35,$6E,$37,$6D,$3E,$6E,$3C,$6D,$37,$6E,$37,$6D,$3C,$6E ;>m5n7m>n<m7n7m<n
	DB  $3A,$6D,$37,$6E,$39,$6D,$3A,$6E,$3A,$6D,$39,$6E,$3C,$6D,$3A,$FF ;:m7n9m:n:m9n<m:
	DB  $B0,$6A,$70,$0F,$11,$A1,$64,$2F,$A3,$6A,$13,$A1,$64,$2F,$A3,$6A ;jp..d/j.d/j
	DB  $13,$A1,$64,$2F,$A3,$6A,$13,$A1,$64,$2F,$6A,$13,$64,$2F,$6A,$13 ;.d/j.d/j.d/j.
	DB  $64,$2F,$A3,$6A,$13,$A1,$64,$2F,$A3,$6A,$13,$A1,$64,$2F,$A3,$6A ;d/j.d/j.d/j
	DB  $13,$A1,$64,$2F,$6A,$13,$64,$2F,$2F,$FF,$B0,$6A,$8E,$32,$03,$8E ;.d/j.d//j2.
	DB  $2E,$05,$C0,$8E,$27,$07,$FF,$A1,$64,$70,$2F,$AF,$6A,$8E,$32,$03 ;..'.dp/j2.
	DB  $B0,$8E,$2E,$05,$8E,$27,$07,$8E,$3A,$00,$FF,$A2,$69,$78,$2B,$6E ;..'.:.ix+n
	DB  $29,$69,$32,$6E,$2B,$A1,$69,$30,$6E,$32,$69,$32,$6E,$30,$69,$2E ;)i2n+i0n2i2n0i.
	DB  $6E,$32,$A2,$69,$2B,$6E,$2E,$69,$32,$6E,$2B,$A1,$69,$32,$6E,$29 ;n2i+n.i2n+i2n)
	DB  $69,$30,$6E,$32,$69,$32,$6E,$30,$69,$2E,$6E,$32,$69,$32,$6E,$2E ;i0n2i2n0i.n2i2n.
	DB  $A2,$69,$2B,$6E,$32,$69,$32,$6E,$2B,$A1,$69,$30,$6E,$2B,$69,$32 ;i+n2i2n+i0n+i2
	DB  $6E,$30,$69,$2E,$6E,$32,$A2,$69,$2B,$6E,$2E,$69,$32,$6E,$2B,$A1 ;n0i.n2i+n.i2n+
	DB  $69,$32,$6E,$30,$69,$30,$6E,$32,$69,$32,$6E,$30,$69,$2E,$6E,$32 ;i2n0i0n2i2n0i.n2
	DB  $69,$2D,$6E,$2E,$FF,$B0,$6A,$8E,$32,$03,$8E,$2E,$05,$8E,$27,$07 ;i-n.j2...'.
	DB  $A1,$64,$70,$2F,$A3,$6A,$8E,$27,$07,$A1,$64,$70,$2F,$A3,$6A,$8E ;dp/j'.dp/j
	DB  $27,$07,$A1,$64,$70,$2F,$A3,$6A,$8E,$27,$07,$A1,$64,$70,$2F,$6A ;'.dp/j'.dp/j
	DB  $8E,$27,$07,$64,$70,$2F,$6A,$8E,$27,$07,$FF,$A2,$69,$7A,$2B,$6E ;'.dp/j'.iz+n
	DB  $29,$69,$32,$6E,$2B,$A1,$69,$30,$6E,$32,$69,$32,$6E,$30,$69,$2E ;)i2n+i0n2i2n0i.
	DB  $6E,$32,$A2,$69,$2B,$6E,$2E,$69,$32,$6E,$2B,$A1,$69,$32,$6E,$29 ;n2i+n.i2n+i2n)
	DB  $69,$30,$6E,$32,$69,$32,$6E,$30,$69,$2E,$6E,$32,$69,$2D,$6E,$2E ;i0n2i2n0i.n2i-n.
	DB  $A2,$69,$2B,$6E,$2B,$6D,$2B,$A1,$65,$70,$2B,$2B,$69,$80,$65,$28 ;i+n+m+ep++ie(
	DB  $28,$A2,$6E,$80,$A1,$65,$23,$69,$80,$65,$1E,$69,$76,$1F,$21,$22 ;(ne#ie.iv.!"
	DB  $26,$22,$24,$26,$29,$26,$29,$2B,$2E,$2B,$2E,$30,$32,$FF,$A2,$69 ;&"$&)&)+.+.02i
	DB  $79,$2B,$6E,$29,$69,$32,$6E,$2B,$A1,$69,$30,$6E,$32,$69,$32,$6E ;y+n)i2n+i0n2i2n
	DB  $30,$69,$2E,$6E,$32,$A2,$69,$2B,$6E,$2E,$69,$32,$6E,$2B,$A1,$69 ;0i.n2i+n.i2n+i
	DB  $32,$6E,$29,$69,$30,$6E,$32,$69,$32,$6E,$30,$69,$2E,$6E,$32,$69 ;2n)i0n2i2n0i.n2i
	DB  $2D,$6E,$2E,$A2,$69,$2B,$6E,$2B,$AC,$6D,$2B,$A1,$69,$80,$65,$23 ;-n.i+n+m+ie#
	DB  $69,$80,$65,$23,$A2,$69,$80,$A1,$65,$23,$A2,$69,$80,$A1,$65,$23 ;ie#ie#ie#
	DB  $69,$80,$65,$23,$69,$80,$65,$23,$A2,$69,$80,$FF,$A1,$64,$70,$2F ;ie#ie#idp/
	DB  $B9,$69,$07,$C6,$80,$FF,$BA,$63,$72,$2B,$C6,$80,$FF,$A4,$69,$79 ;i.ƀcr+ƀiy
	DB  $2E,$6E,$2E,$B2,$6D,$2E,$C6,$80,$FF                  ;    .n.m.ƀ


; my code ends here

#INCLUDE ZX81END.ASM




