
// type defines

typedef unsigned char   u8;
typedef unsigned short  u16;
typedef unsigned long   u32;
typedef signed char		s8;
typedef signed short	s16;
typedef signed long		s32;
typedef s32				bool;

// defines

#define NULL                     0
#define true                     1
#define false                    0

#define BIT0                     (1)
#define BIT1                     (1<<1)
#define BIT2                     (1<<2)
#define BIT3                     (1<<3)
#define BIT4                     (1<<4)
#define BIT5                     (1<<5)
#define BIT6                     (1<<6)
#define BIT7                     (1<<7)
#define BIT8                     (1<<8)
#define BIT9                     (1<<9)
#define BIT10                    (1<<10)
#define BIT11                    (1<<11)
#define BIT12                    (1<<12)
#define BIT13                    (1<<13)
#define BIT14                    (1<<14)
#define BIT15                    (1<<15)
#define BIT16                    (1<<16)
#define BIT17                    (1<<17)
#define BIT18                    (1<<18)
#define BIT19                    (1<<19)
#define BIT20                    (1<<20)
#define BIT21                    (1<<21)
#define BIT22                    (1<<22)
#define BIT23                    (1<<23)
#define BIT24                    (1<<24)
#define BIT25                    (1<<25)
#define BIT26                    (1<<26)
#define BIT27                    (1<<27)
#define BIT28                    (1<<28)
#define BIT29                    (1<<29)
#define BIT30                    (1<<30)
#define BIT31                    (1<<31)

#define BITS2                    (BIT2 - 1)
#define BITS3                    (BIT3 - 1)
#define BITS4                    (BIT4 - 1)
#define BITS5                    (BIT5 - 1)
#define BITS6                    (BIT6 - 1)
#define BITS7                    (BIT7 - 1)
#define BITS8                    (BIT8 - 1)
#define BITS9                    (BIT9 - 1)
#define BITS10                   (BIT10 - 1)
#define BITS11                   (BIT11 - 1)
#define BITS12                   (BIT12 - 1)
#define BITS13                   (BIT13 - 1)
#define BITS14                   (BIT14 - 1)
#define BITS15                   (BIT15 - 1)
#define BITS16                   (BIT16 - 1)
#define BITS17                   (BIT17 - 1)
#define BITS18                   (BIT18 - 1)
#define BITS19                   (BIT19 - 1)
#define BITS20                   (BIT20 - 1)
#define BITS21                   (BIT21 - 1)
#define BITS22                   (BIT22 - 1)
#define BITS23                   (BIT23 - 1)
#define BITS24                   (BIT24 - 1)
#define BITS25                   (BIT25 - 1)
#define BITS26                   (BIT26 - 1)
#define BITS27                   (BIT27 - 1)
#define BITS28                   (BIT28 - 1)
#define BITS29                   (BIT29 - 1)
#define BITS30                   (BIT30 - 1)
#define BITS31                   (BIT31 - 1)
#define BITS32                   (BITS31 | BIT31)

// Registers

#define REG_DISP_CNT             (*(u16*)0x4000000)
#define REG_DISP_STAT            (*(u16*)0x4000004)
#define REG_DISP_MOSAIC          (*(u16*)0x400004C)
#define REG_SCANLINE_COUNT       (*(u16*)0x4000006)
#define REG_KEY                  (*(volatile u16*)0x4000130)

// Start of sprite palette

#define SPRITE_PALETTE        ((u16*)0x5000200)

// Start of screen palette

#define SCREEN_PALETTE        ((u16*)0x5000000)	

// Screen dimensions

#define SCREEN_WIDTH             240
#define SCREEN_HALF_WIDTH        (SCREEN_WIDTH / 2)
#define SCREEN_HEIGHT            160
#define SCREEN_HALF_HEIGHT       (SCREEN_HEIGHT / 2)

// Colors

#define RGB( r, g, b )           (((b)<<10)+((g)<<5)+(r))
#define RGB_GET_R( c )           (((c)&(31    ))    )
#define RGB_GET_G( c )           (((c)&(31<< 5))>> 5)
#define RGB_GET_B( c )           (((c)&(31<<10))>>10)

// Keypad

#define KEY_A_PRESSED            (!((REG_KEY) & (1<<0)))
#define KEY_B_PRESSED            (!((REG_KEY) & (1<<1)))
#define KEY_SELECT_PRESSED       (!((REG_KEY) & (1<<2)))
#define KEY_START_PRESSED        (!((REG_KEY) & (1<<3)))
#define KEY_RIGHT_PRESSED        (!((REG_KEY) & (1<<4)))
#define KEY_LEFT_PRESSED         (!((REG_KEY) & (1<<5)))
#define KEY_UP_PRESSED           (!((REG_KEY) & (1<<6)))
#define KEY_DOWN_PRESSED         (!((REG_KEY) & (1<<7)))
#define KEY_R_PRESSED            (!((REG_KEY) & (1<<8)))
#define KEY_L_PRESSED            (!((REG_KEY) & (1<<9)))

// Screen Modes

#define MODE_0                   0x0
#define MODE_1                   BIT0
#define MODE_2                   BIT1
#define MODE_3                   BIT0 | BIT1
#define MODE_4                   BIT2
#define MODE_5                   BIT0 | BIT2
#define BACKBUFFER               BIT4
#define H_BLANK_OAM              BIT5 
#define OBJ_MAP_2D               0x0
#define OBJ_MAP_1D               BIT6
#define FORCE_BLANK              BIT7
#define BG0_ENABLE               BIT8
#define BG1_ENABLE               BIT9 
#define BG2_ENABLE               BIT10
#define BG3_ENABLE               BIT11
#define OBJ_ENABLE               BIT12 
#define WIN1_ENABLE              BIT13 
#define WIN2_ENABLE              BIT14
#define WINOBJ_ENABLE            BIT15

#define SetMode(mode)            REG_DISP_CNT = (mode)


#define BGCOLOR_256				 (0x1<<7)
#define CHARMAP0				 (0x0<<8)
#define CHARMAP1				 (0x1<<8) 	
#define CHARMAP2				 (0x2<<8)	
#define CHARMAP3				 (0x3<<8)
#define CHARMAP4				 (0x4<<8)
#define CHARMAP5				 (0x5<<8)
#define CHARMAP6				 (0x6<<8)
#define CHARMAP7				 (0x7<<8)	
#define CHARMAP8				 (0x8<<8)


// Timer Related

#define FREQUENCY_0		0x0
#define FREQUENCY_64	BIT0
#define FREQUENCY_256	BIT1
#define FREQUENCY_1024	BIT0 | BIT1

#define TIMER_CASCADE	BIT2
#define TIMER_IRQ		BIT6
#define TIMER_ENABLE	BIT7
#define REG_TM0D       *(volatile u16*)0x4000100
#define REG_TM0CNT     *(volatile u16*)0x4000102
#define REG_TM1D       *(volatile u16*)0x4000104
#define REG_TM1CNT     *(volatile u16*)0x4000106
#define REG_TM2D       *(volatile u16*)0x4000108
#define REG_TM2CNT     *(volatile u16*)0x400010A
#define REG_TM3D       *(volatile u16*)0x400010C
#define REG_TM3CNT     *(volatile u16*)0x400010E

// Variable Defines


//////////////////////////////////////////////////////////////////////////////////////
//                                      End                                         //
//////////////////////////////////////////////////////////////////////////////////////
