#include <windows.h>
#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <math.h>

void main()
{
	int i, j, bmSize;
	char *tempString = new char[256];
	ofstream tableFile("image.txt");
	BYTE *dBuf, *bmpBuf, *sBuf, color, count;
	HBITMAP             hbm;
	BITMAP              bm;

	cout << "Enter image filename to compress: ";
	cin >> tempString;

	hbm = (HBITMAP)::LoadImage(NULL, tempString, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE|LR_CREATEDIBSECTION);

	if(!hbm)
		cout << "Failed to load image";

	// get size of the bitmap
	GetObject(hbm, sizeof(bm), &bm);

	if(bm.bmBitsPixel != 8 || bm.bmType)
	{
		DeleteObject(hbm);
		cout << "Not an 8-bit BMP";
	}

	bmSize = bm.bmWidth * bm.bmHeight;

	bmpBuf = new BYTE[bmSize];

	for(j = 0; j < bm.bmHeight; j++)
	{
		sBuf = (BYTE*)bm.bmBits + (j * bm.bmWidth);
		for(i = 0; i < bm.bmWidth; i++)
		{
			bmpBuf[i + (bm.bmHeight - 1 - j) * bm.bmWidth] = *sBuf++;
		}
	}

	dBuf = new BYTE[bmSize];

	for(i = 0, j = 0; i < bmSize;)
	{
		color = bmpBuf[i];
		count = 0;
		while((bmpBuf[i + count] == color) && (count < 15) && 
			((count + i) < (bmSize)))
			count++;

		dBuf[j] = (color & 15) | (count << 4);
		j++;
		i += count;
	}
	dBuf[j] = 0;

	DeleteObject(hbm);
	delete [] bmpBuf;

	for(i = 0; dBuf[i] != 0; i++)
	{
		if(!(i & 7))
			tableFile << "\n\t";
		tableFile << "0x" << itoa((int)(dBuf[i]), tempString, 16) << ',' << '\t';
	}
	tableFile << "0x00";
	tableFile.close();
	delete [] dBuf;
	delete [] tempString;
}