#ifndef __SM_DDRAW

#define __SM_DDRAW


namespace SM_DDraw
{
  struct TDisplay
  {
    HWND          m_hwnd;
    unsigned      m_uWidth;
    unsigned      m_uHeight;
    unsigned      m_uBPP;
    bool          m_bFullScreen;
    bool          m_bDoubleBuffer;
  };

  struct TPixelFormat
  {
    bool          m_bPalettized;
    unsigned      m_uBPP; 
    unsigned      m_uRBitMask,m_uRShiftLeft,m_uRShiftRight;
    unsigned      m_uGBitMask,m_uGShiftLeft,m_uGShiftRight;
    unsigned      m_uBBitMask,m_uBShiftLeft,m_uBShiftRight;
  };

  struct TLockData
  {
    void*         m_pSurfaceData;   // Puntero a superficie
    unsigned      m_uStride;        // Distancia en bytes de una  linea a otra
    unsigned      m_uWidth;
    unsigned      m_uHeight;
  };

  // Inicializacion
  int         Init                  ();
  int         Shutdown              ();

  int         InitDisplay           (const TDisplay& Display);
  int         ShutdownDisplay       ();

  // Runtime
  int         InitFrame             (bool& bRestored); 
  int         EndFrame              ();
  void        ToggleFullscreen      ();

  // Devuelve el pixel format de la superficie indicada
  int         PixelFormat           (bool bBackBuffer, TPixelFormat& PixelFormat);

  // lockea (permite acceso a la superficie indicada)
  int         Lock                  (bool bBackBuffer, TLockData& LockData);


  // unlockea (devuelve acceso a la superficie indicada)
  int         Unlock                (bool bBackBuffer);  

  int         SetPalette            (unsigned uFirstEntry, unsigned uEntries, unsigned* puEntries);

  // Printf guarro
  int _cdecl  Printf                (unsigned x, unsigned y, unsigned uColor, char* pcFormat, ...);
}

#endif