#include "SM_Engine3DPCH.h"
#include "MBStaticList.h"
#include "SM_ParticleSystem.h"

RenderParticleSystem::RenderParticleSystem()
{
    m_iShader=-1;
}


RenderParticleSystem::~RenderParticleSystem()
{
    Shutdown();
}

int RenderParticleSystem::Init()
{
    ParticleList.Init();
    
    return 0;
}

int RenderParticleSystem::Shutdown()
{
    m_iShader=-1;
    return 0;
}


void RenderParticleSystem::Render(RenderContext* pRenderContext, unsigned uOutcode)
{
    SM_D3d::SetRenderState(D3DRS_LIGHTING, FALSE);  
    SM_D3d::Device()->SetVertexShader(FVF_POSNORMALDIFFUSETEX1);    
    SM_D3d::Device()->SetTransform(D3DTS_WORLD, (D3DMATRIX*) &Matrix4X4::Identity);
    SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSU, D3DTADDRESS_CLAMP);
    SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSV, D3DTADDRESS_CLAMP);
    SM_D3d::SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);
    SM_D3d::SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);  
    SM_D3d::SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_POINT);
    SM_D3d::SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);                
    SM_D3d::SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
    SM_D3d::SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);  
    SM_D3d::SetRenderState(D3DRS_ZWRITEENABLE, FALSE);
    SM_D3d::SetRenderState(D3DRS_ZFUNC,    D3DCMP_ALWAYS);
    SM_D3d::SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);
     
    float fTime=Timer::GetTime();

    while (ParticleList.GetNumberElements()<200)
    {
      Particle p;
      p.v3dStart   =m_v3dSource;//Vector3D(0.0f, 0.0f, 10.0f);
      p.v3dVelocity=Vector3D(4.0f*((float(rand())/RAND_MAX)-0.5f), 4.0f*((float(rand())/RAND_MAX)-0.5f), 50.0f+rand()%10);
      p.fDeath     =fTime+1.0f+rand()%10;
      p.fBirth     =fTime;

      ParticleList.InsertTail(p);
    }
    
    Vector3D v3dRight=pRenderContext->m_VRP;
    Vector3D v3dUp   =pRenderContext->m_VUP;

    ShaderManager::GetShader(m_iShader)->SetShaderState(0);

    #define CHUNKSIZE 400
    unsigned uParticles=ParticleList.GetNumberElements();

    int i,j=0;
    unsigned uRendered=0;
    int iIterator=ParticleList.First();
    int iNext;

    if (iIterator!=-1)    
    while (j<uParticles)
    {
      unsigned uChunk=min(CHUNKSIZE, uParticles-uRendered);

      FVF_PosNormalDiffuseTex1* pVertex;
      unsigned short*           pusIndices;
      int                       iVertexOffset, iIndexOffset;        

      // Allocate VB and IB
      if ((iVertexOffset=ResourceManager::GiveVBChunk(ResourceManager::m_iPosNormalDiffuseTex1Stream, 3*CHUNKSIZE*sizeof(FVF_PosNormalDiffuseTex1), (void**)&pVertex))==-1)
      {
        assert(0);
        continue;
      }

      if ((iIndexOffset=ResourceManager::GiveIBChunk(ResourceManager::m_iIndexStream, 3*CHUNKSIZE*sizeof(unsigned short), (void**)&pusIndices))==-1)
      {
        assert(0);
        continue;
      }

      unsigned uLive=0;
      for (i=0 ; i<CHUNKSIZE ; i++)
      {
        iNext=ParticleList.Next(iIterator);  
        if (iNext==-1)
        {
          break;
        }

        Particle* pParticle;
        ParticleList.Get(iIterator, pParticle);

        if (fTime >= pParticle->fDeath)
        {
          ParticleList.Delete(iIterator);
        }
        else
        {
          float x,y,z;

          float fLive=fTime-pParticle->fBirth;

          Vector3D vpn=pRenderContext->m_VPN*50.0f;
          Vector3D vp =pRenderContext->GetViewport()->m_v3dPosition;
          x=vp.x+vpn.x;//+fLive*pParticle->v3dVelocity.x;
          y=vp.y+vpn.y;//+fLive*pParticle->v3dVelocity.y;
          z=vp.z+vpn.z;//+fLive*pParticle->v3dVelocity.z-fLive*fLive*9.8;

          //x=pParticle->v3dStart.x+fLive*pParticle->v3dVelocity.x;
          //y=pParticle->v3dStart.y+fLive*pParticle->v3dVelocity.y;
          //z=pParticle->v3dStart.z+fLive*pParticle->v3dVelocity.z-fLive*fLive*9.8;

          pVertex[0].x=x;     pVertex[0].y=y; pVertex[0].z=z;
          pVertex[0].nx=0.0f; pVertex[0].ny=0.0f; pVertex[0].ny=0.0f;
          pVertex[0].diffuse=0xFFFFFFFF; pVertex[0].u=0.0f;  pVertex[0].v=0.0f, 

          pVertex[1].x=x+v3dRight.x;     pVertex[1].y=y+v3dRight.y; pVertex[1].z=z+v3dRight.z;
          pVertex[1].nx=0.0f; pVertex[1].ny=0.0f; pVertex[1].ny=0.0f;
          pVertex[1].diffuse=0xFFFFFFFF; pVertex[1].u=2.0f;  pVertex[1].v=0.0f, 

          pVertex[2].x=x+v3dUp.x;     pVertex[2].y=y+v3dUp.y; pVertex[2].z=z+v3dUp.z;
          pVertex[2].nx=0.0f; pVertex[2].ny=0.0f; pVertex[2].ny=0.0f;
          pVertex[2].diffuse=0xFFFFFFFF; pVertex[2].u=0.0f;  pVertex[2].v=2.0f, 
      
          pVertex+=3;

          pusIndices[0]=i*3+0;
          pusIndices[1]=i*3+1;
          pusIndices[2]=i*3+2;

          pusIndices+=3;

          uLive++;
        }


        iIterator=iNext;
      }

      ResourceManager::DoneVBChunk(ResourceManager::m_iPosNormalDiffuseTex1Stream);
      ResourceManager::DoneIBChunk(ResourceManager::m_iIndexStream);

      unsigned uStartIndex =iIndexOffset/sizeof(unsigned short);
      unsigned uStartVertex=iVertexOffset/sizeof(FVF_PosNormalDiffuseTex1);

      SM_D3d::Device()->SetStreamSource(
          0, 
          ResourceManager::GetVertexBufferFromID(ResourceManager::m_iPosNormalDiffuseTex1Stream), 
          sizeof(FVF_PosNormalDiffuseTex1));
        
      SM_D3d::Device()->SetIndices(
      ResourceManager::GetIndexBufferFromID(ResourceManager::m_iIndexStream), uStartVertex);        

      SM_D3d::Device()->DrawIndexedPrimitive(
        D3DPT_TRIANGLELIST, 
        0,
        uLive*3,
        uStartIndex,
        uLive);        

      j+=uChunk;
    }
}