// Magic Software, Inc.
// http://www.magic-software.com
// Copyright (c) 2000, All Rights Reserved
//
// Source code from Magic Software is supplied under the terms of a license
// agreement and may not be copied or disclosed except in accordance with the
// terms of that agreement.  The various license agreements may be found at
// the Magic Software web site.  This file is subject to the license
//
// FREE SOURCE CODE
// http://www.magic-software.com/License/free.pdf

#ifndef MGCMULTIPLECURVE3_H
#define MGCMULTIPLECURVE3_H

#include "MgcMultipleCurve.h"
#include "SM_Vector3D.h"


class MgcMultipleCurve3 : public MgcMultipleCurve<Vector3D>
{
public:
    // abstract base class
    MgcMultipleCurve3 (int iSegments, float* afTime);

    // differential geometric quantities
    Vector3D GetNormal (float fTime) const;
    Vector3D GetBinormal (float fTime) const;
    void GetFrame (float fTime, Vector3D& kPosition, Vector3D& kTangent,
        Vector3D& kNormal, Vector3D& kBinormal) const;
    float GetCurvature (float fTime) const;
    float GetTorsion (float fTime) const;
};

#endif
