#include "SM_MathPCH.h"
#include "SM_Plane.h"


void Plane::Normalize()
{
  float f  =1.0f/sqrtf(a*a+b*b+c*c);
  
  a*=f;
  b*=f;
  c*=f;
  d*=f;
}

float Plane::Evaluate(Vector3D* pVector3D)
{
  return (a*pVector3D->x+
          b*pVector3D->y+
          c*pVector3D->z+
          d);
}