comment +
--------------------------------------------------------------- _-_.--------
 "Forever Reality"    MS-DOS 4k-intro  (2023)                _-',^. `-_.
 coded by bitl/7dump  (email: aleks_gs@yahoo.com)        ._-' ,'   `.   `-_
                                                        !`-_._________`-':::
 Greetz to:   HellMood,  sensenstahl, rrrola, Optimus,  !   /\        /\::::
 TomCatAbaddon,  p01,  pestis,  Asato,  iONic,  Manwe,  ;  /  \      /..\:::
 superogue,  Kuemmel, Digimind,  wbc\\bz7, LBi, & YOU!  ! /    \    /....\::
                                                        !/      \  /......\:
 For compilation use:            Requirements:          ;--.___. \/_.__.--;;
 Turbo  Assembler 2.02        Windows XP, DosBox         '-_    `:!;;;;;;;'
 tasm /m2 reality.asm      (theoretically:  DOS with        `-_, :!;;;''
 tlink /t reality.obj     support MPU-401 soundcard ;)          `-!'
----------------------------------------------------------------------------
comment end! +

mode60=1

;Events constants
    inc_scene   = 100h;
    palette     = 200h;
    palette2    = 300h;
    distort     = 400h;
    sqrt_init   = 500h;
    resetpal    = 600h;
    init_txt    = 700h;
    patch_music = 800h;

;Mesh constant
    mesh_size  = 14*3+24*3

;Music player constants
    contr_size = 222
    note_size  = 180
    patch_size = 82
    stat_offs  = 1024 ;( > mesh_size+contr_size+note_size+patch_size)


;Indexes of vars
include var_indx.inc


.model tiny

.data
;Offsets of main scenes proc
    scenes    dw open_part
              dw fall
              dw chess_fall
              dw polyhedron
              dw tunnel
              dw interference
              dw get_down
              dw rotoscop
              dw end_part

    ; oldvector dd 0
    vga60     dw 0b06h, 3e07h, 0c310h, 8c11h, 8f12h, 9015h, 0b16h

include vars.inc

.code
.486
org 0100h

start:
pop gs ; set GS to 0

cld    ; clear direction flag

mov di, offset pos+60  ; clear vars area
mov cl, 82
rep stosb


; Allocate memory (Three buffers of 65536 byte)
call alloc_seg
mov pos+_vaddr, bx

call alloc_seg
mov pos+_vaddr2, bx
mov es, bx          ; init for start fill routine
mov byte ptr es:[65000], 191 ; mem[vaddr2:65000]:=191;

call alloc_seg
mov pos+_vaddr3, bx


;----------------------------Player init ---------------------------------
mov ax, ds                ; ES to uncrunched data offset}
add ax, 512
mov es, ax

mov di, stat_offs         ;offset to stat channels array}
mov si, offset @instr     ;offset to instruments setup}

mov al, 3Fh   ; set UART mode - command
mov dx, 331h  ; MIDI Control Port
out dx, al    ;
dec dx        ; DX to data port 330h

; Make status-table for 16 channels and set instruments and volume
xor bx, bx
@init_player:
   mov al, 0c0h  ;;set instruments to channels}
   add al, bl
   out dx, al
   lodsb         ;;AL=number instrument}
   out dx, al
   mov al, 90h
   add al, bl
   stosw         ; OnOff=90h+chan, Note=0
   movsb         ; Volume
   xor ax, ax
   stosw         ;Enable=0, Pause=0, Possition=0}
   stosw
   inc di
   inc bx
   cmp bl, 16
jb @init_player


; Decrunch music data and mesh-data
xor di,di
mov si, offset @notes
mov cx, (note_size+contr_size+mesh_size+patch_size)/2
@decrunch:
   xor ax, ax
   lodsb
   shl ax, 4
   shr al, 4
   stosw
loop @decrunch


mov ax,13h
int 10h


; Set tweaked 60hz VGA mode 320x200
IF mode60
mov dx, 3d4h
push dx
mov al, 11h
out dx, al
inc dx
in al, dx
and al, 7fh
out dx, al
mov dx, 3C2h
mov al, 0e3h
out dx, al
pop dx
lea si, vga60
mov cl, 7
rep outsw
ELSE
xor cx, cx
ENDIF


mov bl, 15  ; set black palette to color 15 (for hide text)
xor dx, dx
;xor cx, cx
mov ax, 1010h
int 10h
call init_text


mov bp, 6
call palgen

; Set interrupt vector for player routine (1Ch)
mov bx, 70h
push dword ptr gs:[bx]  ; save old 1C vector
pop dword ptr vga60 ;oldvector
push cs
push offset @player
pop dword ptr gs:[bx]   ; put new vector

; Quick timer
mov al, 34h
out 43h, al
mov al, 4096 and 0ffh
out 40h, al
mov al, 4096 shr 8
out 40h, al

push word ptr gs:[46Ch]
pop word ptr [pos+_start_time]
;---------------------------- Main loop ---------------------------------
@mainloop:
lea si, pos ; offset of data (uses for all routines!)


; Timer's variables calc
xor bx, bx
mov es, bx
mov bp, es:[46Ch]
push bp
;q:=timer-start_time;}
sub bp, word ptr [si+_start_time]
mov word ptr [si+_q], bp

pop ax
push ax
;elapsed_time:=(timer-old_time);}
sub ax, word ptr [si+_old_time]
mov word ptr [si+_elapsed_time], ax
;old_time:=timer;}
pop word ptr [si+_old_time]


mov bx, offset let_event  ; proc addres, uses for all routines!
mov dx, word ptr [si+_music_position]


;start first scene
cmp bp, 1*330
jbe @skp_q2
   mov ax, 1+inc_scene
   call bx
@skp_q2:

; Get down
cmp dx, 1085
jbe @skp_m1085
   mov ax, 26+inc_scene
   call bx
   mov cl, 5
   mov ax, 27+palette
   call bx
@skp_m1085:

;Rotoscop start
cmp dx, 1130
jbe @skp_m1130
   mov ax, 28+patch_music
   call bx
   mov cl, 0
   mov ax, 29+palette
   call bx
   mov ax, 30+resetpal
   call bx
   mov ax, 31+inc_scene
   call bx
@skp_m1130:

;End part
cmp dx, 1600
jb @skip_end_part
   mov ax, 32+inc_scene
   call bx
@skip_end_part:

;Exit
cmp dx, 1692
ja @exit


; Selecting scene to draw
mov al, byte ptr [si+_scene]
movzx di, al
dec di
js @skip_scene
shl di,1
add di, offset scenes
call ds:[di]
@skip_scene:



; Wait vertical retrace
push ax
mov  dx, 3DAh
@w1:
    in   al, dx
    test al, 8h
    jnz  @w1
@w2:
    in   al, dx
    test al, 8h
    jz   @w2
pop ax


mov es, word ptr [si+_vaddr]

; Merge two buffers
;if (scene>1) and (scene<5) then AddScreen(vaddr3,vaddr);}
cmp al, 1
jbe @skip_AddScreen
cmp al, 5
jae @skip_AddScreen
  push si
  mov      gs, word ptr [si+_vaddr3]
  xor      si, si
  xor      di, di
  xor      ebx, ebx
  mov      cx, 16000
  @l_add:
  db 65h
  lodsd
  add es:[di], eax
  mov gs:[di], ebx
  add di, 4
  loop @l_add
  pop si
@skip_AddScreen:


; Write Bayer matrix to bottom seg vaddr
;(0,8,2,10, 12,4,14,6, 3,11,1,9, 15,7,13,5);}
mov edx, 6E4CA280h ;bayer-pattern 4x4}
mov ebx, 5D7F91B3h
mov di, 65535-16
mov cx, 16
@bayer:
  mov ax, dx
  and ax, 15
  sub ax, word ptr [si+_shadow]
  shrd edx, ebx, 4
  shr ebx, 4
  stosb
loop @bayer


mov fs, word ptr [si+_vaddr2] ; source2


; Morph palette routine
movzx cx, byte ptr [si+_speed_mpal]
mov ax, word ptr [si+_elapsed_time]
add word ptr [si+_palstep], ax ;palstep:=palstep+step;
cmp word ptr [si+_palstep], cx ;if palstep>speed_mpal then begin
jbe @skip_morphpal
;     mov fs, word ptr [si+_vaddr2]
;     mov es, word ptr [si+_vaddr]
     mov di, 64000
     mov cx, 256*3
     mov al, 0
     mov dx, 3c8h
     out dx, al
     inc dx
     @m_loop:
         mov al, es:[di]
         cmp al, fs:[di]
         je @next_p
         jb @inc_p
         dec ax
         dec ax
         @inc_p:
         inc ax
         mov es:[di], al
         @next_p:
         cmp al, 63
         jbe @setpale
         mov al, 63
         @setpale:
         out dx, al
         inc di
     loop @m_loop
     mov word ptr [si+_palstep], cx  ;palstep:=0;
@skip_morphpal:



; Merge two buffers and put to screen (and clear buffers)
;MergeScreen(vaddr, vaddr2, VGA);
push 0A000h
pop es                            ; dest
mov     gs, word ptr [si+_vaddr]  ; source1
;mov     fs, word ptr [si+_vaddr2] ; source2
mov ebx, dword ptr [si+_colorfill]
xor     si, si
xor     di, di
mov     cx, 16000
@l_Merge:
db 65h
lodsd
add eax, fs:[di]
mov fs:[di], ebx
mov gs:[di], ebx
stosd
loop @l_Merge



in al, 60h               ; wait for ESC
dec al
jnz @mainloop            ; none received, start over

;**************************************************************************
; EXIT
;**************************************************************************
@exit:

test byte ptr pos, 1  ; wait for "note off" position of music
jnz @exit

; Restor old vector to 1C interrupt
xor bx, bx
mov es, bx
push dword ptr vga60 ;oldvector
pop dword ptr es:[70h]

; Set normal timer-freq
mov al, 34h
out 43h, al
xor al, al
out 40h, al
out 40h, al

mov ax, 3                ; back to text
int 10h                  ; mode
int 20h                  ; exit

include mem.inc
include event.inc
include player.inc
include text.inc
include palette.inc
include bayer.inc
include triangle.inc
include cubic.inc
include fall.inc
include chess.inc
include polyhed.inc
include tunnel.inc
include interfer.inc
include scripts.inc
include rotoscop.inc
include data.inc

end start
