		define SNA_FILENAME "test.sna"
		define TRD_FILENAME "test.trd"
		define BIN_FILENAME "test.bin"

		device zxspectrum128

		;define _debug_border=1
		define _anima
		define _anima2
		define _anima3
		define _anima_bg
		define _play_music
		define _analyzator 10
		define _analyzator_splash 9
		define _splash_screen
		define _scroll

		
		ifdef _play_music
		define _page1
		endif

		ifdef _anima2
		define _page4
		endif

		ifdef _anima3
		define _page6
		endif
		
		ifdef _splash_screen
		define _page3
		endif

		ifdef _anima_bg
		ifndef _page3
		define _page3
		endif
		endif

		ifdef _analyzator
		define _analyzator_sens 13
		ifndef _page3
		define _page3
		endif
		endif

		ifdef _analyzator_splash
		define _analyzator_splash_sens 14
		ifndef _page3
		define _page3
		endif
		endif
		
		ifdef _scroll
		define _page7
		define _scroll_address #50df
		endif
		
		page 0
		
		org #6000
page0s	di	: ld sp, $-2
		ld a, 0 : out (#fe), a 
		
		ifdef _play_music
		; init PT3 player
		ld a,#11 : call set_page
		call PT3PLAY
		endif
		
		; init im2
		ld a,#5c, i,a, hl,interr, (#5cff),hl : im 2
		ei

		ifdef _splash_screen
		di
		ld a,#13 : call set_page
		ld hl,#c000, de,#4000, bc,#1b00 : ldir
		
		ifdef _analyzator_splash
		call createAnalSplash
		xor a : ld (SKIP_ANS + 1), a
		endif		

		ei
		
		; splash pause
		ifdef _play_music
sp_puse	ld a, #00
		ld hl, CUR_PATTERN
		cp (hl) : jr z, sp_puse
		ld a, (hl) : ld (sp_puse + 1), a
P_COUNTER	
		ld a, #00 : inc a : ld (P_COUNTER + 1), a
		cp 4 : jr c, sp_puse
		else
		ld b, #ff : halt : djnz $-1
		endif
		endif

		; stop splash analizator
		ifdef _analyzator_splash
		ld a, #ff : ld (SKIP_ANS + 1), a
		endif		
		
		; change border
		ld a, 0 : out (#fe), a 
		
		; clear screen after splash
		ifdef _anima_bg
		ld a,#13 : call set_page
		ld hl,ANIMA_BG, de,#4000, bc,#1b00 : ldir
		ifdef _analyzator
		call createAnal
		xor a : ld (SKIP_AN + 1), a
		endif		
		else
		ld hl,#4000, de,#4001, bc,#1800, (hl), l : ldir
		ld hl,#5800, de,#5801, bc,#2ff, (hl),71 : ldir
		endif
		
		ifdef _scroll
		xor a : ld (SKIP_SC	+ 1), a
		ld hl, #5ac0
		ld d,h, e,l : inc de
		ld bc, #003f
		ld (hl), 70
		ldir
		endif
		
		; start animation
		xor a
		ifdef _anima
		ld (ANIMA_START + 1), a
		endif
		ifdef _anima2
		ld (ANIMA2_START + 1), a
		endif
		ifdef _anima3
		ld (ANIMA3_START + 1), a
		endif
		
		jr $
		
		ifdef _anima
anima	ld a, #01 : dec a : ld (anima + 1), a : ret nz	; animation pause
anima_p	ld ix, anima_proc
		ld a, (ix + 0) : or a : jr nz, 1f
		ld ix, anima_proc + 3
1		ld a, (ix + 0) : ld (anima + 1), a
		ld l, (ix + 1)
		ld h, (ix + 2)
		inc ix : inc ix : inc ix : ld (anima_p + 2), ix
		jp (hl)
anima_proc
		db 5 : dw anma10
		db 5 : dw anma11
		db 5 : dw anma12
		db 5 : dw anma13
		db 5 : dw anma14
		db 5 : dw anma15
		db 5 : dw anma16
		db 5 : dw anma17
		db 5 : dw anma18
		db 5 : dw anma19
		db 5 : dw anma110
		db 5 : dw anma111
		db 5 : dw anma112
		db 5 : dw anma113
		db 5 : dw anma114
		db 5 : dw anma115
		db 5 : dw anma116
		db 5 : dw anma117
		db 5 : dw anma118
		db 5 : dw anma119
		db 5 : dw anma120
		db 5 : dw anma121
		db 5 : dw anma122
		db 5 : dw anma123
		db 5 : dw anma124
		db 5 : dw anma125
		db 5 : dw anma126
		db 5 : dw anma127
		db 5 : dw anma128
		db 5 : dw anma129
		db 5 : dw anma130
		db 5 : dw anma131
		db 5 : dw anma132
		db 5 : dw anma133
		db 5 : dw anma134
		db 5 : dw anma135
		db 5 : dw anma136
		db 5 : dw anma137
		db 5 : dw anma138
		db 5 : dw anma139
 
		db #00
		endif
		
interr	di
		push af,bc,de,hl,ix,iy
		exx : ex af, af'
		push af,bc,de,hl,ix,iy

		ifdef _debug_border : ld a, #01 : out (#fe), a : endif ; debug

		ifdef _anima2
ANIMA2_START
		ld a, #ff : or a : jr nz, $+12
		ld a,#14 : ld bc,#7ffd : out(c), a
		call anima2
		endif

		ifdef _anima3
ANIMA3_START
		ld a, #ff : or a : jr nz, $+12
		ld a,#16 : ld bc,#7ffd : out(c), a
		call anima3
		endif
		
		ifdef _anima
ANIMA_START
		ld a, #ff : or a : jr nz, $+12
		ld a,#10 : ld bc,#7ffd : out(c), a
		call anima
		endif

		ifdef _scroll
SKIP_SC	ld a, #01 : or a : jr nz, 1f
		ld a,#17 : ld bc,#7ffd : out(c), a
		call scroll16
1		
		endif
		
		ifdef _play_music
		ld a,#11 : ld bc,#7ffd : out(c), a
		call PT3PLAY + 5
		ld a, (PT3PLAY + 11) : ld (CUR_PATTERN), a
		endif

		// restore page
		ld a,(CUR_PAGE) : call set_page

		ifdef _analyzator
SKIP_AN	ld a, #01 : or a : jr nz, $+12
		ld a,#13 : ld bc,#7ffd : out(c), a
		call doAnal
		endif

		ifdef _analyzator_splash
SKIP_ANS
		ld a, #01 : or a : jr nz, $+12
		ld a,#13 : ld bc,#7ffd : out(c), a
		call doAnalSplash
		endif
		
		pop iy,ix,hl,de,bc,af
		exx : ex af, af'
		pop iy,ix,hl,de,bc,af
		ei
		ret


set_page
		ld (CUR_PAGE), a : ld bc,#7ffd : out(c), a : ret
		
CUR_PATTERN	db #00
CUR_PAGE	db #00
		
_data
		
		ifdef _anima
		include "res/anma10.asm"
		include "res/anma11.asm"
		include "res/anma12.asm"
		include "res/anma13.asm"
		include "res/anma14.asm"
		include "res/anma15.asm"
		include "res/anma16.asm"
		include "res/anma17.asm"
		include "res/anma18.asm"
		include "res/anma19.asm"
		include "res/anma110.asm"
		include "res/anma111.asm"
		include "res/anma112.asm"
		include "res/anma113.asm"
		include "res/anma114.asm"
		include "res/anma115.asm"
		include "res/anma116.asm"
		include "res/anma117.asm"
		include "res/anma118.asm"
		include "res/anma119.asm"
		include "res/anma120.asm"
		include "res/anma121.asm"
		include "res/anma122.asm"
		include "res/anma123.asm"
		include "res/anma124.asm"
		include "res/anma125.asm"
		include "res/anma126.asm"
		include "res/anma127.asm"
		include "res/anma128.asm"
		include "res/anma129.asm"
		include "res/anma130.asm"
		include "res/anma131.asm"
		include "res/anma132.asm"
		include "res/anma133.asm"
		include "res/anma134.asm"
		include "res/anma135.asm"
		include "res/anma136.asm"
		include "res/anma137.asm"
		include "res/anma138.asm"
		include "res/anma139.asm"

		display /d, "Animation 1 len: ", $ - _data
		endif
		
page0e

		ifdef _play_music
		page 1
		org #c000
page1s		
PT3PLAY	include "sources/PTxPlay.asm"
		incbin "res/music"
page1e
		endif

		page 3
		org #c000
page3s		
		ifdef _splash_screen
		incbin "res/splash"
		endif
		ifdef _anima_bg
ANIMA_BG
		incbin "res/bg"
		endif

		ifdef _analyzator		
		include "sources/analyzator.asm"
		endif

		ifdef _analyzator_splash
		include "sources/analyzator_splash.asm"
		endif
page3e
		

		page 4
		org #c000
page4s
		ifdef _anima2
anima2	ld a, #01 : dec a : ld (anima2 + 1), a : ret nz	; animation pause
anima2_p	ld ix, anima2_proc
		ld a, (ix + 0) : or a : jr nz, 1f
		ld ix, anima2_proc + 3
1		ld a, (ix + 0) : ld (anima2 + 1), a
		ld l, (ix + 1)
		ld h, (ix + 2)
		inc ix : inc ix : inc ix : ld (anima2_p + 2), ix
		jp (hl)
anima2_proc
		db 5 : dw anma20
		db 5 : dw anma21
		db 5 : dw anma22
		db 5 : dw anma23
		db 5 : dw anma24
		db 5 : dw anma25
		db 5 : dw anma26
		db 5 : dw anma27
		db 5 : dw anma28
		db 5 : dw anma29
		db 5 : dw anma210
		db 5 : dw anma211
		db 5 : dw anma212
		db 5 : dw anma213
		db 5 : dw anma214
		db 5 : dw anma215
		db 5 : dw anma216
		db 5 : dw anma217
		db 5 : dw anma218
		db 5 : dw anma219
		db 5 : dw anma220
		db 5 : dw anma221
		db 5 : dw anma222
 
		db #00
		
_data2
		include "res/anma20.asm"
		include "res/anma21.asm"
		include "res/anma22.asm"
		include "res/anma23.asm"
		include "res/anma24.asm"
		include "res/anma25.asm"
		include "res/anma26.asm"
		include "res/anma27.asm"
		include "res/anma28.asm"
		include "res/anma29.asm"
		include "res/anma210.asm"
		include "res/anma211.asm"
		include "res/anma212.asm"
		include "res/anma213.asm"
		include "res/anma214.asm"
		include "res/anma215.asm"
		include "res/anma216.asm"
		include "res/anma217.asm"
		include "res/anma218.asm"
		include "res/anma219.asm"
		include "res/anma220.asm"
		include "res/anma221.asm"
		include "res/anma222.asm"

		display /d, "Animation 2 len: ", $ - _data2
		endif
page4e
		
		page 6
		org #c000
page6s
		ifdef _anima3
anima3	ld a, #01 : dec a : ld (anima3 + 1), a : ret nz	; animation pause
anima3_p	ld ix, anima3_proc
		ld a, (ix + 0) : or a : jr nz, 1f
		ld ix, anima3_proc + 3
1		ld a, (ix + 0) : ld (anima3 + 1), a
		ld l, (ix + 1)
		ld h, (ix + 2)
		inc ix : inc ix : inc ix : ld (anima3_p + 2), ix
		jp (hl)
anima3_proc
		db 4 : dw anma30
		db 4 : dw anma31
		db 4 : dw anma32
		db 4 : dw anma33
		db 4 : dw anma34
		db 4 : dw anma35
		db 4 : dw anma36
		db 4 : dw anma37
		db 4 : dw anma38
		db 4 : dw anma39
		db 4 : dw anma310
		db 4 : dw anma311
		db 4 : dw anma312
		db 4 : dw anma313
		db 4 : dw anma314
		db 4 : dw anma315
		db 4 : dw anma316
		db 4 : dw anma317
		db 4 : dw anma318
		db 4 : dw anma319
		db 4 : dw anma320
		db 4 : dw anma321
		db 4 : dw anma322
		db 4 : dw anma323
		db 4 : dw anma324
		db 4 : dw anma325
		db 4 : dw anma326
		db 4 : dw anma327
		db 4 : dw anma328
		db 4 : dw anma329
		db 4 : dw anma330
 
		db #00
_data3
		include "res/anma30.asm"
		include "res/anma31.asm"
		include "res/anma32.asm"
		include "res/anma33.asm"
		include "res/anma34.asm"
		include "res/anma35.asm"
		include "res/anma36.asm"
		include "res/anma37.asm"
		include "res/anma38.asm"
		include "res/anma39.asm"
		include "res/anma310.asm"
		include "res/anma311.asm"
		include "res/anma312.asm"
		include "res/anma313.asm"
		include "res/anma314.asm"
		include "res/anma315.asm"
		include "res/anma316.asm"
		include "res/anma317.asm"
		include "res/anma318.asm"
		include "res/anma319.asm"
		include "res/anma320.asm"
		include "res/anma321.asm"
		include "res/anma322.asm"
		include "res/anma323.asm"
		include "res/anma324.asm"
		include "res/anma325.asm"
		include "res/anma326.asm"
		include "res/anma327.asm"
		include "res/anma328.asm"
		include "res/anma329.asm"
		include "res/anma330.asm"

		display /d, "Animation 3 len: ", $ - _data3
		endif
page6e
		
		ifdef _scroll
		page 7
		org #db00
page7s	include "sources/scroll.asm"
page7e
		endif
		
		; --------------------------
		include "sources/builder.asm"