const LineWidth = 16;
const LineHeight = 20;
const WindowColor = "#555";
const WindowHiliteColor = "#888";
const WindowBorderColor = "#888";

var GlobalWindowIdCounter = 0;
var GlobalWindowZIndexCounter = 0;
var GlobalColors = new Array();

GlobalColors.push({ Red: 0, Green: 0, Blue: 0 });
GlobalColors.push({ Red: 255, Green: 255, Blue: 255 });

var UploadInput = document.getElementById("upload_input");

UploadInput.onchange = function(Event)
	{
	    for(var Index = 0; Index < Event.target.files.length; Index++) 
	    {
			var ImageFileReader = new FileReader();
			
			ImageFileReader.onload = (function(File) 
				{
					return(function(FileReaderEvent)
						{
							if(File.type.indexOf("image/") == 0 && File.type.indexOf("x-ilbm") == -1)
								LoadStandardImage(FileReaderEvent.target.result, File.name);
							else
								LoadOtherImage(FileReaderEvent.target.result, File.name);
						});
				})(Event.target.files[Index]);
			
			ImageFileReader.readAsDataURL(Event.target.files[Index]);
	    }
	};

var Dropzone = document.getElementById("dropzone");

Dropzone.style.width = "100%";
Dropzone.style.height = "100%";

Dropzone.ondragover = function(Event) 
	{
		Event.preventDefault();
	};

Dropzone.ondragleave = function(Event) 
	{
		Event.preventDefault();
	};

	Dropzone.ondrop = function(Event) 
	{
		Event.preventDefault();
		
		if(Event.dataTransfer.types[0] == "Text" || Event.dataTransfer.types[0] == "text/plain" || Event.dataTransfer.types[0] == "public.utf8-plain-text")
		{
		    var Data;
		    
		    if(Event.dataTransfer.types[0] == "Text")
			    Data = Event.dataTransfer.getData("Text").split(',');
		    else
		    	Data = Event.dataTransfer.getData("text/plain").split(',');
	    
		    document.getElementById(Data[2]).style.left = (document.getElementById(Data[2]).offsetLeft + Event.screenX - parseInt(Data[0], 10));
		    document.getElementById(Data[2]).style.top = (document.getElementById(Data[2]).offsetTop + Event.screenY - parseInt(Data[1], 10));
		}
		
		for(var Index = 0; Index < Event.dataTransfer.files.length; Index++)
		{
			var ImageFileReader = new FileReader();
		
			ImageFileReader.onload = (function(File) 
				{
					return(function(FileReaderEvent)
						{
							if(File.type.indexOf("image/") == 0 && File.type.indexOf("x-ilbm") == -1)
								LoadStandardImage(FileReaderEvent.target.result, File.name);
							else
								LoadOtherImage(FileReaderEvent.target.result, File.name);
						});
				})(Event.dataTransfer.files[Index]);
			
			ImageFileReader.readAsDataURL(Event.dataTransfer.files[Index]);
		}
	};

//LoadStandardImage("0866.png", "0866.png");

// -----------------------------------------------------------------------------
	
function LoadStandardImage(ImageSource, FileName)
{
	var ImageInfos = new Array();
	
	ImageInfos.Image = document.createElement("img");
	ImageInfos.FileName = FileName;
	
	ImageInfos.Image.onload = function() 
		{
			DisplayImageWindow(ImageInfos);
		};

	ImageInfos.Image.src = ImageSource;
}

function LoadOtherImage(ImageSource, FileName)
{
	var ImageInfos = new Array();
	
	ImageInfos.Image = document.createElement("img");
	ImageInfos.FileName = FileName;
	
	ImageInfos.Image.onload = function() 
		{
			DisplayImageWindow(ImageInfos);
		};

	ImageInfos.Data = new Uint8Array(Base64ToArray(ImageSource));
	
	DecodeIff(ImageInfos);
	
	if(ImageInfos.Canvas)
		ImageInfos.Image.src = ImageInfos.Canvas.toDataURL();
}

function Base64ToArray(Base64Data)
{
	var Base64TranslationTable = [ 62, 0, 0, 0, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 0, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51 ];
	
	var DecodedData = new Array();
	
	for(var Index = Base64Data.lastIndexOf(",") + 1; Index < Base64Data.length; Index += 4)
	{
		var DecodedTriplet = 
			(Base64TranslationTable[Base64Data.charCodeAt(Index) - 43] << 18) | 
			(Base64TranslationTable[Base64Data.charCodeAt(Index + 1) - 43] << 12) | 
			(Base64TranslationTable[Base64Data.charCodeAt(Index + 2) - 43] << 6) | 
			Base64TranslationTable[Base64Data.charCodeAt(Index + 3) - 43];

		for(var TripletIndex = 0; TripletIndex < 3; TripletIndex++)
		{
			if(Base64Data[Index + TripletIndex] != "=")
			{
				DecodedData.push((DecodedTriplet >> (16 - TripletIndex * 8)) & 0xff);
			}
			else
			{
				break;
			}
		}
	}
	
	return DecodedData;
}

function DecodeIff(ImageInfos)
{
	var IffInfos = { Data: ImageInfos.Data, DataIndex: 0, Colors: null, Canvas: null };

	ParseIff(IffInfos);

	ImageInfos.Canvas = IffInfos.Canvas;
	ImageInfos.Colors = IffInfos.Colors;
	ImageInfos.AspectX = IffInfos.AspectX;
	ImageInfos.AspectY = IffInfos.AspectY;
}

function ParseIff(IffInfos)
{
	var Id = String.fromCharCode(IffInfos.Data[IffInfos.DataIndex++]);
	Id += String.fromCharCode(IffInfos.Data[IffInfos.DataIndex++]);
	Id += String.fromCharCode(IffInfos.Data[IffInfos.DataIndex++]);
	Id += String.fromCharCode(IffInfos.Data[IffInfos.DataIndex++]);
	
	var Size = IffInfos.Data[IffInfos.DataIndex++] << 24;
	Size += IffInfos.Data[IffInfos.DataIndex++] << 16;
	Size += IffInfos.Data[IffInfos.DataIndex++] << 8;
	Size += IffInfos.Data[IffInfos.DataIndex++];
	
	if(IffInfos.DataIndex == 8 && Id != "FORM")
	{
		console.log("Image is not an ILBM file!");
		
		return;
	}
	
	var EndIndex = IffInfos.DataIndex + Size;
	
	while(IffInfos.DataIndex < EndIndex)
	{
		switch(Id)
		{
		case "FORM":
			var Type = String.fromCharCode(IffInfos.Data[IffInfos.DataIndex++]);
			Type += String.fromCharCode(IffInfos.Data[IffInfos.DataIndex++]);
			Type += String.fromCharCode(IffInfos.Data[IffInfos.DataIndex++]);
			Type += String.fromCharCode(IffInfos.Data[IffInfos.DataIndex++]);

			if(Type != "ILBM")
			{
				IffInfos.DataIndex += Size;

				return;
			}
			
			while(IffInfos.DataIndex < EndIndex)
				ParseIff(IffInfos);

			break;
			
		case "BMHD":
			IffInfos.Width = IffInfos.Data[IffInfos.DataIndex++] << 8;
			IffInfos.Width += IffInfos.Data[IffInfos.DataIndex++];

			IffInfos.Height = IffInfos.Data[IffInfos.DataIndex++] << 8;
			IffInfos.Height += IffInfos.Data[IffInfos.DataIndex++];
			
			IffInfos.OffsetX = IffInfos.Data[IffInfos.DataIndex++] << 8;
			IffInfos.OffsetX += IffInfos.Data[IffInfos.DataIndex++];

			IffInfos.OffsetY = IffInfos.Data[IffInfos.DataIndex++] << 8;
			IffInfos.OffsetY += IffInfos.Data[IffInfos.DataIndex++];

			IffInfos.Bitplanes = IffInfos.Data[IffInfos.DataIndex++];
			IffInfos.Masking = IffInfos.Data[IffInfos.DataIndex++];
			IffInfos.Compression = IffInfos.Data[IffInfos.DataIndex++];

			IffInfos.DataIndex++;
			
			IffInfos.TransparentColor = IffInfos.Data[IffInfos.DataIndex++] << 8;
			IffInfos.TransparentColor += IffInfos.Data[IffInfos.DataIndex++];

			IffInfos.AspectX = IffInfos.Data[IffInfos.DataIndex++];
			IffInfos.AspectY = IffInfos.Data[IffInfos.DataIndex++];

			IffInfos.PageWidth = IffInfos.Data[IffInfos.DataIndex++] << 8;
			IffInfos.PageWidth += IffInfos.Data[IffInfos.DataIndex++];

			IffInfos.PageHeight = IffInfos.Data[IffInfos.DataIndex++] << 8;
			IffInfos.PageHeight += IffInfos.Data[IffInfos.DataIndex++];
			
			break;

		case "CAMG":
			if(Size == 4)
			{
				IffInfos.ViewportMode = IffInfos.Data[IffInfos.DataIndex++] << 24;
				IffInfos.ViewportMode += IffInfos.Data[IffInfos.DataIndex++] << 16;
				IffInfos.ViewportMode += IffInfos.Data[IffInfos.DataIndex++] << 8;
				IffInfos.ViewportMode += IffInfos.Data[IffInfos.DataIndex++];
			}
			else
			{
				console.log("Unknown CAMG chunk size detected!");
				
				IffInfos.DataIndex += Size;
			}
			
			break;
			
		case "CMAP":
			IffInfos.Colors = new Array();
			
			var LowerColorBits = 0;
			
			while(IffInfos.DataIndex < EndIndex)
			{
				var Red = IffInfos.Data[IffInfos.DataIndex++];
				var Green = IffInfos.Data[IffInfos.DataIndex++];
				var Blue = IffInfos.Data[IffInfos.DataIndex++];
				
				IffInfos.Colors.push({ Red: Red, Green: Green, Blue: Blue });
				
				LowerColorBits |= Red & 0x0f | Green & 0x0f | Blue & 0x0f;
			}

			if(LowerColorBits == 0) // Check for a 4096 colors palette.
			{
				for(var ColorIndex = 0; ColorIndex < IffInfos.Colors.length; ColorIndex++)
				{
					IffInfos.Colors[ColorIndex].Red = Math.floor(IffInfos.Colors[ColorIndex].Red * 255.0 / 240.0);
					IffInfos.Colors[ColorIndex].Green = Math.floor(IffInfos.Colors[ColorIndex].Green * 255.0 / 240.0);
					IffInfos.Colors[ColorIndex].Blue = Math.floor(IffInfos.Colors[ColorIndex].Blue * 255.0 / 240.0);
				}
			}
			
			if(IffInfos.DataIndex & 1) // Avoid odd data index.
				IffInfos.DataIndex++;
			
			break;
			
		case "BODY":
			if(IffInfos.Canvas)
			{
				console.log("Found another BODY - skipping...");
				
				IffInfos.DataIndex += Size;
				
				break;
			}

			if(IffInfos.ViewportMode & 0x80) // EHB image.
			{
				while(IffInfos.Colors.length < 64)
					IffInfos.Colors.push({ Red: 0, Green: 0, Blue: 0 });
				
				for(var Index = 0; Index < 32; Index++)
				{
					var Red = Math.floor(IffInfos.Colors[Index].Red / 2.0);
					var Green = Math.floor(IffInfos.Colors[Index].Green / 2.0);
					var Blue = Math.floor(IffInfos.Colors[Index].Blue / 2.0);
					
					IffInfos.Colors[Index + 32].Red = Red;
					IffInfos.Colors[Index + 32].Green = Green;
					IffInfos.Colors[Index + 32].Blue = Blue;
				}
			}
			
			IffInfos.Canvas = document.createElement("canvas");
			
			IffInfos.Canvas.width = IffInfos.Width;
			IffInfos.Canvas.height = IffInfos.Height;

			var Context = IffInfos.Canvas.getContext("2d");
			var Data = Context.getImageData(0, 0, IffInfos.Width, IffInfos.Height);
			
			var LineByteCount = Math.ceil(IffInfos.Width / 16) * 2;
			
			var Bitplanes = new Array(IffInfos.Bitplanes);
			
			for(var Index = 0; Index < IffInfos.Bitplanes; Index++)
				Bitplanes[Index] = new Array(LineByteCount);
			
			for(var Y = 0; Y < IffInfos.Height; Y++)
			{
				for(var BitplaneIndex = 0; BitplaneIndex < IffInfos.Bitplanes; BitplaneIndex++)
				{
					if(IffInfos.Compression == 1)
					{
						var LineByteIndex = 0;
	
						while(LineByteIndex < LineByteCount)
						{
							var Count = IffInfos.Data[IffInfos.DataIndex++];
							
							if(Count < 128)
							{
								Count++;
								
								while(Count--)
									Bitplanes[BitplaneIndex][LineByteIndex++] = IffInfos.Data[IffInfos.DataIndex++];
							}
							else
							{
								Count = 256 - Count + 1;
								var Byte = IffInfos.Data[IffInfos.DataIndex++];
								
								while(Count--)
									Bitplanes[BitplaneIndex][LineByteIndex++] = Byte;
							}
						}
					}
					else
					{
						for(var LineByteIndex = 0; LineByteIndex < LineByteCount; LineByteIndex++)
						{
							Bitplanes[BitplaneIndex][LineByteIndex] = IffInfos.Data[IffInfos.DataIndex++];
						}
					}
				}
				
				for(var X = 0; X < IffInfos.Width; X++)
				{
					var LineByteIndex = Math.floor(X / 8.0);
					var ByteMask = 0x80 >> (X & 0x7);
					var ColorIndex = 0;
					
					for(var BitplaneIndex = 0; BitplaneIndex < IffInfos.Bitplanes; BitplaneIndex++)
						if((Bitplanes[BitplaneIndex][LineByteIndex] & ByteMask) != 0)
							ColorIndex += 1 << BitplaneIndex;  
					
					var PixelIndex = (X + Y * IffInfos.Width) * 4;

					if(ColorIndex >= IffInfos.Colors.length)
						ColorIndex = 0;
					
					Data.data[PixelIndex] = IffInfos.Colors[ColorIndex].Red;
					Data.data[PixelIndex + 1] = IffInfos.Colors[ColorIndex].Green;
					Data.data[PixelIndex + 2] = IffInfos.Colors[ColorIndex].Blue;
					Data.data[PixelIndex + 3] = 255;
				}
			}
			
			Context.putImageData(Data, 0, 0);

			break;
			
		default:
			IffInfos.DataIndex += Size;
			
			if(IffInfos.DataIndex & 1) // Avoid odd data index.
				IffInfos.DataIndex++;
			
			break;
		}
	}
}

function DisplayImageWindow(ImageInfos)
{
	ImageInfos.Id = GlobalWindowIdCounter++;

	var WindowDiv = CreateImageWindow(ImageInfos);
	
	Dropzone.appendChild(WindowDiv);
	
	ProcessMenuAction(WindowDiv.id.substring(WindowDiv.id.lastIndexOf("_") + 1));
}

function GetColors(Canvas)
{
	var Context = Canvas.getContext("2d");
	var Data = Context.getImageData(0, 0, Canvas.width, Canvas.height);
	var ColorCube = new Uint32Array(256 * 256 * 256);
	var Colors = new Array();
	
	for(var Y = 0; Y < Canvas.height; Y++)
	{
		for(var X = 0; X < Canvas.width; X++)
		{
			var PixelIndex = (X + Y * Canvas.width) * 4;

			var Red = Data.data[PixelIndex];
			var Green = Data.data[PixelIndex + 1];
			var Blue = Data.data[PixelIndex + 2];
			var Alpha = Data.data[PixelIndex + 3];
			
			if(Alpha == 255)
			{
				if(ColorCube[Red * 256 * 256 + Green * 256 + Blue] == 0)
					Colors.push({ Red: Red, Green: Green, Blue: Blue });
				
				ColorCube[Red * 256 * 256 + Green * 256 + Blue]++;
			}
		}
	}
	
	Colors.sort(function (Color1, Color2) { return (Color1.Red * 0.21 + Color1.Green * 0.72 + Color1.Blue * 0.07) - (Color2.Red * 0.21 + Color2.Green * 0.72 + Color2.Blue * 0.07) });
	
	return Colors;
}

function CreateColorCube(Canvas)
{
	var Context = Canvas.getContext("2d");
	var Data = Context.getImageData(0, 0, Canvas.width, Canvas.height);
	var TotalColorCount = 0;
	var ColorCube = new Uint32Array(256 * 256 * 256);
	
	for(var Y = 0; Y < Canvas.height; Y++)
	{
		for(var X = 0; X < Canvas.width; X++)
		{
			var PixelIndex = (X + Y * Canvas.width) * 4;

			var Red = Data.data[PixelIndex];
			var Green = Data.data[PixelIndex + 1];
			var Blue = Data.data[PixelIndex + 2];
			var Alpha = Data.data[PixelIndex + 3];

			//var BitsPerColor = 4;
			//var ShadesPerColor = 1 << BitsPerColor;
			
			//Red = Math.round(Math.round(Red * (ShadesPerColor - 1) / 255) * 255 / (ShadesPerColor - 1));
			//Green = Math.round(Math.round(Green * (ShadesPerColor - 1) / 255) * 255 / (ShadesPerColor - 1));
			//Blue = Math.round(Math.round(Blue * (ShadesPerColor - 1) / 255) * 255 / (ShadesPerColor - 1));
			
			if(Alpha == 255)
			{
				if(ColorCube[Red * 256 * 256 + Green * 256 + Blue] == 0)
					TotalColorCount++;
				
				ColorCube[Red * 256 * 256 + Green * 256 + Blue]++;
			}
		}
	}
	
	return ColorCube;
}

function TrimColorCube(ColorCube, ColorCubeInfo)
{
	var RedMin = 255;
	var RedMax = 0;
	
	var GreenMin = 255;
	var GreenMax = 0;
	
	var BlueMin = 255;
	var BlueMax = 0;
	
	var RedCounts = new Uint32Array(256);
	var GreenCounts = new Uint32Array(256);
	var BlueCounts = new Uint32Array(256);
	
	var TotalColorCount = 0;
	
	var AverageRed = 0;
	var AverageGreen = 0;
	var AverageBlue = 0;
	
	for(var Red = ColorCubeInfo.RedMin; Red <= ColorCubeInfo.RedMax; Red++)
	{
		for(var Green = ColorCubeInfo.GreenMin; Green <= ColorCubeInfo.GreenMax; Green++)
		{
			for(var Blue = ColorCubeInfo.BlueMin; Blue <= ColorCubeInfo.BlueMax; Blue++)
			{
				var ColorCount = ColorCube[Red * 256 * 256 + Green * 256 + Blue]; 
				
				if(ColorCount != 0)
				{
					RedCounts[Red] += ColorCount;
					GreenCounts[Green] += ColorCount;
					BlueCounts[Blue] += ColorCount;
					
					if(Red < RedMin)
						RedMin = Red;

					if(Red > RedMax)
						RedMax = Red;

					if(Green < GreenMin)
						GreenMin = Green;

					if(Green > GreenMax)
						GreenMax = Green;
					
					if(Blue < BlueMin)
						BlueMin = Blue;

					if(Blue > BlueMax)
						BlueMax = Blue;
					
					AverageRed += Red * ColorCount;
					AverageGreen += Green * ColorCount;
					AverageBlue += Blue * ColorCount;
					
					TotalColorCount += ColorCount;
				}
			}
		}
	}
	
	AverageRed = Math.round(AverageRed / TotalColorCount);
	AverageGreen = Math.round(AverageGreen / TotalColorCount);
	AverageBlue = Math.round(AverageBlue / TotalColorCount);
	
	return { RedMin: RedMin, RedMax: RedMax, GreenMin: GreenMin, GreenMax: GreenMax, BlueMin: BlueMin, BlueMax: BlueMax, RedCounts: RedCounts, GreenCounts: GreenCounts, BlueCounts: BlueCounts, Red: AverageRed, Green: AverageGreen, Blue: AverageBlue, ColorCount: TotalColorCount };
}

function QuantizeColors(Canvas, ColorCount)
{
	var ColorCube = CreateColorCube(Canvas);
	var ColorCubeInfos = new Array(TrimColorCube(ColorCube, { RedMin: 0, RedMax: 255, GreenMin: 0, GreenMax: 255, BlueMin: 0, BlueMax: 255 }));

	while(ColorCubeInfos.length < ColorCount)
	{
		var LongestCubeLength = 0;
		var LongestCubeIndex = 0;
		
		var HeaviestCubeCount = 0;
		var HeaviestCubeIndex = 0;

		var RedLength; 
		var GreenLength; 
		var BlueLength; 
		
		for(var Index = 0; Index < ColorCubeInfos.length; Index++)
		{
			RedLength = ColorCubeInfos[Index].RedMax - ColorCubeInfos[Index].RedMin; 
			GreenLength = ColorCubeInfos[Index].GreenMax - ColorCubeInfos[Index].GreenMin; 
			BlueLength = ColorCubeInfos[Index].BlueMax - ColorCubeInfos[Index].BlueMin; 
			
			if(Math.max(RedLength, GreenLength, BlueLength) > LongestCubeLength)
			{
				LongestCubeLength = Math.max(RedLength, GreenLength, BlueLength);
				LongestCubeIndex = Index;
			}
			
			if(Math.max(RedLength, GreenLength, BlueLength) > 1 && ColorCubeInfos[Index].ColorCount > HeaviestCubeCount)
			{
				HeaviestCubeCount = ColorCubeInfos[Index].ColorCount;
				HeaviestCubeIndex = Index;
			}
		}

		var OldColorCubeInfo = ColorCubeInfos[LongestCubeIndex];
		//var OldColorCubeInfo = ColorCubeInfos[HeaviestCubeIndex];
		var NewColorCubeInfo = new Array();
		
		NewColorCubeInfo.RedMin = OldColorCubeInfo.RedMin;
		NewColorCubeInfo.RedMax = OldColorCubeInfo.RedMax;
		NewColorCubeInfo.GreenMin = OldColorCubeInfo.GreenMin;
		NewColorCubeInfo.GreenMax = OldColorCubeInfo.GreenMax;
		NewColorCubeInfo.BlueMin = OldColorCubeInfo.BlueMin;
		NewColorCubeInfo.BlueMax = OldColorCubeInfo.BlueMax;

		RedLength = OldColorCubeInfo.RedMax - OldColorCubeInfo.RedMin; 
		GreenLength = OldColorCubeInfo.GreenMax - OldColorCubeInfo.GreenMin; 
		BlueLength = OldColorCubeInfo.BlueMax - OldColorCubeInfo.BlueMin; 
		
		if(RedLength >= GreenLength && RedLength >= BlueLength)
		{
			if(RedLength > 1)
			{
				var LowIndex = OldColorCubeInfo.RedMin;
				var HighIndex = OldColorCubeInfo.RedMax;
				var LowCount = Math.pow(OldColorCubeInfo.RedCounts[LowIndex], 0.2);
				var HighCount = Math.pow(OldColorCubeInfo.RedCounts[HighIndex], 0.2);
				
				while(LowIndex < HighIndex - 1)
				{
					if(LowCount < HighCount)
					{
						LowCount += Math.pow(OldColorCubeInfo.RedCounts[++LowIndex], 0.2);
					}
					else
					{
						HighCount += Math.pow(OldColorCubeInfo.RedCounts[--HighIndex], 0.2);
					}
				}
				
				//OldColorCubeInfo.RedMax = LowIndex; 
				//NewColorCubeInfo.RedMin = HighIndex; 
				
				NewColorCubeInfo.RedMax = OldColorCubeInfo.RedMax; 
				OldColorCubeInfo.RedMax = OldColorCubeInfo.RedMin + Math.floor(RedLength / 2.0); 
				NewColorCubeInfo.RedMin = OldColorCubeInfo.RedMax + 1; 
			}
			else
			{
				break;
			}
		}
		else if(GreenLength >= RedLength && GreenLength >= BlueLength)
		{
			if(GreenLength > 1)
			{
				var LowIndex = OldColorCubeInfo.GreenMin;
				var HighIndex = OldColorCubeInfo.GreenMax;
				var LowCount = Math.pow(OldColorCubeInfo.GreenCounts[LowIndex], 0.2);
				var HighCount = Math.pow(OldColorCubeInfo.GreenCounts[HighIndex], 0.2);
				
				while(LowIndex < HighIndex - 1)
				{
					if(LowCount < HighCount)
					{
						LowCount += OldColorCubeInfo.GreenCounts[++LowIndex];
					}
					else
					{
						HighCount += OldColorCubeInfo.GreenCounts[--HighIndex];
					}
				}
				
				//OldColorCubeInfo.GreenMax = LowIndex; 
				//NewColorCubeInfo.GreenMin = HighIndex; 
				
				NewColorCubeInfo.GreenMax = OldColorCubeInfo.GreenMax; 
				OldColorCubeInfo.GreenMax = OldColorCubeInfo.GreenMin + Math.floor(GreenLength / 2.0); 
				NewColorCubeInfo.GreenMin = OldColorCubeInfo.GreenMax + 1; 
			}
			else
			{
				break;
			}
		}
		else
		{
			if(BlueLength > 1)
			{
				var LowIndex = OldColorCubeInfo.BlueMin;
				var HighIndex = OldColorCubeInfo.BlueMax;
				var LowCount = Math.pow(OldColorCubeInfo.BlueCounts[LowIndex], 0.2);
				var HighCount = Math.pow(OldColorCubeInfo.BlueCounts[HighIndex], 0.2);
				
				while(LowIndex < HighIndex - 1)
				{
					if(LowCount < HighCount)
					{
						LowCount += Math.pow(OldColorCubeInfo.BlueCounts[++LowIndex], 0.2);
					}
					else
					{
						HighCount += Math.pow(OldColorCubeInfo.BlueCounts[--HighIndex], 0.2);
					}
				}
				
				//OldColorCubeInfo.BlueMax = LowIndex; 
				//NewColorCubeInfo.BlueMin = HighIndex; 
				
				NewColorCubeInfo.BlueMax = OldColorCubeInfo.BlueMax; 
				OldColorCubeInfo.BlueMax = OldColorCubeInfo.BlueMin + Math.floor(BlueLength / 2.0); 
				NewColorCubeInfo.BlueMin = OldColorCubeInfo.BlueMax + 1; 
			}
			else
			{
				break;
			}
		}
		
		ColorCubeInfos[LongestCubeIndex] = TrimColorCube(ColorCube, OldColorCubeInfo);
		//ColorCubeInfos[HeaviestCubeIndex] = TrimColorCube(ColorCube, OldColorCubeInfo);
		ColorCubeInfos.push(TrimColorCube(ColorCube, NewColorCubeInfo));
	}
	
	return ColorCubeInfos;
}

function QuantizationCountWeight(Count)
{
	return Math.pow(Count, 0.2); // Standard.
	//return Math.pow(Count, 0.1);
	//return Count;
}

function QuantizeRecursive(ColorCube, ColorCubeInfo, Palette, RecursionDepth, MaxRecursionDepth)
{
	var RedLength = ColorCubeInfo.RedMax - ColorCubeInfo.RedMin; 
	var GreenLength = ColorCubeInfo.GreenMax - ColorCubeInfo.GreenMin; 
	var BlueLength = ColorCubeInfo.BlueMax - ColorCubeInfo.BlueMin; 

	if(Math.max(RedLength, GreenLength, BlueLength) == 1)
		return;
	
	if(RecursionDepth == MaxRecursionDepth)
	{
		Palette.push({ Red: ColorCubeInfo.Red, Green: ColorCubeInfo.Green, Blue: ColorCubeInfo.Blue });
		
		return;
	}
	
	var NewColorCubeInfo = new Array();
	
	NewColorCubeInfo.RedMin = ColorCubeInfo.RedMin;
	NewColorCubeInfo.RedMax = ColorCubeInfo.RedMax;
	NewColorCubeInfo.GreenMin = ColorCubeInfo.GreenMin;
	NewColorCubeInfo.GreenMax = ColorCubeInfo.GreenMax;
	NewColorCubeInfo.BlueMin = ColorCubeInfo.BlueMin;
	NewColorCubeInfo.BlueMax = ColorCubeInfo.BlueMax;

	if(RedLength >= GreenLength && RedLength >= BlueLength)
	{
		var LowIndex = ColorCubeInfo.RedMin;
		var HighIndex = ColorCubeInfo.RedMax;
		var LowCount = QuantizationCountWeight(ColorCubeInfo.RedCounts[LowIndex]);
		var HighCount = QuantizationCountWeight(ColorCubeInfo.RedCounts[HighIndex]);
		
		while(LowIndex < HighIndex - 1)
		{
			if(LowCount < HighCount)
			{
				LowCount += QuantizationCountWeight(ColorCubeInfo.RedCounts[++LowIndex]);
			}
			else
			{
				HighCount += QuantizationCountWeight(ColorCubeInfo.RedCounts[--HighIndex]);
			}
		}
		
		ColorCubeInfo.RedMax = LowIndex; 
		NewColorCubeInfo.RedMin = HighIndex; 
	}
	else if(GreenLength >= RedLength && GreenLength >= BlueLength)
	{
		var LowIndex = ColorCubeInfo.GreenMin;
		var HighIndex = ColorCubeInfo.GreenMax;
		var LowCount = QuantizationCountWeight(ColorCubeInfo.GreenCounts[LowIndex]);
		var HighCount = QuantizationCountWeight(ColorCubeInfo.GreenCounts[HighIndex]);
		
		while(LowIndex < HighIndex - 1)
		{
			if(LowCount < HighCount)
			{
				LowCount += QuantizationCountWeight(ColorCubeInfo.GreenCounts[++LowIndex]);
			}
			else
			{
				HighCount += QuantizationCountWeight(ColorCubeInfo.GreenCounts[--HighIndex]);
			}
		}
		
		ColorCubeInfo.GreenMax = LowIndex; 
		NewColorCubeInfo.GreenMin = HighIndex; 
	}
	else
	{
		var LowIndex = ColorCubeInfo.BlueMin;
		var HighIndex = ColorCubeInfo.BlueMax;
		var LowCount = QuantizationCountWeight(ColorCubeInfo.BlueCounts[LowIndex]);
		var HighCount = QuantizationCountWeight(ColorCubeInfo.BlueCounts[HighIndex]);
		
		while(LowIndex < HighIndex - 1)
		{
			if(LowCount < HighCount)
			{
				LowCount += QuantizationCountWeight(ColorCubeInfo.BlueCounts[++LowIndex]);
			}
			else
			{
				HighCount += QuantizationCountWeight(ColorCubeInfo.BlueCounts[--HighIndex]);
			}
		}
		
		ColorCubeInfo.BlueMax = LowIndex; 
		NewColorCubeInfo.BlueMin = HighIndex; 
	}
	
	QuantizeRecursive(ColorCube, TrimColorCube(ColorCube, ColorCubeInfo), Palette, RecursionDepth + 1, MaxRecursionDepth);
	QuantizeRecursive(ColorCube, TrimColorCube(ColorCube, NewColorCubeInfo), Palette, RecursionDepth + 1, MaxRecursionDepth);
}

function RemapImage(Canvas, Palette, FloydSteinbergFactor)
{
	var FloydSteinbergCoefficients = new Array(7 * FloydSteinbergFactor, 3 * FloydSteinbergFactor, 5 * FloydSteinbergFactor, 1 * FloydSteinbergFactor); // (7, 3, 5, 1) = standard.
	var Context = Canvas.getContext("2d");
	var Data = Context.getImageData(0, 0, Canvas.width, Canvas.height);
	
	for(var Y = 0; Y < Canvas.height; Y++)
	{
		for(var X = 0; X < Canvas.width; X++)
		{
			var PixelIndex = (X + Y * Canvas.width) * 4;

			var Red = Data.data[PixelIndex];
			var Green = Data.data[PixelIndex + 1];
			var Blue = Data.data[PixelIndex + 2];
			var Alpha = Data.data[PixelIndex + 3];
			
			if(Alpha == 255)
			{
				// Find the matching color index.
				
				var LastDistance = Number.MAX_VALUE;
				var RemappedPaletteIndex = 0;
				
				for(var PaletteIndex = 0; PaletteIndex < Palette.length; PaletteIndex++)
				{
					var RedDelta = Palette[PaletteIndex].Red - Red;
					var GreenDelta = Palette[PaletteIndex].Green - Green;
					var BlueDelta = Palette[PaletteIndex].Blue - Blue;
	
					var Distance = RedDelta * RedDelta + GreenDelta * GreenDelta + BlueDelta * BlueDelta; 
					
					if(Distance < LastDistance)
					{
						RemappedPaletteIndex = PaletteIndex;
						LastDistance = Distance;
					}
				}
	
				if(FloydSteinbergFactor != 0)
				{
					var RedDelta = Palette[RemappedPaletteIndex].Red - Red;
					var GreenDelta = Palette[RemappedPaletteIndex].Green - Green;
					var BlueDelta = Palette[RemappedPaletteIndex].Blue - Blue;

					if(X < Canvas.width - 1)
					{
						Data.data[PixelIndex + 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 4] - RedDelta * FloydSteinbergCoefficients[0] / 16)));
						Data.data[PixelIndex + 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 4 + 1] - GreenDelta * FloydSteinbergCoefficients[0] / 16)));
						Data.data[PixelIndex + 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 4 + 2] - BlueDelta * FloydSteinbergCoefficients[0] / 16)));
					}
	
					if(Y < Canvas.height - 1)
					{
						if(X > 0)
						{
							Data.data[PixelIndex + Canvas.width * 4 - 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 4] - RedDelta * FloydSteinbergCoefficients[1] / 16)));
							Data.data[PixelIndex + Canvas.width * 4 - 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 4 + 1] - GreenDelta * FloydSteinbergCoefficients[1] / 16)));
							Data.data[PixelIndex + Canvas.width * 4 - 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 4 + 2] - BlueDelta * FloydSteinbergCoefficients[1] / 16)));
						}
						
						Data.data[PixelIndex + Canvas.width * 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4] - RedDelta * FloydSteinbergCoefficients[2] / 16)));
						Data.data[PixelIndex + Canvas.width * 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 1] - GreenDelta * FloydSteinbergCoefficients[2] / 16)));
						Data.data[PixelIndex + Canvas.width * 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 2] - BlueDelta * FloydSteinbergCoefficients[2] / 16)));
	
						if(X < Canvas.width - 1)
						{
							Data.data[PixelIndex + Canvas.width * 4 + 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 4] - RedDelta * FloydSteinbergCoefficients[3] / 16)));
							Data.data[PixelIndex + Canvas.width * 4 + 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 4 + 1] - GreenDelta * FloydSteinbergCoefficients[3] / 16)));
							Data.data[PixelIndex + Canvas.width * 4 + 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 4 + 2] - BlueDelta * FloydSteinbergCoefficients[3] / 16)));
						}
					}
				}

				Data.data[PixelIndex] = Palette[RemappedPaletteIndex].Red;
				Data.data[PixelIndex + 1] = Palette[RemappedPaletteIndex].Green;
				Data.data[PixelIndex + 2] = Palette[RemappedPaletteIndex].Blue;
				Data.data[PixelIndex + 3] = 255;
			}
		}
	}
	
	Context.putImageData(Data, 0, 0);
}

function RemapImageLuminance(Canvas, Colors, DitherPattern)
{
	var Context = Canvas.getContext("2d");
	var Data = Context.getImageData(0, 0, Canvas.width, Canvas.height);

	var MixedColors = new Array();
	
	if(DitherPattern && DitherPattern[0] == 1 && Colors.length <= 64)
	{
		var ColorCount = Colors.length;
		
		for(var Index1 = 0; Index1 < ColorCount; Index1++)
		{
			for(var Index2 = Index1 + 1; Index2 < ColorCount; Index2++)
			{
				var Luminance1 = Colors[Index1].Red * 0.21 + Colors[Index1].Green * 0.72 + Colors[Index1].Blue * 0.07;
				var Luminance2 = Colors[Index2].Red * 0.21 + Colors[Index2].Green * 0.72 + Colors[Index2].Blue * 0.07;
				var LuminanceDeltaSquare = (Luminance1 - Luminance2) * (Luminance1 - Luminance2); 
				
				//if(LuminanceDeltaSquare < 48 * 48)
				MixedColors.push({ Index1: Index1, Index2: Index2, Red: Math.round((Colors[Index1].Red + Colors[Index2].Red) / 2.0), Green: Math.round((Colors[Index1].Green + Colors[Index2].Green) / 2.0), Blue: Math.round((Colors[Index1].Blue + Colors[Index2].Blue) / 2.0) });
			}
		}
	}
	
	for(var Y = 0; Y < Canvas.height; Y++)
	{
		for(var X = 0; X < Canvas.width; X++)
		{
			var PixelIndex = (X + Y * Canvas.width) * 4;

			var Red = Data.data[PixelIndex];
			var Green = Data.data[PixelIndex + 1];
			var Blue = Data.data[PixelIndex + 2];
			var Alpha = Data.data[PixelIndex + 3];
			var Luminance = Red * 0.21 + Green * 0.72 + Blue * 0.07;
			
			if(Alpha == 255)
			{
				// Find the matching color index.
				
				var LastDistance = Number.MAX_VALUE;
				var RemappedColorIndex = 0;
				
				for(var ColorIndex = 0; ColorIndex < Colors.length; ColorIndex++)
				{
					var RedDelta = Colors[ColorIndex].Red - Red;
					var GreenDelta = Colors[ColorIndex].Green - Green;
					var BlueDelta = Colors[ColorIndex].Blue - Blue;
	
					var Luminance2 = Colors[ColorIndex].Red * 0.21 + Colors[ColorIndex].Green * 0.72 + Colors[ColorIndex].Blue * 0.07; 
					var LuminanceDelta = Luminance2 - Luminance;
					
					//var Distance = (RedDelta * RedDelta * 0.21 + GreenDelta * GreenDelta * 0.72 + BlueDelta * BlueDelta * 0.07) * 0.75 + LuminanceDelta * LuminanceDelta; 
					var Distance = (RedDelta * RedDelta + GreenDelta * GreenDelta + BlueDelta * BlueDelta) * 0.5 + LuminanceDelta * LuminanceDelta; 
					
					if(Distance < LastDistance)
					{
						RemappedColorIndex = ColorIndex;
						LastDistance = Distance;
					}
				}
	
				if(DitherPattern)
				{
					if(DitherPattern[0] == 1) // Checker pattern.
					{
						for(var ColorIndex = 0; ColorIndex < MixedColors.length; ColorIndex++)
						{
							var RedDelta = MixedColors[ColorIndex].Red - Red;
							var GreenDelta = MixedColors[ColorIndex].Green - Green;
							var BlueDelta = MixedColors[ColorIndex].Blue - Blue;
			
							var Luminance2 = MixedColors[ColorIndex].Red * 0.21 + MixedColors[ColorIndex].Green * 0.72 + MixedColors[ColorIndex].Blue * 0.07; 
							var LuminanceDelta = Luminance2 - Luminance;
							
							//var Distance = (RedDelta * RedDelta * 0.21 + GreenDelta * GreenDelta * 0.72 + BlueDelta * BlueDelta * 0.07) * 0.75 + LuminanceDelta * LuminanceDelta; 
							var Distance1 = (RedDelta * RedDelta + GreenDelta * GreenDelta + BlueDelta * BlueDelta) * 0.5 + LuminanceDelta * LuminanceDelta; 
							
							RedDelta = Colors[MixedColors[ColorIndex].Index1].Red - Red;
							GreenDelta = Colors[MixedColors[ColorIndex].Index1].Green - Green;
							BlueDelta = Colors[MixedColors[ColorIndex].Index1].Blue - Blue;
			
							Luminance2 = Colors[MixedColors[ColorIndex].Index1].Red * 0.21 + Colors[MixedColors[ColorIndex].Index1].Green * 0.72 + Colors[MixedColors[ColorIndex].Index1].Blue * 0.07; 
							LuminanceDelta = Luminance2 - Luminance;
							
							//var Distance = (RedDelta * RedDelta * 0.21 + GreenDelta * GreenDelta * 0.72 + BlueDelta * BlueDelta * 0.07) * 0.75 + LuminanceDelta * LuminanceDelta; 
							var Distance2 = (RedDelta * RedDelta + GreenDelta * GreenDelta + BlueDelta * BlueDelta) * 0.5 + LuminanceDelta * LuminanceDelta; 
							
							RedDelta = Colors[MixedColors[ColorIndex].Index2].Red - Red;
							GreenDelta = Colors[MixedColors[ColorIndex].Index2].Green - Green;
							BlueDelta = Colors[MixedColors[ColorIndex].Index2].Blue - Blue;
			
							Luminance2 = Colors[MixedColors[ColorIndex].Index2].Red * 0.21 + Colors[MixedColors[ColorIndex].Index2].Green * 0.72 + Colors[MixedColors[ColorIndex].Index2].Blue * 0.07; 
							LuminanceDelta = Luminance2 - Luminance;
							
							//var Distance = (RedDelta * RedDelta * 0.21 + GreenDelta * GreenDelta * 0.72 + BlueDelta * BlueDelta * 0.07) * 0.75 + LuminanceDelta * LuminanceDelta; 
							var Distance3 = (RedDelta * RedDelta + GreenDelta * GreenDelta + BlueDelta * BlueDelta) * 0.5 + LuminanceDelta * LuminanceDelta; 
							
							var Distance = (Distance1 * 8 + Distance2 + Distance3) / 10;
							
							if(Distance < LastDistance)
							{
								RemappedColorIndex = ((X ^ Y) & 1) ? MixedColors[ColorIndex].Index1 : MixedColors[ColorIndex].Index2;
								LastDistance = Distance;
							}
						}
					}
					else // Error diffusion.
					{
						var RedDelta = Colors[RemappedColorIndex].Red - Red;
						var GreenDelta = Colors[RemappedColorIndex].Green - Green;
						var BlueDelta = Colors[RemappedColorIndex].Blue - Blue;
	
						if(X < Canvas.width - 2)
						{
							if(DitherPattern[4])
							{
								Data.data[PixelIndex + 8] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 8] - RedDelta * DitherPattern[4])));
								Data.data[PixelIndex + 8 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 8 + 1] - GreenDelta * DitherPattern[4])));
								Data.data[PixelIndex + 8 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 8 + 2] - BlueDelta * DitherPattern[4])));
							}
	
							if(Y < Canvas.height - 1 && DitherPattern[9])
							{
								Data.data[PixelIndex + Canvas.width * 4 + 8] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 8] - RedDelta * DitherPattern[9])));
								Data.data[PixelIndex + Canvas.width * 4 + 8 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 8 + 1] - GreenDelta * DitherPattern[9])));
								Data.data[PixelIndex + Canvas.width * 4 + 8 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 8 + 2] - BlueDelta * DitherPattern[9])));
							}
	
							if(Y < Canvas.height - 2 && DitherPattern[14])
							{
								Data.data[PixelIndex + Canvas.width * 2 * 4 + 8] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 8] - RedDelta * DitherPattern[14])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 + 8 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 8 + 1] - GreenDelta * DitherPattern[14])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 + 8 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 8 + 2] - BlueDelta * DitherPattern[14])));
							}
						}
						
						if(X < Canvas.width - 1)
						{
							if(DitherPattern[3])
							{
								Data.data[PixelIndex + 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 4] - RedDelta * DitherPattern[3])));
								Data.data[PixelIndex + 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 4 + 1] - GreenDelta * DitherPattern[3])));
								Data.data[PixelIndex + 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 4 + 2] - BlueDelta * DitherPattern[3])));
							}
	
							if(Y < Canvas.height - 1 && DitherPattern[8])
							{
								Data.data[PixelIndex + Canvas.width * 4 + 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 4] - RedDelta * DitherPattern[8])));
								Data.data[PixelIndex + Canvas.width * 4 + 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 4 + 1] - GreenDelta * DitherPattern[8])));
								Data.data[PixelIndex + Canvas.width * 4 + 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 4 + 2] - BlueDelta * DitherPattern[8])));
							}
	
							if(Y < Canvas.height - 2 && DitherPattern[13])
							{
								Data.data[PixelIndex + Canvas.width * 2 * 4 + 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 4] - RedDelta * DitherPattern[13])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 + 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 4 + 1] - GreenDelta * DitherPattern[13])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 + 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 4 + 2] - BlueDelta * DitherPattern[13])));
							}
						}
						
						if(Y < Canvas.height - 1 && DitherPattern[7])
						{
							Data.data[PixelIndex + Canvas.width * 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4] - RedDelta * DitherPattern[7])));
							Data.data[PixelIndex + Canvas.width * 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 1] - GreenDelta * DitherPattern[7])));
							Data.data[PixelIndex + Canvas.width * 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 2] - BlueDelta * DitherPattern[7])));
						}
	
						if(Y < Canvas.height - 2 && DitherPattern[12])
						{
							Data.data[PixelIndex + Canvas.width * 2 * 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4] - RedDelta * DitherPattern[12])));
							Data.data[PixelIndex + Canvas.width * 2 * 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 1] - GreenDelta * DitherPattern[12])));
							Data.data[PixelIndex + Canvas.width * 2 * 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 2] - BlueDelta * DitherPattern[12])));
						}
	
						if(X > 0)
						{
							if(Y < Canvas.height - 1 && DitherPattern[6])
							{
								Data.data[PixelIndex + Canvas.width * 4 - 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 4] - RedDelta * DitherPattern[6])));
								Data.data[PixelIndex + Canvas.width * 4 - 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 4 + 1] - GreenDelta * DitherPattern[6])));
								Data.data[PixelIndex + Canvas.width * 4 - 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 4 + 2] - BlueDelta * DitherPattern[6])));
							}
	
							if(Y < Canvas.height - 2 && DitherPattern[11])
							{
								Data.data[PixelIndex + Canvas.width * 2 * 4 - 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 - 4] - RedDelta * DitherPattern[11])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 - 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 - 4 + 1] - GreenDelta * DitherPattern[11])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 - 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 - 4 + 2] - BlueDelta * DitherPattern[11])));
							}
						}
						
						if(X > 1)
						{
							if(Y < Canvas.height - 1 && DitherPattern[5])
							{
								Data.data[PixelIndex + Canvas.width * 4 - 8] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 8] - RedDelta * DitherPattern[5])));
								Data.data[PixelIndex + Canvas.width * 4 - 8 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 8 + 1] - GreenDelta * DitherPattern[5])));
								Data.data[PixelIndex + Canvas.width * 4 - 8 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 8 + 2] - BlueDelta * DitherPattern[5])));
							}
	
							if(Y < Canvas.height - 2 && DitherPattern[10])
							{
								Data.data[PixelIndex + Canvas.width * 2 * 4 - 8] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 - 8] - RedDelta * DitherPattern[10])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 - 8 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 - 8 + 1] - GreenDelta * DitherPattern[10])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 - 8 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 - 8 + 2] - BlueDelta * DitherPattern[10])));
							}
						}
					}
				}

				Data.data[PixelIndex] = Colors[RemappedColorIndex].Red;
				Data.data[PixelIndex + 1] = Colors[RemappedColorIndex].Green;
				Data.data[PixelIndex + 2] = Colors[RemappedColorIndex].Blue;
				Data.data[PixelIndex + 3] = 255;
			}
		}
	}
	
	Context.putImageData(Data, 0, 0);
}

function RemapZxSpectrumImageLuminance1(Canvas, Colors, DitherPattern)
{
	var Context = Canvas.getContext("2d");
	var Data = Context.getImageData(0, 0, Canvas.width, Canvas.height);

	var CanvasList = new Array();
	var ColorsMatrix = new Array(Math.ceil(Canvas.width / 8) * Math.ceil(Canvas.height / 8));
	
	// Create a valid colors list.
	
	for(var Index1 = 0; Index1 < 8 - 1; Index1++)
	{
		for(var Index2 = Index1 + 1; Index2 < 8; Index2++)
		{
			// First color block entry.
			
			var NewCanvas = document.createElement("canvas");
			
			NewCanvas.width = Canvas.width;
			NewCanvas.height = Canvas.height;
			
			NewCanvas.getContext("2d").drawImage(Canvas, 0, 0);		

			RemapImageLuminance(NewCanvas, [{ Red: Colors[Index1].Red, Green: Colors[Index1].Green, Blue: Colors[Index1].Blue }, { Red: Colors[Index2].Red, Green: Colors[Index2].Green, Blue: Colors[Index2].Blue }], DitherPattern);

			CanvasList.push({ Canvas: NewCanvas, Colors: [{ Red: Colors[Index1].Red, Green: Colors[Index1].Green, Blue: Colors[Index1].Blue }, { Red: Colors[Index2].Red, Green: Colors[Index2].Green, Blue: Colors[Index2].Blue }] });

			// Second color block entry.
			
			NewCanvas = document.createElement("canvas");
			
			NewCanvas.width = Canvas.width;
			NewCanvas.height = Canvas.height;
			
			NewCanvas.getContext("2d").drawImage(Canvas, 0, 0);		
			
			RemapImageLuminance(NewCanvas, [{ Red: Colors[Index1 + 8].Red, Green: Colors[Index1 + 8].Green, Blue: Colors[Index1 + 8].Blue }, { Red: Colors[Index2 + 8].Red, Green: Colors[Index2 + 8].Green, Blue: Colors[Index2 + 8].Blue }], DitherPattern);
			
			CanvasList.push({ Canvas: NewCanvas, Colors: [{ Red: Colors[Index1 + 8].Red, Green: Colors[Index1 + 8].Green, Blue: Colors[Index1 + 8].Blue }, { Red: Colors[Index2 + 8].Red, Green: Colors[Index2 + 8].Green, Blue: Colors[Index2 + 8].Blue }] });
		}
	}
	
	// Create colors matrix.
	
	for(var Y = 0; Y < Math.ceil(Canvas.height / 8); Y++)
	{
		for(var X = 0; X < Math.ceil(Canvas.width / 8); X++)
		{
			var BestColorsListIndex = 0;
			var LastDistance = Number.MAX_VALUE;

			for(var ColorsListIndex = 0; ColorsListIndex < CanvasList.length; ColorsListIndex++)
			{
				var TotalDistance = 0;
				
				for(var Y2 = 0; Y2 < 8; Y2++)
				{
					for(var X2 = 0; X2 < 8; X2++)
					{
						var PixelIndex = (X * 8 + X2 + (Y * 8 + Y2) * Canvas.width) * 4;

						var Red = Data.data[PixelIndex];
						var Green = Data.data[PixelIndex + 1];
						var Blue = Data.data[PixelIndex + 2];
						var Alpha = Data.data[PixelIndex + 3];
						var Luminance = Red * 0.21 + Green * 0.72 + Blue * 0.07;

						// First color.
						
						var RedDelta = CanvasList[ColorsListIndex].Colors[0].Red - Red;
						var GreenDelta = CanvasList[ColorsListIndex].Colors[0].Green - Green;
						var BlueDelta = CanvasList[ColorsListIndex].Colors[0].Blue - Blue;
		
						var Luminance2 = CanvasList[ColorsListIndex].Colors[0].Red * 0.21 + CanvasList[ColorsListIndex].Colors[0].Green * 0.72 + CanvasList[ColorsListIndex].Colors[0].Blue * 0.07; 
						var LuminanceDelta = Luminance2 - Luminance;
						
						//var Distance = (RedDelta * RedDelta * 0.21 + GreenDelta * GreenDelta * 0.72 + BlueDelta * BlueDelta * 0.07) * 0.75 + LuminanceDelta * LuminanceDelta; 
						var Distance = (RedDelta * RedDelta + GreenDelta * GreenDelta + BlueDelta * BlueDelta) * 0.5 + LuminanceDelta * LuminanceDelta; 

						// Second color.
						
						RedDelta = CanvasList[ColorsListIndex].Colors[1].Red - Red;
						GreenDelta = CanvasList[ColorsListIndex].Colors[1].Green - Green;
						BlueDelta = CanvasList[ColorsListIndex].Colors[1].Blue - Blue;
		
						Luminance2 = CanvasList[ColorsListIndex].Colors[1].Red * 0.21 + CanvasList[ColorsListIndex].Colors[1].Green * 0.72 + CanvasList[ColorsListIndex].Colors[1].Blue * 0.07; 
						LuminanceDelta = Luminance2 - Luminance;
						
						//var Distance2 = (RedDelta * RedDelta * 0.21 + GreenDelta * GreenDelta * 0.72 + BlueDelta * BlueDelta * 0.07) * 0.75 + LuminanceDelta * LuminanceDelta; 
						var Distance2 = (RedDelta * RedDelta + GreenDelta * GreenDelta + BlueDelta * BlueDelta) * 0.5 + LuminanceDelta * LuminanceDelta; 

						TotalDistance += Math.min(Distance, Distance2);
					}
				}
				
				if(TotalDistance < LastDistance)
				{
					BestColorsListIndex = ColorsListIndex;
					LastDistance = TotalDistance;
				}
			}

			Canvas.getContext("2d").drawImage(CanvasList[BestColorsListIndex].Canvas, X * 8, Y * 8, 8, 8, X * 8, Y * 8, 8, 8);
		}
	}
}

function RemapZxSpectrumImageLuminance2(Canvas, Colors, DitherPattern)
{
	var Context = Canvas.getContext("2d");
	var Data = Context.getImageData(0, 0, Canvas.width, Canvas.height);

	var CanvasList = new Array();
	var ColorsMatrix = new Array(Math.ceil(Canvas.width / 8) * Math.ceil(Canvas.height / 8));
	
	// Create a valid colors list.
	
	for(var Index1 = 0; Index1 < 8 - 1; Index1++)
	{
		for(var Index2 = Index1 + 1; Index2 < 8; Index2++)
		{
			// First color block entry.
			
			var NewCanvas = document.createElement("canvas");
			
			NewCanvas.width = Canvas.width;
			NewCanvas.height = Canvas.height;
			
			NewCanvas.getContext("2d").drawImage(Canvas, 0, 0);		

			RemapImageLuminance(NewCanvas, [{ Red: Colors[Index1].Red, Green: Colors[Index1].Green, Blue: Colors[Index1].Blue }, { Red: Colors[Index2].Red, Green: Colors[Index2].Green, Blue: Colors[Index2].Blue }], DitherPattern);

			CanvasList.push({ Canvas: NewCanvas, Colors: [{ Red: Colors[Index1].Red, Green: Colors[Index1].Green, Blue: Colors[Index1].Blue }, { Red: Colors[Index2].Red, Green: Colors[Index2].Green, Blue: Colors[Index2].Blue }] });

			// Second color block entry.
			
			NewCanvas = document.createElement("canvas");
			
			NewCanvas.width = Canvas.width;
			NewCanvas.height = Canvas.height;
			
			NewCanvas.getContext("2d").drawImage(Canvas, 0, 0);		
			
			RemapImageLuminance(NewCanvas, [{ Red: Colors[Index1 + 8].Red, Green: Colors[Index1 + 8].Green, Blue: Colors[Index1 + 8].Blue }, { Red: Colors[Index2 + 8].Red, Green: Colors[Index2 + 8].Green, Blue: Colors[Index2 + 8].Blue }], DitherPattern);
			
			CanvasList.push({ Canvas: NewCanvas, Colors: [{ Red: Colors[Index1 + 8].Red, Green: Colors[Index1 + 8].Green, Blue: Colors[Index1 + 8].Blue }, { Red: Colors[Index2 + 8].Red, Green: Colors[Index2 + 8].Green, Blue: Colors[Index2 + 8].Blue }] });
		}
	}
	
	// Create colors matrix.
	
	for(var Y = 0; Y < Math.ceil(Canvas.height / 8); Y++)
	{
		for(var X = 0; X < Math.ceil(Canvas.width / 8); X++)
		{
			var BestColorsListIndex = 0;
			var LastDistance = Number.MAX_VALUE;

			for(var ColorsListIndex = 0; ColorsListIndex < CanvasList.length; ColorsListIndex++)
			{
				var TotalDistance = 0;
				var Data2 = CanvasList[ColorsListIndex].Canvas.getContext("2d").getImageData(0, 0, CanvasList[ColorsListIndex].Canvas.width, CanvasList[ColorsListIndex].Canvas.height);
				
				for(var Y2 = 0; Y2 < 8; Y2++)
				{
					for(var X2 = 0; X2 < 8; X2++)
					{
						var PixelIndex1 = (X * 8 + X2 + (Y * 8 + Y2) * Canvas.width) * 4;
						var PixelIndex2 = (X * 8 + X2 + (Y * 8 + Y2) * CanvasList[ColorsListIndex].Canvas.width) * 4;

						var Alpha = Data.data[PixelIndex1 + 3];
					
						if(Alpha == 255)
						{
							var Red1 = Data.data[PixelIndex1];
							var Green1 = Data.data[PixelIndex1 + 1];
							var Blue1 = Data.data[PixelIndex1 + 2];
							var Luminance1 = Red1 * 0.21 + Green1 * 0.72 + Blue1 * 0.07;

							var Red2 = Data2.data[PixelIndex2];
							var Green2 = Data2.data[PixelIndex2 + 1];
							var Blue2 = Data2.data[PixelIndex2 + 2];
							var Luminance2 = Red2 * 0.21 + Green2 * 0.72 + Blue2 * 0.07;
							
							var RedDelta = Red2 - Red1;
							var GreenDelta = Green2 - Green1;
							var BlueDelta = Blue2 - Blue1;
							var LuminanceDelta = Luminance2 - Luminance1;
							
							//var Distance = (RedDelta * RedDelta * 0.21 + GreenDelta * GreenDelta * 0.72 + BlueDelta * BlueDelta * 0.07) * 0.75 + LuminanceDelta * LuminanceDelta; 
							//var Distance = (RedDelta * RedDelta + GreenDelta * GreenDelta + BlueDelta * BlueDelta) * 0.5 + LuminanceDelta * LuminanceDelta; 
							var Distance = RedDelta * RedDelta + GreenDelta * GreenDelta + BlueDelta * BlueDelta; 

							TotalDistance += Distance;
						}
					}
				}
				
				if(TotalDistance < LastDistance)
				{
					BestColorsListIndex = ColorsListIndex;
					LastDistance = TotalDistance;
				}
			}

			Canvas.getContext("2d").drawImage(CanvasList[BestColorsListIndex].Canvas, X * 8, Y * 8, 8, 8, X * 8, Y * 8, 8, 8);
		}
	}
}

function RemapZxSpectrumImageLuminance3(Canvas, Colors, DitherPattern)
{
	var Context = Canvas.getContext("2d");
	var Data = Context.getImageData(0, 0, Canvas.width, Canvas.height);

	var CanvasList = new Array();
	var ColorsMatrix = new Array(Math.ceil(Canvas.width / 8) * Math.ceil(Canvas.height / 8));
	
	// Create a valid colors list.
	
	for(var Index1 = 0; Index1 < 8 - 1; Index1++)
	{
		for(var Index2 = Index1 + 1; Index2 < 8; Index2++)
		{
			// First color block entry.
			
			var NewCanvas = document.createElement("canvas");
			
			NewCanvas.width = Canvas.width;
			NewCanvas.height = Canvas.height;
			
			NewCanvas.getContext("2d").drawImage(Canvas, 0, 0);		

			RemapImageLuminance(NewCanvas, [{ Red: Colors[Index1].Red, Green: Colors[Index1].Green, Blue: Colors[Index1].Blue }, { Red: Colors[Index2].Red, Green: Colors[Index2].Green, Blue: Colors[Index2].Blue }], DitherPattern);

			CanvasList.push({ Canvas: NewCanvas, Colors: [{ Red: Colors[Index1].Red, Green: Colors[Index1].Green, Blue: Colors[Index1].Blue }, { Red: Colors[Index2].Red, Green: Colors[Index2].Green, Blue: Colors[Index2].Blue }] });

			// Second color block entry.
			
			NewCanvas = document.createElement("canvas");
			
			NewCanvas.width = Canvas.width;
			NewCanvas.height = Canvas.height;
			
			NewCanvas.getContext("2d").drawImage(Canvas, 0, 0);		
			
			RemapImageLuminance(NewCanvas, [{ Red: Colors[Index1 + 8].Red, Green: Colors[Index1 + 8].Green, Blue: Colors[Index1 + 8].Blue }, { Red: Colors[Index2 + 8].Red, Green: Colors[Index2 + 8].Green, Blue: Colors[Index2 + 8].Blue }], DitherPattern);
			
			CanvasList.push({ Canvas: NewCanvas, Colors: [{ Red: Colors[Index1 + 8].Red, Green: Colors[Index1 + 8].Green, Blue: Colors[Index1 + 8].Blue }, { Red: Colors[Index2 + 8].Red, Green: Colors[Index2 + 8].Green, Blue: Colors[Index2 + 8].Blue }] });
		}
	}
	
	// Create colors matrix.
	
	for(var Y = 0; Y < Math.ceil(Canvas.height / 8); Y++)
	{
		for(var X = 0; X < Math.ceil(Canvas.width / 8); X++)
		{
			var BestColorsListIndex = 0;
			var LastDistance = Number.MAX_VALUE;

			for(var ColorsListIndex = 0; ColorsListIndex < CanvasList.length; ColorsListIndex++)
			{
				var Red1 = 0;
				var Green1 = 0;
				var Blue1 = 0;

				var Red2 = 0;
				var Green2 = 0;
				var Blue2 = 0;

				var Data2 = CanvasList[ColorsListIndex].Canvas.getContext("2d").getImageData(0, 0, CanvasList[ColorsListIndex].Canvas.width, CanvasList[ColorsListIndex].Canvas.height);
				
				for(var Y2 = 0; Y2 < 8; Y2++)
				{
					for(var X2 = 0; X2 < 8; X2++)
					{
						var PixelIndex1 = (X * 8 + X2 + (Y * 8 + Y2) * Canvas.width) * 4;
						var PixelIndex2 = (X * 8 + X2 + (Y * 8 + Y2) * CanvasList[ColorsListIndex].Canvas.width) * 4;

						Red1 += Data.data[PixelIndex1];
						Green1 += Data.data[PixelIndex1 + 1];
						Blue1 += Data.data[PixelIndex1 + 2];

						Red2 += Data2.data[PixelIndex2];
						Green2 += Data2.data[PixelIndex2 + 1];
						Blue2 += Data2.data[PixelIndex2 + 2];
					}
				}
				
				var Red1 = Red1 >> 6;
				var Green1 = Green1 >> 6;
				var Blue1 = Blue1 >> 6;
				var Luminance1 = Red1 * 0.21 + Green1 * 0.72 + Blue1 * 0.07;

				var Red2 = Red2 >> 6;
				var Green2 = Green2 >> 6;
				var Blue2 = Blue2 >> 6;
				var Luminance2 = Red2 * 0.21 + Green2 * 0.72 + Blue2 * 0.07;
				
				var RedDelta = Red2 - Red1;
				var GreenDelta = Green2 - Green1;
				var BlueDelta = Blue2 - Blue1;
				var LuminanceDelta = Luminance2 - Luminance1;
				
				//var Distance = (RedDelta * RedDelta * 0.21 + GreenDelta * GreenDelta * 0.72 + BlueDelta * BlueDelta * 0.07) * 0.75 + LuminanceDelta * LuminanceDelta; 
				//var Distance = (RedDelta * RedDelta + GreenDelta * GreenDelta + BlueDelta * BlueDelta) * 0.5 + LuminanceDelta * LuminanceDelta; 
				//var Distance = RedDelta * RedDelta + GreenDelta * GreenDelta + BlueDelta * BlueDelta; 
				//var Distance = LuminanceDelta * LuminanceDelta;
				var Distance = RedDelta * RedDelta * 0.21 + GreenDelta * GreenDelta * 0.72 + BlueDelta * BlueDelta * 0.07;
				
				if(Distance < LastDistance)
				{
					BestColorsListIndex = ColorsListIndex;
					LastDistance = Distance;
				}
			}

			Canvas.getContext("2d").drawImage(CanvasList[BestColorsListIndex].Canvas, X * 8, Y * 8, 8, 8, X * 8, Y * 8, 8, 8);
		}
	}
}

function RemapLineColorsImageLuminance(Canvas, LineColors, DitherPattern)
{
	var Context = Canvas.getContext("2d");
	var Data = Context.getImageData(0, 0, Canvas.width, Canvas.height);

	for(var Y = 0; Y < Canvas.height; Y++)
	{
		var Colors = LineColors[Y];
		
		var MixedColors = new Array();
		
		if(DitherPattern && DitherPattern[0] == 1 && Colors.length <= 64)
		{
			var ColorCount = Colors.length;
			
			for(var Index1 = 0; Index1 < ColorCount; Index1++)
			{
				for(var Index2 = Index1 + 1; Index2 < ColorCount; Index2++)
				{
					var Luminance1 = Colors[Index1].Red * 0.21 + Colors[Index1].Green * 0.72 + Colors[Index1].Blue * 0.07;
					var Luminance2 = Colors[Index2].Red * 0.21 + Colors[Index2].Green * 0.72 + Colors[Index2].Blue * 0.07;
					var LuminanceDeltaSquare = (Luminance1 - Luminance2) * (Luminance1 - Luminance2); 
					
					//if(LuminanceDeltaSquare < 48 * 48)
					MixedColors.push({ Index1: Index1, Index2: Index2, Red: Math.round((Colors[Index1].Red + Colors[Index2].Red) / 2.0), Green: Math.round((Colors[Index1].Green + Colors[Index2].Green) / 2.0), Blue: Math.round((Colors[Index1].Blue + Colors[Index2].Blue) / 2.0) });
				}
			}
		}
		
		for(var X = 0; X < Canvas.width; X++)
		{
			var PixelIndex = (X + Y * Canvas.width) * 4;

			var Red = Data.data[PixelIndex];
			var Green = Data.data[PixelIndex + 1];
			var Blue = Data.data[PixelIndex + 2];
			var Alpha = Data.data[PixelIndex + 3];
			var Luminance = Red * 0.21 + Green * 0.72 + Blue * 0.07;
			
			if(Alpha == 255)
			{
				// Find the matching color index.
				
				var LastDistance = Number.MAX_VALUE;
				var RemappedColorIndex = 0;
				
				for(var ColorIndex = 0; ColorIndex < Colors.length; ColorIndex++)
				{
					var RedDelta = Colors[ColorIndex].Red - Red;
					var GreenDelta = Colors[ColorIndex].Green - Green;
					var BlueDelta = Colors[ColorIndex].Blue - Blue;
	
					var Luminance2 = Colors[ColorIndex].Red * 0.21 + Colors[ColorIndex].Green * 0.72 + Colors[ColorIndex].Blue * 0.07; 
					var LuminanceDelta = Luminance2 - Luminance;
					
					//var Distance = (RedDelta * RedDelta * 0.21 + GreenDelta * GreenDelta * 0.72 + BlueDelta * BlueDelta * 0.07) * 0.75 + LuminanceDelta * LuminanceDelta; 
					var Distance = (RedDelta * RedDelta + GreenDelta * GreenDelta + BlueDelta * BlueDelta) * 0.5 + LuminanceDelta * LuminanceDelta; 
					
					if(Distance < LastDistance)
					{
						RemappedColorIndex = ColorIndex;
						LastDistance = Distance;
					}
				}
	
				if(DitherPattern)
				{
					if(DitherPattern[0] == 1) // Checker pattern.
					{
						for(var ColorIndex = 0; ColorIndex < MixedColors.length; ColorIndex++)
						{
							var RedDelta = MixedColors[ColorIndex].Red - Red;
							var GreenDelta = MixedColors[ColorIndex].Green - Green;
							var BlueDelta = MixedColors[ColorIndex].Blue - Blue;
			
							var Luminance2 = MixedColors[ColorIndex].Red * 0.21 + MixedColors[ColorIndex].Green * 0.72 + MixedColors[ColorIndex].Blue * 0.07; 
							var LuminanceDelta = Luminance2 - Luminance;
							
							//var Distance = (RedDelta * RedDelta * 0.21 + GreenDelta * GreenDelta * 0.72 + BlueDelta * BlueDelta * 0.07) * 0.75 + LuminanceDelta * LuminanceDelta; 
							var Distance1 = (RedDelta * RedDelta + GreenDelta * GreenDelta + BlueDelta * BlueDelta) * 0.5 + LuminanceDelta * LuminanceDelta; 
							
							RedDelta = Colors[MixedColors[ColorIndex].Index1].Red - Red;
							GreenDelta = Colors[MixedColors[ColorIndex].Index1].Green - Green;
							BlueDelta = Colors[MixedColors[ColorIndex].Index1].Blue - Blue;
			
							Luminance2 = Colors[MixedColors[ColorIndex].Index1].Red * 0.21 + Colors[MixedColors[ColorIndex].Index1].Green * 0.72 + Colors[MixedColors[ColorIndex].Index1].Blue * 0.07; 
							LuminanceDelta = Luminance2 - Luminance;
							
							//var Distance = (RedDelta * RedDelta * 0.21 + GreenDelta * GreenDelta * 0.72 + BlueDelta * BlueDelta * 0.07) * 0.75 + LuminanceDelta * LuminanceDelta; 
							var Distance2 = (RedDelta * RedDelta + GreenDelta * GreenDelta + BlueDelta * BlueDelta) * 0.5 + LuminanceDelta * LuminanceDelta; 
							
							RedDelta = Colors[MixedColors[ColorIndex].Index2].Red - Red;
							GreenDelta = Colors[MixedColors[ColorIndex].Index2].Green - Green;
							BlueDelta = Colors[MixedColors[ColorIndex].Index2].Blue - Blue;
			
							Luminance2 = Colors[MixedColors[ColorIndex].Index2].Red * 0.21 + Colors[MixedColors[ColorIndex].Index2].Green * 0.72 + Colors[MixedColors[ColorIndex].Index2].Blue * 0.07; 
							LuminanceDelta = Luminance2 - Luminance;
							
							//var Distance = (RedDelta * RedDelta * 0.21 + GreenDelta * GreenDelta * 0.72 + BlueDelta * BlueDelta * 0.07) * 0.75 + LuminanceDelta * LuminanceDelta; 
							var Distance3 = (RedDelta * RedDelta + GreenDelta * GreenDelta + BlueDelta * BlueDelta) * 0.5 + LuminanceDelta * LuminanceDelta; 
							
							var Distance = (Distance1 * 8 + Distance2 + Distance3) / 10;
							
							if(Distance < LastDistance)
							{
								RemappedColorIndex = ((X ^ Y) & 1) ? MixedColors[ColorIndex].Index1 : MixedColors[ColorIndex].Index2;
								LastDistance = Distance;
							}
						}
					}
					else // Error diffusion.
					{
						var RedDelta = Colors[RemappedColorIndex].Red - Red;
						var GreenDelta = Colors[RemappedColorIndex].Green - Green;
						var BlueDelta = Colors[RemappedColorIndex].Blue - Blue;
	
						if(X < Canvas.width - 2)
						{
							if(DitherPattern[4])
							{
								Data.data[PixelIndex + 8] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 8] - RedDelta * DitherPattern[4])));
								Data.data[PixelIndex + 8 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 8 + 1] - GreenDelta * DitherPattern[4])));
								Data.data[PixelIndex + 8 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 8 + 2] - BlueDelta * DitherPattern[4])));
							}
	
							if(Y < Canvas.height - 1 && DitherPattern[9])
							{
								Data.data[PixelIndex + Canvas.width * 4 + 8] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 8] - RedDelta * DitherPattern[9])));
								Data.data[PixelIndex + Canvas.width * 4 + 8 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 8 + 1] - GreenDelta * DitherPattern[9])));
								Data.data[PixelIndex + Canvas.width * 4 + 8 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 8 + 2] - BlueDelta * DitherPattern[9])));
							}
	
							if(Y < Canvas.height - 2 && DitherPattern[14])
							{
								Data.data[PixelIndex + Canvas.width * 2 * 4 + 8] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 8] - RedDelta * DitherPattern[14])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 + 8 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 8 + 1] - GreenDelta * DitherPattern[14])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 + 8 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 8 + 2] - BlueDelta * DitherPattern[14])));
							}
						}
						
						if(X < Canvas.width - 1)
						{
							if(DitherPattern[3])
							{
								Data.data[PixelIndex + 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 4] - RedDelta * DitherPattern[3])));
								Data.data[PixelIndex + 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 4 + 1] - GreenDelta * DitherPattern[3])));
								Data.data[PixelIndex + 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 4 + 2] - BlueDelta * DitherPattern[3])));
							}
	
							if(Y < Canvas.height - 1 && DitherPattern[8])
							{
								Data.data[PixelIndex + Canvas.width * 4 + 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 4] - RedDelta * DitherPattern[8])));
								Data.data[PixelIndex + Canvas.width * 4 + 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 4 + 1] - GreenDelta * DitherPattern[8])));
								Data.data[PixelIndex + Canvas.width * 4 + 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 4 + 2] - BlueDelta * DitherPattern[8])));
							}
	
							if(Y < Canvas.height - 2 && DitherPattern[13])
							{
								Data.data[PixelIndex + Canvas.width * 2 * 4 + 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 4] - RedDelta * DitherPattern[13])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 + 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 4 + 1] - GreenDelta * DitherPattern[13])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 + 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 4 + 2] - BlueDelta * DitherPattern[13])));
							}
						}
						
						if(Y < Canvas.height - 1 && DitherPattern[7])
						{
							Data.data[PixelIndex + Canvas.width * 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4] - RedDelta * DitherPattern[7])));
							Data.data[PixelIndex + Canvas.width * 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 1] - GreenDelta * DitherPattern[7])));
							Data.data[PixelIndex + Canvas.width * 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 2] - BlueDelta * DitherPattern[7])));
						}
	
						if(Y < Canvas.height - 2 && DitherPattern[12])
						{
							Data.data[PixelIndex + Canvas.width * 2 * 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4] - RedDelta * DitherPattern[12])));
							Data.data[PixelIndex + Canvas.width * 2 * 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 1] - GreenDelta * DitherPattern[12])));
							Data.data[PixelIndex + Canvas.width * 2 * 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 2] - BlueDelta * DitherPattern[12])));
						}
	
						if(X > 0)
						{
							if(Y < Canvas.height - 1 && DitherPattern[6])
							{
								Data.data[PixelIndex + Canvas.width * 4 - 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 4] - RedDelta * DitherPattern[6])));
								Data.data[PixelIndex + Canvas.width * 4 - 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 4 + 1] - GreenDelta * DitherPattern[6])));
								Data.data[PixelIndex + Canvas.width * 4 - 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 4 + 2] - BlueDelta * DitherPattern[6])));
							}
	
							if(Y < Canvas.height - 2 && DitherPattern[11])
							{
								Data.data[PixelIndex + Canvas.width * 2 * 4 - 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 - 4] - RedDelta * DitherPattern[11])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 - 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 - 4 + 1] - GreenDelta * DitherPattern[11])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 - 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 - 4 + 2] - BlueDelta * DitherPattern[11])));
							}
						}
						
						if(X > 1)
						{
							if(Y < Canvas.height - 1 && DitherPattern[5])
							{
								Data.data[PixelIndex + Canvas.width * 4 - 8] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 8] - RedDelta * DitherPattern[5])));
								Data.data[PixelIndex + Canvas.width * 4 - 8 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 8 + 1] - GreenDelta * DitherPattern[5])));
								Data.data[PixelIndex + Canvas.width * 4 - 8 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 8 + 2] - BlueDelta * DitherPattern[5])));
							}
	
							if(Y < Canvas.height - 2 && DitherPattern[10])
							{
								Data.data[PixelIndex + Canvas.width * 2 * 4 - 8] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 - 8] - RedDelta * DitherPattern[10])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 - 8 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 - 8 + 1] - GreenDelta * DitherPattern[10])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 - 8 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 - 8 + 2] - BlueDelta * DitherPattern[10])));
							}
						}
					}
				}

				Data.data[PixelIndex] = Colors[RemappedColorIndex].Red;
				Data.data[PixelIndex + 1] = Colors[RemappedColorIndex].Green;
				Data.data[PixelIndex + 2] = Colors[RemappedColorIndex].Blue;
				Data.data[PixelIndex + 3] = 255;
			}
		}
	}
	
	Context.putImageData(Data, 0, 0);
}

function RemapFullPaletteImageLuminance(Canvas, BitsPerColor, DitherPattern)
{
	var Context = Canvas.getContext("2d");
	var Data = Context.getImageData(0, 0, Canvas.width, Canvas.height);
	var ShadesPerColor = 1 << BitsPerColor;
	
	for(var Y = 0; Y < Canvas.height; Y++)
	{
		for(var X = 0; X < Canvas.width; X++)
		{
			var PixelIndex = (X + Y * Canvas.width) * 4;

			var Red = Data.data[PixelIndex];
			var Green = Data.data[PixelIndex + 1];
			var Blue = Data.data[PixelIndex + 2];
			var Alpha = Data.data[PixelIndex + 3];
			var Luminance = Red * 0.21 + Green * 0.72 + Blue * 0.07;
			
			if(Alpha == 255)
			{
				if(DitherPattern)
				{
					if(DitherPattern[0] == 1) // Checker pattern.
					{
					}
					else // Error diffusion.
					{
						var MatchingRed = Math.floor(Math.floor(Red * ShadesPerColor / 256.0) * (255.0 / (ShadesPerColor - 1.0)));
						var MatchingGreen = Math.floor(Math.floor(Green * ShadesPerColor / 256.0) * (255.0 / (ShadesPerColor - 1.0)));
						var MatchingBlue = Math.floor(Math.floor(Blue * ShadesPerColor / 256.0) * (255.0 / (ShadesPerColor - 1.0)));
						
						var RedDelta = MatchingRed - Red;
						var GreenDelta = MatchingGreen - Green;
						var BlueDelta = MatchingBlue - Blue;
	
						if(X < Canvas.width - 2)
						{
							if(DitherPattern[4])
							{
								Data.data[PixelIndex + 8] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 8] - RedDelta * DitherPattern[4])));
								Data.data[PixelIndex + 8 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 8 + 1] - GreenDelta * DitherPattern[4])));
								Data.data[PixelIndex + 8 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 8 + 2] - BlueDelta * DitherPattern[4])));
							}
	
							if(Y < Canvas.height - 1 && DitherPattern[9])
							{
								Data.data[PixelIndex + Canvas.width * 4 + 8] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 8] - RedDelta * DitherPattern[9])));
								Data.data[PixelIndex + Canvas.width * 4 + 8 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 8 + 1] - GreenDelta * DitherPattern[9])));
								Data.data[PixelIndex + Canvas.width * 4 + 8 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 8 + 2] - BlueDelta * DitherPattern[9])));
							}
	
							if(Y < Canvas.height - 2 && DitherPattern[14])
							{
								Data.data[PixelIndex + Canvas.width * 2 * 4 + 8] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 8] - RedDelta * DitherPattern[14])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 + 8 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 8 + 1] - GreenDelta * DitherPattern[14])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 + 8 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 8 + 2] - BlueDelta * DitherPattern[14])));
							}
						}
						
						if(X < Canvas.width - 1)
						{
							if(DitherPattern[3])
							{
								Data.data[PixelIndex + 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 4] - RedDelta * DitherPattern[3])));
								Data.data[PixelIndex + 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 4 + 1] - GreenDelta * DitherPattern[3])));
								Data.data[PixelIndex + 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + 4 + 2] - BlueDelta * DitherPattern[3])));
							}
	
							if(Y < Canvas.height - 1 && DitherPattern[8])
							{
								Data.data[PixelIndex + Canvas.width * 4 + 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 4] - RedDelta * DitherPattern[8])));
								Data.data[PixelIndex + Canvas.width * 4 + 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 4 + 1] - GreenDelta * DitherPattern[8])));
								Data.data[PixelIndex + Canvas.width * 4 + 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 4 + 2] - BlueDelta * DitherPattern[8])));
							}
	
							if(Y < Canvas.height - 2 && DitherPattern[13])
							{
								Data.data[PixelIndex + Canvas.width * 2 * 4 + 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 4] - RedDelta * DitherPattern[13])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 + 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 4 + 1] - GreenDelta * DitherPattern[13])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 + 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 4 + 2] - BlueDelta * DitherPattern[13])));
							}
						}
						
						if(Y < Canvas.height - 1 && DitherPattern[7])
						{
							Data.data[PixelIndex + Canvas.width * 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4] - RedDelta * DitherPattern[7])));
							Data.data[PixelIndex + Canvas.width * 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 1] - GreenDelta * DitherPattern[7])));
							Data.data[PixelIndex + Canvas.width * 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 + 2] - BlueDelta * DitherPattern[7])));
						}
	
						if(Y < Canvas.height - 2 && DitherPattern[12])
						{
							Data.data[PixelIndex + Canvas.width * 2 * 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4] - RedDelta * DitherPattern[12])));
							Data.data[PixelIndex + Canvas.width * 2 * 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 1] - GreenDelta * DitherPattern[12])));
							Data.data[PixelIndex + Canvas.width * 2 * 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 + 2] - BlueDelta * DitherPattern[12])));
						}
	
						if(X > 0)
						{
							if(Y < Canvas.height - 1 && DitherPattern[6])
							{
								Data.data[PixelIndex + Canvas.width * 4 - 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 4] - RedDelta * DitherPattern[6])));
								Data.data[PixelIndex + Canvas.width * 4 - 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 4 + 1] - GreenDelta * DitherPattern[6])));
								Data.data[PixelIndex + Canvas.width * 4 - 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 4 + 2] - BlueDelta * DitherPattern[6])));
							}
	
							if(Y < Canvas.height - 2 && DitherPattern[11])
							{
								Data.data[PixelIndex + Canvas.width * 2 * 4 - 4] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 - 4] - RedDelta * DitherPattern[11])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 - 4 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 - 4 + 1] - GreenDelta * DitherPattern[11])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 - 4 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 - 4 + 2] - BlueDelta * DitherPattern[11])));
							}
						}
						
						if(X > 1)
						{
							if(Y < Canvas.height - 1 && DitherPattern[5])
							{
								Data.data[PixelIndex + Canvas.width * 4 - 8] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 8] - RedDelta * DitherPattern[5])));
								Data.data[PixelIndex + Canvas.width * 4 - 8 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 8 + 1] - GreenDelta * DitherPattern[5])));
								Data.data[PixelIndex + Canvas.width * 4 - 8 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 4 - 8 + 2] - BlueDelta * DitherPattern[5])));
							}
	
							if(Y < Canvas.height - 2 && DitherPattern[10])
							{
								Data.data[PixelIndex + Canvas.width * 2 * 4 - 8] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 - 8] - RedDelta * DitherPattern[10])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 - 8 + 1] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 - 8 + 1] - GreenDelta * DitherPattern[10])));
								Data.data[PixelIndex + Canvas.width * 2 * 4 - 8 + 2] = Math.round(Math.min(255, Math.max(0, Data.data[PixelIndex + Canvas.width * 2 * 4 - 8 + 2] - BlueDelta * DitherPattern[10])));
							}
						}
					}
				}

				Data.data[PixelIndex] = MatchingRed;
				Data.data[PixelIndex + 1] = MatchingGreen;
				Data.data[PixelIndex + 2] = MatchingBlue;
				Data.data[PixelIndex + 3] = 255;
			}
		}
	}
	
	Context.putImageData(Data, 0, 0);
}

function CreateBlob(tImageCanvas)
{
	var tBlobData = new Uint16Array(tImageCanvas.width * tImageCanvas.height)

	var tImageContext = tImageCanvas.getContext("2d");
	var Data = tImageContext.getImageData(0, 0, tImageCanvas.width, tImageCanvas.height);

	for(var tY = 0; tY < tImageCanvas.height; tY++)
	{
		for(var tX = 0; tX < tImageCanvas.width; tX++)
		{
			var PixelIndex = (tX + tY * tImageCanvas.width) * 4;

			var tRed = Data.data[PixelIndex];
			var tGreen = Data.data[PixelIndex + 1];
			var tBlue = Data.data[PixelIndex + 2];
			
			var tTrueColor = tRed << 8 | tGreen << 3 | tBlue >> 3;
			
			tBlobData[tX + tY * tImageCanvas.width] = ((tTrueColor & 0xff) << 8) | (tTrueColor >> 8);;
		}
	}
	
	return tBlobData;
}

function CreateDownloadLink(tElementId, tImageCanvas, tFileName)
{
	var tImageBlob = CreateBlob(tImageCanvas);
	
	var tElement = document.getElementById(tElementId);
	
	tElement.innerHTML = tImageCanvas.width + " x " + tImageCanvas.height + " pixels, " + (tImageBlob.length * 2) + " bytes: ";
	
	var tLinkElement = document.createElement("a");
	var tText = document.createTextNode(tFileName);
	
	tLinkElement.appendChild(tText);
	tLinkElement.title = "True color data";
	tLinkElement.href = URL.createObjectURL(new Blob([tImageBlob], { type: "application/octet-binary" }));
	tLinkElement.download = tFileName;
	
	tElement.appendChild(tLinkElement);
}

function CreateImageWindow(ImageInfos)
{
	var ImageScaleFactor = 1;
	
	while(ImageInfos.Image.width * ImageScaleFactor < 640)
		ImageScaleFactor++;
	
	var OriginalCanvas = document.createElement("canvas");
	
	OriginalCanvas.id = "original_canvas_" + ImageInfos.Id;
	OriginalCanvas.className = "image_canvas_class";
	OriginalCanvas.width = ImageInfos.Image.width;
	OriginalCanvas.height = ImageInfos.Image.height;
	OriginalCanvas.style.position = "absolute";
	OriginalCanvas.style.width = OriginalCanvas.width * ImageScaleFactor;
	
	if(ImageInfos.AspectX && ImageInfos.AspectY)
		OriginalCanvas.style.height = Math.floor(OriginalCanvas.height * ImageScaleFactor * ImageInfos.AspectY / ImageInfos.AspectX);
	else
		OriginalCanvas.style.height = OriginalCanvas.height * ImageScaleFactor;
	
	OriginalCanvas.getContext("2d").drawImage(ImageInfos.Image, 0, 0, ImageInfos.Image.width, ImageInfos.Image.height);		

	var DisplayCanvas = document.createElement("canvas");
	
	DisplayCanvas.id = "display_canvas_" + ImageInfos.Id;
	DisplayCanvas.className = "image_canvas_class";
	DisplayCanvas.width = ImageInfos.Image.width;
	DisplayCanvas.height = ImageInfos.Image.height;
	DisplayCanvas.style.position = "absolute";
	DisplayCanvas.style.width = OriginalCanvas.style.width;
	DisplayCanvas.style.height = OriginalCanvas.style.height;
	
	DisplayCanvas.getContext("2d").drawImage(ImageInfos.Image, 0, 0, ImageInfos.Image.width, ImageInfos.Image.height);		

	var PaletteCanvas = document.createElement("canvas");
	
	PaletteCanvas.id = "colors_canvas_" + ImageInfos.Id;
	PaletteCanvas.className = "colors_canvas_class";
	PaletteCanvas.width = ImageInfos.Image.width;
	PaletteCanvas.height = LineHeight;
	PaletteCanvas.style.position = "absolute";
	PaletteCanvas.style.width = OriginalCanvas.style.width;
	PaletteCanvas.style.height = LineHeight;

	var WindowDiv = document.createElement("div");
	var TitleBarDiv = document.createElement("div");
	var MenuDiv = document.createElement("div");
	var ImageDiv = document.createElement("div");
	var ColorsDiv = document.createElement("div");
	var TitleTextSpan = document.createElement("span");
	var CloseLabel = document.createElement("label");

	WindowDiv.ImageInfos = ImageInfos;
	
	WindowDiv.id = "window_div_" + ImageInfos.Id;
	WindowDiv.className = "window_class";
	WindowDiv.draggable = "true";
	WindowDiv.style.left = (GlobalWindowIdCounter * LineHeight) % 640;
	WindowDiv.style.top = (GlobalWindowIdCounter * LineHeight) % 400;
	WindowDiv.style.width = OriginalCanvas.style.width;
	WindowDiv.style.height = parseInt(OriginalCanvas.style.height, 10) + LineHeight + LineHeight + LineHeight;
	WindowDiv.style.zIndex = GlobalWindowZIndexCounter++;
	WindowDiv.addEventListener("dragstart", function(Event) { Event.dataTransfer.setData("Text", Event.screenX + "," + Event.screenY + "," + this.id); }, false);
	//WindowDiv.addEventListener("touchstart", function(Event) { Event.dataTransfer.setData("Text", Event.screenX + "," + Event.screenY + "," + this.id); }, false);
	WindowDiv.addEventListener("click", function(Event) { this.style.zIndex = GlobalWindowZIndexCounter++; }, false);
	
	TitleBarDiv.id = "title_bar_div_" + ImageInfos.Id;
	TitleBarDiv.style.width = OriginalCanvas.style.width;
	TitleBarDiv.style.height = LineHeight;

	TitleTextSpan.id = "title_text_span_" + ImageInfos.Id;
	TitleTextSpan.style.float = "left";
	TitleTextSpan.style.display = "block";
	TitleTextSpan.style.textAlign = "center";
	TitleTextSpan.style.width = parseInt(DisplayCanvas.style.width, 10) - LineWidth;
	TitleTextSpan.style.height = "100%";
	TitleTextSpan.style.userSelect = "none";
	TitleTextSpan.style.backgroundColor = WindowColor;
	//TitleTextSpan.style.verticalAlign = "middle";
	//TitleTextSpan.style.paddingTop = "2";
	TitleTextSpan.innerHTML = encodeURIComponent(ImageInfos.FileName) + " [" + ImageInfos.Image.width + " x " + ImageInfos.Image.height + ", " + GetColors(DisplayCanvas).length + " colours]";
	
	TitleBarDiv.appendChild(TitleTextSpan);
	
	CloseLabel.id = "close_label_" + ImageInfos.Id;
	CloseLabel.className = "window_button_class";
	CloseLabel.style.float = "right";
	CloseLabel.style.display = "block";
	CloseLabel.style.textAlign = "center";
	CloseLabel.style.width = LineWidth;
	CloseLabel.style.height = "100%";
	CloseLabel.style.backgroundColor = WindowColor;
	//CloseLabel.style.paddingTop = "2";
	CloseLabel.innerHTML = "X";
	//CloseLabel.addEventListener("mouseenter", function(Event) { this.style.backgroundColor = WindowHiliteColor; }, false);
	//CloseLabel.addEventListener("mouseleave", function(Event) { this.style.backgroundColor = WindowColor; }, false);
	CloseLabel.addEventListener("click", function(Event) { this.parentNode.parentNode.parentNode.removeChild(this.parentNode.parentNode); }, false);

	TitleBarDiv.appendChild(CloseLabel);
	
	MenuDiv.id = "menu_div_" + ImageInfos.Id;
	MenuDiv.className = "menu_class";
	MenuDiv.style.width = DisplayCanvas.style.width;
	MenuDiv.style.height = LineHeight;
	MenuDiv.style.overflow = "hidden"; 

	MenuDiv.appendChild(CreateMenuItem(ImageInfos.Id,
		{ 
			Type: "checkbox", 
			Name: "global_colors", 
			Text: "Global Colours", 
			Action: function() { SetGlobalColors(this); }
		}));
			
	MenuDiv.appendChild(CreateMenuItem(ImageInfos.Id,
		{ 
			Type: "label", 
			Name: "colors", 
			Text: "Colours", 
			Options: new Array(
				{ Name: "original", Text: "Original", Default: true }, 
				{ Name: "─", Text: "────────", Disabled: true },
				{ Name: "2", Text: "2" }, 
				{ Name: "4", Text: "4" }, 
				{ Name: "8", Text: "8" }, 
				{ Name: "16", Text: "16" }, 
				{ Name: "32", Text: "32" }, 
				{ Name: "64", Text: "64" }, 
				{ Name: "128", Text: "128" }, 
				{ Name: "256", Text: "256" },
				{ Name: "─", Text: "────────", Disabled: true },
				{ Name: "zx", Text: "16 (ZX Spectrum)" }, 
//				{ Name: "16pchg", Text: "16 (PCHG)" }, 
//				{ Name: "32pchg", Text: "32 (PCHG)" }, 
				{ Name: "ehb", Text: "64 (EHB)" }, 
				{ Name: "256-884", Text: "256 (8-8-4)" },
				{ Name: "palette", Text: "Palette" }, 
				{ Name: "─", Text: "────────", Disabled: true },
				{ Name: "global", Text: "Global" }),
			Action: function() { ProcessMenuAction(this.id.substring(this.id.lastIndexOf("_") + 1)); }
		}));
		
	MenuDiv.appendChild(CreateMenuItem(ImageInfos.Id,
		{ 
			Type: "label", 
			Name: "palette", 
			Text: "Palette", 
			Options: new Array(
				{ Name: "256", Text: "256 (8-8-4)" }, 
				{ Name: "512", Text: "512 (ST)" }, 
				{ Name: "4096", Text: "4096 (STE/OCS/ECS)", Default: true }, 
				{ Name: "262144", Text: "262144 (F030)" }, 
				{ Name: "16777216", Text: "16777216 (AGA)" }), 
			Action: function() { ProcessMenuAction(this.id.substring(this.id.lastIndexOf("_") + 1)); }
		}));

	MenuDiv.appendChild(CreateMenuItem(ImageInfos.Id,
		{ 
			Type: "label", 
			Name: "dither", 
			Text: "Dither", 
			Options: new Array(
				{ Name: "none", Text: "None" }, 
				{ Name: "checks", Text: "Checks" }, 
				{ Name: "fs", Text: "Floyd-Steinberg" }, 
				{ Name: "fs85", Text: "Floyd-Steinberg (85%)" }, 
				{ Name: "fs75", Text: "Floyd-Steinberg (75%)", Default: true }, 
				{ Name: "ffs", Text: "False Floyd-Steinberg" }, 
				{ Name: "jjn", Text: "Jarvis, Judice, and Ninke" }, 
				{ Name: "s", Text: "Stucki" }, 
				{ Name: "a", Text: "Atkinson" }, 
				{ Name: "b", Text: "Burkes" }, 
				{ Name: "s", Text: "Sierra" }, 
				{ Name: "trs", Text: "Two-Row Sierra" }, 
				{ Name: "sl", Text: "Sierra Lite" }), 
			Action: function() { ProcessMenuAction(this.id.substring(this.id.lastIndexOf("_") + 1)); }
		}));
	/*
	MenuDiv.appendChild(CreateMenuItem(ImageInfos.Id,
		{ 
			Type: "label", 
			Name: "remap", 
			Text: "Remap", 
			Options: new Array(
				{ Name: "rgb", Text: "RGB" }, 
				{ Name: "rgbl", Text: "RGBL", Default: true }), 
			Action: function() { ProcessMenuAction(this.id.substring(this.id.lastIndexOf("_") + 1)); }
		}));
	
	MenuDiv.appendChild(CreateMenuItem(ImageInfos.Id,
		{ 
			Type: "label", 
			Name: "format", 
			Text: "Format", 
			Options: new Array(
				{ Name: "pi1", Text: "PI1" }, 
				{ Name: "iff", Text: "IFF" }), 
			Action: null
		}));
	*/
	MenuDiv.appendChild(CreateMenuItem(ImageInfos.Id,
		{ 
			Type: "button", 
			Name: "save", 
			Text: "Save", 
			Action: function() { SaveImage(this.id.substring(this.id.lastIndexOf("_") + 1)); }
		}));
		
	ImageDiv.id = "image_div_" + ImageInfos.Id;
	ImageDiv.style.width = OriginalCanvas.style.width;
	ImageDiv.style.height = OriginalCanvas.style.height;

	ImageDiv.appendChild(OriginalCanvas);
	ImageDiv.appendChild(DisplayCanvas);
	
	ColorsDiv.id = "colors_div_" + ImageInfos.Id;
	ColorsDiv.style.width = OriginalCanvas.style.width;
	ColorsDiv.style.height = LineHeight;

	ColorsDiv.appendChild(PaletteCanvas);
	
	WindowDiv.appendChild(TitleBarDiv);
	WindowDiv.appendChild(MenuDiv);
	WindowDiv.appendChild(ImageDiv);
	WindowDiv.appendChild(ColorsDiv);
	
	return WindowDiv;
}

function CreateMenuItem(Id, Item)
{
	var MenuItemDiv = document.createElement("div");
	
	MenuItemDiv.id = "menu_" + Item.Name + "_div_" + Id;
	MenuItemDiv.className = "menu_item_class";
	MenuItemDiv.style.height = LineHeight;
	
	switch(Item.Type)
	{
	case "label":
		var Label = document.createElement("label");
		var Select = document.createElement("select");

		Label.id = "menu_" + Item.Name + "_label_" + Id;
		Label.className = "menu_label_class";
		Label.style.height = LineHeight;
		Label.innerHTML = Item.Text + ":";
		Label.htmlFor = "menu_" + Item.Name + "_select_" + Id;
		
		Select.id = "menu_" + Item.Name + "_select_" + Id;
		Select.className = "menu_select_class";
		Select.style.height = LineHeight;
		Select.addEventListener("change", Item.Action, false);

		for(var Index = 0; Index < Item.Options.length; Index++)
		{
			var Option = document.createElement("option");

			Option.id = "menu_" + Item.Name + "_" + Item.Options[Index].Name + "_option_" + Id;
			Option.className = "menu_option_class";
			Option.innerHTML = Item.Options[Index].Text;

			if(Item.Options[Index].Disabled)
				Option.disabled = true;
			
			if(localStorage)
			{
				if(localStorage.getItem("menu_" + Item.Name + "_select"))
				{
					if(localStorage.getItem("menu_" + Item.Name + "_select") == Item.Options[Index].Text)
						Option.selected = true;
				}
				else if(Item.Options[Index].Default)
				{
					localStorage.setItem("menu_" + Item.Name + "_select", Item.Options[Index].Text);
					Option.selected = true;
				}
			}
			else if(Item.Options[Index].Default)
			{
				Option.selected = true;
			}
			
			Select.appendChild(Option);
		}

		MenuItemDiv.appendChild(Label);
		MenuItemDiv.appendChild(Select);
		
		break;
		
	case "button":
		var Input = document.createElement("input");

		Input.id = "menu_" + Item.Name + "_input_" + Id;
		Input.className = "menu_input_class";
		Input.type = "button";
		Input.style.height = LineHeight;
		Input.value = Item.Text;
		Input.addEventListener("click", Item.Action, false);
		
		MenuItemDiv.appendChild(Input);
		
		break;

	case "checkbox":
		var Input = document.createElement("input");

		Input.id = "menu_" + Item.Name + "_input_" + Id;
		Input.className = "menu_input_class";
		Input.type = "checkbox";
		Input.style.height = LineHeight;
		Input.innerHTML = Item.Text;
		Input.addEventListener("click", Item.Action, false);
		
		MenuItemDiv.appendChild(Input);
		
		break;
	}
	
	return MenuItemDiv;
}

function ProcessMenuAction(Id)
{
	document.getElementById("menu_global_colors_input_" + Id).checked = false;
	
	var OriginalCanvas = document.getElementById("original_canvas_" + Id);
	var DisplayCanvas = document.getElementById("display_canvas_" + Id);

	var ImageInfos = document.getElementById("window_div_" + Id).ImageInfos;
	
	DisplayCanvas.getContext("2d").drawImage(OriginalCanvas, 0, 0);		

	var ColorsSelection = document.getElementById("menu_colors_select_" + Id).value;
	var PaletteSelection = document.getElementById("menu_palette_select_" + Id).value;
	var DitherSelection = document.getElementById("menu_dither_select_" + Id).value;

	var PaletteColors = parseInt(PaletteSelection.substr(0, PaletteSelection.indexOf(" ")));

	if(localStorage)
	{
		localStorage.setItem("menu_colors_select", ColorsSelection);
		localStorage.setItem("menu_palette_select", PaletteSelection);
		localStorage.setItem("menu_dither_select", DitherSelection);
	}
	
	switch(ColorsSelection)
	{
	case "Original":
		ImageInfos.QuantizedColors = GetColors(DisplayCanvas);
		
		break;
	
	default:
		var DitherPattern = null;
		
		switch(DitherSelection)
		{
		case "Checks":
			DitherPattern = [ 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ];
			
			break;
			
		case "Floyd-Steinberg":
			DitherPattern = [ 0, 0, 0, 7.0 / 16.0, 0, 0, 3.0 / 16.0, 5.0 / 16.0, 1.0 / 16.0, 0, 0, 0, 0, 0, 0 ];
			
			break;
			
		case "Floyd-Steinberg (85%)":
			DitherPattern = [ 0, 0, 0, 7.0 * 0.85 / 16.0, 0, 0, 3.0 * 0.85 / 16.0, 5.0 * 0.85 / 16.0, 1.0 * 0.85 / 16.0, 0, 0, 0, 0, 0, 0 ];
			
			break;
			
		case "Floyd-Steinberg (75%)":
			DitherPattern = [ 0, 0, 0, 7.0 * 0.75 / 16.0, 0, 0, 3.0 * 0.75 / 16.0, 5.0 * 0.75 / 16.0, 1.0 * 0.75 / 16.0, 0, 0, 0, 0, 0, 0 ];
		
			break;
		
		case "False Floyd-Steinberg":
			DitherPattern = [ 0, 0, 0, 3.0 / 8.0, 0, 0, 0, 3.0 / 8.0, 2.0 / 8.0, 0, 0, 0, 0, 0, 0 ];
		
			break;
	
		case "Jarvis, Judice, and Ninke":
			DitherPattern = [ 0, 0, 0, 7.0 / 48.0, 5.0 / 48.0, 3.0 / 48.0, 5.0 / 48.0, 7.0 / 48.0, 5.0 / 48.0, 3.0 / 48.0, 1.0 / 48.0, 3.0 / 48.0, 5.0 / 48.0, 3.0 / 48.0, 1.0 / 48.0 ];
		
			break;
	
		case "Stucki":
			DitherPattern = [ 0, 0, 0, 8.0 / 42.0, 4.0 / 42.0, 2.0 / 42.0, 4.0 / 42.0, 8.0 / 42.0, 4.0 / 42.0, 2.0 / 42.0, 1.0 / 42.0, 2.0 / 42.0, 4.0 / 42.0, 2.0 / 42.0, 1.0 / 42.0 ];
		
			break;
		
		case "Atkinson":
			DitherPattern = [ 0, 0, 0, 1.0 / 8.0, 1.0 / 8.0, 0, 1.0 / 8.0, 1.0 / 8.0, 1.0 / 8.0, 0, 0, 0, 1.0 / 8.0, 0, 0 ];
		
			break;
		
		case "Burkes":
			DitherPattern = [ 0, 0, 0, 8.0 / 32.0, 4.0 / 32.0, 2.0 / 32.0, 4.0 / 32.0, 8.0 / 32.0, 4.0 / 32.0, 2.0 / 32.0, 0, 0, 0, 0, 0 ];
		
			break;
		
		case "Sierra":
			DitherPattern = [ 0, 0, 0, 5.0 / 32.0, 3.0 / 32.0, 2.0 / 32.0, 4.0 / 32.0, 5.0 / 32.0, 4.0 / 32.0, 2.0 / 32.0, 0, 2.0 / 32.0, 3.0 / 32.0, 2.0 / 32.0, 0 ];
		
			break;
		
		case "Two-Row Sierra":
			DitherPattern = [ 0, 0, 0, 4.0 / 16.0, 3.0 / 16.0, 1.0 / 16.0, 2.0 / 16.0, 3.0 / 16.0, 2.0 / 16.0, 1.0 / 16.0, 0, 0, 0, 0, 0 ];
		
			break;
		
		case "Sierra Lite":
			DitherPattern = [ 0, 0, 0, 2.0 / 4.0, 0, 0, 1.0 / 4.0, 1.0 / 4.0, 0, 0, 0, 0, 0, 0, 0 ];
		
			break;
		}
		
		var BitsPerColor = 1;

		if(PaletteColors == 256)
			BitsPerColor = 332;
		else
			while(Math.pow(Math.pow(2, BitsPerColor), 3) < PaletteColors)
				BitsPerColor++;
		
		ProcessImage(ImageInfos, DisplayCanvas, ColorsSelection, BitsPerColor, "RGBL", DitherPattern);
		
		break;
	}

	DisplayColors(ImageInfos.QuantizedColors, Id);
}

function ProcessImage(ImageInfos, ImageCanvas, ColorCount, BitsPerColor, RemappingMethod, DitherPattern)
{
	var EhbMode = false;
	var Colors = new Array();
	
	if(ColorCount == "Global")
	{
		for(var Index = 0; Index < GlobalColors.length; Index++)
			Colors.push({ Red: GlobalColors[Index].Red, Green: GlobalColors[Index].Green, Blue: GlobalColors[Index].Blue });
	}
	else if(ColorCount == "16 (ZX Spectrum)")
	{
		Colors.push({ Red: 0x00, Green: 0x00, Blue: 0x00 });
		Colors.push({ Red: 0x00, Green: 0x00, Blue: 0xcd });
		Colors.push({ Red: 0xcd, Green: 0x00, Blue: 0x00 });
		Colors.push({ Red: 0xcd, Green: 0x00, Blue: 0xcd });
		Colors.push({ Red: 0x00, Green: 0xcd, Blue: 0x00 });
		Colors.push({ Red: 0x00, Green: 0xcd, Blue: 0xcd });
		Colors.push({ Red: 0xcd, Green: 0xcd, Blue: 0x00 });
		Colors.push({ Red: 0xcd, Green: 0xcd, Blue: 0xcd });

		Colors.push({ Red: 0x00, Green: 0x00, Blue: 0x00 });
		Colors.push({ Red: 0x00, Green: 0x00, Blue: 0xff });
		Colors.push({ Red: 0xff, Green: 0x00, Blue: 0x00 });
		Colors.push({ Red: 0xff, Green: 0x00, Blue: 0xff });
		Colors.push({ Red: 0x00, Green: 0xff, Blue: 0x00 });
		Colors.push({ Red: 0x00, Green: 0xff, Blue: 0xff });
		Colors.push({ Red: 0xff, Green: 0xff, Blue: 0x00 });
		Colors.push({ Red: 0xff, Green: 0xff, Blue: 0xff });
	}
	else if(ColorCount == "16 (PCHG)" || ColorCount == "32 (PCHG)")
	{
		ColorCount = ColorCount.substr(0, ColorCount.indexOf(" "))

		var MaxRecursionDepth = 1;
		
		while(Math.pow(2, MaxRecursionDepth) < ColorCount)
			MaxRecursionDepth++;
		
		ImageInfos.LineColors = new Array();
		
		for(var LineIndex = 0; LineIndex < ImageCanvas.height; LineIndex++)
		{
			var LineCanvas = document.createElement("canvas");
			
			LineCanvas.width = ImageCanvas.width;
			LineCanvas.height = 1;
			
			LineCanvas.getContext("2d").drawImage(ImageCanvas, 0, LineIndex, ImageCanvas.width, 1, 0, 0, ImageCanvas.width, 1);		
			
			var ColorCube = CreateColorCube(LineCanvas);
			var ColorCubeInfo = TrimColorCube(ColorCube, { RedMin: 0, RedMax: 255, GreenMin: 0, GreenMax: 255, BlueMin: 0, BlueMax: 255 });
			
			Colors = new Array();
			
			QuantizeRecursive(ColorCube, ColorCubeInfo, Colors, 0, MaxRecursionDepth)
			
			Colors.sort(function (Color1, Color2) { return (Color1.Red * 0.21 + Color1.Green * 0.72 + Color1.Blue * 0.07) - (Color2.Red * 0.21 + Color2.Green * 0.72 + Color2.Blue * 0.07) });
			
			var ShadesPerColor = 1 << BitsPerColor;
			
			for(var Index = 0; Index < Colors.length; Index++)
			{
				Colors[Index].Red = Math.floor(Math.floor(Colors[Index].Red * ShadesPerColor / 256.0) * (255.0 / (ShadesPerColor - 1.0)));
				Colors[Index].Green = Math.floor(Math.floor(Colors[Index].Green * ShadesPerColor / 256.0) * (255.0 / (ShadesPerColor - 1.0)));
				Colors[Index].Blue = Math.floor(Math.floor(Colors[Index].Blue * ShadesPerColor / 256.0) * (255.0 / (ShadesPerColor - 1.0)));
			}
			
			ImageInfos.LineColors.push(Colors);
		}
	}
	else if(ColorCount == "256 (8-8-4)")
	{
		for(var Red = 0; Red < 256; Red += 255.0 / 7.0)
			for(var Green = 0; Green < 256; Green += 255.0 / 7.0)
				for(var Blue = 0; Blue < 256; Blue += 255.0 / 3.0)
					Colors.push({ Red: Math.round(Red), Green: Math.round(Green), Blue: Math.round(Blue) });
	}
	else if(ColorCount == "Palette")
	{
		Colors.push({ Red: 0, Green: 0, Blue: 0 });
		Colors.push({ Red: 255, Green: 255, Blue: 255 });
	}
	else
	{
		if(ColorCount == "64 (EHB)")
		{
			EhbMode = true;
			ColorCount = 32;
		}

		if(!ImageInfos.Colors || ImageInfos.Colors.length > ColorCount)
		{
			var ColorCube = CreateColorCube(ImageCanvas);
			var ColorCubeInfo = TrimColorCube(ColorCube, { RedMin: 0, RedMax: 255, GreenMin: 0, GreenMax: 255, BlueMin: 0, BlueMax: 255 });
			
			if(ColorCount == 2)
			{
				Colors.push({ Red: 0, Green: 0, Blue: 0 });
				Colors.push({ Red: 255, Green: 255, Blue: 255 });
			}
			else
			{
				var MaxRecursionDepth = 1;
				
				while(Math.pow(2, MaxRecursionDepth) < ColorCount)
					MaxRecursionDepth++;
				
				QuantizeRecursive(ColorCube, ColorCubeInfo, Colors, 0, MaxRecursionDepth)
				
				Colors.sort(function (Color1, Color2) { return (Color1.Red * 0.21 + Color1.Green * 0.72 + Color1.Blue * 0.07) - (Color2.Red * 0.21 + Color2.Green * 0.72 + Color2.Blue * 0.07) });
				
				if(Colors.length < ColorCount)
					console.log("Warning: " + Colors.length + "/" + ColorCount + " colors!");
	
				if(EhbMode)
				{
					while(Colors.length < 64)
						Colors.push({ Red: 0, Green: 0, Blue: 0 });
					
					for(var Index = 0; Index < 32; Index++)
					{
						var Red = Colors[Index].Red;
						var Green = Colors[Index].Green;
						var Blue = Colors[Index].Blue;
						
						if(Math.max(Red, Green, Blue) >= 128)
						{
							Colors[Index + 32].Red = Math.floor(Red / 2.0);
							Colors[Index + 32].Green = Math.floor(Green / 2.0);
							Colors[Index + 32].Blue = Math.floor(Blue / 2.0);
						}
						else
						{
							Colors[Index + 32].Red = Red;
							Colors[Index + 32].Green = Green;
							Colors[Index + 32].Blue = Blue;
	
							Colors[Index].Red = Red * 2;
							Colors[Index].Green = Green * 2;
							Colors[Index].Blue = Blue * 2;
						}
					}
				}
			}
		}
		else
		{
			for(var Index = 0; Index < ImageInfos.Colors.length; Index++)
				Colors.push({ Red: ImageInfos.Colors[Index].Red, Green: ImageInfos.Colors[Index].Green, Blue: ImageInfos.Colors[Index].Blue });
		}

		if(BitsPerColor == "332")
		{
			for(var Index = 0; Index < Colors.length; Index++)
			{
				Colors[Index].Red = Math.floor(Math.floor(Colors[Index].Red * 8.0 / 256.0) * (255.0 / (8.0 - 1.0)));
				Colors[Index].Green = Math.floor(Math.floor(Colors[Index].Green * 8.0 / 256.0) * (255.0 / (8.0 - 1.0)));
				Colors[Index].Blue = Math.floor(Math.floor(Colors[Index].Blue * 4.0 / 256.0) * (255.0 / (4.0 - 1.0)));
			}
		}
		else
		{
			var ShadesPerColor = 1 << BitsPerColor;
			
			for(var Index = 0; Index < Colors.length; Index++)
			{
				Colors[Index].Red = Math.floor(Math.floor(Colors[Index].Red * ShadesPerColor / 256.0) * (255.0 / (ShadesPerColor - 1.0)));
				Colors[Index].Green = Math.floor(Math.floor(Colors[Index].Green * ShadesPerColor / 256.0) * (255.0 / (ShadesPerColor - 1.0)));
				Colors[Index].Blue = Math.floor(Math.floor(Colors[Index].Blue * ShadesPerColor / 256.0) * (255.0 / (ShadesPerColor - 1.0)));
			}
		}
	}
	
	// Remap image.
	
	if(ColorCount == "16 (ZX Spectrum)")
	{
		RemapZxSpectrumImageLuminance1(ImageCanvas, Colors, DitherPattern);
	}
	else if(ImageInfos.LineColors)
	{
		RemapLineColorsImageLuminance(ImageCanvas, ImageInfos.LineColors, DitherPattern);
	}
	else if(ColorCount == "Palette")
	{
		RemapFullPaletteImageLuminance(ImageCanvas, BitsPerColor, DitherPattern);
	}
	else
	{
		switch(RemappingMethod)
		{
		case "RGB":
			RemapImage(ImageCanvas, Colors, DitherPattern);
	
			break;
	
		case "RGBL":
			RemapImageLuminance(ImageCanvas, Colors, DitherPattern);
	
			break;
		}
	}

	ImageInfos.QuantizedColors = Colors;
}

function DisplayColors(Colors, Id)
{
	var ColorsCanvas = document.getElementById("colors_canvas_" + Id);
	var ColorsContext = ColorsCanvas.getContext("2d");		
	var ColorsData = ColorsContext.getImageData(0, 0, ColorsCanvas.width, ColorsCanvas.height);

	for(var X = 0; X < ColorsCanvas.width; X++)
	{
		var ColorsIndex = Math.floor(X * Colors.length / ColorsCanvas.width);
		
		for(var Y = 0; Y < ColorsCanvas.height; Y++)
		{
			var PixelIndex = (X + Y * ColorsCanvas.width) * 4;

			ColorsData.data[PixelIndex] = Colors[ColorsIndex].Red;
			ColorsData.data[PixelIndex + 1] = Colors[ColorsIndex].Green;
			ColorsData.data[PixelIndex + 2] = Colors[ColorsIndex].Blue;
			ColorsData.data[PixelIndex + 3] = 255;
		}
	}

	ColorsContext.putImageData(ColorsData, 0, 0);
}

function SaveImage(Id)
{
	var ImageInfos = document.getElementById("window_div_" + Id).ImageInfos;
	var FormatSelection = "IFF"; //document.getElementById("menu_format_select_" + Id).value;
	var Canvas = document.getElementById("display_canvas_" + Id);
	var Colors;
	
	if(ImageInfos.Colors)
		Colors = ImageInfos.Colors;
	else
		Colors = GetColors(Canvas);
	
	switch(FormatSelection)
	{
	case "IFF":
		SaveIff(Canvas, Colors);
		
		break;
	}
}

function WriteIffChunkHeader(Data, DataIndex, Id, Size)
{
	for(var Index = 0; Index < Id.length; Index++)
		Data[DataIndex++] = Id.charCodeAt(Index);
	
	Data[DataIndex++] = (Size >> 24) & 0xff;
	Data[DataIndex++] = (Size >> 16) & 0xff;
	Data[DataIndex++] = (Size >> 8) & 0xff;
	Data[DataIndex++] = Size & 0xff;
	
	return DataIndex;
}

function SaveIff(Canvas, Colors)
{
	//alert(Colors.length);
	
	var NumberOfBitplanes = 1;

	while((1 << NumberOfBitplanes) < Colors.length)
		NumberOfBitplanes++;

	var DataIndex = 0;
	var AdjustedImageWidth = Math.ceil(Canvas.width / 16) * 16; 
	var BytesPerLine = AdjustedImageWidth / 8;
	var DataSize = 4 + 4 + 4 + 4 + 4 + 20 + 4 + 4 + 4 + 4 + 22 + 4 + 4; // "FORM" + size + "ILBM" + "BMHD" + size + 20 + "CMAP" + size + "ANNO" + size + "http://tool.anides.de\0" + "BODY" + size.   

	DataSize += Colors.length * 3 + BytesPerLine * NumberOfBitplanes * Canvas.height + (((Colors.length * 3) & 1) ? 1 : 0);
	
	var Data = new Uint8Array(DataSize);
	
	// "FORM".
	
	DataIndex = WriteIffChunkHeader(Data, DataIndex, "FORM", DataSize - 8);
	
	for(var Index = 0; Index < 4; Index++)
		Data[DataIndex++] = "ILBM".charCodeAt(Index);

	// "BMHD".
	
	DataIndex = WriteIffChunkHeader(Data, DataIndex, "BMHD", 20);

	Data[DataIndex++] = (AdjustedImageWidth >> 8) & 0xff;
	Data[DataIndex++] = AdjustedImageWidth & 0xff;

	Data[DataIndex++] = (Canvas.height >> 8) & 0xff;
	Data[DataIndex++] = Canvas.height & 0xff;

	Data[DataIndex++] = 0;
	Data[DataIndex++] = 0;
	Data[DataIndex++] = 0;
	Data[DataIndex++] = 0;
	
	Data[DataIndex++] = NumberOfBitplanes;
	
	Data[DataIndex++] = 0;
	Data[DataIndex++] = 0;
	Data[DataIndex++] = 0;
	Data[DataIndex++] = 0;
	Data[DataIndex++] = 0;
	Data[DataIndex++] = 1;
	Data[DataIndex++] = 1;

	Data[DataIndex++] = (AdjustedImageWidth >> 8) & 0xff;
	Data[DataIndex++] = AdjustedImageWidth & 0xff;

	Data[DataIndex++] = (Canvas.height >> 8) & 0xff;
	Data[DataIndex++] = Canvas.height & 0xff;

	// "CMAP".
	
	DataIndex = WriteIffChunkHeader(Data, DataIndex, "CMAP", Colors.length * 3);
	
	for(var Index = 0; Index < Colors.length; Index++)
	{
		Data[DataIndex++] = Colors[Index].Red;
		Data[DataIndex++] = Colors[Index].Green;
		Data[DataIndex++] = Colors[Index].Blue;
	}
	
	if((Colors.length * 3) & 1)
		Data[DataIndex++] = 0;
	
	// "ANNO".
	
	DataIndex = WriteIffChunkHeader(Data, DataIndex, "ANNO", 21);

	var AnnotationText = "http://tool.anides.de"; // Fixed length!
	
	for(var Index = 0; Index < AnnotationText.length; Index++)
		Data[DataIndex++] = AnnotationText.charCodeAt(Index);

	Data[DataIndex++] = 0;
	
	// "BODY".
	
	DataIndex = WriteIffChunkHeader(Data, DataIndex, "BODY", BytesPerLine * NumberOfBitplanes * Canvas.height);

	var BitplaneLines = new Array(NumberOfBitplanes);
	var Context = Canvas.getContext("2d");
	var ImageData = Context.getImageData(0, 0, Canvas.width, Canvas.height);
	
	for(var Y = 0; Y < Canvas.height; Y++)
	{
		for(var Index = 0; Index < NumberOfBitplanes; Index++)
			BitplaneLines[Index] = new Uint8Array(BytesPerLine);
		
		for(var X = 0; X < Canvas.width; X++)
		{
			var PixelIndex = (X + Y * Canvas.width) * 4;

			var Red = ImageData.data[PixelIndex];
			var Green = ImageData.data[PixelIndex + 1];
			var Blue = ImageData.data[PixelIndex + 2];
			var Alpha = ImageData.data[PixelIndex + 3];
			
			var ColorIndex = 0;

			if(Alpha == 255)
				for(ColorIndex = 0; ColorIndex < Colors.length; ColorIndex++)
					if(Red == Colors[ColorIndex].Red && Green == Colors[ColorIndex].Green && Blue == Colors[ColorIndex].Blue)
						break;
				
			for(var BitplaneIndex = 0; BitplaneIndex < NumberOfBitplanes; BitplaneIndex++)
				if(ColorIndex & (1 << BitplaneIndex)) 
					BitplaneLines[BitplaneIndex][X >> 3] |= 0x80 >> (X & 7);
		}
		
		for(var BitplaneIndex = 0; BitplaneIndex < NumberOfBitplanes; BitplaneIndex++)
			for(var ByteIndex = 0; ByteIndex < BytesPerLine; ByteIndex++)
				Data[DataIndex++] = BitplaneLines[BitplaneIndex][ByteIndex];
	}
	
	// Save file.
	
	var DownloadLink = document.createElement("a");
	
	DownloadLink.download = "IMAGE.IFF";
	DownloadLink.innerHTML = "Download Image";

	if(window.webkitURL != null)
	{
		DownloadLink.href = window.webkitURL.createObjectURL(new Blob([Data], { type: "application/octet-binary" }));
	}
	else
	{
		DownloadLink.href = URL.createObjectURL(new Blob([Data], { type: "application/octet-binary" }));
		DownloadLink.onclick = function(Event) { document.body.removeChild(Event.target); };
		DownloadLink.style.display = "none";
		document.body.appendChild(DownloadLink);
	}

	DownloadLink.click();
}

function SetGlobalColors(Element)
{
	if(Element.checked)
	{
		var Id = Element.id.substring(Element.id.lastIndexOf("_") + 1);
		
		GlobalColors = document.getElementById("window_div_" + Id).ImageInfos.QuantizedColors;

		var WindowDivs = document.getElementById("dropzone").children;
		
		for(var Index = 0; Index < WindowDivs.length; Index++)
		{
			if(WindowDivs[Index].id.indexOf("window_div_") == 0)
			{
				var WindowId = WindowDivs[Index].id.substring(WindowDivs[Index].id.lastIndexOf("_") + 1);

				if(Id != WindowId)
				{
					document.getElementById("menu_global_colors_input_" + WindowId).checked = false;
					
					if(document.getElementById("menu_colors_select_" + WindowId).value == "Global")
						ProcessMenuAction(WindowId);
				}
			}
		}
	}
	else
	{
		GlobalColors = new Array();
		
		GlobalColors.push({ Red: 0, Green: 0, Blue: 0 });
		GlobalColors.push({ Red: 255, Green: 255, Blue: 255 });
	}
}

