#include <math.h>
#include <stdio.h>
#include <stdlib.h>

//#define __Amiga__
#define __Intel__


//#define __8Bit__
//#define __24Bit__


typedef float tFloat;



typedef
struct tvector
{
  tFloat x,y,z;
  long flag;
} tVector;


typedef
struct tmatrix
{
  tVector i;
  tVector j;
  tVector k;
} tMatrix;

typedef
struct tface
{
  long  p1,p2,p3;                   //Index of vertices
  unsigned char *text;              //Pointer of Texture
  unsigned char *pal;               //Pointer of Palette
  long  u1,v1,u2,v2,u3,v3;          //uv koors
} tFace;

typedef
struct tobject
{
  tVector *opoints;
  long    nbPoints;
  tVector *bpoints;
  tVector pos;
  long    nbFaces;
  tFace   *faces;
  tMatrix rotmatrix;
} tObject;


typedef
struct twindow
{
  long  x,y,kx,ky,bpr;
  char *Screen;
} tWindow;

typedef
struct tfacenode
{
  long  z;              //Z-wert
  tFace *face;          //Pointer auf Flaechendaten
  tVector *points;
  struct tfacenode *next;   //Zeiger auf naechste
} tFaceNode;


extern long Filter;
extern long tBpp;

#define SINUSFULL 4096


void tInitMatrix (long, long ,long, tMatrix *);
void tInitSinus (void);
void tCalcObject (tObject *, tMatrix *, tVector *);
void tCalcObject2 (tObject *, tMatrix *, tVector *);

void tDrawFace (tFace * ,tVector *,tWindow *);
tObject *GetObject (long nbFaces, long nbPoints,tFloat x, tFloat y, tFloat z);
void FreeObject (tObject *obj);
void tExitEngine ();