AYCTRL  equ	65533
AYDATA  equ	49149

        org     32768

start   

        ; drum pattern needs to be 0byte aligned and four bytes long
        ; we define three bytes and take the fourth from the ld de,nn opcode
        ; not the best drum pattern, but i only had three bytes left..
drumPattern
        db      0x37                                ; scf
        db      0                                   ; nop
        db      0                                   ; nop

		ld		de,%110000+(7<<8)					; set up mixer
		call	outAyByte

        ld  b,0
loo
        push    bc
        ld b,0
lo 
        push    hl
        pop     hl
        push    hl
        pop     hl
        push    hl
        pop     hl
        push    hl
        pop     hl
    djnz    lo
    pop bc
    djnz    loo

        ; -- main loop --
loop
        ld      ix,databass                         ; poin to first channel's data
        call    chanplay
        db      0xdd,0x2e,LOW(datatune)             ; ld lx,n
        call    chanplay
        db      0xdd,0x2e,LOW(datadrums)            ; ld lx,n
        call    chanplay

synca   djnz    synca
syncb   add     hl,sp                               ; a good, slow, single byte instruction..
        djnz    syncb
        jr      loop

        ; -- play one channel --
chanplay
        ld      a,(ix+CHA_TIMER)                    ; advance timer
        sub     (ix+CHA_SPEED)
        ld      (ix+CHA_TIMER),a
        ld      h,a                                 ; save timer for volume env later..
        jr      nz,nonoteinc

        inc     (ix+CHA_LOOPPOS)                    ; advance note
        ld      a,(ix+CHA_LOOPPOS)
        and     (ix+CHA_REPEATLENGTHMASK)
        jr      nz,nonewpat

        ld      a,(ix+CHA_PATTERNDATALOW)           ; advance pattern
        add     a,(ix+CHA_PATTERNDATASTEP)
        ld      (ix+CHA_PATTERNDATALOW),a

nonewpat
nonoteinc
        ld      d,(ix+CHA_PATTERNDATAHIGH)
        ld      a,(ix+CHA_LOOPPOS)
        and     (ix+CHA_LOOPLENGTHMASK)
        add     a,(ix+CHA_PATTERNDATALOW)
        ld      e,a
        ld      a,(de)
        ld      d,(ix+CHAN_AYCOARSEPITCHCTRL)
        ld      e,a
        call    outAyByte                           ; set pitch
        ld      b,4                                 ; h is timer, >>4 to get volume env
vshift  srl     h
        djnz    vshift
        ld      d,(ix+CHAN_AYVOLCTRL)
        ld      e,h
;        call    outAyByte                           ; set volume
;        ret
 
		; d = ctrl, e = data
outAyByte
		ld		bc,AYCTRL
		out		(c),d
		ld		b,HIGH(AYDATA)
		out		(c),e
		ret
        


CHAN_AYCOARSEPITCHCTRL  equ     0
CHAN_AYVOLCTRL          equ     1
CHA_PATTERNDATALOW      equ     100
CHA_PATTERNDATAHIGH     equ     2
CHA_TIMER               equ     101
CHA_SPEED               equ     3
CHA_LOOPPOS             equ     102
CHA_LOOPLENGTHMASK      equ     4
CHA_REPEATLENGTHMASK    equ     5
CHA_PATTERNDATASTEP     equ     6
        
databass
        db      5
        db      10
        db      5
        db      1
        db      %1
        db      %111
        db      64

datatune
        db      3
        db      9
        db      13
        db      8
        db      %1111
        db      %111111
        db      19

datadrums
        db      1
        db      8
        db      HIGH(drumPattern)
        db      4
        db      %11
        db      %11
;        db      0
    

end start
