/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __CROCOLIB_ASIC_H__
#define __CROCOLIB_ASIC_H__

// ----------------------------------------------------------------------------
extern unsigned char g_asic; // defined in crASICIsBegin.c

// ----------------------------------------------------------------------------
#define crASICBegin( ) asm( "ld bc, $7fb8 \n out (c), c \n ld a, c \n ld ( _g_asic ), a" );
#define crASICEnd( ) asm( "ld bc, $7fa0 \n out (c), c \n ld a, c \n ld ( _g_asic ), a" );

// ----------------------------------------------------------------------------
extern unsigned char __LIB__ crASICIsBegin( );

// ----------------------------------------------------------------------------
enum EASICSpriteMode
{
	ASIC_SPRITEMODE_160_160 = 15, // 0b00001111
	ASIC_SPRITEMODE_160_320 = 14, // 0b00001110
	ASIC_SPRITEMODE_160_640 = 13, // 0b00001101

	ASIC_SPRITEMODE_320_160 = 11, // 0b00001011
	ASIC_SPRITEMODE_320_320 = 10, // 0b00001010
	ASIC_SPRITEMODE_320_640 = 9, // 0b00001001

	ASIC_SPRITEMODE_640_160 = 7, // 0b00000111
	ASIC_SPRITEMODE_640_320 = 6, // 0b00000110
	ASIC_SPRITEMODE_640_640 = 5  // 0b00000101
};

// ----------------------------------------------------------------------------
enum EASICVideoPage
{
	ASIC_VIDEOPAGE_0000 = ( 0 << 4 ), // 0b00
	ASIC_VIDEOPAGE_4000 = ( 1 << 4 ), // 0b01
	ASIC_VIDEOPAGE_8000 = ( 2 << 4 ), // 0b10
	ASIC_VIDEOPAGE_C000 = ( 3 << 4 )  // 0b11
};

// ----------------------------------------------------------------------------
enum EASICVideoPageSize
{
	ASIC_VIDEOPAGESIZE_16KB = ( 0 << 2 ), // 0b00
	ASIC_VIDEOPAGESIZE_32KB = ( 3 << 2 )  // 0b11
};

// ----------------------------------------------------------------------------
extern void __LIB__ crASICUnlock( );

extern void __LIB__ crASICSetPalette( unsigned int *source );

extern void __LIB__ crASICSetSpritePalette( unsigned int source );
extern void __LIB__ crASICSetSpriteData( unsigned int spriteIndex, unsigned int source );

extern void __LIB__ crASICDisableSprite( unsigned int spriteIndex );
extern void __LIB__ crASICEnableSprite( unsigned int spriteIndex, unsigned char mode, unsigned int x, unsigned int y );

extern void __FASTCALL__ __LIB__ crASICCreateSplitScreen( unsigned char line );
extern void __LIB__ crASICSetScreenOffset( unsigned char videoPage, unsigned char videoPageSize, unsigned int offset );
extern void __LIB__ crASICSetScrollOffset( unsigned char scrollX, unsigned char scrollY );

extern void __LIB__ crASICSetupInterrupt( void (*customCallback)() );

// ----------------------------------------------------------------------------
#endif // __CROCOLIB_ASIC_H__
