/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __CROCOLIB_GATEARRAY_H__
#define __CROCOLIB_GATEARRAY_H__

// ----------------------------------------------------------------------------
extern void __CALLEE__ __LIB__ crGASetColor( unsigned int pen, unsigned int color );

extern void __LIB__ crGASetMode( unsigned int videoMode );

// ----------------------------------------------------------------------------
enum EPen
{
	BKGRD = 0,
	PEN_0 = 0,
	PEN_1 = 1,
	PEN_2 = 2,
	PEN_3 = 3,
	PEN_4 = 4,
	PEN_5 = 5,
	PEN_6 = 6,
	PEN_7 = 7,
	PEN_8 = 8,
	PEN_9 = 9,
	PEN_10 = 10,
	PEN_11 = 11,
	PEN_12 = 12,
	PEN_13 = 13,
	PEN_14 = 14,
	PEN_15 = 15,
	BORDER = 16
};

enum ECPCColor
{
	COLOR_0 = 0x54,
	COLOR_1 = 0x44,
	COLOR_2 = 0x55,
	COLOR_3 = 0x5c,
	COLOR_4 = 0x58,
	COLOR_5 = 0x5d,
	COLOR_6 = 0x4c,
	COLOR_7 = 0x45,
	COLOR_8 = 0x4d,
	COLOR_9 = 0x56,
	COLOR_10 = 0x46,
	COLOR_11 = 0x57,
	COLOR_12 = 0x5e,
	COLOR_13 = 0x40,
	COLOR_14 = 0x5f,
	COLOR_15 = 0x4e,
	COLOR_16 = 0x47,
	COLOR_17 = 0x5f,
	COLOR_18 = 0x52,
	COLOR_19 = 0x42,
	COLOR_20 = 0x53,
	COLOR_21 = 0x5a,
	COLOR_22 = 0x59,
	COLOR_23 = 0x5b,
	COLOR_24 = 0x4a,
	COLOR_25 = 0x43,
	COLOR_26 = 0x4b
};

enum EHumanColor
{
	COLOR_BLACK = COLOR_0,
	COLOR_BLUE = COLOR_1,
	COLOR_BRIGHTBLUE = COLOR_2,
	COLOR_RED = COLOR_3,
	COLOR_MAGENTA = COLOR_4,
	COLOR_VIOLET = COLOR_5,
	COLOR_BRIGHTRED = COLOR_6,
	COLOR_PURPLE = COLOR_7,
	COLOR_BRIGHTMAGENTA = COLOR_8,
	COLOR_GREEN = COLOR_9,
	COLOR_CYAN = COLOR_10,
	COLOR_SKYBLUE = COLOR_11,
	COLOR_YELLOW = COLOR_12,
	COLOR_GREY = COLOR_13,
	COLOR_PALEBLUE = COLOR_14,
	COLOR_ORANGE = COLOR_15,
	COLOR_PINK = COLOR_16,
	COLOR_PALEMAGENTA = COLOR_17,
	COLOR_BRIGHTGREEN = COLOR_18,
	COLOR_SEAGREEN = COLOR_19,
	COLOR_BRIGHTCYAN = COLOR_20,
	COLOR_LIMEGREEN = COLOR_21,
	COLOR_PALEGREEN = COLOR_22,
	COLOR_PALECYAN = COLOR_23,
	COLOR_BRIGHTYELLOW = COLOR_24,
	COLOR_PALEYELLOW = COLOR_25,
	COLOR_BRIGHTWHITE = COLOR_26
};

enum EVideoMode
{
	VIDEOMODE_0 = 128 + 4 + 0x0,
	VIDEOMODE_1 = 128 + 4 + 0x1,
	VIDEOMODE_2 = 128 + 4 + 0x2
};

// ----------------------------------------------------------------------------
#endif // __CROCOLIB_GATEARRAY_H__
