/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crGFX.h"

#include <string.h> // memset

// ----------------------------------------------------------------------------
void __LIB__ crGFXDrawRectFast( unsigned int *g_scanlineBuffer, unsigned int startWidth, unsigned int width, unsigned int height, unsigned int pen )
{
#asm
	di;
	ld ( saveStack + 1 ), sp;

	ld ix, 0;
	add	ix, sp;

	ld d, ( ix + 7 ); // de = width
	ld a, ( ix + 6 );
	rra;
	ld e, a;
	ld hl, line;
	add hl, de;	
	ld ( restore + 1 ), hl;

	ex de, hl;	
	
	ld a, ( ix + 6 ); // width
	and 1;
	or a;
	jp z, writeJumpCopy;
	ld a, ( ix + 3 ); // pen
	ld ( writeLastPixel + 1 ), a;
	ld hl, jumpLastPixelCopy;
	jp write;
.writeJumpCopy
	ld hl, jumpCopy;
.write
	ldi;
	ldi;
	ldi;

	ld b, ( ix + 3 ); // de = pen
	ld c, ( ix + 2 );

	ld d, ( ix + 9 ); // scanline start width
	ld e, ( ix + 8 );

	ld h, ( ix + 11 ); // scanline buffer
	ld l, ( ix + 10 );
	dec hl;
	dec hl;
	ld ( lineLoopcount + 1 ), hl;

	ei;
	
	ld a, ( ix + 4 ); 

.lineLoopcount 
	ld hl, 0;
	inc hl;
	inc hl;
	ld ( lineLoopcount + 1 ), hl;
	ld c, ( hl );
	inc hl;
	ld h, ( hl );
	ld l, c;

	ld c, b;

	add hl, de;
	di;
	ld sp, hl;
.line
	defs 64, $c5; // push bc * 64
	defs 3, $0; // nop * 3
.lastPixel
	ld hl, -1;
	add hl, sp;
.writeLastPixel
	ld ( hl ), 255;
.prevSPcount 
	ld sp, 0;
	ei;

	dec a;
	jp nz, lineLoopcount; 

.restore
	ld hl, 0;
	ld ( hl ), $c5;
	inc hl;
	ld ( hl ), $c5;
	inc hl;
	ld ( hl ), $c5;

	jp end;

.jumpCopy
	jp prevSPcount;

.jumpLastPixelCopy
	jp lastPixel;

.end
.saveStack
	ld sp, 0;
#endasm
}
