/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crTEXT.h"
#include "crCRTC.h"
#include "crBANK.h"

#include <lib3d.h>
#include <string.h> // memcpy

// ----------------------------------------------------------------------------
unsigned int fontAdress;
unsigned char *fontCharSet;
unsigned int fontCharsPerLine;
unsigned char fontCharWidth;
unsigned char fontCharHeight;

unsigned int *scanline;
unsigned int* fontCharAdress;
unsigned int iFontCharY;

unsigned int scanlineSub;
unsigned int fontPitch;
unsigned char posY;
unsigned char fontType;
int iOffset;
int c;
int d;
int size;

unsigned char newFontType;

unsigned char count;

// ----------------------------------------------------------------------------
void playMusic( )
{
	crBANKSetC7( );
	asm( "call $106" );
	crBANKSetC0( );
}

// ----------------------------------------------------------------------------
void __LIB__ crTEXTDrawStringRandomScreen( unsigned int *screenPtr, struct SFont *font, struct SFont *font2, struct SFont *font3, int isHexa )
{
	fontAdress = font->fontAdress;
	fontCharSet = font->fontCharSet;
	fontCharsPerLine = font->fontCharsPerLine;
	fontCharWidth = font->fontCharWidth;
	fontCharHeight = font->fontCharHeight;
	
	fontType = 0;

	switch( font->fontBank )
	{
		case 0xC4: crBANKSetC4( ); break;
		case 0xC5: crBANKSetC5( ); break;
		case 0xC6: crBANKSetC6( ); break;
		case 0xC7: crBANKSetC7( ); break;

		default:
		case 0xC0: crBANKSetC0( ); break;
	}

	newFontType = 1;

	scanline = screenPtr;
	scanlineSub = 0x400 * 6;
	fontPitch = ( font->fontPitch >> 1 );

	if ( ( crCRTCGetWidth( ) > 40 ) && ( crCRTCGetHeight( ) > 25 ) )
	{
		size = ( 21 * crCRTCGetWidth( ) ) + 16;
	}
	else
	{
		size = crCRTCGetHeight( ) * crCRTCGetWidth( );
	}

	if ( isHexa )
	{
		scanline += crCRTCGetWidth( ) * 4;
		size -= crCRTCGetWidth( ) * 4 * 2;
	}

	count = 0;

	for ( iOffset = 0; iOffset < size; iOffset++)
	{
		if ( ( count++ ) > 20 )
		{
			count = 0;

			playMusic( );
		}

		if ( isHexa == 0 )
		{
			c = 'A' + ( ( isin( iOffset & 359 ) * (long) 7 ) & 25 );

			fontCharAdress = (unsigned char*) font->fontCharAdress[ c ];
		}
		else
		{
			c = ( ( isin( iOffset & 359 ) * (long) 7 ) & 15 );
			if ( c < 10 )
			{
				c = '0' + c;
			}
			else
			{
				c = 'A' + ( c - 10 );
			}

			if ( newFontType == 1 )
			{
				fontType = ( ( isin( ( iOffset * 3 ) & 359 ) * (long) 5 ) & 3 );
			
				newFontType = 0;
			}
			else
			{
				newFontType = 1;
			}

			if ( fontType == 0 )
			{
				fontCharAdress = (unsigned char*) font->fontCharAdress[ c ];
			}
			else
			if ( fontType == 1 )
			{
				fontCharAdress = (unsigned char*) font2->fontCharAdress[ c ];
			}
			else
			{
				fontCharAdress = (unsigned char*) font3->fontCharAdress[ c ];
			}
		}
		
		*scanline = *fontCharAdress;				
		fontCharAdress += fontPitch;
		scanline += 0x400;

		*scanline = *fontCharAdress;				
		fontCharAdress += fontPitch;
		scanline += 0x400;

		*scanline = *fontCharAdress;				
		fontCharAdress += fontPitch;
		scanline += 0x400;

		*scanline = *fontCharAdress;				
		fontCharAdress += fontPitch;
		scanline += 0x400;

		*scanline = *fontCharAdress;				
		fontCharAdress += fontPitch;
		scanline += 0x400;

		*scanline = *fontCharAdress;				
		fontCharAdress += fontPitch;
		scanline += 0x400;

		*scanline = *fontCharAdress;				
		fontCharAdress += fontPitch;
		
		scanline -= scanlineSub;
		scanline++;
	}

	crBANKSetC0( );
}
