/*
This file is part of CrocoLib.

CrocoLib is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

CrocoLib is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

// ----------------------------------------------------------------------------
#include "crLIB.h"
#include <lib3d.h>

#include <string.h> // memset

#include "Demo.h"

#include "PreBozo.h"

// ----------------------------------------------------------------------------
unsigned char *s_dataPtr = (unsigned char *) 0x3600; 
#define GETDATAPTR( offset ) ( (unsigned char *) ( s_dataPtr + offset ) )

// ----------------------------------------------------------------------------
static void init( );
static void frameUpdate( );
static int isFinished( );

// ----------------------------------------------------------------------------
void main( )
{
#asm
	ei;
	ld sp, $1500 - 2;
#endasm

	crASICIsBegin( );
	crBANKGetBank( );

	playMusic( );

	init( );

	playMusic( );

	while ( isFinished( ) == 0 )
	{
		frameUpdate( );

		playMusic( );
	}

#asm
	ld hl, ( $1500 - 2);
	jp ( hl );
#endasm
}

// ----------------------------------------------------------------------------
static unsigned int s_palette[ 17 ];

// ----------------------------------------------------------------------------
#define PREBOZO_WAITTIME	5

// ----------------------------------------------------------------------------
static int s_preBozoVBLCount;
static int s_isPreBozoFinished;

static int s_preBozoFlipColor;

// ----------------------------------------------------------------------------
void init( )
{
	s_preBozoVBLCount = 0;
	s_isPreBozoFinished = 0;	
	s_preBozoFlipColor = 0;
	
	crSYNCWaitVBL( );
	memset( 0x8000, 0, 0x8000 );

	crSYNCWaitVBL( );
	crGASetColor( BORDER, COLOR_BLACK );
	crGASetColor( BKGRD, COLOR_BLACK );
	crGASetColor( PEN_1, COLOR_BLACK );

	crGASetMode( 2 );
	
	crCRTCSetupScreen( CRTC_OVERSCAN_DISABLE, CRTC_VIDEOPAGE_8000, CRTC_VIDEOPAGE_C000, CRTC_VIDEOPAGESIZE_16KB );
}

// ----------------------------------------------------------------------------
void frameUpdate( )
{	
	unsigned int src;

	if ( s_preBozoVBLCount < PREBOZO_WAITTIME )
	{
		src = GETDATAPTR( DATA_TIME );
	}
	else if ( s_preBozoVBLCount < ( PREBOZO_WAITTIME * 2 ) )
	{
		src = GETDATAPTR( DATA_FOR );
	}
	else if ( s_preBozoVBLCount < ( PREBOZO_WAITTIME * 3 ) )
	{
		src = GETDATAPTR( DATA_MOCAP );
	}
	else
	{
		s_isPreBozoFinished = 1;
	}

	crCRTCFlipScreen( );

	playMusic( );

	crPACKERUnpack( (unsigned int) crCRTCGetScanline( 0 ), src );

	crSYNCWaitVBL( );

	if ( s_preBozoVBLCount < PREBOZO_WAITTIME )
	{
		crGASetColor( BORDER, COLOR_BRIGHTWHITE );
		crGASetColor( BKGRD, COLOR_BLACK );
		crGASetColor( PEN_1, COLOR_BRIGHTWHITE );
	}
	else if ( s_preBozoVBLCount < ( PREBOZO_WAITTIME * 2 ) )
	{
		crGASetColor( BORDER, COLOR_BLACK );
		crGASetColor( BKGRD, COLOR_BRIGHTWHITE );
		crGASetColor( PEN_1, COLOR_BLACK );
	}
	else if ( s_preBozoVBLCount < ( PREBOZO_WAITTIME * 3 ) )
	{
		crGASetColor( BORDER, COLOR_BRIGHTWHITE );
		crGASetColor( BKGRD, COLOR_BLACK );
		crGASetColor( PEN_1, COLOR_BRIGHTWHITE );
	}
	else
	{
		crGASetColor( BORDER, COLOR_BLACK );
		crGASetColor( BKGRD, COLOR_BLACK );
		crGASetColor( PEN_1, COLOR_BLACK );

		s_isPreBozoFinished = 1;
	}

	s_preBozoVBLCount++;
}

// ----------------------------------------------------------------------------
int isFinished( )
{
	return s_isPreBozoFinished;
}
