/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

// ----------------------------------------------------------------------------
#include "crLIB.h"
#include <lib3d.h>

#include <string.h> // memset

#include "Demo.h"

#include "Tunnel.h"

// ----------------------------------------------------------------------------
unsigned char *s_dataPtr = (unsigned char *) 0x4000; 
#define GETDATAPTR( offset ) ( (unsigned char *) ( s_dataPtr + offset ) )

// ----------------------------------------------------------------------------
static void init( );
static void frameUpdate( );
static int isFinished( );

// ----------------------------------------------------------------------------
void main( )
{
#asm
	ei;
	ld sp, $1500 - 2;
#endasm

	crASICIsBegin( );
	crBANKGetBank( );

	playMusic( );
	
	init( );

	playMusic( );
	
	while ( isFinished( ) == 0 )
	{
		frameUpdate( );

		playMusic( );
	}

#asm
	ld hl, ( $1500 - 2);
	jp ( hl );
#endasm
}

// ----------------------------------------------------------------------------
static unsigned int s_palette[ 18 ];
int isSecondTime;

// ----------------------------------------------------------------------------
#define WIDTH			61		// must be < REG1
#define HEIGHT			( 255 + 8 )		// must be <= 255

#define MAXSINCOS		360

unsigned char FRAME_SPEEDX = 20;		// must be < MAXSINCOS
unsigned char FRAME_SPEEDY = 14;		// must be < MAXSINCOS
unsigned char TUNNEL_CURVEX = 15;		// must be < MAXSINCOS
unsigned char TUNNEL_CURVEY = 12;		// must be < MAXSINCOS

#define FRAME_STARTX	0		// must be < MAXSINCOS
#define FRAME_STARTY	114		// must be < MAXSINCOS

#define SQUARECOUNT		15		// must be < 16

unsigned char PALETTE_SHIFT	= 0;		// 0 for blue palette, 4 for red and 8 for green

unsigned char VBLCOUNT = 80;

unsigned char preset;

// ----------------------------------------------------------------------------
#define MEM_COSX	( 0x3600 )
#define MEM_COSY	( MEM_COSX + MAXSINCOS * 2 )
#define MEM_SIZEX1	( MEM_COSY + MAXSINCOS * 2 )
#define MEM_SIZEY1	( MEM_SIZEX1 + SQUARECOUNT * 2 )
#define MEM_SIZEX2	( MEM_SIZEY1 + SQUARECOUNT * 2 )
#define MEM_SIZEY2	( MEM_SIZEX2 + SQUARECOUNT * 2 )
#define MEM_PENS	( MEM_SIZEY2 + SQUARECOUNT * 2 )
#define MEM_SIZES	( MEM_PENS + SQUARECOUNT * 2 )

// static int s_cosX[ MAXSINCOS ];
// static int s_cosY[ MAXSINCOS ];
static int *s_cosX = (int *) ( MEM_COSX );
static int *s_cosY = (int *) ( MEM_COSY );

// static int s_sizeX1[ SQUARECOUNT ];
// static int s_sizeY1[ SQUARECOUNT ];
// static int s_sizeX2[ SQUARECOUNT ];
// static int s_sizeY2[ SQUARECOUNT ];
static int *s_sizeX1 = (int *) ( MEM_SIZEX1 );
static int *s_sizeY1 = (int *) ( MEM_SIZEY1 );
static int *s_sizeX2 = (int *) ( MEM_SIZEX2 );
static int *s_sizeY2 = (int *) ( MEM_SIZEY2 );

// static unsigned int s_pens[ SQUARECOUNT ];
static unsigned int *s_pens = (unsigned int *) ( MEM_PENS );

// static int s_sizes[ SQUARECOUNT ];
static int *s_sizes = (int *) ( MEM_SIZES );

// ----------------------------------------------------------------------------

static unsigned int s_pen;
static unsigned char s_incPalette;

static unsigned int *s_scanlineBuffer;
extern unsigned int *g_scanlineBuffer;

static unsigned int iSquare;

static int s_prevX1;
static int s_prevY1;
static int s_prevX2;
static int s_prevY2;

static int s_frameX;
static int s_frameY;

static int s_iSinX;
static int s_iSinY;

unsigned int s_tempValue;

static int X1;
static int Y1;
static int X2;
static int Y2;

static unsigned char width;
static unsigned char height;

static int addX;
static int addY;

static int s_vblCount;

static int s_isTunnelFinished;

int z = 0;
int size;

unsigned char v;

int i;

// ----------------------------------------------------------------------------
void TUNNEL_Precalculate( )
{
	{
		playMusic( );

		s_isTunnelFinished = 0;
		
		s_vblCount = 0;
		
		s_incPalette = SQUARECOUNT;

		for( iSquare = 0; iSquare < SQUARECOUNT; iSquare++ )
		{
			if ( iSquare == ( SQUARECOUNT / 2 ) )
			{
				playMusic( );
			}

			{
				v =		( ( ( iSquare      ) & 1 ) << 7 ) + ( ( ( iSquare      ) & 1 ) << 6 ) 
					+   ( ( ( iSquare >> 2 ) & 1 ) << 5 ) + ( ( ( iSquare >> 2 ) & 1 ) << 4 ) 
					+   ( ( ( iSquare >> 1 ) & 1 ) << 3 ) + ( ( ( iSquare >> 1 ) & 1 ) << 2 ) 
					+   ( ( ( iSquare >> 3 ) & 1 ) << 1 ) + ( ( ( iSquare >> 3 ) & 1 ) );

				s_pens[ iSquare ] = v + ( v << 8 ); 

				s_palette[ iSquare ] = 0;
			}
			
			{
				if ( z & 31 )
				{
					s_sizes[ iSquare ] = ( 8 * WIDTH ) / ( 3 * ( z & 31 ) );
				}
				else
				{
					s_sizes[ iSquare ] = 0;
				}

				size = s_sizes[ iSquare ];
				if ( size > 1 )
				{
					s_sizeX1[ iSquare ] = ( WIDTH / 2) - ( size / 2 );
					s_sizeY1[ iSquare ] = ( HEIGHT / 2) - ( size / 2 ) - size;
					s_sizeX2[ iSquare ] = ( WIDTH / 2) + ( size / 2 );
					s_sizeY2[ iSquare ] = ( HEIGHT / 2) + ( size / 2 ) + size;
				}

				z += 16 / SQUARECOUNT;
			}
		}
	}

	playMusic( );

	{
		for ( i = 0; i < MAXSINCOS; i++ )
		{
			playMusic( );

			s_cosX[ i ] = div16384( (long) isin( i ) * (long)( 8 ) );
			s_cosY[ i ] = div16384( (long) icos( i ) * (long)( 64 ) );
		}
	}

	{
		s_frameX = FRAME_STARTX;
		s_frameY = FRAME_STARTY;
	}
}

// ----------------------------------------------------------------------------
static void displayTunnel( )
{
	crSYNCWaitVBL( );
	
	{
		s_frameX += FRAME_SPEEDX;
		if ( s_frameX >= MAXSINCOS )
		{
			s_frameX -= MAXSINCOS;
		}

		s_frameY += FRAME_SPEEDY;
		if ( s_frameY >= MAXSINCOS )
		{
			s_frameY -= MAXSINCOS;
		}

		s_iSinX = s_frameX;
		s_iSinY = s_frameY;		
	}

	{
		s_prevX1 = 0;
		s_prevY1 = 0;
		s_prevX2 = WIDTH - 1;
		s_prevY2 = HEIGHT - 1;
	}

	for ( iSquare = 0; iSquare < SQUARECOUNT - 1; iSquare++ )
	{
		if ( iSquare == ( SQUARECOUNT / 2 ) )
		{
			playMusic( );
		}

		if ( s_sizes[ iSquare ] > 1 )
		{
			{
				addX = s_cosX[ s_iSinX ];
				addY = s_cosY[ s_iSinY ];

				X1 = s_sizeX1[ iSquare ] + addX;
				Y1 = s_sizeY1[ iSquare ] + addY;
				X2 = s_sizeX2[ iSquare ] + addX;
				Y2 = s_sizeY2[ iSquare ] + addY;
			}

			{
				s_iSinX += TUNNEL_CURVEX;
				if ( s_iSinX >= MAXSINCOS )
				{
					s_iSinX -= MAXSINCOS;
				}
				s_iSinY += TUNNEL_CURVEY;
				if ( s_iSinY >= MAXSINCOS )
				{
					s_iSinY -= MAXSINCOS;
				}
			}

			{
				if ( X1 < s_prevX1 )
				{
					X1 = s_prevX1;
				}
				if ( X1 > s_prevX2 )
				{
					X1 = s_prevX2;				
				}
				if ( X2 < s_prevX1 ) 
				{
					X2 = s_prevX1;
				}
				if ( X2 > s_prevX2 ) 
				{
					X2 = s_prevX2;
				}

				if ( Y1 < s_prevY1 )
				{
					Y1 = s_prevY1;
				}
				if ( Y1 > s_prevY2 ) 
				{
					Y1 = s_prevY2;				
				}
				if ( Y2 < s_prevY1 ) 
				{
					Y2 = s_prevY1;
				}
				if ( Y2 > s_prevY2 ) 
				{
					Y2 = s_prevY2;
				}
			}

			{
				if ( Y1 > Y2 )
				{
					s_tempValue = Y2;
					Y1 = Y2;
					Y2 = s_tempValue;
				}

				if ( X1 > X2 )
				{
					s_tempValue = X2;
					X1 = X2;
					X2 = s_tempValue;
				}
			}

			s_pen = s_pens[ iSquare ];

			if ( s_prevX2 > s_prevX1 )
			{
				width = s_prevX2 - s_prevX1;

				if ( Y1 > s_prevY1 )
				{
					crGFXDrawRectFast( s_scanlineBuffer + s_prevY1, s_prevX1 + width, width, Y1 - s_prevY1, s_pen );
				}

				if ( s_prevY2 > Y2 )
				{
					crGFXDrawRectFast( s_scanlineBuffer + Y2, s_prevX1 + width, width, s_prevY2 - Y2, s_pen );
				}
			}

			if ( Y2 > Y1 )
			{
				if ( X1 > s_prevX1 )
				{
					width = X1 - s_prevX1;
					crGFXDrawRectFast( s_scanlineBuffer + Y1, s_prevX1 + width, width, Y2 - Y1, s_pen );
				}

				if ( s_prevX2 > X2 )
				{
					width = s_prevX2 - X2;
					crGFXDrawRectFast( s_scanlineBuffer + Y1, X2 + width, width, Y2 - Y1, s_pen );
				}
			}

			s_prevX1 = X1;
			s_prevY1 = Y1;
			s_prevX2 = X2;
			s_prevY2 = Y2;
		}
	}

	s_pen = s_pens[ iSquare ];

	width = X2 - X1;
	if ( width > 0 )
	{
		height = Y2 - Y1;
		if ( height > 0 )
		{
			crGFXDrawRectFast( s_scanlineBuffer + Y1, X1 + width, width, height, s_pen );
		}
	}
}

void setPreset( )
{
	switch( preset)
	{
	case 0:
		FRAME_SPEEDX = 14; FRAME_SPEEDY = 12; TUNNEL_CURVEX = 11; TUNNEL_CURVEY = 16;
		break;

	case 6:
		FRAME_SPEEDX = 8; FRAME_SPEEDY = 16; TUNNEL_CURVEX = 12; TUNNEL_CURVEY = 6;
		break;

	case 2:
		FRAME_SPEEDX = 16; FRAME_SPEEDY = 18; TUNNEL_CURVEX = 14; TUNNEL_CURVEY = 8;
		break;

	case 3:
		FRAME_SPEEDX = 18; FRAME_SPEEDY = 4; TUNNEL_CURVEX = 9; TUNNEL_CURVEY = 12;
		break;

	case 4:
		FRAME_SPEEDX = 13; FRAME_SPEEDY = 9; TUNNEL_CURVEX = 12; TUNNEL_CURVEY = 12;
		break;

	case 5:
		FRAME_SPEEDX = 8; FRAME_SPEEDY = 14; TUNNEL_CURVEX = 14; TUNNEL_CURVEY = 10;
		break;

	case 1:
		FRAME_SPEEDX = 12; FRAME_SPEEDY = 8; TUNNEL_CURVEX = 9; TUNNEL_CURVEY = 9;
		break;
	}
	
}

// ----------------------------------------------------------------------------
void init( )
{
	unsigned char *pSecondTime = 0x814;	

	if ( *pSecondTime == 255 )
	{
		isSecondTime = 0;
	}
	else
	{
		isSecondTime = 1;

		preset = 0;

		VBLCOUNT >>= 1;
		PALETTE_SHIFT = 4;

		setPreset( );
	}

	playMusic( );

	crCRTCSetupScreen( CRTC_OVERSCAN_VERTICAL, CRTC_VIDEOPAGE_8000, CRTC_VIDEOPAGE_C000, CRTC_VIDEOPAGESIZE_32KB );

	crGASetMode( 0 );

	playMusic( );

	memset( 0x8000, 0, 0x8000 );

	playMusic( );

	memset( s_palette, 0, 16 * 2 );

	TUNNEL_Precalculate( );
}

// ----------------------------------------------------------------------------
void frameUpdate( )
{
	if ( s_vblCount < 20 ) 
	{
		if ( s_incPalette > 0 )
		{
			unsigned char iPal;
			
			s_incPalette--;
			iSquare = 0;

			for ( iPal = s_incPalette; iPal < SQUARECOUNT; iPal++ )
			{
				s_palette[ iPal ] = iSquare << PALETTE_SHIFT;
				iSquare++;
			}
		}
	}

	if ( s_vblCount > VBLCOUNT )
	{
		if ( s_incPalette < SQUARECOUNT )
		{
			unsigned char iPal;

			s_incPalette++;
			iSquare = 0;

			for ( iPal = s_incPalette; iPal < SQUARECOUNT; iPal++ )
			{
				s_palette[ iPal ] = iSquare << PALETTE_SHIFT;
				iSquare++;
			}
		}
		else
		{

			if ( isSecondTime )
			{
				s_vblCount = 0;

				PALETTE_SHIFT += 4;
				if ( PALETTE_SHIFT == 8 )
				{
					PALETTE_SHIFT = 0;
				}

				s_incPalette = SQUARECOUNT;

				preset++;
				if ( preset == 7 )
				{
					preset = 0;
				}
				setPreset();
			}
			else
			{
				s_isTunnelFinished = 1;

#asm
				ld hl, $814;
				ld ( hl ), 0;
#endasm
			}			
		}
	}

	crASICSetPalette( s_palette );

	crCRTCFlipScreen( );
	s_scanlineBuffer = g_scanlineBuffer;

	displayTunnel( );

	s_vblCount++;
}

// ----------------------------------------------------------------------------
int isFinished( )
{
	return s_isTunnelFinished;
}
