#include  <afxwin.h>
#include  <afxcmn.h>
#include  <afxext.h>
#include  <afxdlgs.h>

#include  "Constantes.h"
#include  "Resource.h"
#include  "ConvImgCpcDlg.h"
#include  "Conversion.h"
#include  "BitmapCPC.h"
#include  "SauveCPC.h"
#include  "ChoixCouleur.h"
#include  "ChoixColPlus.h"
#include  "Retouche.h"
#include  "Locale.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define     C_ZOOM              200.0


int TailleX = DEST_X, TailleY = DEST_Y;

int Locale = LOC_FRANCAIS;

static char Msg[ 1024 ];


CConvImgCpcDlg::CConvImgCpcDlg( CWnd * pParent )
    : CDialog( CConvImgCpcDlg::IDD, pParent )
{
    m_hIcon = AfxGetApp()->LoadIcon( IDR_MAINFRAME );
    ImageLue = ImageCalculee = FALSE;
    ChangeOverscan = TRUE;
    MemoBpMove = MemoBpZoom = FALSE;
}


void CConvImgCpcDlg::DoDataExchange( CDataExchange * pDX )
{
    CDialog::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_LOCK_ALL, m_LockAll );
    DDX_Control(pDX, IDC_LOCKCOL15, m_LockCol[ 15 ] );
    DDX_Control(pDX, IDC_LOCKCOL14, m_LockCol[ 14 ] );
    DDX_Control(pDX, IDC_LOCKCOL13, m_LockCol[ 13 ] );
    DDX_Control(pDX, IDC_LOCKCOL12, m_LockCol[ 12 ] );
    DDX_Control(pDX, IDC_LOCKCOL11, m_LockCol[ 11 ] );
    DDX_Control(pDX, IDC_LOCKCOL10, m_LockCol[ 10 ] );
    DDX_Control(pDX, IDC_LOCKCOL09, m_LockCol[ 9 ] );
    DDX_Control(pDX, IDC_LOCKCOL08, m_LockCol[ 8 ] );
    DDX_Control(pDX, IDC_LOCKCOL07, m_LockCol[ 7 ] );
    DDX_Control(pDX, IDC_LOCKCOL06, m_LockCol[ 6 ] );
    DDX_Control(pDX, IDC_LOCKCOL05, m_LockCol[ 5 ] );
    DDX_Control(pDX, IDC_LOCKCOL04, m_LockCol[ 4 ] );
    DDX_Control(pDX, IDC_LOCKCOL03, m_LockCol[ 3 ] );
    DDX_Control(pDX, IDC_LOCKCOL02, m_LockCol[ 2 ] );
    DDX_Control(pDX, IDC_LOCKCOL01, m_LockCol[ 1 ] );
    DDX_Control(pDX, IDC_LOCKCOL00, m_LockCol[ 0 ] );
    DDX_Control(pDX, IDC_COL15, m_Col[ 15 ] );
    DDX_Control(pDX, IDC_COL14, m_Col[ 14 ] );
    DDX_Control(pDX, IDC_COL13, m_Col[ 13 ] );
    DDX_Control(pDX, IDC_COL12, m_Col[ 12 ] );
    DDX_Control(pDX, IDC_COL11, m_Col[ 11 ] );
    DDX_Control(pDX, IDC_COL10, m_Col[ 10 ] );
    DDX_Control(pDX, IDC_COL09, m_Col[ 9 ] );
    DDX_Control(pDX, IDC_COL08, m_Col[ 8 ] );
    DDX_Control(pDX, IDC_COL07, m_Col[ 7 ] );
    DDX_Control(pDX, IDC_COL06, m_Col[ 6 ] );
    DDX_Control(pDX, IDC_COL05, m_Col[ 5 ] );
    DDX_Control(pDX, IDC_COL04, m_Col[ 4 ] );
    DDX_Control(pDX, IDC_COL03, m_Col[ 3 ] );
    DDX_Control(pDX, IDC_COL02, m_Col[ 2 ] );
    DDX_Control(pDX, IDC_COL01, m_Col[ 1 ] );
    DDX_Control(pDX, IDC_COL00, m_Col[ 0 ] );
    DDX_Control(pDX, IDC_SAUVE, m_BpSauve);
    DDX_Control(pDX, IDC_LIRE, m_BpLire);
    DDX_Control(pDX, IDC_AFFICHE, m_BpAffiche);
    DDX_Control(pDX, IDC_CALCULE, m_BpCalcule);
    DDX_Control(pDX, IDC_ROUGE, m_Rouge);
    DDX_Control(pDX, IDC_VERT, m_Vert);
    DDX_Control(pDX, IDC_BLEU, m_Bleu);
    DDX_Control(pDX, IDC_MODE0, m_Mode0);
    DDX_Control(pDX, IDC_MODE1, m_Mode1);
    DDX_Control(pDX, IDC_MODE2, m_Mode2);
    DDX_Control(pDX, IDC_MODE3, m_Mode3);
    DDX_Control(pDX, IDC_TRAME0, m_Trame0);
    DDX_Control(pDX, IDC_TRAME1, m_Trame1);
    DDX_Control(pDX, IDC_TRAME2, m_Trame2);
    DDX_Control(pDX, IDC_TRAME3, m_Trame3);
    DDX_Control(pDX, IDC_X2, m_x2);
    DDX_Control(pDX, IDC_X3, m_x3);
    DDX_Control(pDX, IDC_PCTTRAME, m_PctTrame);
    DDX_Control(pDX, IDC_LISTE, m_Liste);
    DDX_Control(pDX, IDC_TAILLEORG, m_TailleOrg);
    DDX_Control(pDX, IDC_TAILLEECR, m_TailleEcr);
    DDX_Control(pDX, IDC_NEWTAILLE, m_NewTaille);
    DDX_Control(pDX, IDC_PROPINF, m_PropInf);
    DDX_Control(pDX, IDC_PROPSUP, m_PropSup);
    DDX_Control(pDX, IDC_DPLX, m_DeplX);
    DDX_Control(pDX, IDC_DPLY, m_DeplY);
    DDX_Control(pDX, IDC_TAILLEX, m_TailleX);
    DDX_Control(pDX, IDC_TAILLEY, m_TailleY);
    DDX_Control(pDX, IDC_SLIDELUM, m_ValLum);
    DDX_Control(pDX, IDC_CONTRASTE, m_Contraste);
    DDX_Control(pDX, IDC_STATIC_PARAMC, m_ParamC );
    DDX_Control(pDX, IDC_STATIC_PARAMI, m_ParamI );
    DDX_Control(pDX, IDC_STATIC_DEPLX, m_TDeplX );
    DDX_Control(pDX, IDC_STATIC_DEPLY, m_TDeplY );
    DDX_Control(pDX, IDC_STATIC_NEWX, m_NewX );
    DDX_Control(pDX, IDC_STATIC_NEWY, m_NewY );
    DDX_Control(pDX, IDC_STATIC_GESTPAL, m_GestPal );
    DDX_Control(pDX, IDC_STATIC_COUL, m_Coul );
    DDX_Control(pDX, IDC_STATIC_BLOQUE, m_Bloque );
    DDX_Control(pDX, IDC_STATIC_R, m_R );
    DDX_Control(pDX, IDC_STATIC_V, m_V );
    DDX_Control(pDX, IDC_STATIC_B, m_B );
    DDX_Control(pDX, IDC_LECTPAL, m_BpLectPal );
    DDX_Control(pDX, IDC_SAUVEPAL, m_BpSauvePal );
    DDX_Control(pDX, IDC_EFFACE, m_BpEfface );
    DDX_Control(pDX, IDC_BPFR, m_BpFr );
    DDX_Control(pDX, IDC_BPEN, m_BpEn );
    DDX_Control(pDX, IDC_CMP, m_BpCmp );
    DDX_Control(pDX, IDC_PLUS, m_BpPlus );
    DDX_Control(pDX, IDC_OVERSCAN, m_BpOverscan );
    DDX_Control(pDX, IDC_RETOUCHE, m_BpRetouche );
    DDX_Control(pDX, IDC_LIGNE, m_BpLineaire );
    DDX_Control(pDX, IDC_NBLIG, m_NbLig );
    DDX_Control(pDX, IDC_NBCOL, m_NbCol );
    DDX_Control(pDX, IDC_STATIC_NBLIG, m_StaticNbLig );
    DDX_Control(pDX, IDC_STATIC_NBCOL, m_StaticNbCol );
    DDX_Control(pDX, IDC_MAJOVERSCAN, m_BpMajOverscan );
    DDX_Control(pDX, IDC_APPLIQUEPAL, m_BpAppliquePal );
    DDX_Control(pDX, IDC_ASM, m_Asm );
    DDX_Control(pDX, IDC_AUTOCALC, m_AutoCalc );
    DDX_Control(pDX, IDC_LISSAGE, m_BpLissage );
    DDX_Control(pDX, IDC_REDUCTPAL1, m_BpReductPal1 );
    DDX_Control(pDX, IDC_REDUCTPAL2, m_BpReductPal2 );
    DDX_Control(pDX, IDC_MODEREDUCT, m_BpModeReduct );
    DDX_Control(pDX, IDC_NB, m_BpNb );
    DDX_Control(pDX, IDC_BATCH, m_BpBatch );
    DDX_Control(pDX, IDC_ORDONNER_PALETTE, m_BpOrdonnerPalette );
    DDX_Control(pDX, IDC_PLUSPROCHE, m_BpPlusProche );
    DDX_Control(pDX, IDC_SPINPCT, m_SpinPct);
    DDX_Control(pDX, IDC_SPINLUM, m_SpinLum);
    DDX_Control(pDX, IDC_STATIC_CONTRASTE, m_StaticContraste );
    DDX_Control(pDX, IDC_ETALE, m_Etale );
}


BEGIN_MESSAGE_MAP(CConvImgCpcDlg, CDialog)
    ON_WM_PAINT()
    ON_WM_QUERYDRAGICON()
    ON_BN_CLICKED(IDC_LIRE, OnLire)
    ON_BN_CLICKED(IDC_AFFICHE, OnAffiche)
    ON_BN_CLICKED(IDC_CALCULE, OnCalcule)
    ON_BN_CLICKED(IDC_SAUVE, OnSauve)
    ON_BN_CLICKED(IDC_EFFACE, OnEfface)
    ON_BN_CLICKED(IDC_MODE0, OnMode0)
    ON_BN_CLICKED(IDC_MODE1, OnMode1)
    ON_BN_CLICKED(IDC_MODE2, OnMode2)
    ON_BN_CLICKED(IDC_MODE3, OnMode3)
    ON_BN_CLICKED(IDC_TRAME0, OnTrame0)
    ON_BN_CLICKED(IDC_TRAME1, OnTrame1)
    ON_BN_CLICKED(IDC_TRAME2, OnTrame2)
    ON_BN_CLICKED(IDC_TRAME3, OnTrame3)
    ON_BN_CLICKED(IDC_LISSAGE, OnLissage)
    ON_BN_CLICKED(IDC_PLUS, OnPlus)
    ON_BN_CLICKED(IDC_AUTOCALC, OnAutoCalc)
    ON_BN_CLICKED(IDC_REDUCTPAL1, OnReductPal1)
    ON_BN_CLICKED(IDC_REDUCTPAL2, OnReductPal2)
    ON_BN_CLICKED(IDC_MODEREDUCT, OnModeReduct)
    ON_BN_CLICKED(IDC_NB, OnNb)
    ON_BN_CLICKED(IDC_X2, OnMatX2)
    ON_BN_CLICKED(IDC_X3, OnMatX3)
    ON_BN_CLICKED(IDC_COL00, OnCol00)
    ON_BN_CLICKED(IDC_COL01, OnCol01)
    ON_BN_CLICKED(IDC_COL02, OnCol02)
    ON_BN_CLICKED(IDC_COL03, OnCol03)
    ON_BN_CLICKED(IDC_COL04, OnCol04)
    ON_BN_CLICKED(IDC_COL05, OnCol05)
    ON_BN_CLICKED(IDC_COL06, OnCol06)
    ON_BN_CLICKED(IDC_COL07, OnCol07)
    ON_BN_CLICKED(IDC_COL08, OnCol08)
    ON_BN_CLICKED(IDC_COL09, OnCol09)
    ON_BN_CLICKED(IDC_COL10, OnCol10)
    ON_BN_CLICKED(IDC_COL11, OnCol11)
    ON_BN_CLICKED(IDC_COL12, OnCol12)
    ON_BN_CLICKED(IDC_COL13, OnCol13)
    ON_BN_CLICKED(IDC_COL14, OnCol14)
    ON_BN_CLICKED(IDC_COL15, OnCol15)
    ON_BN_CLICKED(IDC_LOCK_ALL, OnLockAll)
    ON_BN_CLICKED(IDC_TAILLEORG, OnTailleOrg)
    ON_BN_CLICKED(IDC_TAILLEECR, OnTailleEcr)
    ON_BN_CLICKED(IDC_NEWTAILLE, OnNewTaille)
    ON_BN_CLICKED(IDC_PROPINF, OnPropInf)
    ON_BN_CLICKED(IDC_PROPSUP, OnPropSup)
    ON_BN_CLICKED(IDC_LECTPAL, OnLectPal)
    ON_BN_CLICKED(IDC_SAUVEPAL, OnSauvePal)
    ON_BN_CLICKED(IDC_BPFR, OnBpFr)
    ON_BN_CLICKED(IDC_BPEN, OnBpEn)
    ON_BN_CLICKED(IDC_OVERSCAN, OnOverscan )
    ON_BN_CLICKED(IDC_RETOUCHE, OnRetouche)
    ON_BN_CLICKED(IDC_MAJOVERSCAN, OnMajOverscan )
    ON_BN_CLICKED(IDC_CMP, OnCmp )
    ON_BN_CLICKED(IDC_APPLIQUEPAL, OnAppliquePal)
    ON_BN_CLICKED(IDC_BATCH, OnBatch)
    ON_BN_CLICKED(IDC_ORDONNER_PALETTE, OnOrdonnerPalette)
    ON_BN_CLICKED(IDC_PLUSPROCHE, OnPlusProche)
    ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDELUM, OnCustomdrawSlideLum)
    ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_CONTRASTE, OnCustomdrawContraste)
    ON_NOTIFY(UDN_DELTAPOS, IDC_SPINPCT, OnDeltaposSpinPct)
    ON_NOTIFY(UDN_DELTAPOS, IDC_SPINLUM, OnDeltaposSpinLum)
    ON_WM_RBUTTONDOWN()
    ON_WM_LBUTTONDOWN()
    ON_WM_RBUTTONUP()
    ON_WM_LBUTTONUP()
    ON_WM_MOUSEMOVE()
END_MESSAGE_MAP()


BOOL CConvImgCpcDlg::OnInitDialog()
{
    CDialog::OnInitDialog();

    m_ValLum.SetRange( 0, 200 );
    m_ValLum.SetPos( 100 );
    m_Contraste.SetRange( 0, 200 );
    m_Contraste.SetPos( 100 );
    memcpy( PalCPC, PaletteStandardCPC, sizeof( PalCPC ) );
    BpOn();
    m_Rouge.SetWindowText( "100" );
    m_Vert.SetWindowText( "100" );
    m_Bleu.SetWindowText( "100" );
    m_Mode0.SetCheck( 1 );
    ModeCPC = 0;
    m_Trame0.SetCheck( 1 );
    Methode = 0;
    m_x2.SetCheck( 1 );
    Matrice = 2;
    m_PctTrame.SetWindowText( "100" );
    m_PctTrame.EnableWindow( FALSE );
    m_SpinPct.EnableWindow( FALSE );
    m_DeplX.SetWindowText( "0" );
    m_DeplY.SetWindowText( "0" );
    OnTailleOrg();
    m_TailleX.SetWindowText( "640" );
    m_TailleY.SetWindowText( "400" );
    OnNewTaille();
    SetIcon( m_hIcon, TRUE );
    SetIcon( m_hIcon, FALSE );
    m_BpFr.LoadBitmaps( IDB_BITMAP_FR );
    m_BpEn.LoadBitmaps( IDB_BITMAP_EN );
    m_Etale.SetWindowText( "1" );

    SetInterface();
    m_TailleEcr.SetCheck( 1 );
    WinDC = GetDC();
    ModifParam();
    return( BmEcran.Create( WinDC, BITMAP_X, BITMAP_Y ) );
}

//
// Redessine la fentre... Fonctions propres  WinDaube
//
void CConvImgCpcDlg::OnPaint()
{
    if ( IsIconic() )
        {
        CPaintDC dc( this );
        SendMessage( WM_ICONERASEBKGND, ( WPARAM )dc.GetSafeHdc(), 0 );
        CRect rect;
        GetClientRect(&rect);
        dc.DrawIcon( ( rect.Width() - GetSystemMetrics( SM_CXICON ) + 1 ) >> 1
                   , ( rect.Height() - GetSystemMetrics( SM_CYICON ) + 1 ) >> 1
                   , m_hIcon
                   );
        ChangeOverscan = TRUE;
        }
    else
        {
        if ( ChangeOverscan )
            {
            FillRect( WinDC->m_hDC
                    , CRect( ORG_OVS_X
                           , ORG_OVS_Y
                           , DEST_OVS_X + ORG_OVS_X
                           , DEST_OVS_Y + ORG_OVS_Y
                           )
                    , GetSysColorBrush( GetSysColor( COLOR_WINDOWFRAME ) )
                    );
            ChangeOverscan = FALSE;
            }
        int CentreX = ORG_OVS_X + ( ( DEST_OVS_X - TailleX ) >> 1 );
        int CentreY = ORG_OVS_Y + ( ( DEST_OVS_Y - TailleY ) >> 1 );

        StretchBlt( WinDC->m_hDC
                  , CentreX, CentreY, TailleX, TailleY
                  , BmEcran.GetDC(), 0, 0, TailleX, TailleY
                  , SRCCOPY
                  );
        AffichePalette();
        CDialog::OnPaint();
        }
}

/*
P : A7 2C E7 EA D3 15 4C 8D F7 AA 0E 0C 3B D4
N : 0C 00 0A 00 BF 22 73 61 6C 75 74 00 00 00
    AB 2C ED EA 6C
*/


HCURSOR CConvImgCpcDlg::OnQueryDragIcon()
{
    return( ( HCURSOR )m_hIcon );
}


//
// Affichage de la palette CPC (16 couleurs max)
//
void CConvImgCpcDlg::AffichePalette( void )
{
    CRect rect;
    CDC * TempDC;
    for ( int i = 0; i < 16; i++ )
        {
        m_Col[ i ].GetClientRect( rect );
        TempDC = m_Col[ i ].GetDC();
        TempDC->FillSolidRect( rect
                             , GetRgbCPC( PalCPC[ i ], m_BpPlus.GetCheck() )
                             );
        m_Col[ i ].ReleaseDC( TempDC );
        }
}


BOOL CConvImgCpcDlg::LectImg( char * Nom, SIZE * s )
{
    BOOL Ret = FALSE;

    if ( Picture.Load( Nom ) )
        {
        * s = Picture.GetImageSize();
        ImageTypeCPC = FALSE;
        Ret = TRUE;
        }
    else
        {
        if ( BitmapCPC.CreateImageFile( Nom, &ModeCPC, PalCPC, TRUE ) )
            {
            * s = BitmapCPC.GetImageSize();
            ImageTypeCPC = TRUE;
            Ret = TRUE;
            }
        }
    return( Ret );
}


//
// Lecture d'une image source
//
void CConvImgCpcDlg::OnLire()
{
    BpOff();
    CFileDialog SelectFic( TRUE
                         , NULL
                         , NULL
                         , OFN_FILEMUSTEXIST
                         , GetTexteLoc( 29,Locale )
                         , this
                         );
    if ( SelectFic.DoModal() == IDOK )
        {
        char Nom[ 1024 ];
        strcpy( Nom, SelectFic.GetPathName() );
        wsprintf( Msg, GetTexteLoc( 30, Locale ), Nom );
        m_Liste.AddString( Msg );
        m_Liste.SetTopIndex( m_Liste.GetCount() - 1 );
        m_Liste.UpdateWindow();
        SIZE s;
        int OldMode = ModeCPC;
        if ( LectImg( Nom, &s ) )
            {
            m_Liste.AddString( GetTexteLoc( 31, Locale ) );
            ImageLue = TRUE;
            ImageCalculee = FALSE;
            sprintf( Msg
                   , GetTexteLoc( 32, Locale )
                   , s.cx
                   , s.cy
                   , s.cx / ( double )s.cy
                   );
            m_Liste.AddString( Msg );
            wsprintf( Tmp, SelectFic.GetFileName() );
            SetTitre( Tmp );
            if ( OldMode != ModeCPC )
                {
                m_Mode0.SetCheck( ModeCPC == 0 );
                m_Mode1.SetCheck( ModeCPC == 1 );
                m_Mode2.SetCheck( ModeCPC == 2 );
                m_Mode3.SetCheck( ModeCPC == 3 );
                }

            if ( ImageTypeCPC )
                {
                m_BpOverscan.SetCheck(  BitmapCPC.GetNbCol() == MAX_COLS_CPC
                                     && BitmapCPC.GetNbLig() == MAX_LIGNES_CPC
                                     );
                m_BpPlus.SetCheck( BitmapCPC.IsPlus() );
                if ( m_BpOverscan.GetCheck() )
                    {
                    TailleX = BITMAP_X;
                    TailleY = BITMAP_Y;
                    }
                else
                    {
                    TailleX = DEST_X;
                    TailleY = DEST_Y;
                    }
                ChangeOverscan = TRUE;
                if ( m_BpPlus.GetCheck() && ModeCPC == 3 )
                    {
                    m_Mode1.SetCheck( 1 );
                    m_Mode3.SetCheck( 0 );
                    }
                // Recalcule avec la palette prsente dans l'image
                StRVB * Bitmap = ( StRVB * )BmEcran.GetMemBitmap();
                InitBitmap( ! m_AutoCalc.GetCheck() );
                Passe2( Bitmap
                      , 4 >> ModeCPC
                      , PalCPC
                      , ModeCPC == 0 ? 16 : ModeCPC == 1 ? 4 : 2
                      , m_BpPlus.GetCheck()
                      );
                LisseBitmap( Bitmap, 4 >> ModeCPC );
                InvalidateRect( NULL, FALSE );
                ImageCalculee = TRUE;
                }
            else
                {
                InitBitmap( ! m_AutoCalc.GetCheck() );
                if ( m_AutoCalc.GetCheck() )
                    Calcule();
                }
            }
        else
            m_Liste.AddString( GetTexteLoc( 33, Locale ) );

        m_Liste.SetTopIndex( m_Liste.GetCount() - 1 );
        }
    BpOn();
}


BOOL CConvImgCpcDlg::Calcule( BOOL AfficheListe )
{
    if ( InitBitmap( FALSE ) )
        {
        for ( int i = 0; i < 16; i++ )
            BlockPal[ i ] = m_LockCol[ i ].GetCheck();

        m_PctTrame.GetWindowText( Msg, sizeof( Msg ) );
        m_Etale.GetWindowText( Tmp, sizeof( Tmp ) );
        int Etale = atoi( Tmp );
        Convert( AfficheListe ? &m_Liste : NULL
               , Methode
               , min( max( 0, atoi( Msg ) ), 400 )
               , Matrice
               , ModeCPC
               , ( StRVB * )BmEcran.GetMemBitmap()
               , PalCPC
               , BlockPal
               , m_BpPlus.GetCheck()
               , m_BpLissage.GetCheck()
               , m_BpReductPal1.GetCheck()
               , m_BpReductPal2.GetCheck()
               , m_BpModeReduct.GetCheck()
               , m_BpNb.GetCheck()
               , m_BpOrdonnerPalette.GetCheck()
               , m_BpPlusProche.GetCheck()
               , Etale << 1
               );
        InvalidateRect( NULL, FALSE );
        return( TRUE );
        }
    return( FALSE );
}


//
// Effectue la conversion de l'image vers le mode CPC choisi
//
void CConvImgCpcDlg::OnCalcule()
{
    BpOff();
    if ( Calcule( TRUE ) )
        ImageCalculee = TRUE;
    else
        {
        m_Liste.AddString( GetTexteLoc( 34, Locale ) );
        m_Liste.SetTopIndex( m_Liste.GetCount() - 1 );
        }
    BpOn();
}


//
// Affiche l'image source  l'cran
//
void CConvImgCpcDlg::OnAffiche()
{
    InitBitmap( TRUE );
}


//
// Initialise le bitmap en mmoire en fonction de l'image source lue,
// et l'affiche  l'cran si demand
//
BOOL CConvImgCpcDlg::InitBitmap( BOOL Affiche )
{
    if ( ImageLue )
        {
        SIZE s = ImageTypeCPC ? BitmapCPC.GetImageSize() : Picture.GetImageSize();
        if ( s.cx && s.cy )
            {
            int x = 0, y = 0, tx = TailleX, ty = TailleY;

            m_Rouge.GetWindowText( Msg, sizeof( Msg ) );
            int Rouge = min( max( 0, atoi( Msg ) ), 800 );
            m_Rouge.SetWindowText( itoa( Rouge, Msg, 10 ) );

            m_Vert.GetWindowText( Msg, sizeof( Msg ) );
            int Vert = min( max( 0, atoi( Msg ) ), 800 );
            m_Vert.SetWindowText( itoa( Vert, Msg, 10 ) );

            m_Bleu.GetWindowText( Msg, sizeof( Msg ) );
            int Bleu = min( max( 0, atoi( Msg ) ), 800 );
            m_Bleu.SetWindowText( itoa( Bleu, Msg, 10 ) );
            if ( m_TailleOrg.GetCheck() || m_NewTaille.GetCheck() )
                {
                if ( m_TailleOrg.GetCheck() )
                    {
                    ty = s.cy << 1;
                    tx = s.cx << 1;
                    if ( ModeCPC == 0 )
                        tx <<= 1;
                    else
                        if ( ModeCPC == 2 )
                            tx >>= 1;
                    }
                else
                    if ( m_NewTaille.GetCheck() )
                        {
                        m_TailleX.GetWindowText( Msg, sizeof( Msg ) );
                        tx = atoi( Msg );
                        m_TailleY.GetWindowText( Msg, sizeof( Msg ) );
                        ty = atoi( Msg );
                        }
                m_DeplX.GetWindowText( Msg, sizeof( Msg ) );
                x = atoi( Msg );
                m_DeplY.GetWindowText( Msg, sizeof( Msg ) );
                y = atoi( Msg );
                }
            if ( m_PropInf.GetCheck() || m_PropSup.GetCheck() )
                {
                double r = ( s.cx * TailleY ) / ( double )( s.cy * TailleX );
                if (  ( r > 1 && m_PropInf.GetCheck() )
                   || ( r < 1 && m_PropSup.GetCheck() )
                   )
                    {
                    tx = TailleX;
                    ty = ( int )( TailleY / r );
                    y = ( TailleY - ty ) >> 1;
                    }
                else
                    {
                    tx = ( int )( TailleX * r );
                    ty = TailleY;
                    x = ( TailleX - tx ) >> 1;
                    }
                }
            StRVB * MemBitmap = ( StRVB * )BmEcran.GetMemBitmap();
            memset( MemBitmap, 0, BITMAP_X * BITMAP_Y * 4 );
            if ( ImageTypeCPC )
                BitmapCPC.Render( MemBitmap, ModeCPC, FALSE );
            else
                Picture.Render( BmEcran.GetDC(), CRect( x, y, tx + x, ty + y ) );

            AjusteCouleurs( MemBitmap, Rouge, Vert, Bleu );
            AjusteContraste( MemBitmap, m_Contraste.GetPos() - 100 );
            sprintf( Msg
                   , GetTexteLoc( 35, Locale )
                   , tx
                   , ty
                   , tx / ( double )ty
                   , x
                   , y
                   );
            if ( Affiche )
                {
                m_Liste.AddString( Msg );
                m_Liste.SetTopIndex( m_Liste.GetCount() - 1 );
                int CentreX = ORG_OVS_X + ( ( DEST_OVS_X - TailleX ) >> 1 );
                int CentreY = ORG_OVS_Y + ( ( DEST_OVS_Y - TailleY ) >> 1 );
                StretchBlt( WinDC->m_hDC
                          , CentreX, CentreY, TailleX, TailleY
                          , BmEcran.GetDC(), 0, 0, TailleX, TailleY
                          , SRCCOPY
                          );
                ImageCalculee = FALSE;
                }
            return( TRUE );
            }
        }
    return( FALSE );
}


//
// Sauvegarde l'image
//
void CConvImgCpcDlg::OnSauve()
{
    BpOff();
    CFileDialog SelectFic( FALSE
                         , m_Asm.GetCheck() ? "ASM" : ModeCPC == 3 ? "PAK" : "SCR"
                         , NULL
                         , OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT
                         , GetTexteLoc( m_Asm.GetCheck() ? 63 : ModeCPC == 3 ? 52 : 36
                                      , Locale
                                      )
                         , this
                         );
    if ( SelectFic.DoModal() == IDOK )
        {
        char Nom[ 1024 ];
        strcpy( Nom, SelectFic.GetPathName() );
        wsprintf( Msg, GetTexteLoc( 37, Locale ), Nom );
        m_Liste.AddString( Msg );
        m_Liste.SetTopIndex( m_Liste.GetCount() - 1 );
        m_Liste.UpdateWindow();
        int l = SauveEcran( Nom
                          , ( StRVB * )BmEcran.GetMemBitmap()
                          , m_BpCmp.GetCheck()
                          , ModeCPC
                          , PalCPC
                          , m_BpPlus.GetCheck()
                          , NbLig
                          , NbCol
                          , m_BpLineaire.GetCheck()
                          , m_Asm.GetCheck()
                          , Locale
                          );
        if ( l )
            {
            wsprintf( Msg, GetTexteLoc( 40, Locale ), l );
            m_Liste.AddString( Msg );
            }
        else
            m_Liste.AddString( GetTexteLoc( 39, Locale ) );

        m_Liste.SetTopIndex( m_Liste.GetCount() - 1 );
        }
    BpOn();
}


//
// Inhibition de tous les boutons
//
void CConvImgCpcDlg::BpOff( void )
{
    m_BpSauve.EnableWindow( FALSE );
    m_BpCmp.EnableWindow( FALSE );
    m_Asm.EnableWindow( FALSE );
    m_BpLineaire.EnableWindow( FALSE );
    m_BpLire.EnableWindow( FALSE );
    m_BpAffiche.EnableWindow( FALSE );
    m_BpCalcule.EnableWindow( FALSE );
    m_BpLectPal.EnableWindow( FALSE );
    m_BpSauvePal.EnableWindow( FALSE );
    m_BpAppliquePal.EnableWindow( FALSE );
    m_BpRetouche.EnableWindow( FALSE );
    m_BpBatch.EnableWindow( FALSE );
}


//
// Affichage des boutons autoriss
//
void CConvImgCpcDlg::BpOn( void )
{
    char Msg[ 16 ];

    m_BpSauve.EnableWindow( ImageCalculee );
    m_BpCmp.EnableWindow( ImageCalculee );
    m_Asm.EnableWindow( ImageCalculee );
    m_BpLineaire.EnableWindow( ImageCalculee && ! m_BpCmp.GetCheck() );
    m_BpLire.EnableWindow( TRUE );
    m_BpAffiche.EnableWindow( ImageLue );
    m_BpCalcule.EnableWindow( ImageLue );
    m_BpLectPal.EnableWindow( TRUE );
    m_BpSauvePal.EnableWindow( TRUE );
    m_BpAppliquePal.EnableWindow( TRUE );
    m_BpRetouche.EnableWindow( ImageCalculee && ( ModeCPC < 3 ) );
    m_Mode3.EnableWindow( ! m_BpPlus.GetCheck() );
    m_BpMajOverscan.EnableWindow( m_BpOverscan.GetCheck() );

    NbLig = TailleY >> 1;
    wsprintf( Msg, "%d", NbLig );
    m_NbLig.EnableWindow( m_BpOverscan.GetCheck() );
    m_NbLig.SetWindowText( Msg );

    NbCol = TailleX >> 3;
    wsprintf( Msg, "%d", NbCol );
    m_NbCol.SetWindowText( Msg );
    m_NbCol.EnableWindow( m_BpOverscan.GetCheck() );

    m_BpReductPal1.EnableWindow( m_BpPlus.GetCheck() );
    m_BpReductPal2.EnableWindow( m_BpPlus.GetCheck() );
    m_BpModeReduct.EnableWindow( m_BpPlus.GetCheck() && ( m_BpReductPal1.GetCheck() || m_BpReductPal2.GetCheck() ) );
    m_BpPlusProche.EnableWindow( ! m_BpPlus.GetCheck() );
    m_BpBatch.EnableWindow( TRUE );
}


//
// Dtournement du OnOK, pour que l'appui sur la touche entre
// ne fait rien...
//
void CConvImgCpcDlg::OnOK()
{
}


//
// Gestion du click sur une couleur de la palette : ouverture
// de la fentre de choix de couleur
//
void CConvImgCpcDlg::ClickCol( int NumCol )
{
    if ( ! m_BpPlus.GetCheck() )
        {
        CChoixCouleur c( PalCPC[ NumCol ], this );
        c.DoModal();
        if ( c.GetRetour() )
            PalCPC[ NumCol ] = c.GetCouleur(); // Changement de couleur
        }
    else
        {
        CChoixColPlus c( PalCPC[ NumCol ], this );
        c.DoModal();
        if ( c.GetRetour() )
            PalCPC[ NumCol ] = c.GetCouleur(); // Changement de couleur
        }
    AffichePalette();
    if ( ImageTypeCPC )
        InitBitmap( TRUE );
}


void CConvImgCpcDlg::SetCheckBp( void )
{
    int Mask = ( ! m_PropInf.GetCheck() ) && ( ! m_PropSup.GetCheck() );
    m_DeplX.EnableWindow( Mask && ( m_TailleOrg.GetCheck() || m_NewTaille.GetCheck() ) );
    m_DeplY.EnableWindow( Mask && ( m_TailleOrg.GetCheck() || m_NewTaille.GetCheck() ) );
    m_TailleX.EnableWindow( Mask && m_NewTaille.GetCheck() );
    m_TailleY.EnableWindow( Mask && m_NewTaille.GetCheck() );
    if ( m_AutoCalc.GetCheck() )
        {
        if ( Calcule() )
            {
            ImageCalculee = TRUE;
            BpOn();
            }
        }
    else
        InitBitmap( TRUE );
}


void CConvImgCpcDlg::OnTailleOrg( void )
{
    SetCheckBp();
}


void CConvImgCpcDlg::OnNewTaille( void )
{
    SetCheckBp();
}


void CConvImgCpcDlg::OnTailleEcr( void )
{
    SetCheckBp();
}


void CConvImgCpcDlg::OnPropInf( void )
{
    SetCheckBp();
}


void CConvImgCpcDlg::OnPropSup( void )
{
    SetCheckBp();
}


void CConvImgCpcDlg::OnEfface( void )
{
    m_Liste.ResetContent();
}


void CConvImgCpcDlg::OnLectPal( void )
{
    BpOff();
    CFileDialog SelectFic( TRUE
                         , NULL
                         , NULL
                         , OFN_FILEMUSTEXIST
                         , GetTexteLoc( 49, Locale )
                         , this
                         );
    if ( SelectFic.DoModal() == IDOK )
        {
        char Nom[ 1024 ];
        strcpy( Nom, SelectFic.GetPathName() );
        wsprintf( Msg, GetTexteLoc( 30, Locale ), Nom );
        m_Liste.AddString( Msg );
        m_Liste.SetTopIndex( m_Liste.GetCount() - 1 );
        m_Liste.UpdateWindow();
        if ( LirePalette( Nom, PalCPC, m_BpPlus.GetCheck() ) )
            {
            AffichePalette();
            if ( ImageTypeCPC )
                InitBitmap( TRUE );

            m_Liste.AddString( GetTexteLoc( 31, Locale ) );
            }
        else
            m_Liste.AddString( GetTexteLoc( 33, Locale ) );

        m_Liste.SetTopIndex( m_Liste.GetCount() - 1 );
        }
    BpOn();
}


void CConvImgCpcDlg::OnSauvePal( void )
{
    BpOff();
    CFileDialog SelectFic( FALSE
                         , "PAL"
                         , NULL
                         , OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT
                         , GetTexteLoc( 49, Locale )
                         , this
                         );
    if ( SelectFic.DoModal() == IDOK )
        {
        char Nom[ 1024 ];
        strcpy( Nom, SelectFic.GetPathName() );
        wsprintf( Msg, GetTexteLoc( 37, Locale ), Nom );
        m_Liste.AddString( Msg );
        m_Liste.SetTopIndex( m_Liste.GetCount() - 1 );
        m_Liste.UpdateWindow();
        if ( SauvePalette( Nom, ModeCPC, PalCPC, m_BpPlus.GetCheck() ) )
            m_Liste.AddString( GetTexteLoc( 38, Locale ) );
        else
            m_Liste.AddString( GetTexteLoc( 39, Locale ) );

        m_Liste.SetTopIndex( m_Liste.GetCount() - 1 );
        }
    BpOn();
}


void CConvImgCpcDlg::OnAppliquePal( void )
{
    if ( ImageCalculee )
        {
        AppliquePalette( ( StRVB * )BmEcran.GetMemBitmap()
                       , ModeCPC
                       , PalCPC
                       , m_BpPlus.GetCheck()
                       );
        if ( m_AutoCalc.GetCheck() )
            Calcule();
        else
            InvalidateRect( NULL, FALSE );
        }
}


void CConvImgCpcDlg::OnCol00( void )
{
    ClickCol( 0 );
}


void CConvImgCpcDlg::OnCol01( void )
{
    ClickCol( 1 );
}


void CConvImgCpcDlg::OnCol02( void )
{
    ClickCol( 2 );
}


void CConvImgCpcDlg::OnCol03( void )
{
    ClickCol( 3 );
}


void CConvImgCpcDlg::OnCol04( void )
{
    ClickCol( 4 );
}


void CConvImgCpcDlg::OnCol05( void )
{
    ClickCol( 5 );
}


void CConvImgCpcDlg::OnCol06( void )
{
    ClickCol( 6 );
}


void CConvImgCpcDlg::OnCol07( void )
{
    ClickCol( 7 );
}


void CConvImgCpcDlg::OnCol08( void )
{
    ClickCol( 8 );
}


void CConvImgCpcDlg::OnCol09( void )
{
    ClickCol( 9 );
}


void CConvImgCpcDlg::OnCol10( void )
{
    ClickCol( 10 );
}


void CConvImgCpcDlg::OnCol11( void )
{
    ClickCol( 11 );
}


void CConvImgCpcDlg::OnCol12( void )
{
    ClickCol( 12 );
}


void CConvImgCpcDlg::OnCol13( void )
{
    ClickCol( 13 );
}


void CConvImgCpcDlg::OnCol14( void )
{
    ClickCol( 14 );
}


void CConvImgCpcDlg::OnCol15( void )
{
    ClickCol( 15 );
}


void CConvImgCpcDlg::OnLockAll( void )
{
    int Valeur = 0;

    for ( int i = 0; i < 16; i++ )
        if ( ! m_LockCol[ i ].GetCheck() )
            Valeur = 1;

    for ( int i = 0; i < 16; i++ )
        m_LockCol[ i ].SetCheck( Valeur );
}


void CConvImgCpcDlg::OnCustomdrawSlideLum( NMHDR * pNMHDR, LRESULT * pResult )
{
    static int OldVal = -1;

    if ( m_ValLum.GetPos() != OldVal )
        {
        OldVal = m_ValLum.GetPos();
        wsprintf( Msg, "%d", 200 - m_ValLum.GetPos() );
        m_Rouge.SetWindowText( Msg );
        m_Vert.SetWindowText( Msg );
        m_Bleu.SetWindowText( Msg );
        if ( m_AutoCalc.GetCheck() )
            Calcule();
        else
            OnAffiche();
        }
    * pResult = 0;
}


void CConvImgCpcDlg::OnCustomdrawContraste( NMHDR * pNMHDR, LRESULT * pResult )
{
    static int OldVal = -1;

    if ( m_Contraste.GetPos() != OldVal )
        {
        OldVal = m_Contraste.GetPos();
        if ( m_AutoCalc.GetCheck() )
            Calcule();
        else
            OnAffiche();
        }
    * pResult = 0;
}


void CConvImgCpcDlg::OnBpFr( void )
{
    Locale = LOC_FRANCAIS;
    SetInterface();
}


void CConvImgCpcDlg::OnBpEn( void )
{
    Locale = LOC_ENGLISH;
    SetInterface();
}


void CConvImgCpcDlg::ModifParam( void )
{
    if ( m_AutoCalc.GetCheck() )
        {
        if ( Calcule() )
            ImageCalculee = TRUE;

        BpOn();
        }
}


void CConvImgCpcDlg::OnTrame0( void )
{
    Methode = 0;
    m_PctTrame.EnableWindow( FALSE );
    m_SpinPct.EnableWindow( FALSE );
    ModifParam();
}


void CConvImgCpcDlg::OnTrame1( void )
{
    Methode = 1;
    m_PctTrame.EnableWindow( TRUE );
    m_SpinPct.EnableWindow( TRUE );
    ModifParam();
}


void CConvImgCpcDlg::OnTrame2( void )
{
    Methode = 2;
    m_PctTrame.EnableWindow( TRUE );
    m_SpinPct.EnableWindow( TRUE );
    ModifParam();
}


void CConvImgCpcDlg::OnTrame3( void )
{
    Methode = 3;
    m_PctTrame.EnableWindow( TRUE );
    m_SpinPct.EnableWindow( TRUE );
    ModifParam();
}


void CConvImgCpcDlg::OnMatX2( void )
{
    Matrice = 2;
    ModifParam();
}


void CConvImgCpcDlg::OnMatX3( void )
{
    Matrice = 3;
    ModifParam();
}


void CConvImgCpcDlg::OnMode0( void )
{
    ModeCPC = 0;
    if ( m_AutoCalc.GetCheck() )
        Calcule();
    else
        InitBitmap( TRUE );

    BpOn();
}


void CConvImgCpcDlg::OnMode1( void )
{
    ModeCPC = 1;
    if ( m_AutoCalc.GetCheck() )
        Calcule();
    else
        InitBitmap( TRUE );

    BpOn();
}


void CConvImgCpcDlg::OnMode2( void )
{
    ModeCPC = 2;
    if ( m_AutoCalc.GetCheck() )
        Calcule();
    else
        InitBitmap( TRUE );

    BpOn();
}


void CConvImgCpcDlg::OnMode3( void )
{
    ModeCPC = 3;
    if ( m_AutoCalc.GetCheck() )
        Calcule();
    else
        InitBitmap( TRUE );

    BpOn();
}


void CConvImgCpcDlg::OnPlus( void )
{
    m_BpModeReduct.EnableWindow( m_BpPlus.GetCheck() && ( m_BpReductPal1.GetCheck() || m_BpReductPal2.GetCheck() ) );
    if ( m_BpPlus.GetCheck() && ModeCPC == 3 )
        {
        m_Mode1.SetCheck( 1 );
        m_Mode3.SetCheck( 0 );
        OnMode1();
        }
    else
        if ( m_AutoCalc.GetCheck() )
            Calcule();
        else
            InitBitmap( TRUE );

    BpOn();
}


void CConvImgCpcDlg::OnOverscan( void )
{
    if ( m_BpOverscan.GetCheck() )
        {
        TailleX = BITMAP_X;
        TailleY = BITMAP_Y;
        }
    else
        {
        TailleX = DEST_X;
        TailleY = DEST_Y;
        }
    if ( m_Mode3.GetCheck() )
        {
        m_Mode3.SetCheck( 0 );
        m_Mode1.SetCheck( 1 );
        }
    ChangeOverscan = TRUE;
    InitBitmap( FALSE );
    if ( m_AutoCalc.GetCheck() )
        Calcule();
    else
        InvalidateRect( NULL, FALSE );

    BpOn();
}


void CConvImgCpcDlg::OnModeReduct( void )
{
    ModifParam();
}


void CConvImgCpcDlg::OnNb( void )
{
    ModifParam();
}


void CConvImgCpcDlg::OnReductPal1( void )
{
    m_BpModeReduct.EnableWindow( m_BpPlus.GetCheck() && ( m_BpReductPal1.GetCheck() || m_BpReductPal2.GetCheck() ) );
    ModifParam();
}


void CConvImgCpcDlg::OnReductPal2( void )
{
    m_BpModeReduct.EnableWindow( m_BpPlus.GetCheck() && ( m_BpReductPal1.GetCheck() || m_BpReductPal2.GetCheck() ) );
    ModifParam();
}


void CConvImgCpcDlg::OnAutoCalc( void )
{
    ModifParam();
}


void CConvImgCpcDlg::OnLissage( void )
{
    ModifParam();
}


void CConvImgCpcDlg::OnDeltaposSpinPct( NMHDR * pNMHDR, LRESULT * pResult )
{
    NM_UPDOWN* pNMUpDown = ( NM_UPDOWN * )pNMHDR;

    m_PctTrame.GetWindowText( Msg, sizeof( Msg ) );
    int pct = max( min( atoi( Msg ) - pNMUpDown->iDelta, 200 ), 0 );
    m_PctTrame.SetWindowText( itoa( pct, Msg, 10 ) );
    ModifParam();
    * pResult = 0;
}


void CConvImgCpcDlg::OnDeltaposSpinLum( NMHDR * pNMHDR, LRESULT * pResult )
{
    NM_UPDOWN* pNMUpDown = ( NM_UPDOWN * )pNMHDR;

    m_Rouge.GetWindowText( Msg, sizeof( Msg ) );
    int r = atoi( Msg );
    m_Vert.GetWindowText( Msg, sizeof( Msg ) );
    int v = atoi( Msg );
    m_Bleu.GetWindowText( Msg, sizeof( Msg ) );
    int b = atoi( Msg );
    int l = ( ( K_R * r + K_V * v + K_B * b ) >> 15 ) - pNMUpDown->iDelta;
    l = max( 0, min( l, 200 ) );
    itoa( l, Msg, 10 );
    m_Rouge.SetWindowText( Msg );
    m_Vert.SetWindowText( Msg );
    m_Bleu.SetWindowText( Msg );
    m_ValLum.SetPos( 200 - l );
    if ( m_AutoCalc.GetCheck() )
        Calcule();
    else
        OnAffiche();

    * pResult = 0;
}


void CConvImgCpcDlg::OnMajOverscan( void )
{
    char Msg[ 16 ];

    m_NbLig.GetWindowText( Msg, sizeof( Msg ) );
    NbLig = min( max( 8, atoi( Msg ) ), MAX_LIGNES_CPC );

    wsprintf( Msg, "%d", NbLig );
    m_NbLig.SetWindowText( Msg );
    TailleY = NbLig << 1;

    m_NbCol.GetWindowText( Msg, sizeof( Msg ) );
    NbCol = min( max( 1, atoi( Msg ) ), MAX_COLS_CPC );

    wsprintf( Msg, "%d", NbCol );
    m_NbCol.SetWindowText( Msg );
    TailleX = NbCol << 3;

    ChangeOverscan = TRUE;
    InitBitmap( TRUE );
    if ( m_AutoCalc.GetCheck() )
        Calcule();
    else
        InvalidateRect( NULL, FALSE );
}


void CConvImgCpcDlg::OnCmp( void )
{
    if ( m_BpCmp.GetCheck() )
        m_BpLineaire.SetCheck( 0 );

    BpOn();
}


void CConvImgCpcDlg::OnRetouche( void )
{
    CRetouche Retouche( ModeCPC
                      , PalCPC
                      , m_BpPlus.GetCheck()
                      , BmEcran.GetDC()
                      , ( StRVB * )BmEcran.GetMemBitmap()
                      , Locale
                      , TailleX
                      , TailleY
                      , this
                      );

    Retouche.DoModal();
    InvalidateRect( NULL, FALSE );
}


void CConvImgCpcDlg::OnBatch()
{
    static char BufFiles[ 0x1000 ];
    BpOff();
    CFileDialog f( TRUE
                 , NULL
                 , NULL
                 , OFN_FILEMUSTEXIST | OFN_ALLOWMULTISELECT
                 , GetTexteLoc( 29,Locale )
                 , this
                 );
    f.m_ofn.lpstrFile = BufFiles;
    f.m_ofn.nMaxFile = sizeof( BufFiles );
    if ( f.DoModal() == IDOK )
        {
        POSITION pos = f.GetStartPosition();
        do
            {
            char NomSauve[ 256 ];
            strcpy( NomSauve, f.GetNextPathName( pos ) );
            SIZE s;
            wsprintf( Msg, GetTexteLoc( 30, Locale ), NomSauve );
            m_Liste.AddString( Msg );
            if ( LectImg( NomSauve, &s ) )
                {
                char * q = strchr( NomSauve, '.' );
                if ( q )
                    * q = 0;

                strcat( NomSauve, ".SCR" );
                m_Liste.AddString( GetTexteLoc( 31, Locale ) );
                ImageLue = TRUE;
                InitBitmap( FALSE );
                if ( ImageTypeCPC )
                    {
                    // Recalcule avec la palette prsente dans l'image
                    Passe2( ( StRVB * )BmEcran.GetMemBitmap()
                          , 4 >> ModeCPC
                          , PalCPC
                          , ModeCPC == 0 ? 16 : ModeCPC == 1 ? 4 : 2
                          , m_BpPlus.GetCheck()
                          );
                    LisseBitmap( ( StRVB * )BmEcran.GetMemBitmap()
                               , 4 >> ( ModeCPC == 3 ? 1 : ModeCPC )
                               );
                    InvalidateRect( NULL, FALSE );
                    ImageCalculee = TRUE;
                    }
                else
                    Calcule();

                int l = SauveEcran( NomSauve
                                  , ( StRVB * )BmEcran.GetMemBitmap()
                                  , m_BpCmp.GetCheck()
                                  , ModeCPC
                                  , PalCPC
                                  , m_BpPlus.GetCheck()
                                  , NbLig
                                  , NbCol
                                  , m_BpLineaire.GetCheck()
                                  , m_Asm.GetCheck()
                                  , Locale
                                  );
                if ( l )
                    {
                    wsprintf( Msg, GetTexteLoc( 40, Locale ), l );
                    m_Liste.AddString( Msg );
                    }
                else
                    m_Liste.AddString( GetTexteLoc( 39, Locale ) );

                m_Liste.SetTopIndex( m_Liste.GetCount() - 1 );
                UpdateWindow();
                }
            }
        while( pos );
        }
    BpOn();
}


void CConvImgCpcDlg::OnOrdonnerPalette( void )
{
    ModifParam();
}


void CConvImgCpcDlg::OnPlusProche( void )
{
    ModifParam();
}


//
// Initialisation des textes & boutons de l'interface en fonction de la langue
//
void CConvImgCpcDlg::SetInterface( void )
{
    m_BpLire.SetWindowText( GetTexteLoc( 0, Locale ) );
    m_BpAffiche.SetWindowText( GetTexteLoc( 1, Locale ) );
    m_BpCalcule.SetWindowText( GetTexteLoc( 2, Locale ) );
    m_BpSauve.SetWindowText( GetTexteLoc( 3, Locale ) );
    m_ParamC.SetWindowText( GetTexteLoc( 4, Locale ) );
    m_R.SetWindowText( GetTexteLoc( 5, Locale ) );
    m_V.SetWindowText( GetTexteLoc( 6, Locale ) );
    m_B.SetWindowText( GetTexteLoc( 7, Locale ) );
    m_Trame0.SetWindowText( GetTexteLoc( 8, Locale ) );
    m_Trame1.SetWindowText( GetTexteLoc( 9, Locale ) );
    m_Trame2.SetWindowText( GetTexteLoc( 10, Locale ) );
    m_Trame3.SetWindowText( GetTexteLoc( 11, Locale ) );
    m_GestPal.SetWindowText( GetTexteLoc( 12, Locale ) );
    m_Coul.SetWindowText( GetTexteLoc( 13, Locale ) );
    m_Bloque.SetWindowText( GetTexteLoc( 14, Locale ) );
    m_BpLectPal.SetWindowText( GetTexteLoc( 15, Locale ) );
    m_BpSauvePal.SetWindowText( GetTexteLoc( 16, Locale ) );
    m_BpEfface.SetWindowText( GetTexteLoc( 17, Locale ) );
    m_ParamI.SetWindowText( GetTexteLoc( 18, Locale ) );
    m_TailleOrg.SetWindowText( GetTexteLoc( 19, Locale ) );
    m_NewTaille.SetWindowText( GetTexteLoc( 20, Locale ) );
    m_PropInf.SetWindowText( GetTexteLoc( 21, Locale ) );
    m_PropSup.SetWindowText( GetTexteLoc( 22, Locale ) );
    m_TDeplX.SetWindowText( GetTexteLoc( 23, Locale ) );
    m_TDeplY.SetWindowText( GetTexteLoc( 24, Locale ) );
    m_NewX.SetWindowText( GetTexteLoc( 25, Locale ) );
    m_NewY.SetWindowText( GetTexteLoc( 26, Locale ) );
    m_LockAll.SetWindowText( GetTexteLoc( 41, Locale ) );
    m_BpCmp.SetWindowText( GetTexteLoc( 50, Locale ) );
    m_BpRetouche.SetWindowText( GetTexteLoc( 55, Locale ) );

    m_StaticNbLig.SetWindowText( GetTexteLoc( 57, Locale ) );
    m_StaticNbCol.SetWindowText( GetTexteLoc( 58, Locale ) );
    m_BpLineaire.SetWindowText( GetTexteLoc( 59, Locale ) );
    m_BpAppliquePal.SetWindowText( GetTexteLoc( 61, Locale ) );
    m_Asm.SetWindowText( GetTexteLoc( 62, Locale ) );
    m_AutoCalc.SetWindowText( GetTexteLoc( 64, Locale ) );
    m_TailleEcr.SetWindowText( GetTexteLoc( 65, Locale ) );
    m_BpBatch.SetWindowText( GetTexteLoc( 66, Locale ) );
    m_BpLissage.SetWindowText( GetTexteLoc( 67, Locale ) );
    m_BpNb.SetWindowText( GetTexteLoc( 68, Locale ) );
    m_BpReductPal1.SetWindowText( GetTexteLoc( 69, Locale ) );
    m_BpReductPal2.SetWindowText( GetTexteLoc( 70, Locale ) );
    m_BpModeReduct.SetWindowText( GetTexteLoc( 71, Locale ) );
    m_StaticContraste.SetWindowText( GetTexteLoc( 72, Locale ) );
    m_BpPlusProche.SetWindowText( GetTexteLoc( 73, Locale ) );
    SetTitre( NULL );
}


void CConvImgCpcDlg::SetTitre( char * NomFic )
{
    wsprintf( Msg
            , "%s (Build %s %s) %c %s"
            , VERSION
            , __DATE__
            , __TIME__
            , NomFic ? '-' : ' '
            , NomFic ? NomFic : ""
            );
    SetWindowText( Msg );
}


//
// Relache le bouton droit de la souris
//
void CConvImgCpcDlg::OnRButtonUp( UINT nFlags, CPoint point )
{
    MemoBpMove = FALSE;
    CDialog::OnRButtonDown( nFlags, point );
}


//
// Relache le bouton gauche de la souris
//
void CConvImgCpcDlg::OnLButtonUp( UINT nFlags, CPoint point )
{
    MemoBpZoom = FALSE;
    CDialog::OnLButtonDown( nFlags, point );
}


//
// Appui sur le bouton droit de la souris
//
void CConvImgCpcDlg::OnRButtonDown( UINT nFlags, CPoint point )
{
    if ( m_TailleOrg.GetCheck() || m_NewTaille.GetCheck() )
        {
        int CentreX = ORG_OVS_X + ( ( DEST_OVS_X - TailleX ) >> 1 );
        int CentreY = ORG_OVS_Y + ( ( DEST_OVS_Y - TailleY ) >> 1 );
        if (  point.x >= CentreX
           && point.y >= CentreY
           && point.x < TailleX + CentreX
           && point.y < TailleY + CentreY
           )
            {
            if ( ! MemoBpMove )
                {
                MemoBpMove = TRUE;
                xMove = point.x;
                yMove = point.y;
                }
            else
                {
                if ( point.x != xMove || point.y != yMove )
                    {
                    xMove -= point.x;
                    yMove -= point.y;
                    m_DeplX.GetWindowText( Tmp, sizeof( Tmp ) );
                    wsprintf( Tmp, "%d", atoi( Tmp ) - xMove );
                    m_DeplX.SetWindowText( Tmp );
                    m_DeplY.GetWindowText( Tmp, sizeof( Tmp ) );
                    wsprintf( Tmp, "%d", atoi( Tmp ) - yMove );
                    m_DeplY.SetWindowText( Tmp );
                    xMove = point.x;
                    yMove = point.y;
                    if ( m_AutoCalc.GetCheck() )
                        Calcule();
                    else
                        InitBitmap( TRUE );
                    }
                }
            }
        }
    CDialog::OnRButtonDown( nFlags, point );
}


//
// Appui sur le bouton gauche de la souris
//
void CConvImgCpcDlg::OnLButtonDown( UINT nFlags, CPoint point )
{
    if ( m_TailleOrg.GetCheck() || m_NewTaille.GetCheck() )
        {
        int CentreX = ORG_OVS_X + ( ( DEST_OVS_X - TailleX ) >> 1 );
        int CentreY = ORG_OVS_Y + ( ( DEST_OVS_Y - TailleY ) >> 1 );
        if (  point.x >= CentreX
           && point.y >= CentreY
           && point.x < TailleX + CentreX
           && point.y < TailleY + CentreY
           )
            {
            if ( ! MemoBpZoom )
                {
                MemoBpZoom = TRUE;
                xZoom = point.x;
                yZoom = point.y;
                }
            else
                {
                if ( point.x != xZoom || point.y != yZoom )
                    {
                    m_TailleX.GetWindowText( Tmp, sizeof( Tmp ) );
                    int TailleX = atoi( Tmp );
                    m_TailleY.GetWindowText( Tmp, sizeof( Tmp ) );
                    int TailleY = atoi( Tmp );
                    int ZoomX = point.x - xZoom;
                    int ZoomY = point.y - yZoom;
                    xZoom = point.x;
                    yZoom = point.y;
                    if ( ZoomX > 0 )
                        TailleX = ( int )( TailleX * ( 1 + ZoomX / C_ZOOM ) );
                    else
                        TailleX = ( int )( TailleX / ( 1 - ZoomX / C_ZOOM ) );

                    if ( ZoomY > 0 )
                        TailleY = ( int )( TailleY * ( 1 + ZoomY / C_ZOOM ) );
                    else
                        TailleY = ( int )( TailleY / ( 1 - ZoomY / C_ZOOM ) );

                    m_TailleX.SetWindowText( itoa( TailleX, Tmp, 10 ) );
                    m_TailleY.SetWindowText( itoa( TailleY, Tmp, 10 ) );
                    if ( m_AutoCalc.GetCheck() )
                        Calcule();
                    else
                        InitBitmap( TRUE );
                    }
                }
            }
        }
    CDialog::OnLButtonDown( nFlags, point );
}


//
// fonction appele lorsque l'utilisateur dplace la souris
//
void CConvImgCpcDlg::OnMouseMove(UINT nFlags, CPoint point)
{
    switch( nFlags )
        {
        case MK_LBUTTON :
            OnLButtonDown( nFlags, point );
            break;

        case MK_RBUTTON :
            OnRButtonDown( nFlags, point );
            break;
        }
    CDialog::OnMouseMove( nFlags, point );
}
