#include <afxwin.h>

#include "Picture.h"


#define HIMETRIC_INCH   2540


BOOL CPicture::Load( LPCTSTR pszPathName )
{
    HANDLE hFile = CreateFile( pszPathName
                             , GENERIC_READ
                             , FILE_SHARE_READ
                             , NULL
                             , OPEN_EXISTING
                             , FILE_ATTRIBUTE_NORMAL
                             , NULL
                             );
    if ( ! hFile )
        return( FALSE );

    DWORD len = GetFileSize( hFile, NULL );
    if ( ! len )
        return( FALSE );

    HGLOBAL hGlobal = GlobalAlloc( GMEM_MOVEABLE | GMEM_NODISCARD, len );
    if ( ! hGlobal )
        {
        CloseHandle( hFile );
        return( FALSE );
        }

    char * lpBuffer = reinterpret_cast<char*> ( GlobalLock( hGlobal ) );
    DWORD dwBytesRead = 0;

    ReadFile( hFile, lpBuffer, len, &dwBytesRead, NULL );
    CloseHandle( hFile );
    GlobalUnlock(hGlobal);

    IStream * pStream = NULL;
    if ( CreateStreamOnHGlobal( hGlobal, FALSE, &pStream ) != S_OK )
        {
        GlobalFree( hGlobal );
        return( FALSE );
        }

    if ( m_spIPicture )
        m_spIPicture.Release();

    BOOL bRet = ( OleLoadPicture( pStream
                                , 0
                                , FALSE
                                , IID_IPicture
                                , (void ** )&m_spIPicture
                                ) == S_OK
                 );
    GlobalFree( hGlobal );
    return( bRet );
}


void CPicture::Render( HDC dc, RECT * rc, LPCRECT prcMFBounds )
{
    long hmWidth, hmHeight;

    if ( ! rc || ( rc->right == rc->left && rc->bottom == rc->top ) )
        {
        SIZE sz = GetImageSize( dc );
        rc->right = sz.cx;
        rc->bottom = sz.cy;
        }
    m_spIPicture->get_Width( &hmWidth );
    m_spIPicture->get_Height( &hmHeight );
    m_spIPicture->Render( dc
                        , rc->left
                        , rc->top
                        , rc->right - rc->left
                        , rc->bottom - rc->top
                        , 0
                        , hmHeight
                        , hmWidth
                        , -hmHeight
                        , prcMFBounds
                        );
}


SIZE CPicture::GetImageSize( HDC dc ) const
{
    SIZE sz = { 0, 0 };

    if ( m_spIPicture )
        {
        LONG hmWidth, hmHeight;
        m_spIPicture->get_Width( &hmWidth );
        m_spIPicture->get_Height( &hmHeight );

        sz.cx = hmWidth;
        sz.cy = hmHeight;

        if ( ! dc ) 
            {
            HDC dcscreen = GetWindowDC( NULL );
            SetHIMETRICtoDP( dcscreen, &sz );
            }
        else
            SetHIMETRICtoDP( dc, &sz );
        }
    return( sz );
}


void CPicture::SetHIMETRICtoDP( HDC hdc, SIZE * sz ) const
{
    int nMapMode;
    if ( ( nMapMode = GetMapMode( hdc ) ) < MM_ISOTROPIC && nMapMode != MM_TEXT )
        {
        SetMapMode( hdc, MM_HIMETRIC );
        POINT pt;
        pt.x = sz->cx;
        pt.y = sz->cy;
        LPtoDP( hdc, &pt, 1 );
        sz->cx = pt.x;
        sz->cy = pt.y;
        SetMapMode( hdc, nMapMode );
        }
    else
        {
        int cxPerInch, cyPerInch;
        cxPerInch = GetDeviceCaps( hdc, LOGPIXELSX );
        cyPerInch = GetDeviceCaps( hdc, LOGPIXELSY );
        sz->cx = MulDiv( sz->cx, cxPerInch, HIMETRIC_INCH );
        sz->cy = MulDiv( sz->cy, cyPerInch, HIMETRIC_INCH );
        }
    POINT pt;
    pt.x = sz->cx;
    pt.y = sz->cy;
    DPtoLP(hdc,&pt,1);
    sz->cx = pt.x;
    sz->cy = pt.y;
}
