#include <windows.h>
#include <tchar.h>
#include <stdio.h>
#include "Configuration.h"

_TCHAR *ini_file = "./tracker.ini";

DWORD CONFIGURATION_GETDWORD( _TCHAR *section, _TCHAR *keyname, DWORD defval )
{
	return GetPrivateProfileInt( section, keyname, defval, ini_file );
}

void CONFIGURATION_SETDWORD( _TCHAR *section,  _TCHAR *keyname, DWORD value )
{
	_TCHAR temp[1024];
	_stprintf( temp, _T("%d") , value );
	CONFIGURATION_SETSTRING( section, keyname, temp );
}

void CONFIGURATION_GETSTRING( _TCHAR *section, _TCHAR *keyname, _TCHAR *string, DWORD strlen, _TCHAR *def )
{
	GetPrivateProfileString( section, keyname, def, string, strlen, ini_file );
}

void CONFIGURATION_SETSTRING( _TCHAR *section, _TCHAR *keyname, _TCHAR *string )
{
	WritePrivateProfileString( section, keyname, string, ini_file );
}

