#include "stdafx.h"
#include "tracker.h"

#include "mainfrm.h"
#include "gtkformat.h"
#include "trackerDoc.h"
#include "trackerView.h"

#include <math.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static int kfx_floor(float x)
{
    int xi;
    WORD old_fpcw,new_fpcw;
    __asm
    {
        fld     x
        fwait
        fnstcw  old_fpcw
        fwait
        mov     ax,old_fpcw
        or      ah,0x0c
        mov     new_fpcw,ax
        fldcw   new_fpcw
        fistp   xi
        fldcw   old_fpcw
        mov     eax,xi
        cmp     eax,0
        jg      noadd
        inc     eax
    noadd:
        mov     xi,eax
    }
    return xi;
}


static char note_table[12*6+1][4]=
{
  "---",
  "C-1","C#1","D-1","D#1","E-1","F-1","F#1","G-1","G#1","A-1","A#1","B-1",
  "C-2","C#2","D-2","D#2","E-2","F-2","F#2","G-2","G#2","A-2","A#2","B-2",
  "C-3","C#3","D-3","D#3","E-3","F-3","F#3","G-3","G#3","A-3","A#3","B-3",
  "C-4","C#4","D-4","D#4","E-4","F-4","F#4","G-4","G#4","A-4","A#4","B-4",
  "C-5","C#5","D-5","D#5","E-5","F-5","F#5","G-5","G#5","A-5","A#5","B-5",
  "C-6","C#6","D-6","D#6","E-6","F-6","F#6","G-6","G#6","A-6","A#6","B-6"
};

static int x_size_array[4]=
{
	0,0,0,0,
};
void CPatternView::DrawPattern(CDC *pDC)
{
	CTrackerDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	if (!pDoc->synth || ! pDoc->pl)
		return;

	CRect rect;
	int xpostab[]={0,30,50,70};
	int xpos,i,j,patStart;
	CGdiObject *oldstock;


	int x_offset;
	int x_spacing;
	int x_row_spacing;
	int y_col_spaceing;
	CSize char_size;

	// TODO: add draw code for native data here

	pDC->SetBkColor  (RGB(0,0,0));
	pDC->SetBkMode (TRANSPARENT);
	pDC->SetTextColor (pDoc->ctrl_text);

	// lets shrink window for tracker data	
	pDC->SetViewportOrg (0,128);
	GetClientRect (&rect);
	rect.bottom-=(128);



	CFont font;
	font.CreateFont(11,0,0,0,0,0,0,0,0,00,0,0,0,"Lucida Console");
//	oldstock = pDC->SelectStockObject (SYSTEM_FIXED_FONT);
	oldstock = pDC->SelectObject (&font);
	// hackeli-hack..  try to figure out the spacing between chars..
	// use "M" as reference char...
	char_size = pDC->GetTextExtent("M");

	x_offset = char_size.cx * 2 + rect.left;
	y_col_spaceing = char_size.cy;

	xpostab[0] = 0 + rect.left;
	xpostab[1] = xpostab[0] + 3 * char_size.cx;	
	xpostab[2] = xpostab[1] + 2 * char_size.cx;	
	xpostab[3] = xpostab[2] + 2 * char_size.cx;	

	x_row_spacing = (2+2+2+3+1) * char_size.cx;

	///-----------------------
	patStart = patScroller.GetScrollPos ();



	// draw tracker bar
	pDC->FillSolidRect (rect.left,rect.top, rect.Width (), y_col_spaceing,pDoc->ctrl_bg);
	pDC->Draw3dRect (rect.left,rect.top, rect.Width (), y_col_spaceing,pDoc->ctrl_light,pDoc->ctrl_dark);

	j =  pDoc->gtk->channels[seqCursor.col].positions[seqCursor.pos].pattern;
	for (i=patStart;i<16;i++)
	{
		char tmp[64];
		if (!j) sprintf (tmp,"empty");
		else sprintf (tmp,"%02x:%02d",j,i);

//		pDC->TextOut ((i-patStart)*x_row_spacing+rect.left+25,0,tmp);
		pDC->TextOut ((i-patStart)*x_row_spacing+rect.left+x_offset,0,tmp);
	}
//------------------------------
	
	pDC->SetViewportOrg (0,128+y_col_spaceing);
	GetClientRect (&rect);
	rect.bottom-=(128+y_col_spaceing*2);

	// draw lousy stuff beetween each track...
//	xpos = rect.left + 20;
	xpos = x_offset;
	for (i=0;i<16;i++)
	{
//		pDC->Draw3dRect (xpos+i*95,rect.top,2,rect.Height (),pDoc->ctrl_light,pDoc->ctrl_dark);		
//		if (xpos+i*95 > rect.right) break;
		pDC->Draw3dRect (xpos+i*x_row_spacing,rect.top,2,rect.Height (),pDoc->ctrl_light,pDoc->ctrl_dark);		
		if (xpos+i*x_row_spacing > rect.right) break;
	}


	int middle;
	middle = ((int)(rect.Height ()/2.0) - y_col_spaceing / 2.0f);

// draw middle "edit" bar
	pDC->FillSolidRect (rect.left,middle, rect.Width (), y_col_spaceing,pDoc->ctrl_bg);
	pDC->Draw3dRect (rect.left,middle, rect.Width (), y_col_spaceing,pDoc->ctrl_light,pDoc->ctrl_dark);


	x_offset += char_size.cx;
	// draw cursor
	xpos = (patCursor.col-patStart)*x_row_spacing+x_offset;

	if (isPatternEdit && (!pDoc->playing))
	{
		if (!patCursor.rowcol)
		{
			pDC->FillSolidRect (xpos,middle,xpostab[1] - xpostab[0],y_col_spaceing,pDoc->ctrl_cursor);	
		} else
			{
				if ((patCursor.rowcol-1) & 1) xpos+=char_size.cx;

				xpos = xpos + xpostab[((patCursor.rowcol-1)>>1)+1];
				pDC->FillSolidRect (xpos,middle,char_size.cx,y_col_spaceing,pDoc->ctrl_cursor);

			}
	}
  
// Draw pattern data
	pDC->SetTextColor (pDoc->ctrl_text);



	char buf[16];
	int pos_start;
	int edt_mode;
	int ep1,ep2,ec1,ec2;
	COLORREF curscol; 

	if (!pDoc->playing)
		pos_start = patCursor.pos;
	else 
		pos_start = pDoc->play_patternrow;

	
	pos_start =  -pos_start * y_col_spaceing + middle;
	pDC->SetTextColor (pDoc->ctrl_text);


	GTK_PATTERN *pattern;
	GTK_PATTERNPOS *patpos;
	int num;
	if (!pDoc->playing)
		num = pDoc->gtk->channels[seqCursor.col].positions[seqCursor.pos].pattern;
	else
		num = pDoc->play_pattern;

	pattern = &pDoc->gtk->patterns[num];


//	lets draw the "numbers"
	for (i=0;i<pattern->len;i++)
	{

		if ((i*y_col_spaceing + pos_start)> rect.top)
		{
			sprintf (buf,"%02x",i);
			pDC->TextOut (0,i*y_col_spaceing + pos_start,buf);
		}
		if ((i*y_col_spaceing + pos_start)> rect.bottom) break;
	}

  // If we are in block copy mode, find out which row/col 
  // that should be marked..
	#define mswap(a,b) {int tmp; tmp=(a);(a)=(b);(b)=tmp;}
	if (pDoc->editData.state == GTK_EDITSTATE_PATTERNSELECT)
	{
		ep1 = pDoc->editData.beginmark.pos;
		ep2 = pDoc->editData.endmark.pos;
		if (ep1 > ep2)
			  mswap(ep1,ep2);

		ec1 = pDoc->editData.beginmark.col;
		ec2 = pDoc->editData.endmark.col;
		if (ec1 > ec2)
			mswap(ec1,ec2);
	}
	#undef mswap

	//	lets draw each channel
	edt_mode=0;
	///for (j=0;j<64;j++)
	for (j=0;j<pattern->len;j++)
	{

		if ((y_col_spaceing*j + pos_start) < rect.top)
			continue;
		if ((y_col_spaceing*j + pos_start) > rect.bottom)
			continue;


        patpos = pattern->patterndata[j];
        curscol=pDoc->ctrl_text;
        if (pDoc->editData.state == GTK_EDITSTATE_PATTERNSELECT)
        {
            edt_mode=0;
            if ((j >= ep1) && (j <= ep2))
            {
              edt_mode=1;
              curscol = pDoc->ctrl_marktext;
            }
        }
		
		for (i=patStart;i<16;i++)
		{
			xpos = (i-patStart)*x_row_spacing+x_offset;
            if (!edt_mode)
            {
                if (i == patCursor.col)	pDC->SetTextColor (pDoc->ctrl_curtext);
                else	pDC->SetTextColor (pDoc->ctrl_text);
      
            } else
                {
                  if ((i>=ec1) && (i<=ec2))
                    pDC->SetTextColor (curscol);          
                  else 
                    pDC->SetTextColor (pDoc->ctrl_text);          
      
                } // else

			if (patpos[i].note == GTK_NOTE_OFF)
			{
				sprintf (buf,"off");
			} else
				{
					if (patpos[i].note > 12*6)
						sprintf (buf,"???");
					else
						sprintf (buf,note_table[patpos[i].note]);
				}
			pDC->TextOut (xpos+xpostab[0],j*y_col_spaceing + pos_start,buf);
			
			// DAN!! fixa en sn dr instllningsbar grej fr varje sn hr RGB!
			sprintf (buf,"%02x",patpos[i].velocity);
			pDC->SetTextColor(RGB(0xFF,0xFF,0x40));
			pDC->TextOut (xpos+xpostab[1],j*y_col_spaceing + pos_start,buf);

			sprintf (buf,"%02x",patpos[i].fx);
			pDC->SetTextColor(RGB(0xE0,0xFF,0xFF));
			pDC->TextOut (xpos+xpostab[2],j*y_col_spaceing + pos_start,buf);

			sprintf (buf,"%02x",patpos[i].param);
			pDC->SetTextColor(RGB(0x80,0xFF,0x60));
			pDC->TextOut (xpos+xpostab[3],j*y_col_spaceing + pos_start,buf);			
			if ((i-patStart)*x_row_spacing+rect.left > rect.right) break;
		}
		if ((j*y_col_spaceing + pos_start) > rect.bottom) break;

	}

  pDC->SelectObject(oldstock);
} // drawTrk
