/*
   Reverie
   amigasphere.h
   Copyright (C)2003 Dan Potter
*/

#ifndef __AMIGASPHERE_H
#define __AMIGASPHERE_H

class DelayCube;

class AmigaSphere : public Drawable {
public:
	AmigaSphere(DelayCube * srctheta, bool startBounce);
	virtual ~AmigaSphere();

	virtual void draw(int list);
	virtual void nextFrame();

	void setBouncing();

	class ToBounce : public Animation {
	public:
		virtual void nextFrame(Drawable * t) {
			AmigaSphere * as = (AmigaSphere *)t;
			as->setBouncing();
			complete(t);
		}
	};

private:
	void drawSphere(Color c);

	float		m_theta, m_dt, m_yaw;
	float		m_size;
	bool		m_bouncing;

	// For bounce mode
	Vector		m_velocity, m_lastvel;

	RefPtr<DelayCube>	m_dc;
	bool			m_thetaset;
};

#endif	// __AMIGASPHERE_H

