/*
   Reverie
   copperbars.cpp
   Copyright (C)2003 Dan Potter
*/

#include "global.h"
#include "copperbars.h"

/*

Another little old school demo effect from the Amiga, sinus bars (sometimes
called Copper bars, because they were done with the Copper chip on the
Amiga). Back in the Amiga days they had to program the Copper to change
a palette entry for each scanline at horizontal refresh. We don't have
it so hard these days with the PVR. In fact a lot of people would probably
consider this cheating ;)

*/

// This will be two polygons, each being half a gradient bar. Note that
// it's ok to mix vertex macro types.
static void drawbar(float y, float z, float r, float g, float b) {
	// Top poly (black to white)
	plx_vert_fnp(PLX_VERT, 0.0f, y, z, 1.0f, r, g, b);
	plx_vert_inp(PLX_VERT, 0.0f, y-20.0f, z, 0xff000000);
	plx_vert_fnp(PLX_VERT, 640.0f, y, z, 1.0f, r, g, b);
	plx_vert_inp(PLX_VERT_EOS, 640.0f, y-20, z, 0xff000000);

	// Bottom poly (white to black)
	plx_vert_inp(PLX_VERT, 0.0f, y+20.0f, z, 0xff000000);
	plx_vert_fnp(PLX_VERT, 0.0f, y, z, 1.0f, r, g, b);
	plx_vert_inp(PLX_VERT, 640.0f, y+20.0f, z, 0xff000000);
	plx_vert_fnp(PLX_VERT_EOS, 640.0f, y, z, 1.0f, r, g, b);
}

static float colors[3*10] = {
	0.0f, 0.5f, 1.0f,
	0.0f, 1.0f, 0.0f,
	1.0f, 0.0f, 0.0f,
	0.0f, 0.0f, 1.0f,
	0.5f, 0.5f, 0.0f,
	0.5f, 0.0f, 0.5f,
	0.5f, 0.5f, 0.5f,
	0.73f, 0.8f, 0.25f,
	0.25f, 0.8f, 0.73f,
	1.0f, 1.0f, 0.0f
};

CopperBars::CopperBars() {
	m_theta = 0;
	m_dt = 2*M_PI/160.0f;
}

CopperBars::~CopperBars() {
}

void CopperBars::draw(int list) {
	if (list != PLX_LIST_OP_POLY)
		return;

	plx_cxt_texture(NULL);
	plx_cxt_culling(PLX_CULL_NONE);
	plx_cxt_send(list);

	// Draw a sinus bar at our current position and several positions
	// back. Each bar will get its own Z value (descending).
	Vector pos = getPosition();
	Color col = getColor();
	for (int i=0; i<10; i++) {
		drawbar(240.0f + fsin(m_theta - m_dt*i*6) * 120.0f, pos.z - i,
			colors[i*3+0]*col.r, colors[i*3+1]*col.g, colors[i*3+2]*col.b);
	}
}

void CopperBars::nextFrame() {
	// Move our counters
	m_theta += m_dt;

	Drawable::nextFrame();
}


