/*
   Reverie
   main.cpp
   Copyright (C)2003 Dan Potter
*/

#include "global.h"

static pvr_init_params_t params = {
	/* Enable opaque and translucent polygons with size 32 */
	{ PVR_BINSIZE_32, PVR_BINSIZE_0, PVR_BINSIZE_32, PVR_BINSIZE_0, PVR_BINSIZE_0 },

	/* Vertex buffer size 1024K */
	1024*1024
};

extern uint8 romdisk[];
KOS_INIT_ROMDISK(romdisk);

bool gfxInit() {
	/* Initialize PVR */
	if (pvr_init(&params) < 0)
		return false;

	/* Initialize the Parallax as well */
	plx_cxt_init();
	plx_mat3d_init();
	plx_mat3d_mode(PLX_MAT_PROJECTION);
	plx_mat3d_identity();
	plx_mat3d_perspective(45.0f, 640.0f / 480.0f, 0.1f, 100.0f);
	plx_mat3d_mode(PLX_MAT_MODELVIEW);

	return true;
}

void gfxShutdown() {
	pvr_stats_t	stats;

	pvr_get_stats(&stats);
	dbglog(DBG_DEBUG, "3D Stats: %ld vblanks, frame rate ~%f fps, max vertex used %lu bytes\n",
		stats.vbl_count, (double)stats.frame_rate, stats.vtx_buffer_used_max);
}

void doDemo();

int main(int argc, char **argv) {
	arch_set_exit_path(ARCH_EXIT_MENU);

	if (!gfxInit())
		return -1;

	fs_chdir("/rd");
	doDemo();

	gfxShutdown();

	return 0;
}

