#ifndef _MODE_13H_
#define _MODE_13H_

#define VGA 0xA0000

extern "C" {

	// mode change procs
	void SetMode13();
	void SetTextMode();
	
	// drawing procs
	void ClearScreen(int color, unsigned int where);
        #pragma aux ClearScreen parm [eax] [edi];

	void PutPixel(int x, int y, int color, unsigned int where);
        #pragma aux PutPixel parm [ebx] [eax] [edx] [edi]

	int GetPixel(int x, int y, unsigned int where);
        #pragma aux GetPixel parm [ebx] [eax] [edi]

	void HLine(int x1, int x2, int y, int color, unsigned int where);
        #pragma aux HLine parm [ebx] [ecx] [edi] [eax] [esi]
	
	// palette procs
	void SetPal(int color, int red, int green, int blue);
        #pragma aux SetPal parm [eax] [ebx] [ecx] [edi]
	
	// virtual screen procs
	void CopyScreen(int source, int dest);
        #pragma aux CopyScreen parm [esi] [edi]

	// other procs
	void VRetrace();
}

typedef unsigned char TColor[3];
typedef TColor TPalette[256];

typedef char *PTVirtual;

	void Line(int x1, int y1, int x2, int y2, int color, unsigned int where);

	void GetPal(int color, unsigned char *r, unsigned char *g, unsigned char *b);
	void GetPalette(TPalette pal);
	void SetPalette(TPalette pal);

	void RotatePalette(TPalette pal, int first, int last);
	void FadeOut(TPalette pal, int first, int last);
	void FadeTo(TPalette pal, TPalette dest, int first, int last);

	PTVirtual SetupVirtual(PTVirtual *Vscr, unsigned int *Voff);
	void ShutDownVirtual(PTVirtual *Vscr);

	void LoadPCX(char *fn, unsigned int where, int dimX, int dimY,
                 int offX,int offY, TPalette pal);


#endif
