//      bitmaps.cpp     -- Implementacin de la clase TBitmap para 32 bpp

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include "bitmaps.h"

unsigned _RGB(byte r, byte g, byte b);
#pragma aux _RGB =	\
"xor ah, ah"	\
"shl eax, 16"	\
"mov ax, bx"	\
parm [al] [bh] [bl]	\
modify [eax]	\
value [eax];

unsigned RGB(byte r, byte g, byte b) { return _RGB(r, g, b); }

// constructores y destructor
TBitmap::TBitmap(int w, int h) {
     datos = (unsigned *)malloc(w * h * 4);
     if (datos) {
        ancho = w;
        alto = h;
        tablay = (int *)malloc(h * sizeof(int));
        for (int y = 0; y < h; y++) tablay[y] = ancho * y;
     }
     else {
          ancho = 0;
          alto = 0;
          tablay = NULL;
     }
}


TBitmap::TBitmap(TBitmap *clon) {
     datos = (unsigned *)malloc(clon->ancho * clon->alto * 4);
     if (datos) {
        ancho = clon->ancho;
        alto = clon->alto;
        tablay = (int *)malloc(alto * sizeof(int));
        memcpy(datos, clon->datos, ancho * alto * 4);
        memcpy(tablay, clon->tablay, alto * sizeof(int));
     }
     else {
          ancho = 0;
          alto = 0;
          tablay = NULL;
     }
}


TBitmap::TBitmap(char *f) {
	char extension[4];
	int l = strlen(f) - 3;
	for (int i = 0; i < 4; i++) extension[i] = f[l + i];
	if (!strcmp(extension, "pcx")) { LoadPCX(f); return; }
//	if (!strcmp(extension, "tga")) { LoadTGA(f); return; }
	ancho = alto = 0;
	tablay = NULL;
}

// Destructor
TBitmap::~TBitmap() {
     if (datos) free(datos);
     if (tablay) free(tablay);
}


// Mtodos
void TBitmap::PutPixel(int x, int y, unsigned color) {
     if ((x < 0) || (x >= ancho) || (y < 0) || (y >= alto)) return;
     *(datos + tablay[y] + x) = color;
}

void TBitmap::PutPixel(int x, int y, byte red, byte green, byte blue) {
     if ((x < 0) || (x >= ancho) || (y < 0) || (y >= alto)) return;
     *(datos + tablay[y] + x) = _RGB(red, green, blue);
}

unsigned TBitmap::GetPixel(int x, int y) {
     if ((x < 0) || (x >= ancho) || (y < 0) || (y >= alto)) return -1;
     return *(datos + tablay[y] + x);
}

void TBitmap::Borra(unsigned color) {
	unsigned offs = (unsigned)datos;
	unsigned size = ancho * alto;
	_asm {
		mov eax, [color]
		mov ecx, [size]
		mov edi, [offs]
		rep stosd
	}
}


void TBitmap::Copia(TBitmap *fuente) {
     if ((ancho != fuente->ancho) || (alto != fuente->alto)) return;
     unsigned size = ancho * alto;
     unsigned *src = fuente->datos;
     unsigned *dst = datos;
     _asm {
        mov ecx, [size]
        mov esi, [src]
        mov edi, [dst]
        rep movsd
     }
}



void TBitmap::Blur() {
	unsigned bpsl = ancho * 4;
	unsigned size = ancho * (alto - 2);
	unsigned offs = (unsigned)datos;
	_asm {
		mov edi, [offs]
		mov edx, [bpsl]
		mov ecx, [size]
		add edi, edx
		xor eax, eax
		mov esi, edx
		xor ebx, ebx
		neg esi
		blah:   mov al, [edi + esi]
				mov bl, [edi + edx]
				add eax, ebx
				mov bl, [edi - 4]
				add eax, ebx
				mov bl, [edi + 4]
				add eax, ebx
				shr eax, 2
//				mov [edi], al
//				inc edi
				stosb
				
				mov al, [edi + esi]
				mov bl, [edi + edx]
				add eax, ebx
				mov bl, [edi - 4]
				add eax, ebx
				mov bl, [edi + 4]
				add eax, ebx
				shr eax, 2
//				mov [edi], al
//				inc edi
				stosb
				
				mov al, [edi + esi]
				mov bl, [edi + edx]
				add eax, ebx
				mov bl, [edi - 4]
				add eax, ebx
				mov bl, [edi + 4]
				add eax, ebx
				shr eax, 2
//				mov [edi], al
//				add edi, 2
				stosb
				inc edi
				dec ecx
				
				jnz blah
	}
}


// Cargadores de PCX y TGA

// cargador de PCX de 8 bpp (conversin a 16 bpp)
void TBitmap::LoadPCX(char *f) {
     PCXHeader pcx;
     FILE *file;
     byte paleta[256][3];
     byte *temp;

     if (datos) free(datos);
     if (tablay) free(tablay);

     if ((file = fopen(f, "rb")) == NULL) {
        ancho = alto = 0; datos = NULL; tablay = NULL; return;
     }

     // Lectura del encabezado del archivo PCX
     if (!fread(&pcx, 128, 1, file)) {
        ancho = alto = 0; datos = NULL; tablay = NULL; return;
     }

     // Comprobar validez del archivo
     if ((pcx.ID != 10) || (pcx.Compression != 1) || (pcx.BPP != 8)) {
        ancho = alto = 0; datos = NULL; tablay = NULL; return;
     }

     // Reservar memoria e inicializar los miembros del objeto
     ancho = pcx.XMax - pcx.XMin + 1;
     alto = pcx.YMax - pcx.YMin + 1;
     temp = (byte *)malloc(ancho * alto);
     if (!temp) { ancho = alto = 0; tablay = NULL; return; }
     datos = (unsigned *)malloc(ancho * alto * 4);
     if (!datos) { ancho = alto = 0; tablay = NULL; return; }
     tablay = (int *)malloc(alto * sizeof(int));
     for (int i = 0; i < alto; i++) tablay[i] = i * ancho;

     // Leer la imagen
     unsigned long pos = 0, total = ancho * alto;
     byte a, b;
     while (pos < total) {
           a = fgetc(file);
           if ((a & 0xC0) == 0xC0) {
              b = fgetc(file);
              a &= 0x3F;
              for (i = 0; i < a; i++) temp[pos++] = b;
           }
           else temp[pos++] = a;
     }

     // Leer la paleta
     fseek(file, -768, SEEK_END);
     fread(paleta, 768, 1, file);
     fclose(file);

     // convertir a 15 bpp
     for (i = 0; i < total; i++)
         datos[i] = _RGB(paleta[temp[i]][0], paleta[temp[i]][1], paleta[temp[i]][2]);

     free(temp);
}


// Implementacin de TBitmap8bpp
TBitmap8bpp::TBitmap8bpp(int w, int h) {
     datos = (byte *)malloc(w * h);
     if (datos) {
        ancho = w;
        alto = h;
        tablay = (int *)malloc(h * sizeof(int));
        for (int y = 0; y < h; y++) tablay[y] = ancho * y;
        memset(paleta, 0, 256 * sizeof(unsigned));
     }
     else {
          ancho = 0;
          alto = 0;
          tablay = NULL;
     }
}


TBitmap8bpp::TBitmap8bpp(char *f) {
	LoadPCX(f);
}


TBitmap8bpp::TBitmap8bpp(int w, int h, unsigned char *data, unsigned *palette) {
     ancho = w;
     alto = h;
     datos = (byte *)data;
     memcpy(paleta, palette, 256 * sizeof(unsigned));
     tablay = (int *)malloc(h * sizeof(int));
     for (int y = 0; y < h; y++) tablay[y] = ancho * y;
}

TBitmap8bpp::~TBitmap8bpp() {
//     if (datos) free(datos);  // bitmaps are now stored with the exe
     if (tablay) free(tablay);
}

void TBitmap8bpp::PutPixel(int x, int y, byte color) {
     if ((x < 0) || (x >= ancho) || (y < 0) || (y >= alto)) return;
     *(datos + tablay[y] + x) = color;
}

byte TBitmap8bpp::GetPixel(int x, int y) {
     if ((x < 0) || (x >= ancho) || (y < 0) || (y >= alto)) return -1;
     return *(datos + tablay[y] + x);
}

void TBitmap8bpp::Borra(byte color) {
	if (datos) memset(datos, color, ancho * alto);
}

void TBitmap8bpp::BlitTo(TBitmap *dest, int x0, int y0) {
	int xa = 0, ya = 0, width = ancho, height = alto, i;
	if ((x0 >= dest->ancho) || (y0 >= dest->ancho)) return;
	if ((x0 + width) > dest->ancho) width = dest->ancho - x0;
	if ((y0 + height) > dest->alto) height = dest->alto - y0;
	if (x0 < 0) { xa = -x0; width += x0; x0 = 0; }
	if (y0 < 0) { ya = -y0; height += y0; y0 = 0; }
	byte *src;
	unsigned *dst;
	while ((height--) > 0) {
		src = datos + tablay[ya++] + xa;
		dst = dest->datos + dest->tablay[y0++] + x0;
		for (i = 0; i < width; i++) *dst++ = paleta[*src++];
	}
}

void TBitmap8bpp::TransBlitTo(TBitmap *dest, int x0, int y0, byte tcolor) {
	int xa = 0, ya = 0, width = ancho, height = alto, i;
	if ((x0 >= dest->ancho) || (y0 >= dest->ancho)) return;
	if ((x0 + width) > dest->ancho) width = dest->ancho - x0;
	if ((y0 + height) > dest->alto) height = dest->alto - y0;
	if (x0 < 0) { xa = -x0; width += x0; x0 = 0; }
	if (y0 < 0) { ya = -y0; height += y0; y0 = 0; }
	byte *src;
	unsigned *dst;
	while ((height--) > 0) {
		src = datos + tablay[ya++] + xa;
		dst = dest->datos + dest->tablay[y0++] + x0;
                for (i = 0; i < width; i++) {
                        if (*src != tcolor) *dst = paleta[*src];
                        dst++; src++;
                }
	}
}

void TBitmap8bpp::BlitTo8bpp(TBitmap8bpp *dest, int x0, int y0) {
	int xa = 0, ya = 0, width = ancho, height = alto, i;
	if ((x0 >= dest->ancho) || (y0 >= dest->ancho)) return;
	if ((x0 + width) > dest->ancho) width = dest->ancho - x0;
	if ((y0 + height) > dest->alto) height = dest->alto - y0;
	if (x0 < 0) { xa = -x0; width += x0; x0 = 0; }
	if (y0 < 0) { ya = -y0; height += y0; y0 = 0; }
	byte *src;
	byte *dst;
	while ((height--) > 0) {
		src = datos + tablay[ya++] + xa;
		dst = dest->datos + dest->tablay[y0++] + x0;
		for (i = 0; i < width; i++) *dst++ = paleta[*src++];
	}
}

void TBitmap8bpp::LoadPCX(char *f) {
     PCXHeader pcx;
     FILE *file;
     byte pal[256][3];

     if (datos) free(datos);
     if (tablay) free(tablay);

     if ((file = fopen(f, "rb")) == NULL) {
        ancho = alto = 0; datos = NULL; tablay = NULL; return;
     }

     // Lectura del encabezado del archivo PCX
     if (!fread(&pcx, 128, 1, file)) {
        ancho = alto = 0; datos = NULL; tablay = NULL; fclose(file); return;
     }

     // Comprobar validez del archivo
     if ((pcx.ID != 10) || (pcx.Compression != 1) || (pcx.BPP != 8)) {
        ancho = alto = 0; datos = NULL; tablay = NULL; fclose(file); return;
     }

     // Reservar memoria e inicializar los miembros del objeto
     ancho = pcx.XMax - pcx.XMin + 1;
     alto = pcx.YMax - pcx.YMin + 1;
     datos = (byte *)malloc(ancho * alto);
     if (!datos) { ancho = alto = 0; tablay = NULL; fclose(file); return; }
     tablay = (int *)malloc(alto * sizeof(int));
     for (int i = 0; i < alto; i++) tablay[i] = i * ancho;

     // Leer la imagen
     unsigned long pos = 0, total = ancho * alto;
     byte a, b;
     while (pos < total) {
           a = fgetc(file);
           if ((a & 0xC0) == 0xC0) {
              b = fgetc(file);
              a &= 0x3F;
              for (i = 0; i < a; i++) datos[pos++] = b;
           }
           else datos[pos++] = a;
     }

     // Leer la paleta
     fseek(file, -768, SEEK_END);
     fread(pal, 768, 1, file);
     fclose(file);

     for (i = 0; i < 256; i++)
         paleta[i] = _RGB(pal[i][0], pal[i][1], pal[i][2]);

}


void TBitmap8bpp::Blur() {
	unsigned off = ancho + (unsigned)datos;
	unsigned size = ancho * (alto - 2);
	unsigned bpsl = ancho;
	_asm {
		mov edx, [bpsl]
		mov edi, [off]
		mov esi, [bpsl]
		mov ecx, [size]
		neg edx
		xor eax, eax
		xor ebx, ebx
		bla:	mov al, [edi + edx]
				mov bl, [edi + esi]
				add eax, ebx
				mov bl, [edi - 1]
				add eax, ebx
				mov bl, [edi + 1]
				add eax, ebx
				shr eax, 2
				mov [edi], al
				inc edi
				dec ecx
				jnz bla
	}
}

