//      greets.cpp

#include <conio.h>
#include <math.h>
#include "mode13.h"
#include "obj3d.h"
#include "triangle.h"
#include "phongpal.h"
#include "vectors.h"
#include "lightsrc.h"
#include "stuff.h"
#include "greets.h"

#include "sphere2.h"
#include "spherei.h"
#include "tex1.h"

#include "greet1.h"
#include "greet2.h"
#include "greet3.h"
#include "greet4.h"
#include "greet5.h"
#include "greet6.h"
#include "greet7.h"
#include "greet8.h"
#include "greet9.h"
#include "greet10.h"
#include "greet11.h"
#include "greet12.h"
#include "greet13.h"
#include "greet14.h"
#include "greet15.h"
#include "greet16.h"


double g_transtable[256][3], g_invtranstable[256][3];
unsigned char g_tindex;

int g_rottable[256][3];
int g_boffset[256];


void GREETS_Setup() {
	double ang;
        unsigned int x, y;
	for (int i = 0; i < 256; i++) {
                ang = i * Pi / 128.0;
                g_transtable[i][0] = 1 + cos(ang) * 0.2;
                g_transtable[i][1] = 1 + sin(ang) * 0.3;
                g_transtable[i][2] = 1 - cos(ang * 2) * 0.5;
                g_invtranstable[i][0] = 1.0 / g_transtable[i][0];
                g_invtranstable[i][1] = 1.0 / g_transtable[i][1];
                g_invtranstable[i][2] = 1.0 / g_transtable[i][2];
                g_rottable[i][0] = sin(ang) * 3.0 + 1.0;
                g_rottable[i][1] = cos(ang) * 3.0 + 2.0;
                g_rottable[i][2] = -cos(ang / 2.0) * 3.0 - 2.0;
                x = 20.0 - cos(ang * 2) * 20.0;
                y = 119.0 + sin(ang * 4) * 20.0;
                g_boffset[i] = y * 320 + x;
	}
}


void g_Transform(TObject3D *o) {
        unsigned char t = g_tindex;
	for (int i = 0; i < o->NumVertex; i++) {
                o->Vertex[i]->x *= g_transtable[t][0];
                o->Vertex[i]->y *= g_transtable[t][1];
                o->Vertex[i]->z *= g_transtable[t][2];
		o->Vertex[i]->FakeNormal();
		t--;
	}
}

void g_UnTransform(TObject3D *o) {
        unsigned char t = g_tindex;
	for (int i = 0; i < o->NumVertex; i++) {
                o->Vertex[i]->x *= g_invtranstable[t][0];
                o->Vertex[i]->y *= g_invtranstable[t][1];
                o->Vertex[i]->z *= g_invtranstable[t][2];
		t--;
	}
}


void g_DrawGreet(unsigned int source, unsigned int where);
#pragma aux g_DrawGreet =        \
"mov edx, 60"   \
"yloop: mov ecx, 160"   \
"xloop: mov al, [esi]"  \
"       inc esi"        \
"       add al, [edi]"  \
"       jnc cont"       \
"       mov al, 0FFh"   \
"cont:  mov [edi], al"  \
"       inc edi"        \
"       dec ecx"        \
"       jnz xloop"      \
"       add edi, 160"   \
"       dec edx"        \
"       jnz yloop"      \
parm [esi] [edi]        \
modify [eax ebx ecx edx];


void GREETS_Run() {
		TObject3D *obj = new TObject3D();
		TObject3D *sphere = new TObject3D();
		PTVirtual vscr;
		unsigned int voff;
		TPalette pal;

                unsigned int Greet[16] = { (unsigned int)GREET1,
                                           (unsigned int)GREET2,
                                           (unsigned int)GREET3,
                                           (unsigned int)GREET4,
                                           (unsigned int)GREET5,
                                           (unsigned int)GREET6,
                                           (unsigned int)GREET7,
                                           (unsigned int)GREET8,
                                           (unsigned int)GREET9,
                                           (unsigned int)GREET10,
                                           (unsigned int)GREET11,
                                           (unsigned int)GREET12,
                                           (unsigned int)GREET13,
                                           (unsigned int)GREET14,
                                           (unsigned int)GREET15,
                                           (unsigned int)GREET16 };
		
        SetupVirtual(&vscr, &voff);
        Read3DObject(SPHERE2_VKX, obj);
        obj->Scale(1.8, 1.8, 1.8);
        obj->SetCenter(160, 100);
        Read3DObject(SPHEREI_VKX, sphere);
        sphere->Scale(3.6, 3.6, 3.6);
        sphere->SetCenter(160, 100);
        sphere->MapEnviroment();
        TextureOffset = (unsigned int)TEX1;
        StartCol = 127;
        WidthCol = 63;
        SetLightPosition(0, 0, 1);
        g_tindex = 0;
        int counter = 0;
        int GreetIdx = 0;
        double ambient = 128.0;
        double s;
        GetMusicInfo();
        while (position < 12) GetMusicInfo();
        rowflag = 0;
        while (position < 14) {
                if (rowflag) if ((row & 7) == 0) {
                        ambient = 128.0;
                        GreetIdx++;
                }
                Fast256PhongPal(ambient, 80, 250, ambient, 10, 250,
                                ambient, 100, 250, pal);
                GlobalStyle = c_texturemapped;
                sphere->Draw(voff);
                g_Transform(obj);
        	GlobalStyle = ca_wireframe;
                StartCol = 32;
        	obj->Draw(voff);
        	GlobalStyle = c_particles;
                StartCol = 127;
        	obj->DrawParticles(voff);
                g_DrawGreet(Greet[GreetIdx], voff + g_boffset[counter & 0xFF]);
        	Blur(voff);
        	VRetrace();
        	CopyScreen(voff, VGA);
        	SetPalette(pal);
                g_UnTransform(obj);
                g_tindex += 4;
        	obj->Rotate(-1, 1, -1);
        	Light.Rotate(1, -2, 0);
                sphere->Rotate( g_rottable[counter & 0xFF][0],
                                g_rottable[counter & 0xFF][1],
                                g_rottable[counter & 0xFF][2]);
        	if (ambient > 0.0) ambient -= 8.0;
                s = 1 - CosT[(counter++ << 1) % 360] * 0.02;
        	obj->Scale(s, s, s);
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
        }
        delete obj;    
        delete sphere;
        ShutDownVirtual(&vscr);
}

