//      intro.cpp

#include <conio.h>
#include <math.h>
#include <time.h>
#include <stdlib.h>
#include <malloc.h>
#include "mode13.h"
#include "obj3d.h"
#include "triangle.h"
#include "phongpal.h"
#include "vectors.h"
#include "stuff.h"
#include "intro.h"

#include "torus.h"
#include "mono.h"

#include "tex4.h"
#include "paper.h"
#include "banner7.h"
#include "initial.h"


double i_transtable[256][3], i_invtranstable[256][3];
int i_tunpos[360][2];
unsigned char i_tindex;
int i_rippletable[256];


void INTRO_Setup() {
	double ang;
	int x, y;
	for (int i = 0; i < 256; i++) {
		ang = i * 3.14159265 / 128.0;
                i_transtable[i][0] = 1 + cos(ang) * 0.2;
                i_transtable[i][1] = 1 + sin(ang) * 0.2;
                i_transtable[i][2] = 1 - cos(ang * 2) * 0.4;
                i_invtranstable[i][0] = 1.0 / i_transtable[i][0];
                i_invtranstable[i][1] = 1.0 / i_transtable[i][1];
                i_invtranstable[i][2] = 1.0 / i_transtable[i][2];
	}
	for (i = 0; i < 360; i++) {
		ang = i * Pi / 180.0;
                i_tunpos[i][0] = 160 + cos(ang) * 250;
                i_tunpos[i][1] = 100 + sin(ang) * 250;
	}
	srand(clock());
        for (i = 0; i < 256; i++) {
		x = 320 * rand() / RAND_MAX;
		y = 200 * rand() / RAND_MAX;
		i_rippletable[i] = x + y * 320;
	}
}



void DoWater( short *water, unsigned char *source,
              unsigned char *where, int page) {
	int p1 = page * 128000;
	int p2 = (page ^ 1) * 128000;
	_asm {
		mov edi, [water]
		add edi, 642
		mov esi, edi
		add edi, [p1]
		add esi, [p2]
		mov ecx, 63358
		waterloop: mov ax, [edi - 640]
				   add ax, [edi + 640]
				   add ax, [edi - 638]
				   add ax, [edi + 638]
				   add ax, [edi - 642]
				   add ax, [edi + 642]
				   add ax, [edi - 2]
				   add ax, [edi + 2]
				   sar ax, 2
				   sub ax, [esi]
				   mov bx, ax
				   sar bx, 4
				   sub ax, bx
				   mov [esi], ax
				   add edi, 2
				   add esi, 2
				   dec ecx
				   jnz waterloop
				   
		mov esi, [p2]
		mov edi, [where]
		add esi, [water]
		add edi, 321
		add esi, 642
		mov edx, 198
		xor eax, eax
		loopy:  mov ecx, 318
		loopx:  mov ax, [esi]
				sub ax, [esi + 640]
				sar ax, 5
                                add ax, 319
                                sub ax, cx
				movzx ebx, ax
				mov ax, [esi]
				sub ax, [esi + 2]
				sar ax, 5
                                add ax, 199
                                sub ax, dx
				add ebx, [source]
				push ax
				shl ax, 6
				add ebx, eax
				pop ax
				shl ax, 8
				add ebx, eax
				mov al, [ebx]
				add esi, 2
				mov [edi], al
				inc edi
				dec ecx
				jnz loopx
				add esi, 4
				add edi, 2
				dec edx
				jnz loopy
	}
}



void i_Transform(TObject3D *o) {
        unsigned char t = i_tindex;
	for (int i = 0; i < o->NumVertex; i++) {
                o->Vertex[i]->x *= i_transtable[t][0];
                o->Vertex[i]->y *= i_transtable[t][1];
		t -= 2;
	}
}


void i_UnTransform(TObject3D *o) {
        unsigned char t = i_tindex;
	for (int i = 0; i < o->NumVertex; i++) {
                o->Vertex[i]->x *= i_invtranstable[t][0];
                o->Vertex[i]->y *= i_invtranstable[t][1];
		t -= 2;
	}
}


void i_DrawBanner(unsigned int banner, unsigned int where);
#pragma aux i_DrawBanner = \
"add edi, 19978"	\
"mov edx, 138"	\
"loopy: mov ecx, 182"	\
"loopx: mov al, [esi]"	\
"	inc esi"	\
"	or al, al"	\
"	jz skip"	\
"	mov [edi], al"	\
"skip:  inc edi"	\
"	dec ecx"	\
"	jnz loopx"	\
"	add edi, 138"	\
"	dec edx"	\
"	jnz loopy"	\
parm [esi] [edi]	\
modify [eax ecx edx];


void INTRO_Run() {
		TObject3D *obj = new TObject3D();
		TObject3D *tun = new TObject3D();
		PTVirtual vscr;
                unsigned int voff, toff;
                TPalette pal, temp;
                short *Water;


	Water = (short *)malloc(128000 * sizeof(short));
	SetupVirtual(&vscr, &voff);
        Read3DObject(MONO_VKX, obj);
        obj->Scale(0.6, 0.6, 0.6);
        obj->SetCenter(160, 100);
        obj->Traslate(0, 0, 100);
        for (int i = 0; i < obj->NumVertex; i++) obj->Vertex[i]->FakeNormal();
        obj->MapEnviroment();
        obj->Traslate(0, 0, -100);
        Read3DObject(TUNNEL_VKX, tun);
        tun->Rotate(90, 0, 0);
        tun->Scale(7.2, 7.2, 7.2);
        GlobalStyle = c_texturemapped;
        toff = (unsigned int)Water;
	_asm {
                mov edi, [toff]
		mov ecx, 64000
		xor eax, eax
		rep stosd
	}


        ClearPalette(temp);
        CopyPalette(INITIAL_PAL, pal, 0, 239);
        for (i = 0; i < 16; i++) 
        	pal[i + 240][0] = pal[i + 240][1] = pal[i + 240][2] = i * 4;
	CopyScreen((unsigned int)INITIAL, voff);
        VRetrace();
        SetPalette(temp);
	CopyScreen((unsigned int)INITIAL, VGA);
        GetMusicInfo();
        while (position < 1) {
                if (rowflag) {
                        FadePaletteTo(temp, pal, 0, 255);
                        VRetrace();
                        SetPalette(temp);
                }
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
        }
        VRetrace();
        SetPalette(pal);
        CopyPalette(pal, temp, 0, 255);

	int count = 0;
        unsigned char rp = 0;
        TextureOffset = (unsigned int)PAPER;
        i = 800;
        while (position < 2) {
                CopyScreen((unsigned int)INITIAL, voff);
                if (rowflag) Water[i_rippletable[rp++]] = 10000;
                DoWater(Water, (unsigned char *)INITIAL, (unsigned char *)voff, count);
                if (row >= 32) {
                        obj->Traslate(0, 0, i);
                        obj->Draw(voff);
                        obj->Traslate(0, 0, -i);
                        if (i > 0) i -= 20;
                        obj->Rotate(0, 0, 3);
                }
                VRetrace();
                SetPalette(temp);
		CopyScreen(voff, VGA);
		count ^= 1;
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
                if (rowflag && (row >= 32)) {
                        FadePalette(temp, 0, 239);
                        FadePalette(temp, 0, 239);
                }
	}

        CopyPalette(TEX4_PAL, pal, 0, 63);
        CopyPalette(BANNER7_PAL, pal, 64, 239);
        CopyPalette(pal, temp, 64, 255);
        toff = (unsigned int)temp;
        _asm {
                mov edi, [toff]
                mov ecx, 48
                xor eax, eax
                rep stosd
        }
        i_tindex = 0;
        int a = 0;
        GetMusicInfo();
        while (position < 3) {
                ClearScreen(0, voff);
                tun->SetCenter(i_tunpos[a][0], i_tunpos[a][1]);
        	tun->Rotate(0, 0, -a);
                TextureOffset = (unsigned int)TEX4;
        	tun->Draw(voff);
        	tun->Rotate(0, 0, a);
                TextureOffset = (unsigned int)PAPER;
                obj->Traslate(0, 0, 200 * SinT[(a << 1) % 360]);
                i_Transform(obj);
        	obj->Draw(voff);
                if (row >= 28) i_DrawBanner((unsigned int)BANNER7, voff);
        	VRetrace();
                SetPalette(temp);
        	CopyScreen(voff, VGA);
                i_UnTransform(obj);
                obj->Traslate(0, 0, -200 * SinT[(a << 1) % 360]);
                i_tindex += 2;
        	obj->Rotate(1, 0, 3);
        	tun->Rotate(0, -1, 0);
        	a = (a + 1) % 360;
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
                FadePaletteTo(temp, TEX4_PAL, 0, 63);
        }

        ClearPalette(temp);
        CopyPalette(pal, temp, 64, 239);
        while (row < 62) {
        	ClearScreen(0, voff);
                tun->SetCenter(i_tunpos[a][0], i_tunpos[a][1]);
        	tun->Rotate(0, 0, -a);
                TextureOffset = (unsigned int)PAPER;
        	tun->Draw(voff);
        	tun->Rotate(0, 0, a);
                TextureOffset = (unsigned int)TEX4;
                obj->Traslate(0, 0, 200 * SinT[(a << 1) % 360]);
                i_Transform(obj);
        	obj->Draw(voff);
                if (row < 36) i_DrawBanner((unsigned int)BANNER7, voff);
        	VRetrace();
                SetPalette(temp);
        	CopyScreen(voff, VGA);
                i_UnTransform(obj);
                obj->Traslate(0, 0, -200 * SinT[(a << 1) % 360]);
                i_tindex += 2;
        	obj->Rotate(1, 0, 3);
        	tun->Rotate(0, -1, 0);
        	a = (a + 1) % 360;
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
                FadePaletteTo(temp, pal, 0, 255);
        }

//        free(Water);
        delete obj;    
        delete tun;
        ShutDownVirtual(&vscr);
}

