//      title.cpp

#include <conio.h>
#include <math.h>
#include <malloc.h>
#include "mode13.h"
#include "obj3d.h"
#include "triangle.h"
#include "phongpal.h"
#include "vectors.h"
#include "lightsrc.h"
#include "cuadro.h"
#include "stuff.h"
#include "title.h"

#include "sphere2.h"

#include "logo1.h"
#include "banner1.h"


double t_transtable[256][3], t_invtranstable[256][3];
double t_scaletable[256][2];
double  t_paramtable[256 * 6];
double *t_parameter;
char t_paramidx = 0;
unsigned char t_tindex;


void TITLE_Setup() {
	double ang;
	for (int i = 0; i < 256; i++) {
		ang = i * 3.14159265 / 128.0;
                t_transtable[i][0] = 1 + cos(ang) * 0.2;
                t_transtable[i][1] = 1 + sin(ang) * 0.3;
                t_transtable[i][2] = 1 - cos(ang * 2) * 0.4;
                t_invtranstable[i][0] = 1.0 / t_transtable[i][0];
                t_invtranstable[i][1] = 1.0 / t_transtable[i][1];
                t_invtranstable[i][2] = 1.0 / t_transtable[i][2];
                t_scaletable[i][0] = 1 + sin(ang) * 0.01;
                t_scaletable[i][1] = 1 - sin(ang * 2) * 0.02;
	}
	for (i = 0; i < 64; i++) {
                t_paramtable[i * 6 + 0] = i;
                t_paramtable[i * 6 + 1] = 120 + i * 2;
                t_paramtable[i * 6 + 2] = 0;
                t_paramtable[i * 6 + 3] = 120;
                t_paramtable[i * 6 + 4] = 64 - i;
                t_paramtable[i * 6 + 5] = 248 - i * 2;
	}
	for (i = 0; i < 64; i++) {
                t_paramtable[(64 + i) * 6 + 0] = 64 - i;
                t_paramtable[(64 + i) * 6 + 1] = 248 - i * 2;
                t_paramtable[(64 + i) * 6 + 2] = i;
                t_paramtable[(64 + i) * 6 + 3] = 120 + i * 2;
                t_paramtable[(64 + i) * 6 + 4] = 0;
                t_paramtable[(64 + i) * 6 + 5] = 120;
	}
	for (i = 0; i < 64; i++) {
                t_paramtable[(128 + i) * 6 + 0] = i;
                t_paramtable[(128 + i) * 6 + 1] = 120 + i * 2;
                t_paramtable[(128 + i) * 6 + 2] = 64;
                t_paramtable[(128 + i) * 6 + 3] = 248;
                t_paramtable[(128 + i) * 6 + 4] = 0;
                t_paramtable[(128 + i) * 6 + 5] = 120;
	}
	for (i = 0; i < 64; i++) {
                t_paramtable[(192 + i) * 6 + 0] = 64 - i;
                t_paramtable[(192 + i) * 6 + 1] = 248 - i * 2;
                t_paramtable[(192 + i) * 6 + 2] = 64 - i;
                t_paramtable[(192 + i) * 6 + 3] = 248 - i * 2;
                t_paramtable[(192 + i) * 6 + 4] = i;
                t_paramtable[(192 + i) * 6 + 5] = 120 + i * 2;
	}
}


void t_Transform(TObject3D *o) {
        unsigned char t = t_tindex;
	for (int i = 0; i < o->NumVertex; i++) {
                o->Vertex[i]->x *= t_transtable[t][0];
                o->Vertex[i]->y *= t_transtable[t][1];
                o->Vertex[i]->z *= t_transtable[t][2];
		o->Vertex[i]->FakeNormal();
		t--;
	}
}

void t_UnTransform(TObject3D *o) {
        unsigned char t = t_tindex;
	for (int i = 0; i < o->NumVertex; i++) {
                o->Vertex[i]->x *= t_invtranstable[t][0];
                o->Vertex[i]->y *= t_invtranstable[t][1];
                o->Vertex[i]->z *= t_invtranstable[t][2];
		t--;
	}
}


void TITLE_Run() {
		TObject3D *obj = new TObject3D();
		TObject3D *logo = new TObject3D();
		PTVirtual vscr;
		unsigned int voff;
		TPalette pal;
		
        SetupVirtual(&vscr, &voff);
        Read3DObject(SPHERE2_VKX, obj);
        obj->Scale(3.5, 3.5, 3.5);
        obj->SetCenter(160, 100);
        GeneraCuadro(2, 100, logo);
        logo->Scale(3.0, 2.0, 1.0);
        logo->Scale(1.5, 1.5, 1.0);
        logo->SetCenter(160, 100);
        TextureOffset = (unsigned int)LOGO1;
        StartCol = 0;
        WidthCol = 100;
        SetLightPosition(1, 1, 1);
        t_tindex = 0;
        
        t_parameter = t_paramtable;
        t_paramidx = 0;
        double ambient = 256.0;

        GetMusicInfo();
               
        while (position < 5) {
                if (rowflag) {
                        if ((row & 7) == 0) ambient = 80.0;
                        if ((row == 0) || (row == 4)) ambient = 160;
                }
                if ((t_paramidx++) == 0) t_parameter = t_paramtable;
                Fast256PhongPal( ambient, *(t_parameter++), *(t_parameter++),
                                 ambient, *(t_parameter++), *(t_parameter++),
                                 ambient, *(t_parameter++), *(t_parameter++), pal);
                t_Transform(obj);
        	GlobalStyle = c_flatshaded;
        	obj->Draw(voff);
        	GlobalStyle = ca_texturemapped;
        	logo->Draw(voff);
        	Blur(voff);
                if ((row & 7) < 4)
                        DrawBanner((unsigned int)BANNER1, 200, 90, 119, 109, voff);
        	VRetrace();
        	CopyScreen(voff, VGA);
        	SetPalette(pal);
                t_UnTransform(obj);
                t_tindex += 2;
        	obj->Rotate(-1, 1, -1);
                logo->Scale(t_scaletable[t_tindex][0], t_scaletable[t_tindex][1], 1.0);
        	Light.Rotate(0, 0, 2);
        	if (ambient > 0.0) ambient -= 8.0;
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
        }

        while (row < 60) {
                if (rowflag) {
                        if ((row & 7) == 0) ambient = 80.0;
                        if ((row == 0) || (row == 4)) ambient = 160;
                }
                if ((t_paramidx++) == 0) t_parameter = t_paramtable;
                Fast256PhongPal( ambient, *(t_parameter++), *(t_parameter++),
                                 ambient, *(t_parameter++), *(t_parameter++),
                                 ambient, *(t_parameter++), *(t_parameter++), pal);
                t_Transform(obj);
        	GlobalStyle = c_flatshaded;
        	obj->Draw(voff);
        	GlobalStyle = ca_texturemapped;
        	logo->Draw(voff);
        	Blur(voff);
                if ((row & 7) < 4)
                        DrawBanner((unsigned int)BANNER1, 200, 90, 119, 109, voff);
        	VRetrace();
        	CopyScreen(voff, VGA);
        	SetPalette(pal);
                t_UnTransform(obj);
                t_tindex += 2;
        	obj->Rotate(-1, 1, -1);
                logo->Scale(t_scaletable[t_tindex][0], t_scaletable[t_tindex][1], 1.0);
        	Light.Rotate(0, 0, 2);
        	if (ambient > 0.0) ambient -= 8.0;
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
        }

        delete obj;
        delete logo;
        ShutDownVirtual(&vscr);
}

