
program Tetorial;

uses Mode13, XMS, FVektor2, Crt, Strings,
     Midas, MConfig, MFile, MPlayer, ModP, Errors;


{ Tipos y variables globales }
var VScr1, VScr2 : PTVirtual;
    VSeg1, VSeg2 : word;

    TempPal : TPalette;

    module : PmpModule;
    moduleInfo : PPmpInformation;
    MP : ^ModulePlayer;

    aux : word;
{ Parte 1: Introduccin (Plasma + Imgenes estticas) }
type PTIntroPic = ^TIntroPic;
     TIntroPic = array[0..119] of array[0..179] of byte;

var IntroPic : PTIntroPic;
    IntroPal1, IntroPal2 : TPalette;
    hPic1, hPic2 : XMSHandle;
    pos1, pos2, pos3, pos4 : byte;
    PlasmaTab1 : array[0..255] of byte;
    PlasmaTab2 : array[0..319] of byte;

{ Parte 2: Toro Rojo Deforme }
var Torus : PTSolid;
    TorusEnv : PTTexture;
    EnvPal1 : TPalette;
    hEnv1 : XMSHandle;

{ Parte 3: Saludos }
type TLight = record
              x, y : single;
              vx, vy : byte;
              end;

var Trans1 : array[-20..20] of array[-20..20] of boolean;
    Light : array[0..6] of TLight;
    VSin : array[0..255] of single;
    GreetPal : TPalette;
    hGreetPic : XMSHandle;

{ Parte 4: Interferencia + Luces }
var hNoise : array[0..3] of XMSHandle;

{ Parte 5: Fuego }
type PTFirePic = ^TFirePic;
     TFirePic = array[0..103] of array[0..319] of byte;

var FirePic : PTFirePic;
    FirePal : TPalette;
    hFirePic : XMSHandle;

{ Parte 6: RotaZoomIconos }
type PTIcon = ^TIcon;
     TIcon = array[0..31] of array[0..31] of byte;

     PTSprite = ^TSprite;
     TSprite = record
               ox, oy, oz : Fixed;
               icon : PTIcon;
               zoomin : boolean;
               v : array[0..3] of TVector;
               end;

var Icon : array[0..4] of PTIcon;
    Sprite : array[1..25] of PTSprite;
    hIcon : array[0..4] of XMSHandle;
    hIconBack : XMSHandle;
    IconPal : TPalette;

{ Parte 7: Toro deforme con textura y sombreado Phong + Imgenes estticas }
var hTexture : XMSHandle;
    TexturePal : TPalette;
    hLogo : array[0..1] of XMSHandle;
    LogoPal : array[0..1] of TPalette;

    hEndPic : array[0..3] of XMSHandle;
    EndPal : array[0..3] of TPalette;

{ Procedimientos globales }

procedure XMSError;
begin
     SetTextMode;
     writeln;
     writeln('Error en el manejo de XMS. Mejor reinicia tu mquina.');
     writeln;
     halt(1);
end;

procedure ConfigMidas;
var done : integer;
begin
    midasSetDefaults;
    done := midasConfig;
    if done = 1 then
    begin
         midasSaveConfig('sound.cfg');
         SetTextMode;
         writeln;
         WriteLn('Configuration saved. Press any key to continue...');
         readkey;
    end
    else
    begin
         WriteLn('Configuration couldn''t be saved.');
         halt(1);
    end;
end;

procedure InitMidas;
var error, isConfig : integer;
    asciiz : array[0..256] of char;
begin
     error := fileExists('sound.cfg', @isConfig);
     if error <> OK then MidasError(error);
     if isConfig <> 1 then ConfigMidas;
     error := fileExists('sound.cfg', @isConfig);
     if error <> OK then MidasError(error);
     MidasSetDefaults;
     MidasLoadConfig('sound.cfg');
     MidasInit;
     StrPCopy(asciiz, 'sum-ish2.mod');
     module := MidasLoadModule(asciiz, @mpMod, nil);
end;


procedure InitAll;
var x, y : integer;
    i : byte;
begin
     Randomize;
     if not XMSExist then
     begin
          writeln('This demo needs 1000 Kb of XMS and 500 Kb of EMS for sound');
          halt(1);
     end;
     if (XMSFree div 1024) < 1024 then
     begin
          writeln('Not enough XMS free. This demo needs ONE MEGABYTE of XMS!');
          halt(1);
     end;
     if (memavail div 1024) < 380 then
     begin
          writeln('Not enough memory. This demo needs 540 Kb of base memory,');
          writeln('one megabyte of XMS free and about 500 Kb of EMS for music.');
          halt(1);
     end;
     clrscr;
     writeln;
     writeln(' * Allocating memory...');
     { Globales }
     SetupVirtual(VScr1, VSeg1);
     SetupVirtual(VScr2, VSeg2);
     { Introduccin }
     if XMSAlloc(hPic1, 180 * 120) <> 0 then XMSError;
     if XMSAlloc(hPic2, 180 * 120) <> 0 then XMSError;
     { Toro Rojo }
     Torus := new(PTSolid, Init);
     Torus^.Load('torus1.vkx');
     if XMSAlloc(hEnv1, 65535) <> 0 then XMSError;
     { Saludos }
     if XMSAlloc(hGreetPic, 64000) <> 0 then XMSError;
     { Interferencia }
     for i := 0 to 3 do
     begin
          if XMSAlloc(hNoise[i], 64000) <> 0 then XMSError;
          for y := 0 to 199 do
              for x := 0 to 319 do
                  PutPixel(x, y, random(16) + 16, VSeg1);
          if base2xms(VScr1, hNoise[i], 64000) <> 0 then XMSError;
     end;
     { Fuego }
     if XMSAlloc(hFirePic, 104 * 320) <> 0 then XMSError;
     { Iconos }
     if XMSAlloc(hIconBack, 64000) <> 0 then XMSError;
     for i := 0 to 4 do
         if XMSAlloc(hIcon[i], 1024) <> 0 then XMSError;
     { Toro + wholelottabackgrounds }
     if XMSAlloc(hTexture, 65535) <> 0 then XMSError;
     for i := 0 to 1 do
         if XMSAlloc(hLogo[i], 64000) <> 0 then XMSError;
     for i := 0 to 3 do
         if XMSAlloc(hEndPic[i], 64000) <> 0 then XMSError;


     writeln(' * Loading intro pictures...');
     IntroPic := new(PTIntroPic);
     LoadPCX('tetorial.dat', VSeg1, 180, 120, 0, 0, IntroPal1, 0, 13240);
     for y := 0 to 119 do
         for x := 0 to 179 do IntroPic^[y][x] := GetPixel(x, y, VSeg1) + 128;
     if base2xms(IntroPic, hPic1, 180 * 120) <> 0 then XMSError;
     LoadPCX('tetorial.dat', VSeg1, 180, 120, 0, 0, IntroPal2, 13240, 25612);
     for y := 0 to 119 do
         for x := 0 to 179 do IntroPic^[y][x] := GetPixel(x, y, VSeg1) + 128;
     if base2xms(IntroPic, hPic2, 180 * 120) <> 0 then XMSError;
     dispose(IntroPic);

     writeln(' * Loading more pictures...');
     LoadPCX('tetorial.dat', VSeg1, 320, 200, 0, 0, GreetPal, 25612, 35887);
     if base2xms(VScr1, hGreetPic, 64000) <> 0 then XMSError;
     LoadPCX('tetorial.dat', VSeg1, 320, 104, 0, 0, FirePal, 35887, 51737);
     if base2xms(VScr1, hFirePic, 104 * 320) <> 0 then XMSError;
     TorusEnv := new(PTTexture);
     LoadTexture('tetorial.dat', TorusEnv, EnvPal1, 51737, 81218);
     for y := 0 to 254 do
         for x := 0 to 255 do TorusEnv^[y, x] := TorusEnv^[y, x] + 128;
     if base2xms(TorusEnv, hEnv1, 256 * 255) <> 0 then XMSError;
     LoadTexture('tetorial.dat', TorusEnv, TempPal, 81218, 85013);
     if base2xms(TorusEnv, hTexture, 256 * 255) <> 0 then XMSError;
     MakeTexturePal(0, 256, 0, 256, 0, 256, 1.2, 200, TexturePal, 128, 63,
                    TempPal, 2);
     Torus^.SetStyle(TextureMap);
     Torus^.SetColor(128, 63);
     Torus^.SetTexture(TorusEnv, 2);
     Torus^.MakePhongTable;
     dispose(TorusEnv);

     writeln(' * Damn, there''s a lot of pictures!!!');
     Icon[0] := new(PTIcon);
     for i := 0 to 4 do
     begin
     case i of
       0 : LoadPCX('tetorial.dat', VSeg1, 32, 32, 0, 0, IconPal, 85013, 86423);
       1 : LoadPCX('tetorial.dat', VSeg1, 32, 32, 0, 0, IconPal, 86423, 87906);
       2 : LoadPCX('tetorial.dat', VSeg1, 32, 32, 0, 0, IconPal, 87906, 89276);
       3 : LoadPCX('tetorial.dat', VSeg1, 32, 32, 0, 0, IconPal, 89276, 90503);
       4 : LoadPCX('tetorial.dat', VSeg1, 32, 32, 0, 0, IconPal, 90503, 92103);
     end;
          for y := 0 to 31 do
              for x := 0 to 31 do Icon[0]^[y][x] := GetPixel(x, y, VSeg1);
          if base2xms(Icon[0], hIcon[i], 1024) <> 0 then XMSError;
     end;
     dispose(Icon[0]);
     LoadPCX('tetorial.dat', VSeg1, 320, 200, 0, 0, TempPal, 92103, 99757);
     if base2xms(VScr1, hIconBack, 64000) <> 0 then XMSError;
     for i := 128 to 255 do IconPal[i] := TempPal[i];
     IconPal[0][0] := 0;
     IconPal[0][1] := 0;
     IconPal[0][2] := 0;

     writeln(' * Ok, this is the last stream of pictures...');
     LoadPCX('tetorial.dat', VSeg1, 320, 200, 0, 0, LogoPal[0], 99757, 122166);
     if base2xms(VScr1, hLogo[0], 64000) <> 0 then XMSError;
     LoadPCX('tetorial.dat', VSeg1, 320, 200, 0, 0, LogoPal[1], 122166, 148307);
     if base2xms(VScr1, hLogo[1], 64000) <> 0 then XMSError;
     for i := 0 to 3 do
     begin
     case i of
      0 : LoadPCX('tetorial.dat', VSeg1, 320, 200, 0, 0, EndPal[i], 148307, 182716);
      1 : LoadPCX('tetorial.dat', VSeg1, 320, 200, 0, 0, EndPal[i], 182716, 221570);
      2 : LoadPCX('tetorial.dat', VSeg1, 320, 200, 0, 0, EndPal[i], 221570, 269020);
      3 : LoadPCX('tetorial.dat', VSeg1, 320, 200, 0, 0, EndPal[i], 269020, 303518);
     end;
          if base2xms(VScr1, hEndPic[i], 64000) <> 0 then XMSError;
     end;


     writeln(' * Setting up tables and palettes...');
     { Globales }
     for i := 0 to 255 do
         PlasmaTab1[i] := round(cos(Pi * i / 128) * 31) + 32;
     for x := 0 to 319 do
         PlasmaTab2[x] := round(sqr(sqr((x - 160) / 80)) * 24);
     { Introduccin }
     for i := 0 to 127 do
     begin
          IntroPal1[i + 128] := IntroPal1[i];
          IntroPal2[i + 128] := IntroPal2[i];
     end;
     for i := 0 to 31 do
     begin
          IntroPal1[i][0] := i;
          IntroPal1[i][1] := i;
          IntroPal1[i][2] := 63;
     end;
     for i := 32 to 63 do
     begin
          IntroPal1[i][0] := (63 - i);
          IntroPal1[i][1] := (63 - i);
          IntroPal1[i][2] := 63;
     end;
     for i := 64 to 95 do
     begin
          IntroPal1[i][0] := 0;
          IntroPal1[i][1] := 0;
          IntroPal1[i][2] := 95 - i;
     end;
     for i := 96 to 127 do
     begin
          IntroPal1[i][0] := 0;
          IntroPal1[i][1] := 0;
          IntroPal1[i][2] := i - 64;
     end;
     for i := 0 to 127 do IntroPal2[i] := IntroPal1[i];

     { Saludos }
     for y := -20 to 20 do
         for x := -20 to 20 do
             if (sqr(x) + sqr(y)) <= 400 then Trans1[y][x] := true
                                         else Trans1[y][x] := false;

     for i := 0 to 15 do GreetPal[i][0] := i div 4;
     for i := 0 to 15 do GreetPal[i + 16][0] := i div 4 + 2;
     for i := 0 to 15 do GreetPal[i + 32][0] := i div 4 + 4;
     for i := 0 to 15 do GreetPal[i + 48][0] := i div 2 + 8;
     for i := 0 to 15 do GreetPal[i + 64][0] := i div 2 + 16;
     for i := 0 to 15 do GreetPal[i + 80][0] := i div 2 + 20;
     for i := 0 to 15 do GreetPal[i + 96][0] := i + 24;
     for i := 0 to 15 do GreetPal[i + 112][0] := i + 32;
     for i := 0 to 15 do GreetPal[i + 128][0] := i + 40;
     for i := 0 to 15 do GreetPal[i + 144][0] := (i div 2) + 52;
     for i := 0 to 15 do GreetPal[i + 160][0] := (i div 2) + 56;
     for i := 0 to 15 do GreetPal[i + 176][0] := (i div 4) + 60;
     for i := 0 to 15 do GreetPal[i + 192][0] := (i div 8) + 62;
     for i := 208 to 255 do GreetPal[i][0] := 63;
     for i := 0 to 255 do
     begin
          GreetPal[i][1] := GreetPal[i][0];
          GreetPal[i][2] := GreetPal[i][0];
     end;

     for i := 0 to 255 do VSin[i] := cos(i * Pi / 128);

     for i := 0 to 6 do
     begin
          Light[i].x := sin(2 * Pi * i / 6) * 80 + 140;
          Light[i].y := cos(2 * Pi * i / 6) * 35 + 50;
          Light[i].vx := round(i * 36.5);
          Light[i].vy := round(i * 18.25) + 128;
     end;
     { Fuego }
     for i := 0 to 7 do
     begin
          FirePal[i + 128][0] := 0;
          FirePal[i + 128][1] := 0;
          FirePal[i + 128][2] := i;
     end;
     for i := 0 to 7 do
     begin
          FirePal[i + 136][0] := 0;
          FirePal[i + 136][1] := 0;
          FirePal[i + 136][2] := 7 - i;
     end;
     for i := 0 to 7 do
     begin
          FirePal[i + 144][0] := i;
          FirePal[i + 144][1] := 0;
          FirePal[i + 144][2] := 0;
     end;
     for i := 0 to 7 do
     begin
          FirePal[i + 152][0] := 7 - i;
          FirePal[i + 152][1] := 0;
          FirePal[i + 152][2] := 0;
     end;
     for i := 0 to 31 do
     begin
          FirePal[i + 160][0] := i * 2;
          FirePal[i + 160][1] := 0;
          FirePal[i + 160][2] := 0;
     end;
     for i := 0 to 31 do
     begin
          FirePal[i + 192][0] := 63;
          FirePal[i + 192][1] := i * 2;
          FirePal[i + 192][2] := 0;
     end;
     for i := 0 to 31 do
     begin
          FirePal[i + 224][0] := 63;
          FirePal[i + 224][1] := 63;
          FirePal[i + 224][2] := i * 2;
     end;
     { Imgenes estticas + toro }
     for x := 0 to 1 do
         for i := 128 to 255 do
             LogoPal[x][i] := TexturePal[i];
     for x := 0 to 3 do
         for i := 128 to 255 do
             EndPal[x][i] := TexturePal[i];


     writeln(' * Loading music module...');
     InitMidas;
     MP := module^.MP;

     Frame.Reset;
     SetMode13;
end;


procedure Goodbye;
var i : byte;
begin
     { Msica }
     midasStopModule(module);
     midasFreeModule(module);
     midasClose;

     { Globales }
     ShutDownVirtual(VScr1);
     ShutDownVirtual(VScr2);
     { Introduccin }
     if XMSDispose(hPic1) <> 0 then XMSError;
     if XMSDispose(hPic2) <> 0 then XMSError;
     { Toro Rojo }
     dispose(Torus, Done);
     if XMSDispose(hEnv1) <> 0 then XMSError;
     { Saludos }
     if XMSDispose(hGreetPic) <> 0 then XMSError;
     { Interferencia }
     for i := 0 to 3 do if XMSDispose(hNoise[i]) <> 0 then XMSError;
     { Fuego }
     if XMSDispose(hFirePic) <> 0 then XMSError;
     { Iconos rotozoombantes }
     for i := 0 to 4 do if XMSDispose(hIcon[i]) <> 0 then XMSError;
     if XMSDispose(hIconBack) <> 0 then XMSError;
     { Toro texturiphongsombreado }
     if XMSDispose(hTexture) <> 0 then XMSError;
     for i := 0 to 1 do if XMSDispose(hLogo[i]) <> 0 then XMSError;
     for i := 0 to 3 do if XMSDispose(hEndPic[i]) <> 0 then XMSError;

     { Salir }
     SetTextMode;
     writeln;
     writeln(' Tetorial  --  a mini demo by: FAC');
     writeln;
     if keypressed then halt(0);
end;


function ModSync(p, r : word) : boolean;
begin
     MP^.GetInformation(moduleInfo);
     if (moduleInfo^)^.pos < p then
     begin
          ModSync := true;
          exit;
     end;
     if (moduleInfo^)^.pos > p then
     begin
          ModSync := false;
          exit;
     end;
     if (moduleInfo^)^.row < r then ModSync := true
                               else ModSync := false;
end;


{ Parte 1: Introduccin (plasma + imgenes estticas) }

procedure DrawIntroPlasma;
var p1, p2, p3, p4 : byte;
begin
     asm
          mov al, pos3
          mov p3, al
          mov ax, VSeg1
          mov es, ax
          mov ah, pos4
          mov si, 200
          xor di, di

   @loopy:
          mov dl, pos1
          mov dh, pos2
          mov cx, 320

   @loopx:
          xor bh, bh
          mov bl, dl
          mov al, [offset PlasmaTab1 + bx]
          mov bl, dh
          add al, [offset PlasmaTab1 + bx]
          mov bl, p3
          add al, [offset PlasmaTab1 + bx]
          mov bl, ah
          add al, [offset PlasmaTab1 + bx]
          add al, [offset PlasmaTab2 + si]
          mov bx, cx
          add al, [offset PlasmaTab2 + bx]
          shr al, 1
          mov es:[di], al
          inc di
          inc dl
          add dh, 2
          dec cx
          jne @loopx

          inc p3
          add ah, 2
          dec si
          jne @loopy
   end;
end;

procedure DrawIntroPic; assembler;
asm
   mov es, VSeg1
   mov dx, 320
   mov ax, 20
   mul dx
   mov di, ax
   add di, 70
   mov bx, word ptr [IntroPic + 2]
   mov si, word ptr [IntroPic]
   push ds
   mov ds, bx
   mov dx, 120

   @loopy: mov cx, 180

          @loopx: mov al, [si]
                  xor al, $FF
                  jz @jump
                  xor al, $FF
                  mov es:[di], al

          @jump: inc di
                 inc si
                 dec cx
                 jnz @loopx

                 add di, 140
                 dec dx
                 jnz @loopy
                 pop ds
end;


procedure Intro;
var i, j : byte;
begin
     IntroPic := new(PTIntroPic);
     fillchar(TempPal, 768, 0);
     SetPalette(TempPal);
     TempPal := IntroPal1;
     fillchar(TempPal, 384, 0);
     if xms2base(hPic1, IntroPic, 180 * 120) <> 0 then XMSError;
     ClearScreen(0, VSeg1);
     DrawIntroPic;
     CopyScreen(VSeg1, VGA);
     FadeTo(TempPal, 10);

     MidasPlayModule(module, 0);

     for j := 1 to 64 do
     begin
          for i := 0 to 127 do
          begin
               if TempPal[i][0] < IntroPal1[i][0] then inc(TempPal[i][0]);
               if TempPal[i][1] < IntroPal1[i][1] then inc(TempPal[i][1]);
               if TempPal[i][2] < IntroPal1[i][2] then inc(TempPal[i][2]);
          end;

          RotatePalette(TempPal, 127, 0);
          RotatePalette(IntroPal1, 127, 0);
          DrawIntroPlasma;
          DrawIntroPic;
          SetPalette(TempPal);
          CopyScreen(VSeg1, VGA);

          dec(pos1, 4);
          inc(pos3, 4);
          inc(pos1, random(2));
          dec(pos2, random(3));
          inc(pos3, random(3));
          dec(pos4, random(2));
     end;

     while ModSync(1, 0) do
     begin
          RotatePalette(IntroPal1, 127, 0);
          DrawIntroPlasma;
          DrawIntroPic;
          SetPalette(IntroPal1);
          CopyScreen(VSeg1, VGA);

          dec(pos1, 4);
          inc(pos3, 4);
          inc(pos1, random(2));
          dec(pos2, random(3));
          inc(pos3, random(3));
          dec(pos4, random(2));
          if keypressed then
          begin
               dispose(IntroPic);
               Goodbye;
          end;
     end;

     if xms2base(hPic2, IntroPic, 180 * 120) <> 0 then XMSError;
     TempPal := IntroPal2;
     fillchar(TempPal, 384, 63);
     for i := 0 to 127 do
     begin
          IntroPal2[i] := IntroPal1[i];
          TempPal[i][2] := 32;
     end;
     for j := 1 to 64 do
     begin
          for i := 0 to 127 do
          begin
               if TempPal[i][0] > IntroPal2[i][0] then dec(TempPal[i][0]);
               if TempPal[i][1] > IntroPal2[i][1] then dec(TempPal[i][1]);
               if TempPal[i][2] > IntroPal2[i][2] then dec(TempPal[i][2]);
               if TempPal[i][2] < IntroPal2[i][2] then inc(TempPal[i][2]);
          end;

          RotatePalette(TempPal, 127, 0);
          RotatePalette(IntroPal2, 127, 0);
          DrawIntroPlasma;
          DrawIntroPic;
          SetPalette(TempPal);
          CopyScreen(VSeg1, VGA);

          dec(pos1, 4);
          inc(pos3, 4);
          inc(pos1, random(2));
          dec(pos2, random(3));
          inc(pos3, random(3));
          dec(pos4, random(2));
     end;

     while ModSync(2, 0) do
     begin
          RotatePalette(IntroPal2, 127, 0);
          DrawIntroPlasma;
          DrawIntroPic;
          SetPalette(IntroPal2);
          CopyScreen(VSeg1, VGA);

          dec(pos1, 4);
          inc(pos3, 4);
          inc(pos1, random(2));
          dec(pos2, random(3));
          inc(pos3, random(3));
          dec(pos4, random(2));
          if keypressed then
          begin
               dispose(IntroPic);
               Goodbye;
          end;
     end;
     dispose(IntroPic);
end;


{ Parte 2: Toro Rojo + Plasma }

procedure RedTorus;
var x, y, z, ax, ay, az : integer;
    i, j : byte;
begin
     TorusEnv := new(PTTexture);
     if xms2base(hEnv1, TorusEnv, 256 * 255) <> 0 then XMSError;
     Torus^.SetStyle(EnviromentMap);
     Torus^.SetTexture(TorusEnv, 0);
     for i := 0 to 127 do
     begin
          EnvPal1[i + 128] := EnvPal1[i];
          EnvPal1[i] := IntroPal2[i];
     end;
     x := 250;
     y := 50;
     z := 600;
     ax := 50;
     ay := 80;
     az := 0;

     while ModSync(3, 56) do
     begin
          Torus^.SetOrigin(x, y, z);
          RotatePalette(EnvPal1, 127, 0);
          DrawIntroPlasma;
          Torus^.Draw(VSeg1);
          SetPalette(EnvPal1);
          CopyScreen(VSeg1, VGA);

          dec(pos1, 5);
          inc(pos3, 5);
          inc(pos1, random(2));
          dec(pos2, random(3));
          inc(pos3, random(3));
          dec(pos4, random(2));

          Torus^.Rotate(ax div 10, ay div 10, az div 10);
          inc(ax);
          inc(ay);
          inc(az);
          if ax > 100 then ax := 0;
          if ay > 100 then ay := 20;
          if az > 60 then az := -20;
          dec(x, 2);
          if not ModSync(3, 31) then z := 200
          else if not ModSync(3, 0) then z := 600
               else if not ModSync(2, 31) then z := 0;
          if not ModSync(3, 31) then y := -60
          else if not ModSync(3, 0) then y := 0
               else if not ModSync(2, 31) then y := 50;
          if keypressed then
          begin
               dispose(TorusEnv);
               Goodbye;
          end;
     end;
     x := 0; y := 0; z := 0;
     Torus^.SetOrigin(x, y, z);
     aux := Torus^.CountVertex;

     TempPal := EnvPal1;
     for j := 1 to 32 do
     begin
          for i := 0 to 255 do
          begin
               if TempPal[i][0] > 0 then dec(TempPal[i][0]);
               if TempPal[i][1] > 0 then dec(TempPal[i][1]);
               if TempPal[i][2] > 0 then dec(TempPal[i][2]);
               if TempPal[i][0] > 0 then dec(TempPal[i][0]);
               if TempPal[i][1] > 0 then dec(TempPal[i][1]);
               if TempPal[i][2] > 0 then dec(TempPal[i][2]);
          end;
          RotatePalette(TempPal, 127, 0);
          DrawIntroPlasma;
          SetPalette(TempPal);
          CopyScreen(VSeg1, VGA);

          dec(pos1, 2);
          inc(pos3, 2);
          inc(pos1, random(2));
          dec(pos2, random(3));
          inc(pos3, random(3));
          dec(pos4, random(2));
     end;
     dispose(TorusEnv);
end;


{ Parte 3: Saludos }
procedure DrawLight(x, y : integer); assembler;
asm
        mov es, VSeg1
        mov di, x
        mov ax, 320
        mul y
        add di, ax
        xor si, si
        mov ch, 41

        @loopy: mov cl, 41

        @loopx: mov al, byte ptr [Trans1 + si]
                test al, $FF
                jz @jump
                mov al, es:[di]
                add al, 32
                mov es:[di], al

        @jump:  inc si
                inc di
                dec cl
                jnz @loopx
                add di, 279
                dec ch
                jnz @loopy
end;

procedure Greets;
var i : byte;
begin
     ClearScreen(0, VGA);
     SetPalette(GreetPal);
     xms2base(hGreetPic, Vscr2, 64000);
     while ModSync(4, 0) do;
     while ModSync(4, 59) do
     begin
          CopyScreen(VSeg2, VSeg1);
          for i := 0 to 6 do
          begin
               DrawLight(trunc(Light[i].x), trunc(Light[i].y));
               Light[i].x := Light[i].x + VSin[Light[i].vx] * 1.6;
               Light[i].y := Light[i].y + VSin[Light[i].vy] * 1.2;
               inc(Light[i].vx);
               inc(Light[i].vy);
               Light[i].x := Light[i].x + VSin[Light[i].vx] * 1.6;
               Light[i].y := Light[i].y + VSin[Light[i].vy] * 1.2;
               inc(Light[i].vx);
               inc(Light[i].vy);
               if keypressed then Goodbye;
          end;
          VRetrace;
          CopyScreen(VSeg1, VGA);
     end;
end;

{ Parte 4: Interferencia }

procedure Noise;
var i, frame : byte;
    prob : integer;
begin
     TempPal := GreetPal;
     frame := 0;
     for prob := 100 to 400 do
     begin
          if random(prob) > 100 then xms2base(hNoise[frame], VScr1, 64000)
                                else CopyScreen(VSeg2, VSeg1);
          for i := 0 to 6 do
          begin
               DrawLight(trunc(Light[i].x), trunc(Light[i].y));
               Light[i].x := Light[i].x + VSin[Light[i].vx] * 1.6;
               Light[i].y := Light[i].y + VSin[Light[i].vy] * 1.2;
               inc(Light[i].vx);
               inc(Light[i].vy);
               Light[i].x := Light[i].x + VSin[Light[i].vx] * 1.6;
               Light[i].y := Light[i].y + VSin[Light[i].vy] * 1.2;
               inc(Light[i].vx);
               inc(Light[i].vy);
               if keypressed then Goodbye;
          end;
          VRetrace;
          CopyScreen(VSeg1, VGA);
          frame := (frame + 1) mod 4;
     end;

     while ModSync(5, 56) do
     begin
          xms2base(hNoise[frame], VScr1, 64000);
          for i := 0 to 6 do
          begin
               DrawLight(trunc(Light[i].x), trunc(Light[i].y));
               Light[i].x := Light[i].x + VSin[Light[i].vx] * 1.6;
               Light[i].y := Light[i].y + VSin[Light[i].vy] * 1.2;
               inc(Light[i].vx);
               inc(Light[i].vy);
               Light[i].x := Light[i].x + VSin[Light[i].vx] * 1.6;
               Light[i].y := Light[i].y + VSin[Light[i].vy] * 1.2;
               inc(Light[i].vx);
               inc(Light[i].vy);
               if keypressed then Goodbye;
          end;
          SetPalette(TempPal);
          VRetrace;
          CopyScreen(VSeg1, VGA);
          frame := (frame + 1) mod 4;
          RotatePalette(TempPal, 1, 15);
          for i := 1 to 13 do
              RotatePalette(TempPal, i * 16, i * 16 + 15);
     end;

     for prob := 1 to 64 do
     begin
          xms2base(hNoise[frame], VScr1, 64000);
          for i := 0 to 6 do
          begin
               DrawLight(trunc(Light[i].x), trunc(Light[i].y));
               Light[i].x := Light[i].x + VSin[Light[i].vx] * 1.6;
               Light[i].y := Light[i].y + VSin[Light[i].vy] * 1.2;
               inc(Light[i].vx);
               inc(Light[i].vy);
               Light[i].x := Light[i].x + VSin[Light[i].vx] * 1.6;
               Light[i].y := Light[i].y + VSin[Light[i].vy] * 1.2;
               inc(Light[i].vx);
               inc(Light[i].vy);
          end;
          VRetrace;
          SetPalette(TempPal);
          CopyScreen(VSeg1, VGA);
          frame := (frame + 1) mod 4;
          for i := 0 to 255 do
          begin
               if TempPal[i][0] > 0 then dec(TempPal[i][0]);
               if TempPal[i][1] > 0 then dec(TempPal[i][1]);
               if TempPal[i][2] > 0 then dec(TempPal[i][2]);
          end;
          RotatePalette(TempPal, 1, 15);
          for i := 1 to 13 do
              RotatePalette(TempPal, i * 16, i * 16 + 15);
     end;
end;

{ Parte 5: Fuego + Naomi }

procedure DrawFire;
var x, y : integer;
begin
     asm
        mov es, VSeg1
        mov ax, VSeg2
        push ds
        mov ds, ax
        mov si, 6401 { 320 * 20 + 1 }
        mov di, 7041 { 320 * 22 + 1 }
        mov dx, 176

        @loopy:  mov cx, 318

        @loopx:  xor ah, ah
                 mov al, byte ptr [si]
                 add al, byte ptr [si + 640]
                 adc ah, 0
                 add al, byte ptr [si + 639]
                 adc ah, 0
                 add al, byte ptr [si + 641]
                 adc ah, 0
                 shr ax, 2
                 test al, 80h
                 jnz @jump1
                 mov al, 80h

        @jump1:  mov es:[di], al
                 mov [si], al
                 inc si
                 inc di
                 dec cx
                 jnz @loopx
                 add si, 2
                 add di, 2
                 dec dx
                 jnz @loopy

                 pop ds
                 mov di, 63360
                 mov cx, 160
                 db long; xor ax, ax
                 db $F3, $66, $AB

                 mov ax, word ptr [FirePic + 2]
                 mov si, word ptr [FirePic]
                 push ds
                 xor di, di
                 mov ds, ax
                 mov cx, 33280

        @loop:   mov al, [si]
                 test al, $FF
                 jz @jump
                 mov es:[di], al

        @jump:   inc di
                 inc si
                 dec cx
                 jnz @loop
                 pop ds

     end;
     for y := 197 to 199 do
         for x := 0 to 320 do
             PutPixel(x, y, random(2) * 127 + 128, VSeg2);
end;


procedure Fire;
var x, y : integer;
begin
     ClearScreen(0, VSeg1);
     ClearScreen(0, VGA);
     ClearScreen(128, VSeg2);
     for y := 197 to 199 do
         for x := 0 to 319 do
             PutPixel(x, y, random(2) * 127 + 128, VSeg2);
     SetPalette(FirePal);
     TempPal := FirePal;
     TempPal[0][0] := 48;
     TempPal[0][1] := 48;
     TempPal[0][2] := 63;
     TempPal[128] := TempPal[0];
     FirePic := new(PTFirePic);
     if xms2base(hFirePic, FirePic, 104 * 320) <> 0 then XMSError;
     while ModSync(6, 0) do;
     while ModSync(6, 32) do
     begin
          DrawFire;
          SetPalette(TempPal);
          CopyScreen(VSeg1, VGA);
          if TempPal[0][0] > 0 then dec(TempPal[0][0]);
          if TempPal[0][1] > 0 then dec(TempPal[0][1]);
          if TempPal[0][2] > 0 then dec(TempPal[0][2]);
          TempPal[128] := TempPal[0];
          if keypressed then
          begin
               dispose(FirePic);
               Goodbye;
          end;
     end;
     TempPal[0][0] := 48;
     TempPal[0][1] := 48;
     TempPal[0][2] := 63;
     TempPal[128] := TempPal[0];
     while ModSync(7, 0) do
     begin
          DrawFire;
          SetPalette(TempPal);
          CopyScreen(VSeg1, VGA);
          if TempPal[0][0] > 0 then dec(TempPal[0][0]);
          if TempPal[0][1] > 0 then dec(TempPal[0][1]);
          if TempPal[0][2] > 0 then dec(TempPal[0][2]);
          TempPal[128] := TempPal[0];
          if keypressed then
          begin
               dispose(FirePic);
               Goodbye;
          end;
     end;
     dispose(FirePic);
end;

{ Parte 6: Iconos }

procedure ResetSprite(spr : byte);
begin
     with Sprite[spr]^ do
     begin
          ox := random(280) - 140;
          oy := random(160) - 80;
          oz := -300 - random(300);
          ox := Fixed(ox) shl 16;
          oy := Fixed(oy) shl 16;
          oz := Fixed(oz) shl 16;
          zoomin := true;
     end;
end;

procedure InitSprites;
var i : byte;
begin
     for i := 1 to 25 do
     begin
          ResetSprite(i);
          with Sprite[i]^ do
          begin
               oz := random(1200) - 600;
               if oz > 200 then zoomin := false else zoomin := true;
               oz := Fixed(oz) shl 16;
               v[0].SetP(-16, -16, 0);
               v[1].SetP(16, -16, 0);
               v[2].SetP(16, 16, 0);
               v[3].SetP(-16, 16, 0);
          end;
          Sprite[i]^.icon := Icon[(i - 1) mod 5];
     end;
end;

procedure DrawSprite(spr : byte);
var preX, preU, preV : array[0..199, 0..1] of Fixed;

    procedure ScanSide(sx1, sy1, su1, sv1, sx2, sy2, su2, sv2 : Fixed);
    var yc, ydiv : integer;
        xc, xadd, uc, uadd, vc, vadd : Fixed;
    begin
         if sy1 > sy2 then
         begin
              xc := sy1; sy1 := sy2; sy2 := xc;
              xc := sx1; sx1 := sx2; sx2 := xc;
              xc := su1; su1 := su2; su2 := xc;
              xc := sv1; sv1 := sv2; sv2 := xc;
         end;
         ydiv := (sy2 - sy1) shr 16;
         if ydiv = 0 then exit;
         xadd := (sx2 - sx1) div ydiv;
         uadd := (su2 - su1) div ydiv;
         vadd := (sv2 - sv1) div ydiv;
         xc := sx1; uc := su1; vc := sv1;
         for yc := (sy1 shr 16) to (sy2 shr 16) do
         begin
              if xc < preX[yc, 0] then
              begin
                   preX[yc, 0] := xc;
                   preU[yc, 0] := uc;
                   preV[yc, 0] := vc;
              end;
              if xc > preX[yc, 1] then
              begin
                   preX[yc, 1] := xc;
                   preU[yc, 1] := uc;
                   preV[yc, 1] := vc;
              end;
              inc(xc, xadd);
              inc(uc, uadd);
              inc(vc, vadd);
         end;
    end;
var ymin, ymax, xmin, xmax, xdiv : Fixed;
    y : integer;
    u, umul, v, vmul : Fixed;
    curIcon : PTIcon;
    c : byte;
begin
     with Sprite[spr]^ do
     begin
          for y := 0 to 3 do
               with v[y] do
               begin
                    zoff := oz;
                    Calc2d;
                    inc(x2d, ox);
                    dec(y2d, oy);
                    if x2d < 0 then x2d := 0
                       else if x2d > 20905984 then x2d := 20905984;
                    if y2d < 0 then y2d := 0
                       else if y2d > 13041664 then y2d := 13041664;
               end;
          ymin := v[0].y2d;
          if v[1].y2d < ymin then ymin := v[1].y2d;
          if v[2].y2d < ymin then ymin := v[2].y2d;
          if v[3].y2d < ymin then ymin := v[3].y2d;
          ymax := v[0].y2d;
          if v[1].y2d > ymax then ymax := v[1].y2d;
          if v[2].y2d > ymax then ymax := v[2].y2d;
          if v[3].y2d > ymax then ymax := v[3].y2d;
          if ymin = ymax then exit;
          ymin := ymin shr 16;
          ymax := ymax shr 16;
          for y := ymin to ymax do
          begin
               preX[y, 0] := $7FFFFFFF;
               preX[y, 1] := 0;
          end;
          ScanSide( v[0].x2d, v[0].y2d, 0, 0,
                    v[1].x2d, v[1].y2d, 2031616, 0 );
          ScanSide( v[1].x2d, v[1].y2d, 2031616, 0,
                    v[2].x2d, v[2].y2d, 2031616, 2031616);
          ScanSide( v[2].x2d, v[2].y2d, 2031616, 2031616,
                    v[3].x2d, v[3].y2d, 0, 2031616);
          ScanSide( v[3].x2d, v[3].y2d, 0, 2031616,
                    v[0].x2d, v[0].y2d, 0, 0);
     end;
     curIcon := Sprite[spr]^.icon;
     asm
        mov es, VSeg1
        mov ax, word ptr [curIcon + 2]
        db $8E, $E0 { mov fs, ax }
     end;
     for y := ymin to ymax do
     begin
          xmin := preX[y, 0] shr 16;
          xmax := preX[y, 1] shr 16;
          xdiv := xmax - xmin;
          if xdiv = 0 then
          begin
               umul := 0;
               vmul := 0;
          end
          else
          begin
               umul := (preU[y, 1] - preU[y, 0]) div xdiv;
               vmul := (preV[y, 1] - preV[y, 0]) div xdiv;
          end;
          u := preU[y, 0];
          v := preV[y, 0];
          asm
             db long; mov cx, word ptr [xmax]
             inc cx
             db long; mov di, word ptr [xmin]
             sub cx, di
             mov ax, 320
             mul y
             add di, ax
             db long; mov dx, word ptr [u]
             db long; mov si, word ptr [v]

          @loop:  db long; mov bx, si
                  db long; mov ax, dx
                  db long; shr bx, 11
                  db long; shr ax, 16
                  and bx, 0000001111100000b
                  db long; add dx, word ptr [umul]
                  add bx, ax
                  add bx, 8 { porqu hay que sumarle 8 a BX? }
                  db long; add si, word ptr [vmul]
                  db $64, $8A, $07 { mov al, fs:[bx] }
                  test al, $FF
                  jz @jump
                  mov es:[di], al

          @jump:  inc di
                  dec cx
                  jnz @loop
          end;
     end;
end;

procedure MoveSprites;
var i, j : byte;
begin
     for i := 1 to 25 do
     begin
          with Sprite[i]^ do
          begin
               DrawSprite(i);
               if odd(i) then for j := 0 to 3 do v[j].VRotate(0, 0, 10)
                         else for j := 0 to 3 do v[j].VRotate(0, 0, -10);
               if zoomin then
               begin
                    inc(oz, 1966080);
                    if oz > 52428800 then zoomin := false;
               end
               else
               begin
                    dec(oz, 1966080);
                    if oz < -45875200 then ResetSprite(i);
               end;
          end;
     end;
end;


procedure RotoIcons;
var i : byte;
begin
     ClearScreen(0, VGA);
     SetPalette(IconPal);
     if xms2base(hIconBack, VScr2, 64000) <> 0 then XMSError;
     for i := 0 to 4 do
     begin
          Icon[i] := new(PTIcon);
          if xms2base(hIcon[i], Icon[i], 1024) <> 0 then XMSError;
     end;
     for i := 1 to 25 do Sprite[i] := new(PTSprite);
     InitSprites;
     while ModSync(7, 56) do
     begin
          CopyScreen(VSeg2, VSeg1);
          MoveSprites;
          CopyScreen(VSeg1, VGA);
          if keypressed then
          begin
               for i := 1 to 25 do dispose(Sprite[i]);
               for i := 0 to 4 do dispose(Icon[i]);
               Goodbye;
          end;
     end;
     TempPal := IconPal;
     while ModSync(8, 0) do
     begin
          for i := 0 to 255 do
          begin
               if TempPal[i][0] > 0 then dec(TempPal[i][0]);
               if TempPal[i][1] > 0 then dec(TempPal[i][1]);
               if TempPal[i][2] > 0 then dec(TempPal[i][2]);
               if TempPal[i][0] > 0 then dec(TempPal[i][0]);
               if TempPal[i][1] > 0 then dec(TempPal[i][1]);
               if TempPal[i][2] > 0 then dec(TempPal[i][2]);
          end;
          CopyScreen(VSeg2, VSeg1);
          MoveSprites;
          SetPalette(TempPal);
          CopyScreen(VSeg1, VGA);
     end;
     for i := 1 to 25 do dispose(Sprite[i]);
     for i := 0 to 4 do dispose(Icon[i]);
end;

{ Parte 7: El regreso del toro deforme }

procedure BlueGreenTorus;
var i, j, k, p, r : word;
    n, z, ax, ay, az : integer;
begin
     TorusEnv := new(PTTexture);
     if xms2base(hTexture, TorusEnv, 256 * 255) <> 0 then XMSError;
     Torus^.SetStyle(TextureMap);
     Torus^.SetTexture(TorusEnv, 2);
     n := 0;
     ax := -50;
     ay := 0;
     az := -20;
     p := 8;
     r := 4;

     SetPal(0, 0, 0, 0);
     ClearScreen(0, VGA);
{     Torus^.Vnum := 1000;}
     for j := 0 to 13 do
     begin
          xms2base(hEndPic[j mod 4], VScr2, 64000);
          TempPal := EndPal[j mod 4];
          while ModSync(p, r) do
          begin
               CopyScreen(VSeg2, VSeg1);
               asm
                  mov bx, n
                  shl bx, 2
                  db long; mov ax, word ptr [SinT + bx]
                  db long; add ax, 0; dw $0001
                  db long; shr ax, 8
                  add ax, 200
                  mov z, ax
               end;
               Torus^.SetOrigin(0, 0, z);
               Torus^.Draw(VSeg1);
               SetPalette(TempPal);
               CopyScreen(VSeg1, VGA);

               Torus^.Rotate(ax div 8, ay div 8, az div 8);
               dec(ax); dec(ay); dec(az);
               if ax < -80 then ax := 20;
               if ay < -40 then ay := 60;
               if az < -50 then az := 50;

               inc(n, 10);
               if n >= 360 then n := 0;

               if keypressed then
               begin
                    dispose(TorusEnv);
                    Goodbye;
               end;
          end;

          inc(r, 4);
          if r = 64 then
          begin
               r := 0;
               inc(p);
          end;

          if xms2base(hLogo[ord(odd(j))], VScr2, 64000) <> 0 then XMSError;
          TempPal := LogoPal[ord(odd(j))];
          while ModSync(p, r) do
          begin
               CopyScreen(VSeg2, VSeg1);
               asm
                  mov bx, n
                  shl bx, 2
                  db long; mov ax, word ptr [SinT + bx]
                  db long; add ax, 0; dw $0001
                  db long; shr ax, 8
                  add ax, 200
                  mov z, ax
               end;
               Torus^.SetOrigin(0, 0, z);
               Torus^.Draw(VSeg1);
               SetPalette(TempPal);
               CopyScreen(VSeg1, VGA);

               Torus^.Rotate(ax div 8, ay div 8, az div 8);
               dec(ax); dec(ay); dec(az);
               if ax < -80 then ax := 20;
               if ay < -40 then ay := 60;
               if az < -50 then az := 50;

               inc(n, 10);
               if n >= 360 then n := 0;

               for k := 0 to 127 do
               begin
                    if TempPal[k][0] > 0 then dec(TempPal[k][0]);
                    if TempPal[k][1] > 0 then dec(TempPal[k][1]);
                    if TempPal[k][2] > 0 then dec(TempPal[k][2]);
                    if TempPal[k][0] > 0 then dec(TempPal[k][0]);
                    if TempPal[k][1] > 0 then dec(TempPal[k][1]);
                    if TempPal[k][2] > 0 then dec(TempPal[k][2]);
               end;

               if keypressed then
               begin
                    dispose(TorusEnv);
                    Goodbye;
               end;
          end;
          inc(r, 4);
     end;
     dispose(TorusEnv);
     if xms2base(hLogo[0], VScr1, 64000) <> 0 then XMSError;
     SetPalette(LogoPal[0]);
     CopyScreen(VSeg1, VGA);
     while ModSync(9, 63) do
     begin
          for i := 0 to 127 do
          begin
               if LogoPal[0][i][0] > 0 then dec(LogoPal[0][i][0]);
               if LogoPal[0][i][1] > 0 then dec(LogoPal[0][i][1]);
               if LogoPal[0][i][2] > 0 then dec(LogoPal[0][i][2]);
          end;
          VRetrace;
          SetPalette(LogoPal[0]);
     end;
end;


{ Principal }

begin
     InitAll;
     Intro;
     RedTorus;
     Greets;
     Noise;
     Fire;
     RotoIcons;
     BlueGreenTorus;
     Goodbye;
end.