//
// tinyplayer: An example for using libv2 and a lesson in getting
//             Win32 executables small. Written by Tammo "kb" 
//             Hinrichs in 2004. This file (as well as the .sln
//             and the .vcproj file) is in the public domain,
//             do with it what you want.
//
//             farbrausch consumer consulting, Dec. 2004
//

// it is advised to look into the compiler settings to see why the
// final exe takes only 52k (or 12.5k after being packed with an
// executable packer)

// we need: windows...
#define WIN32_LEAN_AND_MEAN
#include <windows.h>

// ... the libv2 ...
#include "../libv2.h"

// ... and our tune.
#include "tune.h"

// --------------------------------------------------------------------------------

// a few fakes coming up because this gets compiled without any stdlib and so
// we don't even have printf() :

static HANDLE stdout;

static void print(const char *text)
{
	unsigned long bw;
	int len=0;
	while (text[len]) len++; // yeah, strlen() also is a luxury. :)
	WriteFile(stdout,text,len,&bw,0);
}

// VC needs this symbol as soon as something uses floating point numbers
// (and libv2 does):
extern "C" int _fltused;
int _fltused;

// --------------------------------------------------------------------------------

extern "C" void mainCRTStartup()
{
	// we need this for print() to work
	stdout=GetStdHandle(STD_OUTPUT_HANDLE);

	// print a bunch of senseless info..
	print("\nFarbrausch Tiny Music Player v0.2\n");
	print("Code and Synthesizer (C) 2000-2004 kb/Farbrausch\n");
	print("\n\nNow Playing: 'Welcome to...' by kb\n");

	// init synthesizer and player with the tune and the current window
	ssInit(theTune,GetForegroundWindow());

	// start playing
	ssPlay();

	print("\n\npress ESC to quit\n");

	// wait until someone presses ESC
	// yep, I know this will stop even if we don't have focus. I simply don't care.
	while (GetAsyncKeyState(VK_ESCAPE)>=0) 
	{ 
		// draw rotating stuff and make sure we don't use up 100% cpu
		static const char* anim[]={"|","/","-","\\"};
		print(anim[int(ssGetTime()/250.0f)&3]);
		print("\r");
		Sleep(10); 
	}

	// stop and deinit the player
	ssStop();
	ssClose();

	// ... and we're done.
	ExitProcess(0);
}

