#!/usr/bin/perl -w

# GoFoft 1.0
# by Quentin Smith
# GPLed

use Gnome;
use Gtk::XmHTML;
use LWP::UserAgent;
use Fcntl;

my %image_cache;
my $cache_file = $ENV{HOME}."/.gofoft_cache";

my $mldbm_method = "Data::Dumper";
if (eval "require Storable") {
    $mldbm_method = "Storable";
} elsif (eval "require FreezeThaw") {
    $mldbm_method = "FreezeThaw";
}

if (eval "require DB_File") {
    # We got DB_File.
    #DB_File->import();
    use MLDBM ("DB_File", $mldbm_method);
    tie (%image_cache, 'MLDBM', $cache_file, O_RDWR|O_CREAT, 0640, $DB_HASH);
} elsif (eval "require GDBM_File") {
    # We have GDBM_File.
    #GDBM_File->import();
    use MLDBM ("GDBM_File", $mldbm_method);
    tie (%image_cache, 'MLDBM', $cache_file, &GDBM_WRCREAT, 0640);
} else {
    # Well, we'll just have to keep the cache in memory.
}

init Gnome "GoFoft";
init Gtk::XmHTML;

$start = $ARGV[0]||'http://comclub.dyndns.org/foft';
print "start: $start\n";

my @history;
my $cur_history_point=0;

$ua = new LWP::UserAgent();
$win = new Gtk::Window -toplevel;
$win->signal_connect('destroy', sub {Gtk->exit(0)});
$win->set_usize(400, 400);
$win->set_border_width(2);
$win->set_title("GoFoft");
$win->realize;
$html = new Gtk::XmHTML;
$html->set_allow_images(1);
$html->set_image_procs(\&get_image);
$html->signal_connect('activate', \&goto_url);
$html->signal_connect('anchor_track', \&goto_url, 1);
$html->signal_connect('key_press', \&key_press);
$html->source("<B>Loading $start...</B>");
#print $html->{klass};
$html->show;

$vbox = new Gtk::VBox(0,2);
$hbox = new Gtk::HBox(0,2);

$toolbar = new Gtk::Toolbar('horizontal', 'both');
$toolbar->set_space_style('line');
$toolbar->set_button_relief("none");

$window = $win->window;
$color = $win->style->bg('normal');

$back_button = $toolbar->append_item ( "Back", "Go back in the history",
				  "Navigation/Back",
				  new_pixmap("xpm/back.xpm",$window,$color));
$back_button->signal_connect('clicked', sub {
    #pop @history;
    if ($cur_history_point > 0) {
	$cur_history_point--;
	#goto_url($html, {'href' =>(pop @history)});
	fetch_page($history[$cur_history_point]);
    }
});
$forward_button = $toolbar->append_item( "Forward", "Go forward in the history",
				 "Navigation/Forward",
				 new_pixmap("xpm/forward.xpm",$window,$color));
$forward_button->signal_connect('clicked', sub {
    #pop @history;
    if ($cur_history_point < $#history) {
	$cur_history_point++;
	#goto_url($html, {'href' =>(pop @history)});
	fetch_page($history[$cur_history_point]);
    }
});
$toolbar->show();

$foft_button = new Gtk::Button();
$foft_button->add(new_pixmap("xpm/logo.xpm",$window,$color));
$foft_button->set_relief("none");
$foft_button->signal_connect('clicked', sub {
    goto_url($html, {'href' => "http://comclub.dyndns.org/foft"});
});

$hbox->pack_start($toolbar, 0, 0, 0);
$hbox->pack_end($foft_button,0,0,0);

$vbox->pack_start($hbox, 0, 0, 0);
$vbox->pack_start($html, 1, 1, 0);
$vbox->show_all();

$win->add($vbox);
$win->show;

Gtk->idle_add(sub {
    #goto_url($html, {'href' => $start});
    print "GOTO: $start\n";
    fetch_page($start);
    $history[$cur_history_point] = $start;
    return 0;
});
main Gtk;


sub get_image {
	my ($html, $href) = @_;
	my ($request, $data);
	
	while (Gtk->events_pending) { Gtk->main_iteration(); }
	my $base = $base;
	if ($href =~ /^\//) { $base =~ /^(\w+\:\/\/[^\/]+)\//; $base = $1; }
	$href = "${base}$href" unless $href =~ m/:/;
	while ($href =~ s/(?<!http\:\/)\/[^\/]*\/\.\.\//\//g) {}
	$href =~ s/http\:\/\/(.*?)\/\.\.\//http\:\/\/$1\//g;
	print "GET IMAGE: $href\n";
	if (defined($image_cache{$href}) && defined($image_cache{$href}->{data}) && $image_cache{$href}->{data}->is_fresh()) {
	    return ($href, $image_cache{$href}->{data}->content());
	} else {
	    $request = new HTTP::Request('GET', $href);
	    $request->if_modified_since($image_cache{$href}->{data}->date()) if ($image_cache{$href});
	    $data = $ua->request($request);
	    if ($data->code() == 304) {
		#It wasn't modified.
		return ($href, $image_cache{$href}->{data}->content());
	    } elsif ($data->is_success) {
		$image_cache{$href} = {data => $data};
		return ($href, $data->content());
	    } else {
		# print $data->error_as_HTML();
		return ($href, undef);
	    }
	}
	
}

sub goto_url {
	my ($html, $p, $track) =@_;
	
	if (ref $track) {
		($track, $p) = ($p, $track);
	}
	my ($href) = $p->{'href'};
	if ($track) {
		#print "track\n";
		#foreach (keys %{$p}) {
		#	print "$_ -> $p->{$_}\n";
		#}
		return unless $href;
		print "URL: $href\n";
		return;
	}
	$base = '' unless $base;
	#local $base = $base;
	if ($href =~ /^\//) { $base =~ /^(\w+\:\/\/[^\/]+)\//; $base = $1; }
	$href = "${base}$href" unless $href =~ m/:/;
	print "GOTO: $href : BASE: $base\n";
	$cur_history_point++;
	if ($cur_history_point <= $#history) {
#undef @history[$cur_history_point..$#history];
	    $#history = $cur_history_point;
	}
	$history[$cur_history_point] = $href;
	fetch_page($href);
	#$back_button->set_sensitive(1);
	#$forward_button->set_sensitive(($cur_history_point < $#history));
}
sub fetch_page {
    my $request1 = new HTTP::Request('HEAD', $_[0]);
    my $headers = $ua->request($request1);
    if (($headers->content_type eq "text/html") || ($headers->content_type eq "text/plain")) {
	$request = new HTTP::Request('GET', $_[0]);
	$data = $ua->request($request);
	if ($data->is_success) {
	    my ($uri) = $data->base;
	    $base = $uri if ($uri =~ m/\/$/); #
	    if ($uri =~ /^(.*\/)[^\/]+$/) { $base = $1 }
	    print "BASE: $base\n";
	    $html->source($data->content());
	} else {
	    $html->source($data->error_as_HTML());
	}
	$back_button->set_sensitive($cur_history_point > 0);
	$forward_button->set_sensitive($cur_history_point < $#history);
	return $data;
    
    } else {
	my $res = fork();
	if ($res == 0) {
	    use File::Spec::Functions qw(:ALL);
	    print "HELLO FROM CHILD: ",$headers->base;
	    exec rel2abs(catdir(curdir(),"gofoft-download.pl")), $headers->base;
	    }
    }
}
sub key_press {
    my ($widget, $event) = @_;
    
}

sub new_pixmap {
	my ($filename, $window, $background) = @_;
	my ($pixmap, $mask) = create_from_xpm Gtk::Gdk::Pixmap($window, $background, $filename);

	return new Gtk::Pixmap($pixmap, $mask);
}
