
#include <math.h>
#include <assert.h>
#include "sdfx_delay.h"


/* Sets delaytime and read pointer. The write pointer is not moved. */
void sdfx_delay_set_delaytime(struct SDFX_DELAY *self, int valueL, int valueR)
{
	/* must not exceed buffer size */
	if (valueL > self->bufsizeL) valueL = self->bufsizeL;
	if (valueR > self->bufsizeR) valueR = self->bufsizeR;

	self->delaytimeL = valueL;
	self->delaytimeR = valueR;

	self->rL = 
		self->bufferL +
		(((self->wL - self->bufferL) + 1) % self->delaytimeL);

	self->rR = 
		self->bufferR +
		(((self->wR - self->bufferR) + 1) % self->delaytimeR);
}


void *sdfx_delay_create(
	int channels, 
	int delaytimeL, int delaytimeR, 
	float feedbackL, float feedbackR,
	float dry, float wet)
{
	struct SDFX_DELAY *result;	

	result = (void *)malloc(sizeof(struct SDFX_DELAY));

	// set virtual method pointer
	result->process_mixing = sdfx_delay_process_mixing;
	result->process_replacing = sdfx_delay_process_replacing;


	result->bufsizeL = delaytimeL;
	result->bufsizeR = delaytimeR;

	result->bufferL = malloc(delaytimeL * sizeof(float));
	result->bufferR = malloc(delaytimeR * sizeof(float));

	assert(result->bufferL);
	assert(result->bufferR);

	result->feedbackL = feedbackL;
	result->feedbackR = feedbackR;

	result->wetL = wet;
	result->wetR = wet;

	result->dryL = dry;
	result->dryR = dry;

	// init write pointer
	result->wL = result->bufferL;
	result->wR = result->bufferR;

	sdfx_delay_set_delaytime(result, delaytimeL, delaytimeR);


	result->filter = sdfx_lphp_filter_create(channels, 0.01, 0.0, 0.12, 0.0);

	return result;
}



void sdfx_delay_process_mixing(void *self, float *src, float *dest, int len, int channels, int time)
{
	// TODO!
}


void sdfx_delay_process_replacing(void *self, float *src, float *dest, int len, int channels, int time)
{
	int i, c;
	float iL, iR; 
	struct SDFX_DELAY *Self;

	Self = self;

	if (channels > SDFX_MAX_CHANNELS) channels = SDFX_MAX_CHANNELS;

	for (i=0; i<len; i++)
	{
		iL = *src++;		
		iR = *src++; //  <-------------

		/* Output value */
		*dest++ = *(Self->rL) * Self->wetL + iL * Self->dryL;
		*dest++ = *(Self->rR) * Self->wetR + iR * Self->dryR;

		*(Self->wL) = 
			sdfx_lphp_filter_dofilter(Self->filter,
				iL + Self->feedbackL * *(Self->rR) // reversed feedback!
				,0);

		*(Self->wR) = 
			sdfx_lphp_filter_dofilter(Self->filter,
				iR + Self->feedbackR * *(Self->rL) // reversed feedback!
				,1); 

		/* etteeppi! */

		if (++Self->rL == Self->bufferL + Self->delaytimeL) Self->rL = Self->bufferL;
		if (++Self->rR == Self->bufferR + Self->delaytimeR) Self->rR = Self->bufferR;

		if (++Self->wL == Self->bufferL + Self->delaytimeL) Self->wL = Self->bufferL;
		if (++Self->wR == Self->bufferR + Self->delaytimeR) Self->wR = Self->bufferR;

		/* Self->rL = 
			  Self->bufferL + ((Self->rL - Self->bufferL + 1) % Self->delaytimeL);
		Self->rR = 
			  Self->bufferR + ((Self->rR - Self->bufferR + 1) % Self->delaytimeR); 

		Self->wL = 
			  Self->bufferL + ((Self->wL - Self->bufferL + 1) % Self->delaytimeL);
		Self->wR = 
			  Self->bufferR + ((Self->wR - Self->bufferR + 1) % Self->delaytimeR); */


	} /* for len */
	
} /* sdfx_delay_process_replacing */
