#ifndef SDFX_DELAY_H
#define SDFX_DELAY_H


/* Stereo delay */

#include <math.h>
#include "sdfx.h"
#include "sdfx_lphp_filter.h"

typedef struct SDFX_DELAY {
	SDFX_BASE
	float *bufferL, *bufferR; /* virtual tape loop */
	int bufsizeL, bufsizeR; /* number of floats allocated for buffer */
	int delaytimeL, delaytimeR;
	float *wL, *wR, *rL, *rR; /*  write and read "heads" on the virtual tape loop */
	float wetL, wetR; /* 0-1, please */
	float dryL, dryR; /* 0-1, please */
	float feedbackL, feedbackR; /* 0-1, please */

	struct SDFX_LPHP_FILTER *filter;
};

float sdfx_lphp_filter_dofilter(struct SDFX_LPHP_FILTER *Self, float inp, int channel);

void *sdfx_delay_create(int channels, int delaytimeL, int delaytimeR, float feedbackL, float feedbackR, float dry, float wet);
void sdfx_delay_set_delaytime(struct SDFX_DELAY *self, int valueL, int valueR);
void sdfx_delay_process_mixing(void *self, float *src, float *dest, int len, int channels, int time);
void sdfx_delay_process_replacing(void *self, float *src, float *dest, int len, int channels, int time);


#endif