
/*
	Monipuolisempi delay. Toimii ainakin jonkinlaisena 
	flangerina ja choruksena.

	Tss on kiinten kokoinen "nauhasilmukka", jolla
	on kirjoitus- ja lukupt, ja nauhan kulkunopeus
	vaihtelee lennossa (speedLFO).

	Nauhaa nytkytelln eteenpin musiikin tahdissa.
*/


#include <math.h>
#include <assert.h>
#include "sdfx_delay2.h"

/* Sets delaytime and read pointer. The write pointer is not moved. */
void sdfx_delay2_set_delaytime(struct SDFX_DELAY2 *self, int c, int value)
{
	/* must not exceed buffer size */
	if (value > self->bufsize[c] - 1) value = self->bufsize[c] - 1;

	self->delaytime[c] = value;

	self->r[c] =
		(self->w[c] + self->bufsize[c] - self->delaytime[c]); 

}


void *sdfx_delay2_create(
  int channels, 
  int delaytimeL, int delaytimeR, 
  float feedbackL, float feedbackR, 
  float dry, float wet, float interfeedback,
  float speedL, float speedR, 
  float speedLFOamplitudeL, float speedLFOamplitudeR,
  float speedLFOspeedL, float speedLFOspeedR)
{
	struct SDFX_DELAY2 *result;
	int c;

	result = (void *)malloc(sizeof(struct SDFX_DELAY2));

	result->bufsize[0] = SDFX_DELAY2_BUFSIZE;
	result->bufsize[1] = SDFX_DELAY2_BUFSIZE;

	result->prevtime = 0;

	result->feedback[0] = feedbackL;
	result->feedback[1] = feedbackR;

	result->wet[0] = wet;
	result->wet[1] = wet;

	result->dry[0] = dry;
	result->dry[1] = dry;

	result->speed[0] = speedL;
	result->speed[1] = speedR;
	result->speedLFOamplitude[0] = speedLFOamplitudeL;
	result->speedLFOamplitude[1] = speedLFOamplitudeR;
	result->speedLFOspeed[0] = speedLFOspeedL;
	result->speedLFOspeed[1] = speedLFOspeedR;
	result->speedLFOpos[0] = 0;
	result->speedLFOpos[1] = 0;

	// init write pointer
	result->w[0] = 0;
	result->w[1] = 0;

	// set virtual method pointer
	result->process_mixing = sdfx_delay2_process_mixing;
	result->process_replacing = sdfx_delay2_process_replacing;

	sdfx_delay2_set_delaytime(result, 0, delaytimeL);
	sdfx_delay2_set_delaytime(result, 1, delaytimeR);

	return result;
}



void sdfx_delay2_process_mixing(void *self, float *src, float *dest, int len, int channels, int time)
{
	// TODO!
}

float cubic(float finpos, float xm1, float x0, float x1, float x2)
{
	// cubic interpolation taken from musicdsp.org archive / by Olli Niemitalo

	float a, b, c;

	a = (3 * (x0-x1) - xm1 + x2) / 2;
	b = 2*x1 + xm1 - (5*x0 + x2) / 2;
	c = (x1 - xm1) / 2;
	return ( (((a * finpos) + b) * finpos + c) * finpos + x0 );
}

void sdfx_delay2_process_replacing(void *self, float *src, float *dest, int len, int channels, int time)
{
	int i, c, 
		ri, wi; // integer parts of read and write pos.
	float rf, wf; // fractional parts of read and write pos.
	float wleft;
	float outval, o[SDFX_MAX_CHANNELS],  /* output value */
		 inp, readval, writeval, step;
	struct SDFX_DELAY2 *Self;

	Self = self;

	if (channels > SDFX_MAX_CHANNELS) channels = SDFX_MAX_CHANNELS;

	for (i=0; i<len; i++)
	{
		for (c=0; c<channels; c++)
		{
			inp = *src++; // effect's input sample

			ri = Self->r[c];
			wi = Self->w[c];
			while (ri > SDFX_DELAY2_BUFSIZE) { Self->r[c] -= SDFX_DELAY2_BUFSIZE; ri -= SDFX_DELAY2_BUFSIZE; }
			while (wi > SDFX_DELAY2_BUFSIZE) { Self->w[c] -= SDFX_DELAY2_BUFSIZE; wi -= SDFX_DELAY2_BUFSIZE; }
			rf = Self->r[c] - ri;
			wf = Self->w[c] - wi;

			readval = // old material read from the "tape"
				Self->buffer[c][(ri) % (SDFX_DELAY2_BUFSIZE)] * (1.0 - rf) + 
				Self->buffer[c][(ri + 1) % (SDFX_DELAY2_BUFSIZE)] * rf;
		
/*				cubic(	rf,
					Self->buffer[c][(ri + SDFX_DELAY2_BUFSIZE - 1) % (SDFX_DELAY2_BUFSIZE)],
					Self->buffer[c][(ri) % (SDFX_DELAY2_BUFSIZE)],
					Self->buffer[c][(ri + 1) % (SDFX_DELAY2_BUFSIZE)],
					Self->buffer[c][(ri + 2) % (SDFX_DELAY2_BUFSIZE)]
				); */

			outval = readval * Self->wet[c] + inp * Self->dry[c];

			writeval = inp + Self->feedback[c] * readval;

			/* nykys, jolla mennn eteenpin */
			step = (Self->speed[c] + sin(Self->speedLFOpos[c]) * Self->speedLFOamplitude[c]);
			if ((Self->prevtime / 3) != (time / 3)) 
				step *= 2;

			wleft = step;
			while (wleft > 0.00001) 
			{
				if (wf + wleft >= 1.0)
				{
					Self->buffer[c][wi % SDFX_DELAY2_BUFSIZE] =
						(1.0 - wf) * writeval
						+ wf * Self->buffer[c][wi % SDFX_DELAY2_BUFSIZE];
					wleft -= (1.0 - wf);
					wi++;
					wf = 0;
				}
				else
				{
					Self->buffer[c][wi % SDFX_DELAY2_BUFSIZE] =
						wleft * writeval
						+ (1.0 - wleft) * Self->buffer[c][wi % SDFX_DELAY2_BUFSIZE];
					wleft = 0;
				}				 
			}

			/* etteeppi! */
			Self->w[c] += step;
			Self->r[c] = Self->w[c] + (float)SDFX_DELAY2_BUFSIZE - (float)Self->delaytime[c];
			Self->speedLFOpos[c] += Self->speedLFOspeed[c];

			/* ulostus */
			*dest++ = outval;
		}

	} /* for len */

	Self->prevtime = time;

} /* sdfx_delay2_process_replacing */
