#ifndef SDFX_DELAY2_H
#define SDFX_DELAY2_H


/* Stereo delay */

#include <math.h>
#include "sdfx.h"

// tss kakkosversiossa w- ja r-offsetit ovat liukulukuja
// eli voidaan liikkua delay-puskurissa portaattomasti 

// tarpeeksi iso kakkosen potenssi (maksimiviiveaika)
#define SDFX_DELAY2_BUFSIZE (65536)


typedef float *floatptr;

typedef struct SDFX_DELAY2 {
	SDFX_BASE
	int prevtime;
//	floatptr buffer[SDFX_MAX_CHANNELS]; /* virtual tape loop */
	float buffer[SDFX_MAX_CHANNELS][SDFX_DELAY2_BUFSIZE];
	int bufsize[SDFX_MAX_CHANNELS]; /* number of floats allocated for buffer */
	int delaytime[SDFX_MAX_CHANNELS];
	float w[SDFX_MAX_CHANNELS], r[SDFX_MAX_CHANNELS]; /*  write and read "heads" on the virtual tape loop */
	float wet[SDFX_MAX_CHANNELS]; /* 0-1, please */
	float dry[SDFX_MAX_CHANNELS]; /* 0-1, please */
	float feedback[SDFX_MAX_CHANNELS]; /* 0-1, please */
	float interfeedback;
	float speed[SDFX_MAX_CHANNELS];
	float speedLFOamplitude[SDFX_MAX_CHANNELS];
	float speedLFOspeed[SDFX_MAX_CHANNELS];
	float speedLFOpos[SDFX_MAX_CHANNELS];
};


void *sdfx_delay2_create(
  int channels, 
  int delaytimeL, int delaytimeR, 
  float feedbackL, float feedbackR, 
  float dry, float wet, float interfeedback,
  float speedL, float speedR, 
  float speedLFOamplitudeL, float speedLFOamplitudeR,
  float speedLFOspeedL, float speedLFOspeedR
);
void sdfx_delay2_process_mixing(void *self, float *src, float *dest, int len, int channels, int time);
void sdfx_delay2_process_replacing(void *self, float *src, float *dest, int len, int channels, int time);


#endif