
#include <math.h>
#include <assert.h>
#include "sdfx_formant_filter.h"


/*
Public source code by alex@smartelectronix.com
Simple example of implementation of formant filter
Vowelnum can be 0,1,2,3,4 <=> A,E,I,O,U
Good for spectral rich input like saw or square 
*/
//-------------------------------------------------------------VOWEL COEFFICIENTS
static const double coeff[5][11]= {
{ 8.11044e-06,
8.943665402,    -36.83889529,    92.01697887,    -154.337906,    181.6233289,
-151.8651235,   89.09614114,    -35.10298511,    8.388101016,    -0.923313471  ///A
},
{4.36215e-06,
8.90438318,    -36.55179099,    91.05750846,    -152.422234,    179.1170248,  ///E
-149.6496211,87.78352223,    -34.60687431,    8.282228154,    -0.914150747
},
{ 3.33819e-06,
8.893102966,    -36.49532826,    90.96543286,    -152.4545478,    179.4835618,
-150.315433,    88.43409371,    -34.98612086,    8.407803364,    -0.932568035  ///I
},
{1.13572e-06,
8.994734087,    -37.2084849,    93.22900521,    -156.6929844,    184.596544,   ///O
-154.3755513,    90.49663749,    -35.58964535,    8.478996281,    -0.929252233
},
{4.09431e-07,
8.997322763,    -37.20218544,    93.11385476,    -156.2530937,    183.7080141,  ///U
-153.2631681,    89.59539726,    -35.12454591,    8.338655623,    -0.910251753
}
};

//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
double formant_filter(double in, int vowelnum, double *memory)
{
	double res;

            res= ( coeff[vowelnum][0]  *in +
                     coeff[vowelnum][1]  *memory[0] +  
                     coeff[vowelnum][2]  *memory[1] +
                     coeff[vowelnum][3]  *memory[2] +
                     coeff[vowelnum][4]  *memory[3] +
                     coeff[vowelnum][5]  *memory[4] +
                     coeff[vowelnum][6]  *memory[5] +
                     coeff[vowelnum][7]  *memory[6] +
                     coeff[vowelnum][8]  *memory[7] +
                     coeff[vowelnum][9]  *memory[8] +
                     coeff[vowelnum][10] *memory[9] );

memory[9]= memory[8];
memory[8]= memory[7];
memory[7]= memory[6];
memory[6]= memory[5];
memory[5]= memory[4];
memory[4]= memory[3];
memory[3]= memory[2];
memory[2]= memory[1];                     
memory[1]= memory[0];
memory[0]= res;
return res;
}


void *sdfx_formant_filter_create(int channels, int vowelnum)
{
	struct SDFX_FORMANT_FILTER *result;	
	int i, c;

	result = (void *)malloc(sizeof(struct SDFX_FORMANT_FILTER));

	// set virtual method pointers
	result->process_mixing = sdfx_formant_filter_process_mixing;
	result->process_replacing = sdfx_formant_filter_process_replacing;

	result->vowelnum = vowelnum;

	/* clear memory */
	for (c=0; c<SDFX_MAX_CHANNELS; c++)
		for (i=0; i<10; i++)
			result->memory[c][i] = 0;

	return result;
}



void sdfx_formant_filter_process_mixing(void *self, float *src, float *dest, int len, int channels, int time)
{
	int i, c;
	float o[SDFX_MAX_CHANNELS]; /* output value */
	struct SDFX_FORMANT_FILTER *Self;

	Self = self;

	if (channels > SDFX_MAX_CHANNELS) channels = SDFX_MAX_CHANNELS;

	for (i=0; i<len; i++)
	{
		for (c=0; c<channels; c++) o[c] = 0.0;

		{
//			f = 
		}
		//*dest = 
	}
}


void sdfx_formant_filter_process_replacing(void *self, float *src, float *dest, int len, int channels, int time)
{
	int i, c;
	struct SDFX_FORMANT_FILTER *Self;

	Self = self;

	if (channels > SDFX_MAX_CHANNELS) channels = SDFX_MAX_CHANNELS;

	for (i=0; i<len; i++)
	{
		for (c=0; c<channels; c++)
		{
			*dest++ = formant_filter(*src++, Self->vowelnum, Self->memory[c]);
		}

	} /* for len */

	Self->vowelnum = (time / 2) % 5;

} /* sdfx_formant_filter_process_replacing */
