
#include <math.h>
#include <assert.h>
#include "sdfx_lphp_filter.h"


/* 

Original by Tobybear / taken from musicdsp.org archives 

var n1,n2,n3,n4:single; // filter delay, init these with 0!
    fb_lp,fb_hp:single; // storage for calculated feedback
const p4=1.0e-24; // Pentium 4 denormal problem elimination

function dofilter(inp,cut_lp,res_lp,cut_hp,res_hp:single):single;
begin
fb_lp:=res_lp+res_lp/(1-cut_lp);
fb_hp:=res_hp+res_hp/(1-cut_lp);
n1:=n1+cut_lp*(inp-n1+fb_lp*(n1-n2))+p4;
n2:=n2+cut_lp*(n1-n2);
n3:=n3+cut_hp*(n2-n3+fb_hp*(n3-n4))+p4;
n4:=n4+cut_hp*(n3-n4);
result:=i-n4;
end;
*/


void sdfx_lphp_filter_calculate_feedback(struct SDFX_LPHP_FILTER *Self)
{
	// calculate feedback
	Self->fb_lp = (Self->res_lp + Self->res_lp / (1 - Self->cut_lp)) * 0.8;
	Self->fb_hp = (Self->res_hp + Self->res_hp / (1 - Self->cut_hp)) * 0.8;
}

#define P4 (0.000000000000000000001)

float sdfx_lphp_filter_dofilter(struct SDFX_LPHP_FILTER *Self, float inp, int channel)
{
	float *n;

	// clip input
        if ((inp > 0.1) || (inp < -0.1)) inp = inp / 2;
        if ((inp > 0.2) || (inp < -0.2)) inp = inp / 2;
        if ((inp > 0.4) || (inp < -0.4)) inp = inp / 2;
        if ((inp > 0.6) || (inp < -0.6)) inp = inp / 2;
        if ((inp > 0.9) || (inp < -0.9)) inp = inp / 2;
	if (inp > 0.999) inp = 0.999;
	if (inp < -0.999) inp = -0.999;

	n = Self->n[channel];

	n[0] += Self->cut_lp * (inp - n[0] + Self->fb_lp * (n[0] - n[1])) + P4;
	n[1] += Self->cut_lp * (n[0] - n[1]);
	n[2] += Self->cut_hp * (n[1] - n[2] + Self->fb_hp * (n[2] - n[3])) + P4;
	n[3] += Self->cut_hp * (n[2] - n[3]);

	return (inp - n[3]);
}


void *sdfx_lphp_filter_create(int channels, float cut_lp, float res_lp, float cut_hp, float res_hp)
{
	struct SDFX_LPHP_FILTER *result;	
	int i, c;

	result = (void *)malloc(sizeof(struct SDFX_LPHP_FILTER));

	// set virtual method pointers
	result->process_mixing = sdfx_lphp_filter_process_mixing;
	result->process_replacing = sdfx_lphp_filter_process_replacing;

	result->cut_lp = cut_lp;
	result->res_lp = res_lp;
	result->cut_hp = cut_hp;
	result->res_hp = res_hp;

	sdfx_lphp_filter_calculate_feedback(result);

	/* clear memory */
	for (c=0; c<SDFX_MAX_CHANNELS; c++)
		for (i=0; i<4; i++)
			result->n[c][i] = 0;

	return result;
}



void sdfx_lphp_filter_process_mixing(void *self, float *src, float *dest, int len, int channels, int time)
{
	// TODO! the same as process_replacing, but += instead of =
}


void sdfx_lphp_filter_process_replacing(void *self, float *src, float *dest, int len, int channels, int time)
{
	int i, c;
	struct SDFX_LPHP_FILTER *Self;


	Self = self;

	if (channels > SDFX_MAX_CHANNELS) channels = SDFX_MAX_CHANNELS;

	for (i=0; i<len; i++)
	{
		for (c=0; c<channels; c++)
		{
			*dest++ = sdfx_lphp_filter_dofilter(Self, *src++, c);
		}

	} /* for len */
} /* sdfx_lphp_filter_process_replacing */
